/*
 * Decompiled with CFR 0.152.
 */
package comToi.simple_harvesting;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;

public class ServerConfig {
    public boolean DisableNormalHarvesting = false;
    public boolean HoeUsesEnabled = true;
    public int CropHarvestRadius = 3;
    public int GrassRadius = 2;
    public boolean HandHarvestEnabled = true;
    public boolean HoeHarvestEnabled = true;
    public boolean DisableFieldBreakOnJump = false;
    private final transient File file;
    private static final transient Gson gson = new GsonBuilder().setPrettyPrinting().create();

    public ServerConfig(File file) {
        this.file = file;
        this.ensureValidConfigFile();
        this.load();
    }

    private void ensureValidConfigFile() {
        if (!this.file.exists()) {
            return;
        }
        try (FileReader reader = new FileReader(this.file);){
            gson.fromJson((Reader)reader, ServerConfig.class);
        }
        catch (JsonSyntaxException | IOException e) {
            this.file.delete();
        }
    }

    public void load() {
        if (!this.file.exists()) {
            this.save();
            return;
        }
        try (FileReader reader = new FileReader(this.file);){
            ServerConfig config = (ServerConfig)gson.fromJson((Reader)reader, ServerConfig.class);
            if (config != null) {
                this.DisableNormalHarvesting = config.DisableNormalHarvesting;
                this.HoeUsesEnabled = config.HoeUsesEnabled;
                this.CropHarvestRadius = config.CropHarvestRadius;
                this.GrassRadius = config.GrassRadius;
                this.HandHarvestEnabled = config.HandHarvestEnabled;
                this.HoeHarvestEnabled = config.HoeHarvestEnabled;
                this.DisableFieldBreakOnJump = config.DisableFieldBreakOnJump;
            }
        }
        catch (JsonSyntaxException | IOException e) {
            this.file.delete();
            this.save();
        }
    }

    public void save() {
        try (FileWriter writer = new FileWriter(this.file);){
            gson.toJson((Object)this, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean hasHoeHarvestEnabled() {
        return this.HoeHarvestEnabled;
    }
}

