/*
 * Decompiled with CFR 0.152.
 */
package comToi.simple_harvesting_1_21_1_forge;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BeetrootBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.TallGrassBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod(value="simple_harvesting_forge")
class SimpleHarvestingForge {
    private static final List<Class<? extends Block>> HARVESTABLE_BLOCKS = new ArrayList<Class<? extends Block>>(){
        {
            this.add(TallGrassBlock.class);
            this.add(DoublePlantBlock.class);
            this.add(FlowerBlock.class);
        }
    };
    public static ForgeConfig config;

    public SimpleHarvestingForge() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.loadConfig();
    }

    private void loadConfig() {
        File configFile = new File("config/simple_harvesting_1_21_1_forge.json");
        if (!configFile.exists()) {
            config = new ForgeConfig();
            this.saveConfigWithDefaults(configFile);
            return;
        }
        config = new ForgeConfig();
        try (BufferedReader reader = new BufferedReader(new FileReader(configFile));){
            String line;
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).startsWith("\"cropHarvestRadius\"")) {
                    SimpleHarvestingForge.config.cropHarvestRadius = this.parseIntFromLine(line, 3);
                    continue;
                }
                if (line.startsWith("\"grassRadius\"")) {
                    SimpleHarvestingForge.config.grassRadius = this.parseIntFromLine(line, 3);
                    continue;
                }
                if (line.startsWith("\"hoeUsesEnabled\"")) {
                    SimpleHarvestingForge.config.hoeUsesEnabled = this.parseBooleanFromLine(line, true);
                    continue;
                }
                if (!line.startsWith("\"handHarvestEnabled\"")) continue;
                SimpleHarvestingForge.config.handHarvestEnabled = this.parseBooleanFromLine(line, true);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private int parseIntFromLine(String line, int defaultValue) {
        try {
            String[] parts = line.split(":");
            String valuePart = parts[1].split("\\(")[0].trim().replace(",", "");
            return Integer.parseInt(valuePart);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    private boolean parseBooleanFromLine(String line, boolean defaultValue) {
        try {
            String[] parts = line.split(":");
            String valuePart = parts[1].split("\\(")[0].trim().replace(",", "");
            return Boolean.parseBoolean(valuePart);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    private void saveConfigWithDefaults(File file) {
        try (FileWriter writer = new FileWriter(file);){
            writer.write("{\n");
            writer.write("  \"cropHarvestRadius\": 3 (standard: 3),\n");
            writer.write("  \"grassRadius\": 3 (standard: 3),\n");
            writer.write("  \"hoeUsesEnabled\": true (standard: true),\n");
            writer.write("  \"handHarvestEnabled\": true (standard: true)\n");
            writer.write("}\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @SubscribeEvent
    public void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        Level world = event.getLevel();
        if (world.isClientSide()) {
            return;
        }
        Player player = event.getEntity();
        ItemStack mainHand = player.getMainHandItem();
        BlockPos pos = event.getPos();
        BlockState state = world.getBlockState(pos);
        Block block = state.getBlock();
        if (this.isCrop(block) && this.isFullyGrown(state, block) && SimpleHarvestingForge.config.handHarvestEnabled) {
            if (mainHand.isEmpty()) {
                this.harvestCrop(world, pos, block, state);
                event.setCanceled(true);
                return;
            }
            if (mainHand.getItem() instanceof HoeItem && SimpleHarvestingForge.config.hoeUsesEnabled) {
                this.harvestConnectedCrops(world, pos, SimpleHarvestingForge.config.cropHarvestRadius, block);
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onBlockBreak(BlockEvent.BreakEvent event) {
        Level world = (Level)event.getLevel();
        if (world.isClientSide()) {
            return;
        }
        Player player = event.getPlayer();
        ItemStack mainHand = player.getMainHandItem();
        if (!(mainHand.getItem() instanceof HoeItem)) {
            return;
        }
        BlockPos pos = event.getPos();
        BlockState state = world.getBlockState(pos);
        Block block = state.getBlock();
        if (this.isHarvestable(block)) {
            this.harvestArea(world, pos, SimpleHarvestingForge.config.grassRadius);
        }
    }

    private boolean isCrop(Block block) {
        return block instanceof CropBlock || block instanceof BeetrootBlock;
    }

    private boolean isHarvestable(Block block) {
        for (Class<? extends Block> clazz : HARVESTABLE_BLOCKS) {
            if (!clazz.isInstance(block)) continue;
            return true;
        }
        return false;
    }

    private boolean isFullyGrown(BlockState state, Block block) {
        IntegerProperty ageProp = this.getAgeProp(state);
        if (ageProp != null) {
            return (Integer)state.getValue((Property)ageProp) >= this.getMaxAge(block);
        }
        return false;
    }

    private IntegerProperty getAgeProp(BlockState state) {
        for (Property prop : state.getProperties()) {
            if (!(prop instanceof IntegerProperty)) continue;
            IntegerProperty intProp = (IntegerProperty)prop;
            if (!prop.getName().equals("age")) continue;
            return intProp;
        }
        return null;
    }

    private int getMaxAge(Block block) {
        if (block instanceof CropBlock) {
            CropBlock crop = (CropBlock)block;
            return crop.getMaxAge();
        }
        if (block instanceof BeetrootBlock) {
            BeetrootBlock beet = (BeetrootBlock)block;
            return beet.getMaxAge();
        }
        return 7;
    }

    private void harvestCrop(Level world, BlockPos pos, Block block, BlockState state) {
        IntegerProperty ageProp;
        world.levelEvent(2001, pos, Block.getId((BlockState)state));
        if (world instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)world;
            List drops = Block.getDrops((BlockState)state, (ServerLevel)serverWorld, (BlockPos)pos, null);
            for (ItemStack drop : drops) {
                ItemEntity entity = new ItemEntity((Level)serverWorld, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, drop);
                serverWorld.addFreshEntity((Entity)entity);
            }
        }
        if ((ageProp = this.getAgeProp(state)) != null) {
            world.setBlock(pos, (BlockState)state.setValue((Property)ageProp, (Comparable)Integer.valueOf(0)), 3);
        } else {
            world.removeBlock(pos, false);
        }
    }

    private void harvestConnectedCrops(Level world, BlockPos startPos, int radius, Block targetBlock) {
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        LinkedList<BlockPos> queue = new LinkedList<BlockPos>();
        queue.add(startPos);
        visited.add(startPos);
        while (!queue.isEmpty()) {
            BlockPos pos = (BlockPos)queue.poll();
            BlockState state = world.getBlockState(pos);
            Block block = state.getBlock();
            if (block != targetBlock || !this.isCrop(block) || !this.isFullyGrown(state, block)) continue;
            this.harvestCrop(world, pos, block, state);
            for (BlockPos neighbor : new BlockPos[]{pos.north(), pos.south(), pos.east(), pos.west(), pos.above(), pos.below()}) {
                if (visited.contains(neighbor) || !(neighbor.distSqr((Vec3i)startPos) <= (double)(radius * radius))) continue;
                visited.add(neighbor);
                queue.add(neighbor);
            }
        }
    }

    private void harvestArea(Level world, BlockPos centerPos, int radius) {
        for (int dx = -radius; dx <= radius; ++dx) {
            for (int dy = -radius; dy <= radius; ++dy) {
                for (int dz = -radius; dz <= radius; ++dz) {
                    BlockPos pos = centerPos.offset(dx, dy, dz);
                    BlockState state = world.getBlockState(pos);
                    Block block = state.getBlock();
                    if (!this.isHarvestable(block)) continue;
                    this.harvestCrop(world, pos, block, state);
                }
            }
        }
    }

    public static class ForgeConfig {
        public int cropHarvestRadius = 3;
        public int grassRadius = 3;
        public boolean hoeUsesEnabled = true;
        public boolean handHarvestEnabled = true;
    }
}

