/*
 * Decompiled with CFR 0.152.
 */
package comToi.simple_harvesting;

import comToi.simple_harvesting.SHConfig;
import java.io.File;
import java.util.HashSet;
import java.util.LinkedList;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.player.AttackBlockCallback;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1794;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2242;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2302;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_3218;

public class Simple_harvesting
implements ModInitializer {
    public static SHConfig CONFIG;
    private static final class_2248[] HARVESTABLE_BLOCKS;

    public void onInitialize() {
        File configFile = new File("config/simple_harvesting.json");
        CONFIG = new SHConfig(configFile);
        AttackBlockCallback.EVENT.register((player, world, hand, pos, direction) -> {
            if (player.method_68878()) {
                return class_1269.field_5811;
            }
            class_2248 block = world.method_8320(pos).method_26204();
            if (Simple_harvesting.CONFIG.DisableNormalHarvesting && (block instanceof class_2302 || block instanceof class_2242 || this.isInBlockList(block))) {
                return class_1269.field_5814;
            }
            return class_1269.field_5811;
        });
        UseBlockCallback.EVENT.register((player, world, hand, hitResult) -> {
            if (world.field_9236) {
                return class_1269.field_5811;
            }
            if (hand != class_1268.field_5808) {
                return class_1269.field_5811;
            }
            class_1799 mainHand = player.method_6047();
            class_2338 pos = hitResult.method_17777();
            class_2680 state = world.method_8320(pos);
            class_2248 block = state.method_26204();
            class_3218 serverWorld = (class_3218)world;
            boolean isShift = player.method_5715();
            if (Simple_harvesting.CONFIG.DisableNormalHarvesting && isShift) {
                if (mainHand.method_7909() instanceof class_1794) {
                    if (block instanceof class_2302 || block instanceof class_2242) {
                        this.destroyCropsInRadius(world, player, pos);
                        return class_1269.field_5812;
                    }
                    if (this.isInBlockList(block)) {
                        this.destroyGrassInRadius(world, player, pos);
                        return class_1269.field_5812;
                    }
                } else if (mainHand.method_7960() && (block instanceof class_2302 || block instanceof class_2242 || this.isInBlockList(block))) {
                    world.method_8651(pos, true, (class_1297)player);
                    return class_1269.field_5812;
                }
            }
            if (!isShift) {
                if (mainHand.method_7909() instanceof class_1794) {
                    if (block instanceof class_2302 || block instanceof class_2242) {
                        this.harvestAdjacentCrops(world, serverWorld, player, pos, block, state, true);
                        if (Simple_harvesting.CONFIG.hoeUsesEnabled && !player.method_68878()) {
                            this.damageTool(mainHand, player);
                        }
                        return class_1269.field_5812;
                    }
                    if (this.isInBlockList(block)) {
                        this.destroyGrassInRadius(world, player, pos);
                        return class_1269.field_5812;
                    }
                } else if (mainHand.method_7960()) {
                    if (block instanceof class_2302 || block instanceof class_2242) {
                        this.harvestSingleCrop(world, serverWorld, player, pos, block, state, true);
                        return class_1269.field_5812;
                    }
                    if (this.isInBlockList(block)) {
                        world.method_8651(pos, true, (class_1297)player);
                        return class_1269.field_5812;
                    }
                }
            }
            return class_1269.field_5811;
        });
    }

    private boolean isInBlockList(class_2248 block) {
        for (class_2248 b : HARVESTABLE_BLOCKS) {
            if (b != block) continue;
            return true;
        }
        return false;
    }

    private void destroyCropsInRadius(class_1937 world, class_1657 player, class_2338 center) {
        HashSet<class_2338> visited = new HashSet<class_2338>();
        LinkedList<class_2338> queue = new LinkedList<class_2338>();
        queue.add(center);
        while (!queue.isEmpty()) {
            class_2680 state;
            class_2248 block;
            class_2338 pos = (class_2338)queue.poll();
            if (visited.contains(pos)) continue;
            visited.add(pos);
            if (pos.method_19455((class_2382)center) > Simple_harvesting.CONFIG.cropHarvestRadius || !((block = (state = world.method_8320(pos)).method_26204()) instanceof class_2302) && !(block instanceof class_2242)) continue;
            world.method_8651(pos, true, (class_1297)player);
            queue.add(pos.method_10095());
            queue.add(pos.method_10072());
            queue.add(pos.method_10078());
            queue.add(pos.method_10067());
            queue.add(pos.method_10084());
            queue.add(pos.method_10074());
        }
    }

    private void destroyGrassInRadius(class_1937 world, class_1657 player, class_2338 center) {
        int radius = Simple_harvesting.CONFIG.grassRadius;
        for (int x = -radius; x <= radius; ++x) {
            for (int y = -radius; y <= radius; ++y) {
                for (int z = -radius; z <= radius; ++z) {
                    class_2338 pos = center.method_10069(x, y, z);
                    class_2680 state = world.method_8320(pos);
                    class_2248 block = state.method_26204();
                    if (!this.isInBlockList(block)) continue;
                    world.method_8651(pos, true, (class_1297)player);
                }
            }
        }
    }

    private void harvestAdjacentCrops(class_1937 world, class_3218 serverWorld, class_1657 player, class_2338 pos, class_2248 block, class_2680 state, boolean replant) {
        int maxAge;
        class_2758 ageProp = this.getAgeProperty(state);
        if (ageProp == null) {
            return;
        }
        int age = (Integer)state.method_11654((class_2769)ageProp);
        if (block instanceof class_2302) {
            class_2302 crop = (class_2302)block;
            v0 = crop.method_9827();
        } else {
            v0 = maxAge = ((class_2242)block).method_9827();
        }
        if (age < maxAge) {
            return;
        }
        HashSet<class_2338> visited = new HashSet<class_2338>();
        LinkedList<class_2338> queue = new LinkedList<class_2338>();
        queue.add(pos);
        while (!queue.isEmpty()) {
            class_2338 currentPos = (class_2338)queue.poll();
            if (visited.contains(currentPos)) continue;
            visited.add(currentPos);
            if (currentPos.method_19455((class_2382)pos) > Simple_harvesting.CONFIG.cropHarvestRadius) continue;
            class_2680 currentState = world.method_8320(currentPos);
            class_2248 currentBlock = currentState.method_26204();
            class_2758 currentAgeProp = this.getAgeProperty(currentState);
            if (currentAgeProp == null || currentBlock.getClass() != block.getClass() || (Integer)currentState.method_11654((class_2769)currentAgeProp) < maxAge) continue;
            class_2248.method_9511((class_2680)currentState, (class_1937)serverWorld, (class_2338)currentPos, null, (class_1297)player, (class_1799)class_1799.field_8037);
            world.method_8651(currentPos, false, (class_1297)player);
            if (replant) {
                world.method_8652(currentPos, (class_2680)currentState.method_11657((class_2769)currentAgeProp, (Comparable)Integer.valueOf(0)), 3);
            }
            queue.add(currentPos.method_10095());
            queue.add(currentPos.method_10072());
            queue.add(currentPos.method_10078());
            queue.add(currentPos.method_10067());
            queue.add(currentPos.method_10084());
            queue.add(currentPos.method_10074());
        }
    }

    private void harvestSingleCrop(class_1937 world, class_3218 serverWorld, class_1657 player, class_2338 pos, class_2248 block, class_2680 state, boolean replant) {
        int maxAge;
        class_2758 ageProp = this.getAgeProperty(state);
        if (ageProp == null) {
            return;
        }
        int age = (Integer)state.method_11654((class_2769)ageProp);
        if (block instanceof class_2302) {
            class_2302 crop = (class_2302)block;
            v0 = crop.method_9827();
        } else {
            v0 = maxAge = ((class_2242)block).method_9827();
        }
        if (age >= maxAge) {
            class_2248.method_9511((class_2680)state, (class_1937)serverWorld, (class_2338)pos, null, (class_1297)player, (class_1799)class_1799.field_8037);
            world.method_8651(pos, false, (class_1297)player);
            if (replant) {
                world.method_8652(pos, (class_2680)state.method_11657((class_2769)ageProp, (Comparable)Integer.valueOf(0)), 3);
            }
        }
    }

    private class_2758 getAgeProperty(class_2680 state) {
        for (class_2769 prop : state.method_26204().method_9595().method_11659()) {
            if (!(prop instanceof class_2758)) continue;
            class_2758 intProp = (class_2758)prop;
            if (!prop.method_11899().equals("age")) continue;
            return intProp;
        }
        return null;
    }

    private void damageTool(class_1799 stack, class_1657 player) {
        if (player.method_68878()) {
            return;
        }
        stack.method_7974(stack.method_7919() + 1);
        if (stack.method_7919() >= stack.method_7936()) {
            player.method_31548().method_7378(stack);
        }
    }

    static {
        HARVESTABLE_BLOCKS = new class_2248[]{class_2246.field_10214, class_2246.field_10479, class_2246.field_56454, class_2246.field_55742, class_2246.field_10182, class_2246.field_10449, class_2246.field_10086, class_2246.field_10226, class_2246.field_10573, class_2246.field_10270, class_2246.field_10048, class_2246.field_10156, class_2246.field_10315, class_2246.field_10554, class_2246.field_9995, class_2246.field_10548, class_2246.field_16999, class_2246.field_56455, class_2246.field_10428, class_2246.field_55741, class_2246.field_56562, class_2246.field_56563, class_2246.field_42734, class_2246.field_42749, class_2246.field_10003, class_2246.field_10583, class_2246.field_10430, class_2246.field_55060, class_2246.field_55061, class_2246.field_10376, class_2246.field_9993, class_2246.field_10238};
    }
}

