/*
 * Decompiled with CFR 0.152.
 */
package com.gaura.twod_projectiles.mixin;

import com.gaura.twod_projectiles.TwoDProjectiles;
import com.gaura.twod_projectiles.util.TwoDFireworkRocketRenderState;
import com.gaura.twod_projectiles.util.TwoDRollEntity;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.entity.FireworkEntityRenderer;
import net.minecraft.client.renderer.entity.state.FireworkRocketRenderState;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={FireworkEntityRenderer.class})
public class FireworkEntityRendererMixin {
    @Inject(method={"submit(Lnet/minecraft/client/renderer/entity/state/FireworkRocketRenderState;Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/SubmitNodeCollector;Lnet/minecraft/client/renderer/state/CameraRenderState;)V"}, at={@At(value="INVOKE", target="Lcom/mojang/blaze3d/vertex/PoseStack;pushPose()V", shift=At.Shift.AFTER)})
    private void renderTwoDFireworkRocket(FireworkRocketRenderState fireworkRocketRenderState, PoseStack poseStack, SubmitNodeCollector submitNodeCollector, CameraRenderState cameraRenderState, CallbackInfo ci) {
        if (TwoDProjectiles.CONFIG.renderTwoDFireworkRocket && fireworkRocketRenderState instanceof TwoDFireworkRocketRenderState) {
            TwoDFireworkRocketRenderState twoDFireworkRocketRenderState = (TwoDFireworkRocketRenderState)fireworkRocketRenderState;
            poseStack.scale(TwoDProjectiles.CONFIG.fireworkRocketScale, TwoDProjectiles.CONFIG.fireworkRocketScale, TwoDProjectiles.CONFIG.fireworkRocketScale);
            if (fireworkRocketRenderState.isShotAtAngle) {
                poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(twoDFireworkRocketRenderState.twoDProjectiles$getYRot() - 90.0f));
                poseStack.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(twoDFireworkRocketRenderState.twoDProjectiles$getXRot() + TwoDProjectiles.CONFIG.fireworkRocketDirection.getDegree()));
                qY = Axis.YP.rotationDegrees(-90.0f);
                qZ = Axis.ZP.rotationDegrees(TwoDProjectiles.CONFIG.fireworkRocketDirection.getDegree() + (fireworkRocketRenderState.isShotAtAngle ? 0.0f : 90.0f));
                qCombined = new Quaternionf((Quaternionfc)qY).mul((Quaternionfc)qZ);
                axis = new Vector3f();
                qCombined.normalizedPositiveZ(axis);
                poseStack.mulPose((Quaternionfc)new Quaternionf().rotationAxis((float)Math.toRadians(-90.0), (Vector3fc)axis));
                poseStack.mulPose((Quaternionfc)new Quaternionf().rotationAxis((float)Math.toRadians(twoDFireworkRocketRenderState.twoDProjectiles$getRoll()), (Vector3fc)axis));
            } else {
                poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(-90.0f));
                poseStack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(TwoDProjectiles.CONFIG.fireworkRocketDirection.getDegree() + 90.0f));
                qY = Axis.YP.rotationDegrees(-90.0f);
                qZ = Axis.XP.rotationDegrees(TwoDProjectiles.CONFIG.fireworkRocketDirection.getDegree() + 90.0f);
                qCombined = new Quaternionf((Quaternionfc)qY).mul((Quaternionfc)qZ);
                axis = new Vector3f();
                qCombined.normalizedPositiveY(axis);
                poseStack.mulPose((Quaternionfc)new Quaternionf().rotationAxis((float)Math.toRadians(twoDFireworkRocketRenderState.twoDProjectiles$getRoll()), (Vector3fc)axis));
            }
            float offset = TwoDProjectiles.CONFIG.fireworkRocketOffset;
            float radiansZ = (float)Math.toRadians(TwoDProjectiles.CONFIG.fireworkRocketDirection.getDegree());
            float offsetX = -((float)Math.cos(radiansZ)) * offset;
            float offsetY = (float)Math.sin(radiansZ) * offset;
            poseStack.translate(offsetX, offsetY - 0.125f, 0.0f);
        }
    }

    @WrapOperation(method={"submit(Lnet/minecraft/client/renderer/entity/state/FireworkRocketRenderState;Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/SubmitNodeCollector;Lnet/minecraft/client/renderer/state/CameraRenderState;)V"}, at={@At(value="INVOKE", target="Lcom/mojang/blaze3d/vertex/PoseStack;mulPose(Lorg/joml/Quaternionfc;)V", ordinal=0)})
    private void cancelMulPose(PoseStack poseStack, Quaternionfc quaternionfc, Operation<Void> original) {
        if (!TwoDProjectiles.CONFIG.renderTwoDFireworkRocket) {
            original.call(new Object[]{poseStack, quaternionfc});
        }
    }

    @WrapOperation(method={"submit(Lnet/minecraft/client/renderer/entity/state/FireworkRocketRenderState;Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/SubmitNodeCollector;Lnet/minecraft/client/renderer/state/CameraRenderState;)V"}, at={@At(value="INVOKE", target="Lcom/mojang/blaze3d/vertex/PoseStack;mulPose(Lorg/joml/Quaternionfc;)V", ordinal=1)})
    private void cancelRotationDegreesZP(PoseStack poseStack, Quaternionfc quaternionfc, Operation<Void> original) {
        if (!TwoDProjectiles.CONFIG.renderTwoDFireworkRocket) {
            original.call(new Object[]{poseStack, quaternionfc});
        }
    }

    @WrapOperation(method={"submit(Lnet/minecraft/client/renderer/entity/state/FireworkRocketRenderState;Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/SubmitNodeCollector;Lnet/minecraft/client/renderer/state/CameraRenderState;)V"}, at={@At(value="INVOKE", target="Lcom/mojang/blaze3d/vertex/PoseStack;mulPose(Lorg/joml/Quaternionfc;)V", ordinal=2)})
    private void cancelRotationDegreesYP(PoseStack poseStack, Quaternionfc quaternionfc, Operation<Void> original) {
        if (!TwoDProjectiles.CONFIG.renderTwoDFireworkRocket) {
            original.call(new Object[]{poseStack, quaternionfc});
        }
    }

    @WrapOperation(method={"submit(Lnet/minecraft/client/renderer/entity/state/FireworkRocketRenderState;Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/SubmitNodeCollector;Lnet/minecraft/client/renderer/state/CameraRenderState;)V"}, at={@At(value="INVOKE", target="Lcom/mojang/blaze3d/vertex/PoseStack;mulPose(Lorg/joml/Quaternionfc;)V", ordinal=3)})
    private void cancelRotationDegreesXP(PoseStack poseStack, Quaternionfc quaternionfc, Operation<Void> original) {
        if (!TwoDProjectiles.CONFIG.renderTwoDFireworkRocket) {
            original.call(new Object[]{poseStack, quaternionfc});
        }
    }

    @Inject(method={"extractRenderState(Lnet/minecraft/world/entity/projectile/FireworkRocketEntity;Lnet/minecraft/client/renderer/entity/state/FireworkRocketRenderState;F)V"}, at={@At(value="TAIL")})
    private void updateRenderState(FireworkRocketEntity fireworkRocketEntity, FireworkRocketRenderState fireworkRocketRenderState, float f, CallbackInfo ci) {
        if (TwoDProjectiles.CONFIG.renderTwoDFireworkRocket && fireworkRocketRenderState instanceof TwoDFireworkRocketRenderState) {
            TwoDFireworkRocketRenderState twoDFireworkRocketRenderState = (TwoDFireworkRocketRenderState)fireworkRocketRenderState;
            twoDFireworkRocketRenderState.twoDProjectiles$setYRot(fireworkRocketEntity.getYRot(f));
            twoDFireworkRocketRenderState.twoDProjectiles$setXRot(fireworkRocketEntity.getXRot(f));
            twoDFireworkRocketRenderState.twoDProjectiles$setRoll(((TwoDRollEntity)fireworkRocketEntity).twod_projectiles$getRoll(f));
        }
    }
}

