/*
 * Decompiled with CFR 0.152.
 */
package com.gaura.twod_projectiles.mixin;

import com.gaura.twod_projectiles.TwoDProjectiles;
import com.gaura.twod_projectiles.mixin.AbstractArrowInvoker;
import com.gaura.twod_projectiles.util.TwoDRollEntity;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.projectile.ThrownTrident;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ThrownTrident.class})
public class ThrownTridentMixin
implements TwoDRollEntity {
    @Unique
    private float twod_projectiles$roll = 0.0f;
    @Unique
    private final int twod_projectiles$random = RandomSource.create().nextBoolean() ? 1 : -1;

    @Inject(method={"tick()V"}, at={@At(value="TAIL")})
    private void tick(CallbackInfo ci) {
        ThrownTrident thrownTrident = (ThrownTrident)this;
        if (!((AbstractArrowInvoker)thrownTrident).invokeIsInGround()) {
            this.twod_projectiles$roll += (float)((double)((float)this.twod_projectiles$random * TwoDProjectiles.CONFIG.tridentRoll) * thrownTrident.getDeltaMovement().length());
        }
    }

    @Override
    public float twod_projectiles$getRoll(float f) {
        ThrownTrident thrownTrident = (ThrownTrident)this;
        if (((AbstractArrowInvoker)thrownTrident).invokeIsInGround()) {
            return this.twod_projectiles$roll % 360.0f;
        }
        float speed = (float)thrownTrident.getDeltaMovement().length();
        float interpolated = this.twod_projectiles$roll + (float)this.twod_projectiles$random * TwoDProjectiles.CONFIG.tridentRoll * speed * f;
        return interpolated % 360.0f;
    }
}

