/*
 * Decompiled with CFR 0.152.
 */
package dev.fable.fablemod.items;

import com.google.common.collect.Lists;
import dev.fable.fablemod.enchantments.ModEnchantments;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1671;
import net.minecraft.class_1676;
import net.minecraft.class_1684;
import net.minecraft.class_1686;
import net.minecraft.class_174;
import net.minecraft.class_1744;
import net.minecraft.class_1764;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1811;
import net.minecraft.class_1836;
import net.minecraft.class_1839;
import net.minecraft.class_1844;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_3745;
import net.minecraft.class_5244;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class TitanCrossbowItem
extends class_1764 {
    public static int ammoValue = 0;
    private boolean breakable;
    private boolean isLoadingStart = false;
    private boolean isLoadingMiddle = false;
    public static boolean charged = false;
    public static String PotionType;
    private static final String CHARGED_KEY = "Charged";
    private static final String CHARGED_PROJECTILES_KEY = "ChargedProjectiles";
    private static final int DEFAULT_PULL_TIME = 25;
    public static final int RANGE = 8;
    private boolean loaded = false;
    private static final float field_30867 = 0.2f;
    private static final float field_30868 = 0.5f;
    private static final float DEFAULT_SPEED = 3.15f;
    private static final float FIREWORK_ROCKET_SPEED = 1.6f;

    private static float getSpeed(class_1799 stack) {
        return TitanCrossbowItem.hasProjectile(stack, class_1802.field_8639) ? 1.6f : 3.15f;
    }

    public static boolean isCharged(class_1799 stack) {
        class_2487 nbtCompound = stack.method_7969();
        return nbtCompound != null && nbtCompound.method_10577(CHARGED_KEY);
    }

    public void method_7843(class_1799 stack, class_1937 world, class_1657 player) {
        TitanCrossbowItem.setMode(stack, 1);
        super.method_7843(stack, world, player);
    }

    public int method_7837() {
        return 22;
    }

    public static void setCharged(class_1799 stack, boolean charged) {
        class_2487 nbtCompound = stack.method_7948();
        nbtCompound.method_10556(CHARGED_KEY, charged);
    }

    public static int getMode(class_1799 stack) {
        if (stack.method_7969() == null) {
            TitanCrossbowItem.setMode(stack, 1);
            return 1;
        }
        class_2487 nbtCompound = stack.method_7969();
        return nbtCompound.method_10550("Mode");
    }

    public static void setMode(class_1799 stack, int mode) {
        class_2487 nbtCompound = stack.method_7948();
        nbtCompound.method_10569("Mode", mode);
        stack.method_7980(nbtCompound);
    }

    private static void clearProjectiles(class_1799 crossbow) {
        class_2487 nbtCompound = crossbow.method_7969();
        if (nbtCompound != null) {
            class_2499 nbtList = nbtCompound.method_10554(CHARGED_PROJECTILES_KEY, 9);
            nbtList.clear();
            nbtCompound.method_10566(CHARGED_PROJECTILES_KEY, (class_2520)nbtList);
        }
    }

    public static boolean hasProjectile(class_1799 crossbow, class_1792 projectile) {
        return TitanCrossbowItem.getProjectiles(crossbow).stream().anyMatch(s -> s.method_31574(projectile));
    }

    private static void shoot(class_1937 world, class_1309 shooter, class_1268 hand, class_1799 crossbow, class_1799 projectile, float soundPitch, boolean creative, float speed, float divergence, float simulated) {
        if (!world.field_9236) {
            class_1665 projectileEntity;
            boolean bl = projectile.method_31574(class_1802.field_8639);
            if (bl) {
                projectileEntity = new class_1671(world, projectile, (class_1297)shooter, shooter.method_23317(), shooter.method_23320() - (double)0.15f, shooter.method_23321(), true);
            } else {
                projectileEntity = TitanCrossbowItem.createArrow(world, shooter, crossbow, projectile);
                if (creative || simulated != 0.0f) {
                    projectileEntity.field_7572 = class_1665.class_1666.field_7594;
                }
            }
            if (projectile.method_7909() == class_1802.field_8436 || projectile.method_7909() == class_1802.field_8150) {
                projectileEntity = new class_1686(world, shooter);
                ((class_1686)projectileEntity).method_16940(projectile);
            }
            if (projectile.method_7909() == class_1802.field_8634) {
                projectileEntity = new class_1684(world, shooter);
                ((class_1684)projectileEntity).method_16940(projectile);
                ((class_1684)projectileEntity).method_5780("crossbow");
            }
            if (shooter instanceof class_3745) {
                class_3745 crossbowUser = (class_3745)shooter;
                crossbowUser.method_18811(crossbowUser.method_5968(), crossbow, (class_1676)projectileEntity, simulated);
            } else {
                class_243 vec3d = shooter.method_18864(1.0f);
                Quaternionf quaternionf = new Quaternionf().setAngleAxis((double)(simulated * ((float)Math.PI / 180)), vec3d.field_1352, vec3d.field_1351, vec3d.field_1350);
                class_243 vec3d2 = shooter.method_5828(1.0f);
                Vector3f vector3f = vec3d2.method_46409().rotate((Quaternionfc)quaternionf);
                ((class_1676)projectileEntity).method_7485((double)vector3f.x(), (double)vector3f.y(), (double)vector3f.z(), speed, divergence);
            }
            crossbow.method_7956(bl ? 3 : 1, shooter, e -> e.method_20236(hand));
            world.method_8649((class_1297)projectileEntity);
            world.method_43128((class_1657)null, shooter.method_23317(), shooter.method_23318(), shooter.method_23321(), class_3417.field_15187, class_3419.field_15248, 1.0f, soundPitch);
        }
    }

    private static class_1665 createArrow(class_1937 world, class_1309 entity, class_1799 crossbow, class_1799 arrow) {
        int t;
        class_1744 arrowItem = (class_1744)(arrow.method_7909() instanceof class_1744 ? arrow.method_7909() : class_1802.field_8107);
        class_1665 persistentProjectileEntity = arrowItem.method_7702(world, arrow, entity);
        if (entity instanceof class_1657) {
            persistentProjectileEntity.method_7439(true);
        }
        persistentProjectileEntity.method_7444(class_3417.field_14636);
        persistentProjectileEntity.method_7442(true);
        int i = class_1890.method_8225((class_1887)class_1893.field_9132, (class_1799)crossbow);
        if (i > 0) {
            persistentProjectileEntity.method_7451((byte)i);
        }
        if ((t = class_1890.method_8225((class_1887)ModEnchantments.TENSION, (class_1799)crossbow)) > 0) {
            persistentProjectileEntity.method_7438(persistentProjectileEntity.method_7448() + (double)t * 0.33 + 0.5);
        }
        return persistentProjectileEntity;
    }

    public static void shootAll(class_1937 world, class_1309 entity, class_1268 hand, class_1799 stack, float speed, float divergence) {
        List<class_1799> list = TitanCrossbowItem.getProjectiles(stack);
        float[] fs = TitanCrossbowItem.getSoundPitches(entity.method_6051());
        for (int i = 0; i < list.size(); ++i) {
            boolean bl;
            class_1799 itemStack = list.get(i);
            boolean bl2 = bl = entity instanceof class_1657 && ((class_1657)entity).method_31549().field_7477;
            if (itemStack.method_7960()) continue;
            float enderPearlFactor = 1.0f;
            if (ammoValue == 3) {
                enderPearlFactor = 0.8f;
            }
            if (i == 0) {
                TitanCrossbowItem.shoot(world, entity, hand, stack, itemStack, fs[i], bl, speed * enderPearlFactor, divergence, 0.0f);
                continue;
            }
            if (i == 1) {
                TitanCrossbowItem.shoot(world, entity, hand, stack, itemStack, fs[i], bl, speed * enderPearlFactor, divergence, -10.0f);
                continue;
            }
            if (i != 2) continue;
            TitanCrossbowItem.shoot(world, entity, hand, stack, itemStack, fs[i], bl, speed * enderPearlFactor, divergence, 10.0f);
        }
        TitanCrossbowItem.postShoot(world, entity, stack);
    }

    private static float[] getSoundPitches(class_5819 random) {
        boolean bl = random.method_43056();
        return new float[]{1.0f, TitanCrossbowItem.getSoundPitch(bl, random), TitanCrossbowItem.getSoundPitch(!bl, random)};
    }

    private static float getSoundPitch(boolean flag, class_5819 random) {
        float f = flag ? 0.63f : 0.43f;
        return 1.0f / (random.method_43057() * 0.5f + 1.8f) + f;
    }

    private static void postShoot(class_1937 world, class_1309 entity, class_1799 stack) {
        if (entity instanceof class_3222) {
            class_3222 serverPlayerEntity = (class_3222)entity;
            if (!world.field_9236) {
                class_174.field_1196.method_9115(serverPlayerEntity, stack);
            }
            serverPlayerEntity.method_7259(class_3468.field_15372.method_14956((Object)stack.method_7909()));
        }
        TitanCrossbowItem.clearProjectiles(stack);
    }

    public void method_7852(class_1937 world, class_1309 user, class_1799 stack, int remainingUseTicks) {
        if (!world.field_9236) {
            int i = class_1890.method_8225((class_1887)class_1893.field_9098, (class_1799)stack);
            class_3414 soundEvent = this.getQuickChargeSound(i);
            class_3414 soundEvent2 = i == 0 ? class_3417.field_14860 : null;
            float f = (float)(stack.method_7935() - remainingUseTicks) / (float)TitanCrossbowItem.getPullTime(stack);
            if (f < 0.2f) {
                charged = false;
                this.loaded = false;
            }
            if (f >= 0.2f) {
                if (!charged) {
                    charged = true;
                    world.method_43128((class_1657)null, user.method_23317(), user.method_23318(), user.method_23321(), soundEvent, class_3419.field_15248, 0.5f, 1.0f);
                }
            }
            if (f >= 0.5f && soundEvent2 != null && !this.loaded) {
                this.loaded = true;
                world.method_43128((class_1657)null, user.method_23317(), user.method_23318(), user.method_23321(), soundEvent2, class_3419.field_15248, 0.5f, 1.0f);
            }
        }
    }

    public int method_7881(class_1799 stack) {
        return TitanCrossbowItem.getPullTime(stack) + 3;
    }

    public static int getPullTime(class_1799 stack) {
        int i = class_1890.method_8225((class_1887)class_1893.field_9098, (class_1799)stack);
        return i == 0 ? 25 : 25 - 5 * i;
    }

    public class_1839 method_7853(class_1799 stack) {
        return class_1839.field_8947;
    }

    private class_3414 getQuickChargeSound(int stage) {
        switch (stage) {
            case 1: {
                return class_3417.field_15011;
            }
            case 2: {
                return class_3417.field_14916;
            }
            case 3: {
                return class_3417.field_15089;
            }
        }
        return class_3417.field_14765;
    }

    private static float getPullProgress(int useTicks, class_1799 stack) {
        float f = (float)useTicks / (float)TitanCrossbowItem.getPullTime(stack);
        if (f > 1.0f) {
            f = 1.0f;
        }
        return f;
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 context) {
        List<class_1799> list = TitanCrossbowItem.getProjectiles(stack);
        if (TitanCrossbowItem.isCharged(stack) && !list.isEmpty()) {
            class_1799 itemStack = list.get(0);
            tooltip.add((class_2561)class_2561.method_43471((String)"item.minecraft.crossbow.projectile").method_10852(class_5244.field_41874).method_10852(itemStack.method_7954()));
            if (context.method_8035() && itemStack.method_31574(class_1802.field_8639)) {
                ArrayList list2 = Lists.newArrayList();
                class_1802.field_8639.method_7851(itemStack, world, (List)list2, context);
                if (!list2.isEmpty()) {
                    for (int i = 0; i < list2.size(); ++i) {
                        list2.set(i, class_2561.method_43470((String)"  ").method_10852((class_2561)list2.get(i)).method_27692(class_124.field_1080));
                    }
                    tooltip.addAll(list2);
                }
            }
        }
    }

    public boolean method_7838(class_1799 stack) {
        return stack.method_31574((class_1792)this);
    }

    public int method_24792() {
        return 8;
    }

    public TitanCrossbowItem(class_1792.class_1793 settings) {
        super(settings);
    }

    public static class_1799 getProjType(class_1799 stack, class_1309 user) {
        if (user instanceof class_1657) {
            class_1657 player = (class_1657)user;
            if (!(stack.method_7909() instanceof class_1811)) {
                return class_1799.field_8037;
            }
            Predicate<class_1799> predicate = ((class_1811)stack.method_7909()).method_20310();
            class_1799 itemStack = class_1811.method_18815((class_1309)user, (Predicate)predicate);
            if (!itemStack.method_7960()) {
                return itemStack;
            }
            predicate = TitanCrossbowItem.getProjectilePredicate(stack);
            for (int i = 0; i < player.method_31548().method_5439(); ++i) {
                class_1799 itemStack2 = player.method_31548().method_5438(i);
                if (!predicate.test(itemStack2)) continue;
                return itemStack2;
            }
            return player.method_31549().field_7477 ? new class_1799((class_1935)class_1802.field_8107) : class_1799.field_8037;
        }
        return class_1799.field_8037;
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        class_1799 itemStack = user.method_5998(hand);
        if (TitanCrossbowItem.isCharged(itemStack)) {
            TitanCrossbowItem.shootAll(world, (class_1309)user, hand, itemStack, TitanCrossbowItem.getSpeed(itemStack), 1.0f);
            TitanCrossbowItem.setCharged(itemStack, false);
            return class_1271.method_22428((Object)itemStack);
        }
        if (!TitanCrossbowItem.getProjType(itemStack, (class_1309)user).method_7960()) {
            if (!TitanCrossbowItem.isCharged(itemStack)) {
                charged = false;
                this.loaded = false;
                user.method_6019(hand);
            }
            return class_1271.method_22428((Object)itemStack);
        }
        return class_1271.method_22431((Object)itemStack);
    }

    public void method_7840(class_1799 stack, class_1937 world, class_1309 user, int remainingUseTicks) {
        int i = this.method_7881(stack) - remainingUseTicks;
        float f = TitanCrossbowItem.getPullProgress(i, stack);
        if (f >= 1.0f && !TitanCrossbowItem.isCharged(stack) && TitanCrossbowItem.loadProjectiles(user, stack)) {
            TitanCrossbowItem.setCharged(stack, true);
            class_3419 soundCategory = user instanceof class_1657 ? class_3419.field_15248 : class_3419.field_15251;
            world.method_43128((class_1657)null, user.method_23317(), user.method_23318(), user.method_23321(), class_3417.field_14626, soundCategory, 1.0f, 1.0f / (world.method_8409().method_43057() * 0.5f + 1.0f) + 0.2f);
        }
    }

    private static boolean loadProjectiles(class_1309 shooter, class_1799 projectile) {
        int i = class_1890.method_8225((class_1887)class_1893.field_9108, (class_1799)projectile);
        int j = i == 0 ? 1 : 3;
        boolean bl = shooter instanceof class_1657 && ((class_1657)shooter).method_31549().field_7477;
        class_1799 itemStack = TitanCrossbowItem.getProjType(projectile, shooter);
        class_1799 itemStack2 = itemStack.method_7972();
        for (int k = 0; k < j; ++k) {
            if (k > 0) {
                itemStack = itemStack2.method_7972();
            }
            if (itemStack.method_7960() && bl) {
                itemStack = new class_1799((class_1935)class_1802.field_8107);
                itemStack2 = itemStack.method_7972();
            }
            if (TitanCrossbowItem.loadProjectile(shooter, projectile, itemStack, k > 0, bl)) continue;
            return false;
        }
        return true;
    }

    private static boolean loadProjectile(class_1309 shooter, class_1799 crossbow, class_1799 projectile, boolean simulated, boolean creative) {
        class_1799 itemStack;
        boolean bl;
        if (projectile.method_7960()) {
            return false;
        }
        boolean bl2 = bl = creative && projectile.method_7909() instanceof class_1744;
        if (!(bl || creative || simulated)) {
            itemStack = projectile.method_7971(1);
            if (projectile.method_7960() && shooter instanceof class_1657) {
                ((class_1657)shooter).method_31548().method_7378(projectile);
            }
        } else {
            itemStack = projectile.method_7972();
        }
        TitanCrossbowItem.putProjectile(crossbow, itemStack);
        return true;
    }

    private static void putProjectile(class_1799 crossbow, class_1799 projectile) {
        class_2487 nbtCompound = crossbow.method_7948();
        class_2499 nbtList = nbtCompound.method_10573(CHARGED_PROJECTILES_KEY, 9) ? nbtCompound.method_10554(CHARGED_PROJECTILES_KEY, 10) : new class_2499();
        class_2487 nbtCompound2 = new class_2487();
        projectile.method_7953(nbtCompound2);
        nbtList.add((Object)nbtCompound2);
        nbtCompound.method_10566(CHARGED_PROJECTILES_KEY, (class_2520)nbtList);
    }

    public Predicate<class_1799> method_20310() {
        return ammoStack -> {
            if (ammoStack.method_7909() == class_1802.field_8107) {
                ammoValue = 0;
                return true;
            }
            if (ammoStack.method_7909() == class_1802.field_8639) {
                ammoValue = 1;
                return true;
            }
            if (ammoStack.method_7909() == class_1802.field_8634) {
                ammoValue = 3;
                return true;
            }
            return false;
        };
    }

    public static boolean hasProjectileForMode(class_1657 player, int mode) {
        if (mode == 1) {
            for (class_1799 stack : player.method_31548().field_7547) {
                if (stack.method_7909() != class_1802.field_8107 && stack.method_7909() != class_1802.field_8236) continue;
                return true;
            }
        }
        if (mode == 2) {
            for (class_1799 stack : player.method_31548().field_7547) {
                if (stack.method_7909() != class_1802.field_8436 && stack.method_7909() != class_1802.field_8150) continue;
                return true;
            }
        }
        return false;
    }

    public static Predicate<class_1799> getProjectilePredicate(class_1799 bowStack) {
        return ammoStack -> {
            if ((ammoStack.method_7909() == class_1802.field_8107 || ammoStack.method_7909() == class_1802.field_8236) && TitanCrossbowItem.getMode(bowStack) == 1) {
                ammoValue = 0;
                return true;
            }
            if ((ammoStack.method_7909() == class_1802.field_8436 || ammoStack.method_7909() == class_1802.field_8150) && TitanCrossbowItem.getMode(bowStack) == 2) {
                ammoValue = 2;
                if (ammoStack.method_7909().method_7886(ammoStack)) {
                    if (((class_1293)class_1844.method_8067((class_1799)ammoStack).get(0)).method_5586().equals("effect.minecraft.night_vision")) {
                        PotionType = "NightVision";
                    }
                    if (((class_1293)class_1844.method_8067((class_1799)ammoStack).get(0)).method_5586().equals("effect.minecraft.invisibility")) {
                        PotionType = "Invisibility";
                    }
                    if (((class_1293)class_1844.method_8067((class_1799)ammoStack).get(0)).method_5586().equals("effect.minecraft.jump_boost")) {
                        PotionType = "JumpBoost";
                    }
                    if (((class_1293)class_1844.method_8067((class_1799)ammoStack).get(0)).method_5586().equals("effect.minecraft.fire_resistance")) {
                        PotionType = "FireResistance";
                    }
                    if (((class_1293)class_1844.method_8067((class_1799)ammoStack).get(0)).method_5586().equals("effect.minecraft.speed")) {
                        PotionType = "Speed";
                    }
                    if (((class_1293)class_1844.method_8067((class_1799)ammoStack).get(0)).method_5586().equals("effect.minecraft.slowness")) {
                        PotionType = "Slowness";
                    }
                    if (((class_1293)class_1844.method_8067((class_1799)ammoStack).get(0)).method_5586().equals("effect.minecraft.water_breathing")) {
                        PotionType = "WaterBreathing";
                    }
                    if (((class_1293)class_1844.method_8067((class_1799)ammoStack).get(0)).method_5586().equals("effect.minecraft.instant_health")) {
                        PotionType = "Health";
                    }
                    if (((class_1293)class_1844.method_8067((class_1799)ammoStack).get(0)).method_5586().equals("effect.minecraft.instant_damage")) {
                        PotionType = "Damage";
                    }
                    if (((class_1293)class_1844.method_8067((class_1799)ammoStack).get(0)).method_5586().equals("effect.minecraft.poison")) {
                        PotionType = "Poison";
                    }
                    if (((class_1293)class_1844.method_8067((class_1799)ammoStack).get(0)).method_5586().equals("effect.minecraft.regeneration")) {
                        PotionType = "Regeneration";
                    }
                    if (((class_1293)class_1844.method_8067((class_1799)ammoStack).get(0)).method_5586().equals("effect.minecraft.strength")) {
                        PotionType = "Strength";
                    }
                    if (((class_1293)class_1844.method_8067((class_1799)ammoStack).get(0)).method_5586().equals("effect.minecraft.weakness")) {
                        PotionType = "Weakness";
                    }
                    if (((class_1293)class_1844.method_8067((class_1799)ammoStack).get(0)).method_5586().equals("effect.minecraft.luck")) {
                        PotionType = "Luck";
                    }
                    if (((class_1293)class_1844.method_8067((class_1799)ammoStack).get(0)).method_5586().equals("effect.minecraft.slow_falling")) {
                        PotionType = "SlowFalling";
                    }
                    if (((class_1293)class_1844.method_8067((class_1799)ammoStack).get(0)).method_5586().equals("effect.fablemod.mending")) {
                        PotionType = "Mending";
                    }
                } else {
                    PotionType = "Water";
                }
                return true;
            }
            return false;
        };
    }

    public static List<class_1799> getProjectiles(class_1799 crossbow) {
        class_2499 nbtList;
        ArrayList list = Lists.newArrayList();
        class_2487 nbtCompound = crossbow.method_7969();
        if (nbtCompound != null && nbtCompound.method_10573(CHARGED_PROJECTILES_KEY, 9) && (nbtList = nbtCompound.method_10554(CHARGED_PROJECTILES_KEY, 10)) != null) {
            for (int i = 0; i < nbtList.size(); ++i) {
                class_2487 nbtCompound2 = nbtList.method_10602(i);
                list.add(class_1799.method_7915((class_2487)nbtCompound2));
            }
        }
        return list;
    }

    public static String getProjectileForTexture(class_1799 crossbow) {
        class_2499 nbtList;
        class_2487 nbtCompound = crossbow.method_7969();
        if (nbtCompound != null && nbtCompound.method_10573(CHARGED_PROJECTILES_KEY, 9) && (nbtList = nbtCompound.method_10554(CHARGED_PROJECTILES_KEY, 10)) != null) {
            return nbtList.toString();
        }
        return "null";
    }

    public boolean method_7870(class_1799 stack) {
        return true;
    }

    public TitanCrossbowItem unbreakable() {
        this.breakable = !this.breakable;
        return this;
    }

    public void method_7860(class_2487 tag) {
        super.method_7860(tag);
        tag.method_10556("Unbreakable", this.breakable);
    }
}

