/*
 * Decompiled with CFR 0.152.
 */
package dev.fable.fablemod.items.fable;

import dev.fable.fablemod.items.fable.effects.FableEffect;
import dev.fable.fablemod.items.fable.materials.FableMaterials;
import dev.fable.fablemod.screen.moonlightpact.MoonlightPactScreenHandler;
import java.util.List;
import java.util.Random;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1829;
import net.minecraft.class_1832;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_3908;
import net.minecraft.class_747;
import org.jetbrains.annotations.Nullable;

public class FableSword
extends class_1829 {
    private FableEffect[] fableEffects;
    private boolean breakable;
    private final Random random = new Random();

    public FableSword(class_1832 toolMaterial, int attackDamage, float attackSpeed, class_1792.class_1793 settings, FableEffect ... fableEffects) {
        super(toolMaterial, attackDamage, attackSpeed, settings);
        this.fableEffects = fableEffects;
    }

    public FableSword unbreakable() {
        this.breakable = !this.breakable;
        return this;
    }

    public void method_7860(class_2487 tag) {
        super.method_7860(tag);
        tag.method_10556("Unbreakable", this.breakable);
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 context) {
        for (FableEffect effect : this.fableEffects) {
            tooltip.add(effect.getTooltip());
        }
        if (this.method_8022() == FableMaterials.NIGHTMARE) {
            int pact = stack.method_7969().method_10550("Pact");
            switch (pact) {
                case 1: {
                    tooltip.add(class_2561.method_30163((String)"\u00a7ePact of \u00a7dRegeneration"));
                    break;
                }
                case 2: {
                    tooltip.add(class_2561.method_30163((String)"\u00a7ePact of \u00a73Swiftness"));
                    break;
                }
                case 3: {
                    tooltip.add(class_2561.method_30163((String)"\u00a7ePact of \u00a76Strength"));
                    break;
                }
                default: {
                    tooltip.add(class_2561.method_30163((String)"\u00a7eNo pact chosen"));
                }
            }
        }
        super.method_7851(stack, world, tooltip, context);
    }

    public boolean method_7873(class_1799 stack, class_1309 target, class_1309 attacker) {
        FableEffect[] fableEffectArray = stack.method_7909();
        if (fableEffectArray instanceof FableSword) {
            FableSword fableSword = (FableSword)fableEffectArray;
            for (FableEffect effect : fableSword.getFableEffects()) {
                int i = this.getRandomNumber(0, effect.getPercentage());
                if (i != 0) continue;
                if (effect.getStatusEffectInstance() != null && !target.method_6059(effect.getStatusEffectInstance().method_5579())) {
                    target.method_6092(new class_1293(effect.getStatusEffectInstance().method_5579(), effect.getStatusEffectInstance().method_5584(), effect.getStatusEffectInstance().method_5578()));
                }
                if (effect.getExecutable() == null || !(attacker instanceof class_1657)) continue;
                class_1657 player = (class_1657)attacker;
                effect.getExecutable().tick(player, target);
            }
            if (fableSword.method_8022() == FableMaterials.NIGHTMARE && stack.method_7969().method_10550("Pact") != 0) {
                Random random;
                int i;
                int pact = stack.method_7969().method_10550("Pact");
                if (attacker instanceof class_1657 && target instanceof class_1657 && (i = (random = new Random()).nextInt(2)) == 1) {
                    switch (pact) {
                        case 1: {
                            if (attacker.method_6059(class_1294.field_5924)) break;
                            attacker.method_6092(new class_1293(class_1294.field_5924, 100, 1));
                            break;
                        }
                        case 2: {
                            if (attacker.method_6059(class_1294.field_5904)) break;
                            attacker.method_6092(new class_1293(class_1294.field_5904, 100, 1));
                            break;
                        }
                        case 3: {
                            if (attacker.method_6059(class_1294.field_5910)) break;
                            attacker.method_6092(new class_1293(class_1294.field_5910, 100, 0));
                        }
                    }
                }
            }
        }
        return super.method_7873(stack, target, attacker);
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        if (!world.method_8608() && this.method_8022() == FableMaterials.NIGHTMARE && user.method_5998(hand).method_7969().method_10550("Pact") == 0) {
            class_1799 stack = user.method_5998(hand);
            user.method_17355((class_3908)new class_747((i, playerInventory, playerEntity) -> new MoonlightPactScreenHandler(i, user.method_31548()), (class_2561)class_2561.method_43471((String)"Choose a pact")));
            return new class_1271(class_1269.field_5812, (Object)user.method_5998(hand));
        }
        return new class_1271(class_1269.field_5814, (Object)user.method_5998(hand));
    }

    public int getRandomNumber(int min, int max) {
        return this.random.nextInt(max - min);
    }

    public static boolean isPactActive(class_1799 stack) {
        FableSword sword;
        class_1792 class_17922 = stack.method_7909();
        if (class_17922 instanceof FableSword && (sword = (FableSword)class_17922).method_8022() == FableMaterials.NIGHTMARE) {
            class_2487 tag = stack.method_7969();
            return tag != null && tag.method_10550("Pact") != 0;
        }
        return false;
    }

    public static int getPactNumber(class_1799 stack) {
        if (FableSword.isPactActive(stack)) {
            class_2487 tag = stack.method_7969();
            assert (tag != null);
            return tag.method_10550("Pact");
        }
        return 0;
    }

    public FableEffect[] getFableEffects() {
        return this.fableEffects;
    }

    public boolean isBreakable() {
        return this.breakable;
    }

    public Random getRandom() {
        return this.random;
    }

    public void setFableEffects(FableEffect[] fableEffects) {
        this.fableEffects = fableEffects;
    }

    public void setBreakable(boolean breakable) {
        this.breakable = breakable;
    }
}

