/*
 * Decompiled with CFR 0.152.
 */
package dev.fable.fablemod.mixin;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_155;
import net.minecraft.class_1944;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_310;
import net.minecraft.class_340;
import net.minecraft.class_4494;
import net.minecraft.class_6880;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_340.class})
@Environment(value=EnvType.CLIENT)
public class DebugHudMixin {
    private final class_310 client = class_310.method_1551();

    @Inject(method={"getLeftText"}, at={@At(value="RETURN")}, cancellable=true)
    private void getLeftText(CallbackInfoReturnable<List<String>> cir) {
        ArrayList list = Lists.newArrayList();
        list.add("Minecraft: " + class_155.method_16673().method_48019() + " (Fabric/Fable)");
        int fps = this.client.method_47599();
        String fpsColor = "\u00a7f";
        if (fps > 60) {
            fpsColor = "\u00a7a";
        }
        if (fps < 60 && fps > 30) {
            fpsColor = "\u00a7e";
        }
        if (fps < 30) {
            fpsColor = "\u00a7c";
        }
        class_2338 blockPos = this.client.method_1560().method_24515();
        int i = this.client.field_1687.method_2935().method_12130().method_22363(blockPos, 0);
        int j = this.client.field_1687.method_8314(class_1944.field_9284, blockPos);
        int k = this.client.field_1687.method_8314(class_1944.field_9282, blockPos);
        list.add("FPS: " + fpsColor + fps);
        list.add("");
        list.add("Facing: " + this.client.method_1560().method_5735().toString());
        list.add("Coordinates:");
        list.add(String.format(Locale.ROOT, "   X: %.2f", this.client.method_1560().method_23317()));
        list.add(String.format(Locale.ROOT, "   Y: %.2f", this.client.method_1560().method_23318()));
        list.add(String.format(Locale.ROOT, "   Z: %.2f", this.client.method_1560().method_23321()));
        list.add("Biome: " + DebugHudMixin.getBiomeString((class_6880<class_1959>)this.client.field_1687.method_23753(blockPos)));
        list.add("Client Light: " + i + " (" + j + " sky, " + k + " block)");
        cir.setReturnValue((Object)list);
    }

    @Inject(method={"getRightText"}, at={@At(value="RETURN")}, cancellable=true)
    private void getRightText(CallbackInfoReturnable<List<String>> cir) {
        long l = Runtime.getRuntime().maxMemory();
        long m = Runtime.getRuntime().totalMemory();
        long n = Runtime.getRuntime().freeMemory();
        long o = m - n;
        ArrayList list = Lists.newArrayList();
        list.add(String.format(Locale.ROOT, "Java: %s %dbit", System.getProperty("java.version"), this.client.method_1540() ? 64 : 32));
        list.add(String.format(Locale.ROOT, "Mem: % 2d%% %03d/%03dMB", o * 100L / l, DebugHudMixin.toMiB(o), DebugHudMixin.toMiB(l)));
        list.add(String.format(Locale.ROOT, "Allocated: % 2d%% %03dMB", m * 100L / l, DebugHudMixin.toMiB(m)));
        list.add("");
        list.add(String.format(Locale.ROOT, "CPU: %s", class_4494.method_22089()));
        list.add(String.format(Locale.ROOT, "Display: %dx%d (%s)", class_310.method_1551().method_22683().method_4489(), class_310.method_1551().method_22683().method_4506(), class_4494.method_22088()));
        list.add(class_4494.method_22090());
        list.add(class_4494.method_22091());
        cir.setReturnValue((Object)list);
    }

    private static long toMiB(long bytes) {
        return bytes / 1024L / 1024L;
    }

    private static String getBiomeString(class_6880<class_1959> biome) {
        return (String)biome.method_40229().map(biomeKey -> biomeKey.method_29177().toString(), biome_ -> "[unregistered " + biome_ + "]");
    }
}

