/*
 * Decompiled with CFR 0.152.
 */
package io.strikeknight57.bca.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import io.strikeknight57.bca.CobblemonAdditions;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import net.fabricmc.loader.api.FabricLoader;
import org.slf4j.Logger;

public class config {
    private static final Logger LOGGER = CobblemonAdditions.LOGGER;
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Path CONFIG_DIR = FabricLoader.getInstance().getConfigDir().resolve("cobblemon-additions");
    private static final Path CONFIG_PATH = CONFIG_DIR.resolve("cobblemon-additions.json");
    public static final Map<String, String> compatOverrides = new HashMap<String, String>();
    private static final String[] DEFAULT_MODS = new String[]{"cobbledollars", "sophisticatedbackpacks", "cobblenav", "travelersbackpack", "waystones"};
    public static boolean enableLootScan = false;
    public static final Map<String, JsonArray> lootWeights = new HashMap<String, JsonArray>();

    private static JsonObject defaultLootWeights() {
        JsonObject lootWeightsObj = new JsonObject();
        lootWeightsObj.add("general/attic", (JsonElement)config.arrayOf(config.entry("sophisticatedbackpacks", "sophisticatedbackpacks:upgrade_base", 1), config.entry("cobblenav", "cobblenav:pokenav_item_base", 1), config.entry("travelersbackpack", "travelersbackpack:iron_tier_upgrade", 1), config.air(35)));
        lootWeightsObj.add("general/bedroom", (JsonElement)config.arrayOf(config.entry("sophisticatedbackpacks", "sophisticatedbackpacks:backpack", 1), config.entry("cobblenav", "cobblenav:pokenav_item_base", 1), config.entry("travelersbackpack", "travelersbackpack:iron", 1), config.entry("waystones", "waystones:warp_scroll", 8), config.air(35)));
        lootWeightsObj.add("general/kitchen", (JsonElement)config.arrayOf(config.entry("sophisticatedbackpacks", "sophisticatedbackpacks:backpack", 1), config.entry("cobblenav", "cobblenav:pokefinder_item_black", 1), config.entry("travelersbackpack", "travelersbackpack:red_sleeping_bag", 2), config.air(35)));
        lootWeightsObj.add("general/pokecenter", (JsonElement)config.arrayOf(config.entry("sophisticatedbackpacks", "sophisticatedbackpacks:upgrade_base", 4), config.entry("sophisticatedbackpacks", "sophisticatedbackpacks:backpack", 1), config.entry("cobblenav", "cobblenav:pokenav_item_base", 1), config.entry("travelersbackpack", "travelersbackpack:iron_tier_upgrade", 1), config.air(35)));
        lootWeightsObj.add("general/sittingroom", (JsonElement)config.arrayOf(config.entry("sophisticatedbackpacks", "sophisticatedbackpacks:upgrade_base", 1), config.entry("cobblenav", "cobblenav:pokenav_item_base", 1), config.entry("travelersbackpack", "travelersbackpack:iron_tier_upgrade", 1), config.air(35)));
        return lootWeightsObj;
    }

    private static JsonArray arrayOf(JsonObject ... objs) {
        JsonArray arr = new JsonArray();
        for (JsonObject o : objs) {
            arr.add((JsonElement)o);
        }
        return arr;
    }

    private static JsonObject entry(String mod, String item, int weight) {
        JsonObject obj = new JsonObject();
        obj.addProperty("mod", mod);
        obj.addProperty("item", item);
        obj.addProperty("weight", (Number)weight);
        return obj;
    }

    private static JsonObject air(int weight) {
        JsonObject obj = new JsonObject();
        obj.addProperty("air", Boolean.valueOf(true));
        obj.addProperty("weight", (Number)weight);
        return obj;
    }

    public static void init() {
        JsonObject datagenObj;
        JsonObject root;
        try {
            Files.createDirectories(CONFIG_DIR, new FileAttribute[0]);
        }
        catch (IOException e) {
            LOGGER.error("Failed to create config directory: {}", (Object)CONFIG_DIR, (Object)e);
        }
        if (Files.exists(CONFIG_PATH, new LinkOption[0])) {
            try {
                String json = Files.readString(CONFIG_PATH);
                root = JsonParser.parseString((String)json).getAsJsonObject();
            }
            catch (IOException e) {
                LOGGER.error("Failed to read config file", (Throwable)e);
                root = new JsonObject();
            }
        } else {
            root = new JsonObject();
        }
        JsonObject compatObj = root.has("compat") && root.get("compat").isJsonObject() ? root.getAsJsonObject("compat") : new JsonObject();
        config.ensureDefaults(compatObj);
        compatOverrides.clear();
        for (Map.Entry entry : compatObj.entrySet()) {
            compatOverrides.put((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
        }
        root.add("compat", (JsonElement)compatObj);
        JsonObject jsonObject = datagenObj = root.has("datagen") && root.get("datagen").isJsonObject() ? root.getAsJsonObject("datagen") : new JsonObject();
        if (datagenObj.has("enableLootScan")) {
            enableLootScan = datagenObj.get("enableLootScan").getAsBoolean();
        } else {
            datagenObj.addProperty("enableLootScan", Boolean.valueOf(enableLootScan));
        }
        root.add("datagen", (JsonElement)datagenObj);
        JsonObject lootWeightsObj = root.has("lootModWeights") && root.get("lootModWeights").isJsonObject() ? root.getAsJsonObject("lootModWeights") : config.defaultLootWeights();
        lootWeights.clear();
        for (Map.Entry entry : lootWeightsObj.entrySet()) {
            if (!((JsonElement)entry.getValue()).isJsonArray()) continue;
            lootWeights.put((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsJsonArray());
        }
        root.add("lootModWeights", (JsonElement)lootWeightsObj);
        try {
            Files.writeString(CONFIG_PATH, (CharSequence)GSON.toJson((JsonElement)root), new OpenOption[0]);
        }
        catch (IOException e) {
            LOGGER.error("Failed to save config file", (Throwable)e);
        }
        config.mirrorDataSelective("data", "data");
    }

    private static void ensureDefaults(JsonObject compatObj) {
        for (String modId : DEFAULT_MODS) {
            if (compatObj.has(modId)) continue;
            compatObj.addProperty(modId, "");
        }
    }

    private static void mirrorDataSelective(String resourcePath, String targetSubPath) {
        Path targetDir = CONFIG_DIR.resolve(targetSubPath);
        try {
            Files.createDirectories(targetDir, new FileAttribute[0]);
            Path resourceRoot = Paths.get("../build/resources/main", new String[0]).resolve(resourcePath).normalize();
            if (!Files.exists(resourceRoot, new LinkOption[0])) {
                LOGGER.warn("Resource root not found: {}", (Object)resourceRoot);
                return;
            }
            AtomicInteger copiedJson = new AtomicInteger();
            AtomicInteger copiedNbt = new AtomicInteger();
            Files.walk(resourceRoot, new FileVisitOption[0]).forEach(path -> {
                Path relative;
                if (!Files.isRegularFile(path, new LinkOption[0])) {
                    return;
                }
                String name = path.getFileName().toString().toLowerCase();
                boolean isJson = name.endsWith(".json");
                boolean isNbtInStoreFolder = false;
                if (name.endsWith(".nbt")) {
                    relative = resourceRoot.relativize((Path)path);
                    for (int i = 0; i < relative.getNameCount() - 1; ++i) {
                        String folder = relative.getName(i).toString().toLowerCase();
                        if (!folder.contains("store")) continue;
                        isNbtInStoreFolder = true;
                        break;
                    }
                }
                if (isJson || isNbtInStoreFolder) {
                    try {
                        relative = resourceRoot.relativize((Path)path);
                        Path targetFile = targetDir.resolve(relative.toString());
                        Files.createDirectories(targetFile.getParent(), new FileAttribute[0]);
                        if (!Files.exists(targetFile, new LinkOption[0])) {
                            Files.copy(path, targetFile, new CopyOption[0]);
                            if (isJson) {
                                copiedJson.getAndIncrement();
                            } else {
                                copiedNbt.getAndIncrement();
                            }
                        }
                    }
                    catch (IOException e) {
                        LOGGER.error("Failed to copy {}", path, (Object)e);
                    }
                }
            });
        }
        catch (IOException e) {
            LOGGER.error("Failed to mirror data selectively: {}", (Object)targetDir, (Object)e);
        }
    }
}

