/*
 * Decompiled with CFR 0.152.
 */
package io.strikeknight57.bca.loot;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.strikeknight57.bca.CobblemonAdditions;
import io.strikeknight57.bca.config.config;
import io.strikeknight57.bca.util.ModCompat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.loot.v3.LootTableEvents;
import net.fabricmc.fabric.api.loot.v3.LootTableSource;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_44;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_55;
import net.minecraft.class_5658;
import net.minecraft.class_5662;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_77;
import net.minecraft.class_79;
import net.minecraft.class_7924;

public final class ModifyLootTables {
    private static final String RESOURCE_NAMESPACE = "bca";
    private static final Map<class_2960, List<LootEntryConfig>> LOOT_TABLE_CONFIG = new HashMap<class_2960, List<LootEntryConfig>>();

    public static void init() {
        LootTableEvents.MODIFY.register(ModifyLootTables::modifyLootTable);
    }

    private static void modifyLootTable(class_5321<class_52> key, class_52.class_53 tableBuilder, LootTableSource source, class_7225.class_7874 registries) {
        class_2960 tableId = key.method_29177();
        List<LootEntryConfig> entries = LOOT_TABLE_CONFIG.get(tableId);
        if (entries == null) {
            return;
        }
        class_55.class_56 pool = class_55.method_347().method_352((class_5658)class_5662.method_32462((float)class_44.method_32448((float)0.0f).comp_1895(), (float)class_44.method_32448((float)1.0f).comp_1895()));
        class_7225.class_7226 itemRegistry = registries.method_46762(class_7924.field_41197);
        for (LootEntryConfig cfg : entries) {
            if (!cfg.shouldAdd()) continue;
            if (cfg.itemId == null) {
                pool.method_351((class_79.class_80)class_77.method_411((class_1935)class_1802.field_8162).method_437(cfg.weight));
                continue;
            }
            class_2960 itemId = class_2960.method_12829((String)cfg.itemId);
            if (itemId == null) {
                CobblemonAdditions.LOGGER.warn("Skipping malformed item ID '{}' for loot table {}", (Object)cfg.itemId, (Object)tableId);
                continue;
            }
            class_5321 itemKey = class_5321.method_29179((class_5321)class_7924.field_41197, (class_2960)itemId);
            Optional ref = itemRegistry.method_46746(itemKey);
            if (ref.isEmpty()) {
                CobblemonAdditions.LOGGER.debug("Skipping missing item '{}' for loot table {}", (Object)cfg.itemId, (Object)tableId);
                continue;
            }
            pool.method_351((class_79.class_80)class_77.method_411((class_1935)((class_1935)((class_6880.class_6883)ref.get()).comp_349())).method_437(cfg.weight));
        }
        tableBuilder.method_336(pool);
        CobblemonAdditions.LOGGER.debug("Modified loot table {}", (Object)tableId);
    }

    private static void loadFromConfig() {
        LOOT_TABLE_CONFIG.clear();
        for (Map.Entry<String, JsonArray> entry : config.lootWeights.entrySet()) {
            class_2960 id = class_2960.method_60655((String)RESOURCE_NAMESPACE, (String)entry.getKey());
            ArrayList<LootEntryConfig> entries = new ArrayList<LootEntryConfig>();
            for (JsonElement el : entry.getValue()) {
                JsonObject obj = el.getAsJsonObject();
                int weight = obj.get("weight").getAsInt();
                if (obj.has("air") && obj.get("air").getAsBoolean()) {
                    entries.add(new LootEntryConfig(() -> true, null, weight));
                    continue;
                }
                String mod = obj.get("mod").getAsString();
                String item = obj.get("item").getAsString();
                entries.add(new LootEntryConfig(() -> ModCompat.isEnabled(mod), item, weight));
            }
            LOOT_TABLE_CONFIG.put(id, entries);
        }
    }

    private ModifyLootTables() {
    }

    static {
        ModifyLootTables.loadFromConfig();
    }

    private record LootEntryConfig(Supplier<Boolean> condition, String itemId, int weight) {
        boolean shouldAdd() {
            return this.condition.get();
        }
    }
}

