/*
 * Decompiled with CFR 0.152.
 */
package io.strikeknight57.bca.util;

import io.strikeknight57.bca.CobblemonAdditions;
import io.strikeknight57.bca.config.config;
import io.strikeknight57.bca.loot.ModifyLootTables;
import java.util.LinkedHashMap;
import java.util.Map;
import net.fabricmc.loader.api.FabricLoader;
import org.slf4j.Logger;

public class ModCompat {
    private static final Logger LOGGER = CobblemonAdditions.LOGGER;
    private static final Map<String, Boolean> MODS = new LinkedHashMap<String, Boolean>();

    public static void init() {
        ModCompat.detectMods();
        if (MODS.values().stream().anyMatch(Boolean::booleanValue)) {
            ModifyLootTables.init();
        }
    }

    private static void detectMods() {
        for (Map.Entry<String, String> entry : config.compatOverrides.entrySet()) {
            String modId = entry.getKey();
            String override = entry.getValue();
            boolean enabled = "true".equalsIgnoreCase(override) ? true : ("false".equalsIgnoreCase(override) ? false : FabricLoader.getInstance().isModLoaded(modId));
            MODS.put(modId, enabled);
        }
        LOGGER.info("Mod compatibility check results: {}", MODS);
    }

    public static boolean isEnabled(String modId) {
        return MODS.getOrDefault(modId, false);
    }
}

