/*
 * Decompiled with CFR 0.152.
 */
package io.strikeknight57.bca.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.strikeknight57.bca.net.packet.RaycastBlockC2SPayload;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2621;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_7225;

public class RaycastReceiver {
    private static final Map<String, class_2960> PREDEFINED_LOOT_TABLES = Map.of("bca:general/attic", class_2960.method_60655((String)"bca", (String)"general/attic"), "bca:general/bedroom", class_2960.method_60655((String)"bca", (String)"general/bedroom"), "bca:general/kitchen", class_2960.method_60655((String)"bca", (String)"general/kitchen"), "bca:general/pokecenter", class_2960.method_60655((String)"bca", (String)"general/pokecenter"), "bca:general/sittingroom", class_2960.method_60655((String)"bca", (String)"general/sittingroom"));

    public static void init() {
        PayloadTypeRegistry.playC2S().register(RaycastBlockC2SPayload.ID, RaycastBlockC2SPayload.CODEC);
        ServerPlayNetworking.registerGlobalReceiver(RaycastBlockC2SPayload.ID, (payload, context) -> {
            if (!context.player().method_7337()) {
                return;
            }
            context.server().execute(() -> {
                class_2621 lootable;
                class_5321 tableKey;
                class_1937 world = context.player().method_37908();
                class_2586 block = world.method_8321(payload.pos());
                if (block == null) {
                    return;
                }
                RaycastReceiver.replaceLoot(context, block, world, payload);
                if (block instanceof class_2621 && (tableKey = (lootable = (class_2621)block).method_54869()) != null) {
                    class_52 lootTable = world.method_8503().method_58576().method_58295(tableKey);
                    class_52.field_50021.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)lootTable).resultOrPartial(System.err::println).ifPresent(json -> RaycastReceiver.sendLootTableInfo(context.player(), json.getAsJsonObject()));
                }
            });
        });
    }

    private static void replaceLoot(ServerPlayNetworking.Context context, class_2586 block, class_1937 world, RaycastBlockC2SPayload payload) {
        String key = payload.lootTable().toLowerCase(Locale.ROOT).trim();
        class_2960 lootTableId = PREDEFINED_LOOT_TABLES.get(key);
        if (lootTableId == null) {
            context.player().method_43496((class_2561)class_2561.method_43470((String)("Unknown loot table name: " + payload.lootTable())));
            return;
        }
        class_2487 nbtCompound = new class_2487();
        nbtCompound.method_10582("LootTable", lootTableId.toString());
        class_2680 blockState = block.method_10997().method_8320(payload.pos());
        block.method_58690(nbtCompound, (class_7225.class_7874)world.method_30349());
        block.method_5431();
        block.method_10997().method_8413(payload.pos(), blockState, blockState, 1);
        context.player().method_43496((class_2561)class_2561.method_43470((String)"Replacing loot table:"));
        context.player().method_43496((class_2561)class_2561.method_43470((String)block.method_11016().toString()));
        context.player().method_43496((class_2561)class_2561.method_43470((String)("Loot table: " + String.valueOf(lootTableId))));
    }

    private static String getCountRange(JsonObject entry) {
        Object countRange = "1";
        if (entry.has("functions")) {
            for (JsonElement funcEl : entry.getAsJsonArray("functions")) {
                JsonObject func = funcEl.getAsJsonObject();
                if (!"minecraft:set_count".equals(func.get("function").getAsString()) || !func.has("count")) continue;
                JsonObject countObj = func.getAsJsonObject("count");
                int min = countObj.has("min") ? countObj.get("min").getAsInt() : 1;
                int max = countObj.has("max") ? countObj.get("max").getAsInt() : min;
                countRange = min == max ? String.valueOf(min) : min + "-" + max;
            }
        }
        return countRange;
    }

    private static double getTotalWeight(JsonArray entries) {
        double total = 0.0;
        for (JsonElement entryEl : entries) {
            JsonObject entry = entryEl.getAsJsonObject();
            total += entry.has("weight") ? entry.get("weight").getAsDouble() : 1.0;
        }
        return total;
    }

    private static String formatName(String rawName) {
        if (rawName.contains(":")) {
            rawName = rawName.substring(rawName.indexOf(":") + 1);
        }
        String[] words = rawName.split("_");
        StringBuilder formatted = new StringBuilder();
        for (String word : words) {
            if (word.isEmpty()) continue;
            formatted.append(Character.toUpperCase(word.charAt(0))).append(word.substring(1)).append(" ");
        }
        return formatted.toString().trim();
    }

    private static List<EntryInfo> buildVerboseEntries(JsonArray entries) {
        double totalWeight = RaycastReceiver.getTotalWeight(entries);
        ArrayList<EntryInfo> infos = new ArrayList<EntryInfo>();
        for (JsonElement entryEl : entries) {
            JsonObject entry = entryEl.getAsJsonObject();
            String name = RaycastReceiver.formatName(entry.has("name") ? entry.get("name").getAsString() : "(no name)");
            double weight = entry.has("weight") ? entry.get("weight").getAsDouble() : 1.0;
            String countRange = RaycastReceiver.getCountRange(entry);
            double chanceVal = weight / totalWeight * 100.0;
            String chanceStr = String.format("%.2f", chanceVal) + "%";
            infos.add(new EntryInfo(chanceVal, "  - " + chanceStr + " chance to spawn " + countRange + " " + name + "\n"));
        }
        infos.sort((a, b) -> Double.compare(b.chance, a.chance));
        return infos;
    }

    private static List<String> buildCompactEntries(JsonArray entries) {
        double totalWeight = RaycastReceiver.getTotalWeight(entries);
        ArrayList<String> compact = new ArrayList<String>();
        for (JsonElement entryEl : entries) {
            JsonObject entry = entryEl.getAsJsonObject();
            String name = RaycastReceiver.formatName(entry.has("name") ? entry.get("name").getAsString() : "(no name)");
            double weight = entry.has("weight") ? entry.get("weight").getAsDouble() : 1.0;
            String countRange = RaycastReceiver.getCountRange(entry);
            String chanceStr = String.format("%.2f", weight / totalWeight * 100.0) + "%";
            compact.add(countRange + " " + name + ": " + chanceStr);
        }
        return compact;
    }

    private static long countLines(String text) {
        return text.chars().filter(ch -> ch == 10).count() + (long)(!text.isEmpty() && text.charAt(text.length() - 1) != '\n' ? 1 : 0);
    }

    private static void sendLootTableInfo(class_3222 player, JsonObject root) {
        if (!root.has("pools")) {
            return;
        }
        JsonArray pools = root.getAsJsonArray("pools");
        StringBuilder output = new StringBuilder("Total Pools: ").append(pools.size()).append("\n");
        for (int i = 0; i < pools.size(); ++i) {
            JsonObject pool = pools.get(i).getAsJsonObject();
            if (pool.has("rolls")) {
                JsonObject rolls = pool.getAsJsonObject("rolls");
                output.append("  Pool ").append(i + 1).append(" Rolled ").append(rolls.get("min").getAsInt()).append(" - ").append(rolls.get("max").getAsInt()).append(" Times:\n");
            }
            if (!pool.has("entries")) continue;
            for (EntryInfo info : RaycastReceiver.buildVerboseEntries(pool.getAsJsonArray("entries"))) {
                output.append(info.line);
            }
        }
        if (RaycastReceiver.countLines(output.toString()) <= 75L) {
            player.method_43496((class_2561)class_2561.method_43470((String)output.toString()));
            return;
        }
        StringBuilder compactOutput = new StringBuilder("Total Pools: ").append(pools.size()).append("\n");
        for (int i = 0; i < pools.size(); ++i) {
            JsonObject pool = pools.get(i).getAsJsonObject();
            if (pool.has("rolls")) {
                JsonObject rolls = pool.getAsJsonObject("rolls");
                compactOutput.append("  Pool ").append(i + 1).append(" Rolled ").append(rolls.get("min").getAsInt()).append("-").append(rolls.get("max").getAsInt()).append(" Times:\n");
            }
            if (!pool.has("entries")) continue;
            compactOutput.append("    [").append(String.join((CharSequence)", ", RaycastReceiver.buildCompactEntries(pool.getAsJsonArray("entries")))).append("]\n");
        }
        if (RaycastReceiver.countLines(compactOutput.toString()) <= 25L) {
            player.method_43496((class_2561)class_2561.method_43470((String)compactOutput.toString()));
            return;
        }
        ArrayList<CallSite> poolStrings = new ArrayList<CallSite>();
        for (int i = 0; i < pools.size(); ++i) {
            JsonObject pool = pools.get(i).getAsJsonObject();
            Object rollInfo = "";
            if (pool.has("rolls")) {
                JsonObject rolls = pool.getAsJsonObject("rolls");
                rollInfo = "Pool " + (i + 1) + " Rolled " + rolls.get("min").getAsInt() + "-" + rolls.get("max").getAsInt() + " Times: ";
            }
            String entriesStr = "[" + String.join((CharSequence)", ", RaycastReceiver.buildCompactEntries(pool.getAsJsonArray("entries"))) + "]";
            poolStrings.add((CallSite)((Object)((String)rollInfo + entriesStr)));
        }
        player.method_43496((class_2561)class_2561.method_43470((String)(pools.size() + " Total Pools: {" + String.join((CharSequence)", ", poolStrings) + "}")));
    }

    private static class EntryInfo {
        double chance;
        String line;

        EntryInfo(double chance, String line) {
            this.chance = chance;
            this.line = line;
        }
    }
}

