package net.fellter.vanillavsplus.block;

import java.util.Arrays;
import java.util.function.Predicate;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import net.minecraft.block.*;
import net.minecraft.class_10;
import net.minecraft.class_10225;
import net.minecraft.class_1309;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2510;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2754;
import net.minecraft.class_2760;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_4538;
import net.minecraft.class_5819;
import com.mojang.serialization.MapCodec;

public class VerticalStairsBlock extends class_2248 implements class_3737 {
	@SuppressWarnings("unused")
	public static final MapCodec<VerticalStairsBlock> field_46280 = method_54094(VerticalStairsBlock::new);
	public static final class_2754<VerticalStairShape> SHAPE = class_2754.method_11850("vertical_stair_shape", VerticalStairShape.class);
	public static final class_2754<class_2350> FACING = class_2741.field_12481;
	public static final class_2746 WATERLOGGED = class_2741.field_12508;
	public static final class_2754<BlockSide> SIDE = class_2754.method_11850("block_side", BlockSide.class);
	protected static final class_265 NORTH_BASE = class_2248.method_9541(0, 0, 0, 16, 16, 8);
	protected static final class_265 SOUTH_BASE = class_2248.method_9541(0, 0, 8, 16, 16, 16);
	protected static final class_265 WEST_BASE = class_2248.method_9541(0, 0, 0, 8, 16, 16);
	protected static final class_265 EAST_BASE = class_2248.method_9541(8, 0, 0, 16, 16, 16);
	protected static final class_265 BOTTOM_1 = class_2248.method_9541(0.0, 0.0, 0.0, 8.0, 8.0, 8.0);
	protected static final class_265 BOTTOM_4 = class_2248.method_9541(0.0, 0.0, 8.0, 8.0, 8.0, 16.0);
	protected static final class_265 TOP_1 = class_2248.method_9541(0.0, 8.0, 0.0, 8.0, 16.0, 8.0);
	protected static final class_265 TOP_4 = class_2248.method_9541(0.0, 8.0, 8.0, 8.0, 16.0, 16.0);
	protected static final class_265 BOTTOM_2 = class_2248.method_9541(8.0, 0.0, 0.0, 16.0, 8.0, 8.0);
	protected static final class_265 BOTTOM_3 = class_2248.method_9541(8.0, 0.0, 8.0, 16.0, 8.0, 16.0);
	protected static final class_265 TOP_2 = class_2248.method_9541(8.0, 8.0, 0.0, 16.0, 16.0, 8.0);
	protected static final class_265 TOP_3 = class_2248.method_9541(8.0, 8.0, 8.0, 16.0, 16.0, 16.0);

	public VerticalStairsBlock(class_2251 settings) {
		super(settings);
		this.method_9590(this.method_9595().method_11664().method_11657(FACING, class_2350.field_11043).method_11657(WATERLOGGED, false).method_11657(SIDE, BlockSide.LEFT).method_11657(SHAPE, VerticalStairShape.STRAIGHT_LEFT));
	}

	@Override
	protected class_265 method_9549(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
		return this.method_9530(state, world, pos, context);
	}

	@Override
	protected MapCodec<? extends class_2248> method_53969() {
		return field_46280;
	}

	@Override
	protected class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
		Direction direction = state.get(FACING);
		VerticalStairShape stairShape = state.get(SHAPE);
		VoxelShape voxelShape;

		if (state.get(SIDE) == BlockSide.LEFT || state.get(SIDE) == BlockSide.RIGHT) {
			switch (direction) {
				case NORTH -> {
					switch (stairShape) {
						case STRAIGHT_LEFT -> voxelShape = VoxelShapes.union(NORTH_BASE, BOTTOM_4, TOP_4);
						case INNER_TOP_LEFT -> voxelShape = VoxelShapes.union(NORTH_BASE, BOTTOM_4, TOP_4, TOP_3);
						case INNER_BOTTOM_LEFT -> voxelShape = VoxelShapes.union(NORTH_BASE, BOTTOM_4, TOP_4, BOTTOM_3);
						case OUTER_TOP_LEFT -> voxelShape = VoxelShapes.union(NORTH_BASE, TOP_4);
						case OUTER_BOTTOM_LEFT -> voxelShape = VoxelShapes.union(NORTH_BASE, BOTTOM_4);

						case STRAIGHT_RIGHT -> voxelShape = VoxelShapes.union(NORTH_BASE, BOTTOM_3, TOP_3);
						case INNER_TOP_RIGHT -> voxelShape = VoxelShapes.union(NORTH_BASE, BOTTOM_3, TOP_3, TOP_4);
						case INNER_BOTTOM_RIGHT -> voxelShape = VoxelShapes.union(NORTH_BASE, BOTTOM_3, TOP_3, BOTTOM_4);
						case OUTER_TOP_RIGHT -> voxelShape = VoxelShapes.union(NORTH_BASE, TOP_3);
						case OUTER_BOTTOM_RIGHT -> voxelShape = VoxelShapes.union(NORTH_BASE, BOTTOM_3);

						case OUTER_TOP_LEFT_R90 -> voxelShape = VoxelShapes.union(EAST_BASE, TOP_1);
						case OUTER_BOTTOM_LEFT_R90 -> voxelShape = VoxelShapes.union(EAST_BASE, BOTTOM_1);
						case OUTER_TOP_RIGHT_R90 -> voxelShape = VoxelShapes.union(WEST_BASE, TOP_2);
						case OUTER_BOTTOM_RIGHT_R90 -> voxelShape = VoxelShapes.union(WEST_BASE, BOTTOM_2);
						case null, default -> voxelShape = VoxelShapes.fullCube();
					}
				}
				case SOUTH -> {
					switch (stairShape) {
						case STRAIGHT_LEFT -> voxelShape = VoxelShapes.union(SOUTH_BASE, BOTTOM_2, TOP_2);
						case INNER_TOP_LEFT -> voxelShape = VoxelShapes.union(SOUTH_BASE, BOTTOM_2, TOP_2, TOP_1);
						case INNER_BOTTOM_LEFT -> voxelShape = VoxelShapes.union(SOUTH_BASE, BOTTOM_2, TOP_2, BOTTOM_1);
						case OUTER_TOP_LEFT -> voxelShape = VoxelShapes.union(SOUTH_BASE, TOP_2);
						case OUTER_BOTTOM_LEFT -> voxelShape = VoxelShapes.union(SOUTH_BASE, BOTTOM_2);

						case STRAIGHT_RIGHT -> voxelShape = VoxelShapes.union(SOUTH_BASE, BOTTOM_1, TOP_1);
						case INNER_TOP_RIGHT -> voxelShape = VoxelShapes.union(SOUTH_BASE, BOTTOM_1, TOP_1, TOP_2);
						case INNER_BOTTOM_RIGHT -> voxelShape = VoxelShapes.union(SOUTH_BASE, BOTTOM_1, TOP_1, BOTTOM_2);
						case OUTER_TOP_RIGHT -> voxelShape = VoxelShapes.union(SOUTH_BASE, TOP_1);
						case OUTER_BOTTOM_RIGHT -> voxelShape = VoxelShapes.union(SOUTH_BASE, BOTTOM_1);

						case OUTER_TOP_LEFT_R90 -> voxelShape = VoxelShapes.union(WEST_BASE, TOP_3);
						case OUTER_BOTTOM_LEFT_R90 -> voxelShape = VoxelShapes.union(WEST_BASE, BOTTOM_3);
						case OUTER_TOP_RIGHT_R90 -> voxelShape = VoxelShapes.union(EAST_BASE, TOP_4);
						case OUTER_BOTTOM_RIGHT_R90 -> voxelShape = VoxelShapes.union(EAST_BASE, BOTTOM_4);
						case null, default -> voxelShape = VoxelShapes.fullCube();
					}
				}
				case EAST -> {
					switch (stairShape) {
						case STRAIGHT_LEFT -> voxelShape = VoxelShapes.union(EAST_BASE, BOTTOM_1, TOP_1);
						case INNER_TOP_LEFT -> voxelShape = VoxelShapes.union(EAST_BASE, BOTTOM_1, TOP_1, TOP_4);
						case INNER_BOTTOM_LEFT -> voxelShape = VoxelShapes.union(EAST_BASE, BOTTOM_1, TOP_1, BOTTOM_4);
						case OUTER_TOP_LEFT -> voxelShape = VoxelShapes.union(EAST_BASE, TOP_1);
						case OUTER_BOTTOM_LEFT -> voxelShape = VoxelShapes.union(EAST_BASE, BOTTOM_1);

						case STRAIGHT_RIGHT -> voxelShape = VoxelShapes.union(EAST_BASE, BOTTOM_4, TOP_4);
						case INNER_TOP_RIGHT -> voxelShape = VoxelShapes.union(EAST_BASE, BOTTOM_4, TOP_4, TOP_1);
						case INNER_BOTTOM_RIGHT -> voxelShape = VoxelShapes.union(EAST_BASE, BOTTOM_4, TOP_4, BOTTOM_1);
						case OUTER_TOP_RIGHT -> voxelShape = VoxelShapes.union(EAST_BASE, TOP_4);
						case OUTER_BOTTOM_RIGHT -> voxelShape = VoxelShapes.union(EAST_BASE, BOTTOM_4);

						case OUTER_TOP_LEFT_R90 -> voxelShape = VoxelShapes.union(SOUTH_BASE, TOP_2);
						case OUTER_BOTTOM_LEFT_R90 -> voxelShape = VoxelShapes.union(SOUTH_BASE, BOTTOM_2);
						case OUTER_TOP_RIGHT_R90 -> voxelShape = VoxelShapes.union(NORTH_BASE, TOP_3);
						case OUTER_BOTTOM_RIGHT_R90 -> voxelShape = VoxelShapes.union(NORTH_BASE, BOTTOM_3);
						case null, default -> voxelShape = VoxelShapes.fullCube();
					}
				}
				case WEST -> {
					switch (stairShape) {
						case STRAIGHT_LEFT -> voxelShape = VoxelShapes.union(WEST_BASE, BOTTOM_3, TOP_3);
						case INNER_TOP_LEFT -> voxelShape = VoxelShapes.union(WEST_BASE, BOTTOM_3, TOP_3, TOP_2);
						case INNER_BOTTOM_LEFT -> voxelShape = VoxelShapes.union(WEST_BASE, BOTTOM_3, TOP_3, BOTTOM_2);
						case OUTER_TOP_LEFT -> voxelShape = VoxelShapes.union(WEST_BASE, TOP_3);
						case OUTER_BOTTOM_LEFT -> voxelShape = VoxelShapes.union(WEST_BASE, BOTTOM_3);

						case STRAIGHT_RIGHT -> voxelShape = VoxelShapes.union(WEST_BASE, BOTTOM_2, TOP_2);
						case INNER_TOP_RIGHT -> voxelShape = VoxelShapes.union(WEST_BASE, BOTTOM_2, TOP_2, TOP_3);
						case INNER_BOTTOM_RIGHT -> voxelShape = VoxelShapes.union(WEST_BASE, BOTTOM_2, TOP_2, BOTTOM_3);
						case OUTER_TOP_RIGHT -> voxelShape = VoxelShapes.union(WEST_BASE, TOP_2);
						case OUTER_BOTTOM_RIGHT -> voxelShape = VoxelShapes.union(WEST_BASE, BOTTOM_2);

						case OUTER_TOP_LEFT_R90 -> voxelShape = VoxelShapes.union(NORTH_BASE, TOP_4);
						case OUTER_BOTTOM_LEFT_R90 -> voxelShape = VoxelShapes.union(NORTH_BASE, BOTTOM_4);
						case OUTER_TOP_RIGHT_R90 -> voxelShape = VoxelShapes.union(SOUTH_BASE, TOP_1);
						case OUTER_BOTTOM_RIGHT_R90 -> voxelShape = VoxelShapes.union(SOUTH_BASE, BOTTOM_1);
						case null, default -> voxelShape = VoxelShapes.fullCube();
					}
				}
				case null, default -> voxelShape = VoxelShapes.fullCube();
			}

			return voxelShape;
		} else {
			return VoxelShapes.fullCube();
		}
	}

	@Override
	public class_2680 method_9605(class_1750 ctx) {
		class_2350 direction = ctx.method_8042();
		class_2338 blockPos = ctx.method_8037();
		class_3610 fluidState = ctx.method_8045().method_8316(blockPos);
		class_2680 blockState = this.method_9564()
				.method_11657(WATERLOGGED, fluidState.method_15772() == class_3612.field_15910).method_11657(FACING, direction);
		if (direction == class_2350.field_11043 && ctx.method_17698().field_1352 - blockPos.method_10263() < 0.5) {
			return blockState.method_11657(SIDE, BlockSide.LEFT).method_11657(SHAPE, getVerticalStairShape(blockState.method_11657(SIDE, BlockSide.LEFT), ctx.method_8045(), blockPos));
		} else if (direction == class_2350.field_11035 && ctx.method_17698().field_1352 - blockPos.method_10263() > 0.5) {
			return blockState.method_11657(SIDE, BlockSide.LEFT).method_11657(SHAPE, getVerticalStairShape(blockState.method_11657(SIDE, BlockSide.LEFT), ctx.method_8045(), blockPos));
		} else if (direction == class_2350.field_11039 && ctx.method_17698().field_1350 - blockPos.method_10260() > 0.5) {
			return blockState.method_11657(SIDE, BlockSide.LEFT).method_11657(SHAPE, getVerticalStairShape(blockState.method_11657(SIDE, BlockSide.LEFT), ctx.method_8045(), blockPos));
		} else if (direction == class_2350.field_11034 && ctx.method_17698().field_1350 - blockPos.method_10260() < 0.5) {
			return blockState.method_11657(SIDE, BlockSide.LEFT).method_11657(SHAPE, getVerticalStairShape(blockState.method_11657(SIDE, BlockSide.LEFT), ctx.method_8045(), blockPos));
		} else {
			return blockState.method_11657(SIDE, BlockSide.RIGHT).method_11657(SHAPE, getVerticalStairShape(blockState.method_11657(SIDE, BlockSide.RIGHT), ctx.method_8045(), blockPos));
		}
	}

	@SuppressWarnings("unused")
	public static boolean isStraightShape(class_2680 state) {
		return Arrays.stream(VerticalStairShape.STRAIGHT_SHAPES).anyMatch(Predicate.isEqual(state.method_11654(SHAPE)));
	}

	@SuppressWarnings("unused")
	public static boolean isTopShape(class_2680 state) {
		return Arrays.stream(VerticalStairShape.TOP_SHAPES).anyMatch(Predicate.isEqual(state.method_11654(SHAPE)));
	}

	@SuppressWarnings("unused")
	public static boolean isBottomShape(class_2680 state) {
		return Arrays.stream(VerticalStairShape.BOTTOM_SHAPES).anyMatch(Predicate.isEqual(state.method_11654(SHAPE)));
	}

	@SuppressWarnings({"all"})
	public static boolean isOuterShape(class_2680 state) {
		return Arrays.stream(VerticalStairShape.OUTER_SHAPES).anyMatch(Predicate.isEqual(state.method_11654(SHAPE)));
	}

	@SuppressWarnings("unused")
	public static boolean isInnerShape(class_2680 state) {
		return Arrays.stream(VerticalStairShape.INNER_SHAPES).anyMatch(Predicate.isEqual(state.method_11654(SHAPE)));
	}

	@SuppressWarnings("unused")
	public static boolean isLeftShape(class_2680 state) {
		return Arrays.stream(VerticalStairShape.LEFT_SHAPES).anyMatch(Predicate.isEqual(state.method_11654(SHAPE)));
	}

	@SuppressWarnings("unused")
	public static boolean IsRightShape(class_2680 state) {
		return Arrays.stream(VerticalStairShape.RIGHT_SHAPES).anyMatch(Predicate.isEqual(state.method_11654(SHAPE)));
	}

	@Override
	protected class_2680 method_9559(class_2680 state, class_4538 world, class_10225 tickView, class_2338 pos, class_2350 direction, class_2338 neighborPos, class_2680 neighborState, class_5819 random) {
		if (state.method_11654(WATERLOGGED)) {
			tickView.method_64312(pos, class_3612.field_15910, class_3612.field_15910.method_15789(world));
		}

		return state.method_11657(SHAPE, getVerticalStairShape(state, world, pos));
	}

	protected static VerticalStairShape getVerticalStairShape(@NotNull class_2680 state, @NotNull class_1922 world, @NotNull class_2338 pos) {
		class_2350 direction = state.method_11654(FACING);
		class_2680 blockState1 = world.method_8320(pos.method_10093(direction.method_10153()));
		class_2680 blockState2 = world.method_8320(pos.method_10093(direction));
		class_2680 blockState3 = world.method_8320(pos.method_10093(direction.method_10170()));
		class_2680 blockState4 = world.method_8320(pos.method_10093(direction.method_10160()));

		//vpredu right
		if (isStairs(blockState1) && state.method_11654(SIDE) == BlockSide.RIGHT && blockState1.method_11654(FACING) == direction.method_10170()) {
			if (blockState1.method_11654(class_2510.field_11572) == class_2760.field_12619) {
				return VerticalStairShape.INNER_TOP_RIGHT;
			}

			return VerticalStairShape.INNER_BOTTOM_RIGHT;
		}

		//vpravo right
		if (isStairs(blockState3) && state.method_11654(SIDE) == BlockSide.RIGHT && blockState3.method_11654(FACING) == direction) {
			if (blockState3.method_11654(class_2510.field_11572) == class_2760.field_12619) {
				return VerticalStairShape.OUTER_TOP_RIGHT;
			}

			return VerticalStairShape.OUTER_BOTTOM_RIGHT;
		}

		//vzadu right
		if (isStairs(blockState2) && state.method_11654(SIDE) == BlockSide.RIGHT && blockState2.method_11654(FACING) == direction.method_10170()) {
			if (blockState2.method_11654(class_2510.field_11572) == class_2760.field_12619) {
				return VerticalStairShape.OUTER_TOP_LEFT_R90;
			}

			return VerticalStairShape.OUTER_BOTTOM_LEFT_R90;
		}

		//vlevo right
		if (isStairs(blockState4) && state.method_11654(SIDE) == BlockSide.RIGHT && blockState4.method_11654(FACING) == direction) {
			if (blockState4.method_11654(class_2510.field_11572) == class_2760.field_12619) {
				return VerticalStairShape.INNER_TOP_RIGHT;
			}

			return VerticalStairShape.INNER_BOTTOM_RIGHT;
		}

		//vpredu left
		if (isStairs(blockState1) && state.method_11654(SIDE) == BlockSide.LEFT && blockState1.method_11654(FACING) == direction.method_10160()) {
			if (blockState1.method_11654(class_2510.field_11572) == class_2760.field_12619) {
				return VerticalStairShape.INNER_TOP_LEFT;
			}

			return VerticalStairShape.INNER_BOTTOM_LEFT;
		}

		//vpravo left
		if (isStairs(blockState3) && state.method_11654(SIDE) == BlockSide.LEFT && blockState3.method_11654(FACING) == direction) {
			if (blockState3.method_11654(class_2510.field_11572) == class_2760.field_12619) {
				return VerticalStairShape.INNER_TOP_LEFT;
			}

			return VerticalStairShape.INNER_BOTTOM_LEFT;
		}

		//vzadu left
		if (isStairs(blockState2) && state.method_11654(SIDE) == BlockSide.LEFT && blockState2.method_11654(FACING) == direction.method_10160()) {
			if (blockState2.method_11654(class_2510.field_11572) == class_2760.field_12619) {
				return VerticalStairShape.OUTER_TOP_RIGHT_R90;
			}

			return VerticalStairShape.OUTER_BOTTOM_RIGHT_R90;
		}

		//vlevo left
		if (isStairs(blockState4) && state.method_11654(SIDE) == BlockSide.LEFT && blockState4.method_11654(FACING) == direction) {
			if (blockState4.method_11654(class_2510.field_11572) == class_2760.field_12619) {
				return VerticalStairShape.OUTER_TOP_LEFT;
			}

			return VerticalStairShape.OUTER_BOTTOM_LEFT;
		}

		return state.method_11654(SIDE) == BlockSide.LEFT ? VerticalStairShape.STRAIGHT_LEFT : VerticalStairShape.STRAIGHT_RIGHT;
	}

	public static boolean isStairs(@NotNull class_2680 state) {
		return state.method_26204() instanceof class_2510;
	}

	@Override
	public boolean method_10310(@Nullable class_1309 filler, class_1922 world, class_2338 pos, class_2680 state, class_3611 fluid) {
		return true;
	}

	@Override
	public class_1799 method_9700(@Nullable class_1309 drainer, class_1936 world, class_2338 pos, class_2680 state) {
		if (state.method_11654(WATERLOGGED)) {
			world.method_8652(pos, state.method_11657(WATERLOGGED, false), 3);

			if (!state.method_26184(world, pos)) {
				world.method_22352(pos, true);
			}

			return new class_1799(class_1802.field_8705);
		} else {
			return class_1799.field_8037;
		}
	}

	@Override
	protected void method_9515(class_2689.@NotNull class_2690<class_2248, class_2680> builder) {
		builder.method_11667(FACING, SIDE, SHAPE, WATERLOGGED);
	}

	@Override
	protected class_3610 method_9545(@NotNull class_2680 state) {
		return state.method_11654(WATERLOGGED) ? class_3612.field_15910.method_15729(false) : super.method_9545(state);
	}

	@Override
	protected boolean method_9516(class_2680 state, class_10 type) {
		return false;
	}
}
