package net.fellter.vanillavsplus.custom_blocks.concrete_powder;

import net.fellter.vanillavsplus.custom_blocks.falling.VerticalFallingStairsBlock;
import net.minecraft.class_10225;
import net.minecraft.class_1540;
import net.minecraft.class_1750;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2388;
import net.minecraft.class_2398;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3481;
import net.minecraft.class_3486;
import net.minecraft.class_4538;
import net.minecraft.class_5819;
import net.minecraft.class_5945;

public class VerticalConcretePowderStairsBlock extends VerticalFallingStairsBlock {
	private final class_2680 hardenedState;

	public VerticalConcretePowderStairsBlock(class_2251 settings, class_2248 hardened) {
		super(settings);
		this.hardenedState = hardened.method_9564();
	}

	@Override
	public void method_10127(class_1937 world, class_2338 pos, class_2680 fallingBlockState, class_2680 currentStateInPos, class_1540 fallingBlockEntity) {
		if (shouldHarden(world, pos, currentStateInPos) && pos != null) {
			world.method_8652(pos, this.hardenedState
					.method_11657(WATERLOGGED, world.method_8320(pos).method_11654(WATERLOGGED))
					.method_11657(FACING, world.method_8320(pos).method_11654(FACING))
					.method_11657(SHAPE, getVerticalStairShape(fallingBlockState, world, pos))
					.method_11657(SIDE, world.method_8320(pos).method_11654(SIDE)), class_2248.field_31036);
		} else {
			assert pos != null;
			world.method_8652(pos, fallingBlockState
					.method_11657(WATERLOGGED, world.method_8320(pos).method_11654(WATERLOGGED))
					.method_11657(FACING, world.method_8320(pos).method_11654(FACING))
					.method_11657(SHAPE, getVerticalStairShape(fallingBlockState, world, pos))
					.method_11657(SIDE, world.method_8320(pos).method_11654(SIDE)), class_2248.field_31036);
		}
	}

	@Override
	public class_2680 method_9605(class_1750 ctx) {
		class_2338 blockPos = ctx.method_8037();
		class_2680 state = ctx.method_8045().method_8320(blockPos);
		class_1937 world = ctx.method_8045();
		class_2680 placementState = super.method_9605(ctx);

		if (shouldHarden(world, blockPos, world.method_8320(blockPos))) {
			if (placementState != null) {
				return this.hardenedState
						.method_11657(WATERLOGGED, placementState.method_11654(WATERLOGGED))
						.method_11657(FACING, placementState.method_11654(FACING))
						.method_11657(SHAPE, getVerticalStairShape(state, world, blockPos))
						.method_11657(SIDE, placementState.method_11654(SIDE));
			}
		}

		return super.method_9605(ctx);
	}

	private static boolean shouldHarden(class_1922 world, class_2338 pos, class_2680 state) {
		return hardensIn(state) || hardensOnAnySide(world, pos);
	}

	private static boolean hardensOnAnySide(class_1922 world, class_2338 pos) {
		boolean bl = false;
		class_2338.class_2339 mutable = pos.method_25503();

		for (class_2350 direction : class_2350.values()) {
			class_2680 blockState = world.method_8320(mutable);
			if (direction == class_2350.field_11033 && !hardensIn(blockState)) continue;
			mutable.method_25505(pos, direction);
			blockState = world.method_8320(mutable);
			if (!hardensIn(blockState) || blockState.method_26206(world, pos, direction.method_10153())) continue;
			bl = true;
			break;
		}

		return bl;
	}

	private static boolean hardensIn(class_2680 state) {
		return state.method_26227().method_15767(class_3486.field_15517);
	}

	@Override
	public class_2680 method_9559(class_2680 state, class_4538 world, class_10225 tickView, class_2338 pos, class_2350 direction, class_2338 neighborPos, class_2680 neighborState, class_5819 random) {
		if (hardensOnAnySide(world, pos)) {
			return this.hardenedState
					.method_11657(WATERLOGGED, world.method_8320(pos).method_11654(WATERLOGGED))
					.method_11657(FACING, world.method_8320(pos).method_11654(FACING))
					.method_11657(SHAPE, getVerticalStairShape(state, world, pos))
					.method_11657(SIDE, world.method_8320(pos).method_11654(SIDE));
		}

		tickView.method_64310(pos, this, this.getFallDelay());
		return super.method_9559(state, world, tickView, pos, direction, neighborPos, neighborState, random);
	}

	@Override
	public void method_9588(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
		if (!canFallThrough(world.method_8320(pos.method_10074())) || pos.method_10264() < world.method_31607()) {
			return;
		}

		class_1540 fallingBlockEntity = class_1540.method_40005(world, pos, state);
		this.configureFallingBlockEntity(fallingBlockEntity);
	}

	public static boolean canFallThrough(class_2680 state) {
		return state.method_26215() || state.method_26164(class_3481.field_21952) || state.method_51176() || state.method_45474();
	}

	@Override
	public void method_9496(class_2680 state, class_1937 world, class_2338 pos, class_5819 random) {
		if (random.method_43048(16) == 0 && canFallThrough(world.method_8320(pos.method_10074()))) {
			class_5945.method_49099(world, pos, random, new class_2388(class_2398.field_11206, state));
		}
	}
}
