package net.fellter.vanillavsplus.custom_blocks.coral;

import org.jetbrains.annotations.Nullable;

import net.fellter.vanillavsplus.block.VerticalStairsBlock;
import net.minecraft.class_10225;
import net.minecraft.class_1750;
import net.minecraft.class_1922;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3486;
import net.minecraft.class_3610;
import net.minecraft.class_4538;
import net.minecraft.class_5819;

public class VerticalCoralStairsBlock extends VerticalStairsBlock {
	private final class_2248 dead;

	public VerticalCoralStairsBlock(class_2248 dead, class_2251 settings) {
		super(settings);
		this.dead = dead;
	}

	protected void method_9588(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
		if (!this.isInWater(world, pos)) {
			world.method_8652(pos, this.dead.method_34725(state), 2);
		}
	}

	protected class_2680 method_9559(class_2680 state, class_4538 world, class_10225 tickView, class_2338 pos, class_2350 direction, class_2338 neighborPos, class_2680 neighborState, class_5819 random) {
		if (!this.isInWater(world, pos)) {
			tickView.method_64310(pos, this, 60 + random.method_43048(40));
		}

		return super.method_9559(state, world, tickView, pos, direction, neighborPos, neighborState, random);
	}

	protected boolean isInWater(class_1922 world, class_2338 pos) {
		class_2350[] var3 = class_2350.values();

		for (class_2350 direction : var3) {
			class_3610 fluidState = world.method_8316(pos.method_10093(direction));

			if (fluidState.method_15767(class_3486.field_15517)) {
				return true;
			}
		}

		return false;
	}

	@Nullable
	public class_2680 method_9605(class_1750 ctx) {
		if (!this.isInWater(ctx.method_8045(), ctx.method_8037())) {
			ctx.method_8045().method_64310(ctx.method_8037(), this, 60 + ctx.method_8045().method_8409().method_43048(40));
		}

		return super.method_9605(ctx);
	}
}
