package net.fellter.vanillavsplus.custom_blocks.sponge;

import org.jetbrains.annotations.Nullable;

import net.fellter.vanillavsplus.block.VerticalStairsBlock;

import net.minecraft.block.*;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2263;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2404;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3486;
import net.minecraft.class_3610;
import net.minecraft.class_9904;

public class VerticalSpongeStairsBlock extends VerticalStairsBlock {
	private final class_2248 wet;

	public VerticalSpongeStairsBlock(class_2248 wet, class_2251 settings) {
		super(settings);
		this.wet = wet;
	}

	protected void method_9615(class_2680 state, class_1937 world, class_2338 pos, class_2680 oldState, boolean notify) {
		if (!oldState.method_27852(state.method_26204())) {
			this.update(world, pos);
		}
	}

	protected void method_9612(class_2680 state, class_1937 world, class_2338 pos, class_2248 sourceBlock, @Nullable class_9904 wireOrientation, boolean notify) {
		this.update(world, pos);
		super.method_9612(state, world, pos, sourceBlock, wireOrientation, notify);
	}

	protected void update(class_1937 world, class_2338 pos) {
		if (this.absorbWater(world, pos)) {
			world.method_8652(pos, wet.method_34725(world.method_8320(pos)).method_11657(WATERLOGGED, false), 2);
			world.method_8396(null, pos, class_3417.field_45062, class_3419.field_15245, 1.0F, 1.0F);
		}
	}

	private boolean absorbWater(class_1937 world, class_2338 pos) {
		return class_2338.method_49925(pos, 6, 65, (currentPos, queuer) -> {
			for (class_2350 direction : field_23157) {
				queuer.accept(currentPos.method_10093(direction));
			}
		}, (currentPos) -> {
			if (currentPos.equals(pos)) {
				return class_2338.class_10384.field_55165;
			} else {
				class_2680 blockState = world.method_8320(currentPos);
				class_3610 fluidState = world.method_8316(currentPos);

				if (!fluidState.method_15767(class_3486.field_15517)) {
					return class_2338.class_10384.field_55166;
				} else {
					class_2248 block = blockState.method_26204();

					if (block instanceof class_2263 fluidDrainable) {
						if (!fluidDrainable.method_9700(null, world, currentPos, blockState).method_7960()) {
							return class_2338.class_10384.field_55165;
						}
					}

					if (blockState.method_26204() instanceof class_2404) {
						world.method_8652(currentPos, class_2246.field_10124.method_9564(), 3);
					} else {
						if (!blockState.method_27852(class_2246.field_9993) && !blockState.method_27852(class_2246.field_10463) && !blockState.method_27852(class_2246.field_10376) && !blockState.method_27852(class_2246.field_10238)) {
							return class_2338.class_10384.field_55166;
						}

						class_2586 blockEntity = blockState.method_31709() ? world.method_8321(currentPos) : null;
						method_9610(blockState, world, currentPos, blockEntity);
						world.method_8652(currentPos, class_2246.field_10124.method_9564(), 3);
					}

					return class_2338.class_10384.field_55165;
				}
			}
		}) > 1;
	}
}
