package net.fellter.vanillavsplus.datagen;

import java.util.List;
import java.util.concurrent.CompletableFuture;

import net.fellter.vanillavsplus.VanillaVSPlus;
import net.fellter.vanillavsplus.block.VerticalSlabBlock;
import net.fellter.vanillavsplus.block.VerticalStairsBlock;
import net.fellter.vanillavsplus.registry.Args;
import net.fellter.vanillavsplus.util.ModTags;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_6862;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricTagProvider;

public class ModBlockTagProvider extends FabricTagProvider.BlockTagProvider {
	public ModBlockTagProvider(FabricDataOutput output, CompletableFuture<class_7225.class_7874> registriesFuture) {
		super(output, registriesFuture);
	}

	@Override
	protected void method_10514(class_7225.class_7874 wrapperLookup) {
		class_7923.field_41175.method_10220().filter(VanillaVSPlus::isNamespaced).forEach(block -> {
			class_2960 identifier = class_7923.field_41175.method_10221(block);
			if (block instanceof VerticalSlabBlock) method_27169(ModTags.VERTICAL_SLABS).method_26784(identifier);
			if (block instanceof VerticalStairsBlock) method_27169(ModTags.VERTICAL_STAIRS).method_26784(identifier);

			if (Args.DATAGEN_ARGS.containsKey(block) && Args.DATAGEN_ARGS.get(block).blockTags != null) {
				List<class_6862<class_2248>> key = Args.DATAGEN_ARGS.get(block).blockTags;

				for (class_6862<class_2248> blockTagKey : key) {
					method_27169(blockTagKey).method_26784(identifier);
				}
			}
		});
	}

	@Override
	public String method_10321() {
		return "Vanilla+ Verticals Block Tags";
	}
}
