package net.fellter.vanillavsplus.datagen;

import java.util.concurrent.CompletableFuture;

import net.fellter.vanillavsplus.VanillaVSPlus;
import net.fellter.vanillavsplus.registry.Args;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricLanguageProvider;
import net.fabricmc.loader.impl.util.StringUtil;

public class ModLanguageProvider extends FabricLanguageProvider {
	public ModLanguageProvider(FabricDataOutput dataOutput, CompletableFuture<class_7225.class_7874> registryLookup) {
		super(dataOutput, registryLookup);
	}

	@Override
	public void generateTranslations(class_7225.class_7874 wrapperLookup, TranslationBuilder translationBuilder) {
		class_7923.field_41175.method_10220().filter(VanillaVSPlus::isNamespaced).forEach(block -> {
			if (Args.DATAGEN_ARGS.containsKey(block)) {
				class_2960 identifier = class_7923.field_41175.method_10221(block);
				String[] var10000 = identifier.method_12832().split("_");
				StringBuilder stringBuilder = new StringBuilder();
				String var10001;

				for (String string : var10000) {
					stringBuilder.append(StringUtil.capitalize(string)).append(" ");
				}

				var10001 = stringBuilder.delete(stringBuilder.length() - 1, stringBuilder.length()).toString();
				translationBuilder.add(block, var10001);
			}
		});

		translationBuilder.add(class_5321.method_29179(class_7924.field_44688, class_2960.method_60655(VanillaVSPlus.MOD_ID, "vvsp")), "Vanilla+ Verticals");
	}

	@Override
	public String method_10321() {
		return "Vanilla+ Verticals English Translations";
	}
}
