package net.fellter.vanillavsplus.datagen;

import java.util.concurrent.CompletableFuture;

import net.fellter.vanillavsplus.VanillaVSPlus;
import net.fellter.vanillavsplus.block.VerticalSlabBlock;
import net.fellter.vanillavsplus.block.VerticalStairsBlock;
import net.fellter.vanillavsplus.registry.Args;
import net.fellter.vanillavsplus.registry.DatagenArgs;
import net.minecraft.class_141;
import net.minecraft.class_212;
import net.minecraft.class_2248;
import net.minecraft.class_44;
import net.minecraft.class_52;
import net.minecraft.class_55;
import net.minecraft.class_7225;
import net.minecraft.class_77;
import net.minecraft.class_7923;
import net.minecraft.class_85;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricBlockLootTableProvider;

public class ModLootTableProvider extends FabricBlockLootTableProvider {
	public ModLootTableProvider(FabricDataOutput dataOutput, CompletableFuture<class_7225.class_7874> registryLookup) {
		super(dataOutput, registryLookup);
	}

	@Override
	public void method_10379() {
		class_7923.field_41175.method_10220().filter(VanillaVSPlus::isNamespaced).forEach(block -> {
			if (block.method_26162().isPresent() && Args.DATAGEN_ARGS.containsKey(block)) {
				DatagenArgs datagenArgs = Args.DATAGEN_ARGS.get(block);

				//noinspection IfCanBeSwitch
				if (block instanceof VerticalSlabBlock && datagenArgs.needsSilkTouch) {
					method_45988(block, silkTouchDrops(block));
				} else if (block instanceof VerticalStairsBlock && datagenArgs.needsSilkTouch) {
					method_45988(block, method_46003(block));
				} else if (block instanceof VerticalSlabBlock) {
					method_45988(block, vertSlabDrops(block));
				} else if (block instanceof VerticalStairsBlock) {
					method_46025(block);
				}
			}
		});
	}

	private class_52.class_53 vertSlabDrops(class_2248 drop) {
		return class_52.method_324().method_336(class_55.method_347().method_352(class_44.method_32448(1.0F))
				.method_351(this.method_45977(drop, vertSlabDropsEntry(drop))));
	}

	private class_52.class_53 silkTouchDrops(class_2248 drop) {
		return class_52.method_324().method_336(class_55.method_347()
				.method_356(this.method_60390()).method_352(class_44.method_32448(1.0F))
				.method_351(vertSlabDropsEntry(drop)));
	}

	private class_85.class_86<?> vertSlabDropsEntry(class_2248 drop) {
		return class_77.method_411(drop)
				.method_438(class_141.method_621(class_44.method_32448(1.0F))
						.method_524(class_212.method_900(drop)
								.method_22584(net.minecraft.class_4559.class_4560.method_22523().method_22527(VerticalSlabBlock.SINGLE, true))))
				.method_438(class_141.method_621(class_44.method_32448(2.0F))
						.method_524(class_212.method_900(drop)
								.method_22584(net.minecraft.class_4559.class_4560.method_22523().method_22527(VerticalSlabBlock.SINGLE, false))));
	}
}
