package net.fellter.vanillavsplus.datagen;

import net.fellter.vanillavsplus.VanillaVSPlus;
import net.fellter.vanillavsplus.block.ModBlocks;
import net.fellter.vanillavsplus.block.VerticalSlabBlock;
import net.fellter.vanillavsplus.block.VerticalStairsBlock;
import net.fellter.vanillavsplus.item.ModItems;
import net.fellter.vanillavsplus.registry.Args;
import net.fellter.vanillavsplus.registry.DatagenArgs;
import net.minecraft.class_2246;
import net.minecraft.class_2960;
import net.minecraft.class_4910;
import net.minecraft.class_4915;
import net.minecraft.class_4943;
import net.minecraft.class_4944;
import net.minecraft.class_7923;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.datagen.v1.provider.FabricModelProvider;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;

import static net.fellter.vanillavsplus.util.ModBlockStateModelGenerator.*;

@Environment(EnvType.CLIENT)
public class ModModelProvider extends FabricModelProvider {
	public ModModelProvider(FabricDataOutput output) {
		super(output);
	}

	@Override
	public void generateBlockStateModels(class_4910 bsmg) {
		registerVerticalSlab(bsmg, ModBlocks.VERTICAL_BROWN_MUSHROOM_SLAB, class_2960.method_60655(VanillaVSPlus.MOD_ID, "block/brown_mushroom_block"), class_4944.method_25864(class_2246.field_10580));
		registerVerticalSlab(bsmg, ModBlocks.VERTICAL_RED_MUSHROOM_SLAB, class_2960.method_60655(VanillaVSPlus.MOD_ID, "block/red_mushroom_block"), class_4944.method_25864(class_2246.field_10240));

		class_7923.field_41175.method_10220().filter(VanillaVSPlus::isNamespaced).forEach(block -> {
			if (Args.DATAGEN_ARGS.containsKey(block)) {
				DatagenArgs args = Args.DATAGEN_ARGS.get(block);

				if (args.textureMap != null) {
					if (block instanceof VerticalStairsBlock && args.y15 && args.tintSource != null) {
						registerVerticalStairs15(bsmg, block, args.textureMap, args.tintSource);
					} else if (block instanceof VerticalStairsBlock && args.y15) {
						registerVerticalStairs15(bsmg, block, args.textureMap);
					} else if (block instanceof VerticalStairsBlock && args.tintSource != null) {
						registerVerticalStairs(bsmg, block, args.textureMap, args.tintSource);
					} else if (block instanceof VerticalStairsBlock) {
						registerVerticalStairs(bsmg, block, args.textureMap);
					} else if (block instanceof VerticalSlabBlock && args.y15 && args.tintSource != null && args.fullTextureBlock != null) {
						registerVerticalSlab15(bsmg, block, args.fullTextureBlock, args.textureMap, args.tintSource);
					} else if (block instanceof VerticalSlabBlock && args.y15 && args.tintSource != null && args.parentBlock != null) {
						registerVerticalSlab15(bsmg, block, args.parentBlock, args.textureMap, args.tintSource);
					} else if (block instanceof VerticalSlabBlock && args.y15 && args.fullTextureBlock != null) {
						registerVerticalSlab15(bsmg, block, args.fullTextureBlock, args.textureMap);
					} else if (block instanceof VerticalSlabBlock && args.y15 && args.parentBlock != null) {
						registerVerticalSlab15(bsmg, block, args.parentBlock, args.textureMap);
					} else if (block instanceof VerticalSlabBlock && args.tintSource != null && args.fullTextureBlock != null) {
						registerVerticalSlab(bsmg, block, args.fullTextureBlock, args.textureMap, args.tintSource);
					} else if (block instanceof VerticalSlabBlock && args.tintSource != null && args.parentBlock != null) {
						registerVerticalSlab(bsmg, block, args.parentBlock, args.textureMap, args.tintSource);
					} else if (block instanceof VerticalSlabBlock && args.fullTextureBlock != null) {
						registerVerticalSlab(bsmg, block, args.fullTextureBlock, args.textureMap);
					} else if (block instanceof VerticalSlabBlock && args.parentBlock != null) {
						registerVerticalSlab(bsmg, block, args.parentBlock, args.textureMap);
					}
				}
			}
		});
	}

	@Override
	public void generateItemModels(class_4915 itemModelGenerator) {
		itemModelGenerator.method_65442(ModItems.VVSP_TITLE, class_4943.field_22938);
	}
}
