package net.fellter.vanillavsplus.mixin;

import net.fellter.vanillavsplus.block.BlockSide;
import net.fellter.vanillavsplus.block.VerticalStairsBlock;
import net.minecraft.class_10225;
import net.minecraft.class_1750;
import net.minecraft.class_1922;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2510;
import net.minecraft.class_2680;
import net.minecraft.class_2746;
import net.minecraft.class_2754;
import net.minecraft.class_2760;
import net.minecraft.class_2778;
import net.minecraft.class_3612;
import net.minecraft.class_4538;
import net.minecraft.class_5819;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_2510.class)
public abstract class MixinStairsBlock extends class_2248 {
	@Shadow
	@Final
	public static class_2754<class_2350> FACING;

	@Shadow
	@Final
	public static class_2754<class_2760> HALF;

	@Shadow
	@Final
	public static class_2754<class_2778> SHAPE;

	@Shadow
	@Final
	public static class_2746 WATERLOGGED;

	public MixinStairsBlock(class_2251 settings) {
		super(settings);
		this.method_9590(this.method_9595().method_11664().method_11657(FACING, class_2350.field_11043).method_11657(HALF, class_2760.field_12617).method_11657(SHAPE, class_2778.field_12710).method_11657(WATERLOGGED, false));
	}

	@Inject(method = "getPlacementState", at = @At("TAIL"), cancellable = true)
	public void getPlacementState(class_1750 ctx, CallbackInfoReturnable<class_2680> cir) {
		class_2338 blockPos = ctx.method_8037();
		class_2680 upState = ctx.method_8045().method_8320(blockPos.method_10084());
		class_2680 downState = ctx.method_8045().method_8320(blockPos.method_10074());
		class_2680 blockState = super.method_9564().method_11657(FACING, ctx.method_8042()).method_11657(FACING, ctx.method_8042())
				.method_11657(HALF, ctx.method_8038() != class_2350.field_11033 && (ctx.method_8038() == class_2350.field_11036 || !(ctx.method_17698().field_1351 - (double) blockPos.method_10264() > 0.5)) ? class_2760.field_12617 : class_2760.field_12619)
				.method_11657(WATERLOGGED, ctx.method_8045().method_8316(blockPos).method_15772() == class_3612.field_15910);

		if (isVerticalStairs(upState) || isVerticalStairs(downState)) {
			cir.setReturnValue(blockState.method_11657(SHAPE, fellter$getStairShape(blockState, ctx.method_8045(), blockPos)));
		}
	}

	@Inject(method = "getStateForNeighborUpdate", at = @At("HEAD"), cancellable = true)
	protected void getStateForNeighborUpdate(class_2680 state, class_4538 world, class_10225 tickView, class_2338 pos, class_2350 direction, class_2338 neighborPos, class_2680 neighborState, class_5819 random, CallbackInfoReturnable<class_2680> cir) {
		class_2680 upState = world.method_8320(pos.method_10084());
		class_2680 downState = world.method_8320(pos.method_10074());

		if (direction.method_10166().method_10178()) {
			if (isVerticalStairs(upState) || isVerticalStairs(downState)) {
				cir.setReturnValue(state.method_11657(SHAPE, fellter$getStairShape(state, world, pos)));
			}

			if (!isVerticalStairs(upState) || !isVerticalStairs(downState)) {
				cir.setReturnValue(state.method_11657(SHAPE, fellter$getStairShape(state, world, pos)));
			}
		}
	}

	@Unique
	private static boolean isDifferentOrientation(class_2680 state, class_1922 world, class_2338 pos, class_2350 dir) {
		class_2680 blockState = world.method_8320(pos.method_10093(dir));
		return !isStairs(blockState) || blockState.method_11654(FACING) != state.method_11654(FACING) || blockState.method_11654(HALF) != state.method_11654(HALF);
	}

	@Unique
	private static boolean isStairs(class_2680 state) {
		return state.method_26204() instanceof class_2510;
	}

	@Unique
	private static class_2778 fellter$getStairShape(class_2680 state, class_1922 world, class_2338 pos) {
		class_2350 direction = state.method_11654(FACING);
		class_2680 upState = world.method_8320(pos.method_10084());
		class_2680 downState = world.method_8320(pos.method_10074());

		if ((state.method_11654(SHAPE) == class_2778.field_12710) || state.method_11654(SHAPE) == class_2778.field_12712 || state.method_11654(SHAPE) == class_2778.field_12713) {
			if (isVerticalStairs(upState) && !VerticalStairsBlock.isOuterShape(upState)) {
				if (isVerticalStairs(upState) && upState.method_11654(FACING) == direction && state.method_11654(HALF) == class_2760.field_12617) {
					if (upState.method_11654(VerticalStairsBlock.SIDE) == BlockSide.LEFT) {
						return class_2778.field_12712;
					}

					return class_2778.field_12713;
				}

				if (isVerticalStairs(upState) && upState.method_11654(FACING) == direction.method_10170() && state.method_11654(HALF) == class_2760.field_12617) {
					if (upState.method_11654(VerticalStairsBlock.SIDE) == BlockSide.LEFT) {
						return class_2778.field_12713;
					}

					return class_2778.field_12710;
				}

				if (isVerticalStairs(upState) && upState.method_11654(FACING) == direction.method_10160() && state.method_11654(HALF) == class_2760.field_12617) {
					if (upState.method_11654(VerticalStairsBlock.SIDE) == BlockSide.RIGHT) {
						return class_2778.field_12712;
					}

					return class_2778.field_12710;
				}
			}

			if (isVerticalStairs(downState) && !VerticalStairsBlock.isOuterShape(downState)) {
				if (isVerticalStairs(downState) && downState.method_11654(FACING) == direction && state.method_11654(HALF) == class_2760.field_12619) {
					if (downState.method_11654(VerticalStairsBlock.SIDE) == BlockSide.LEFT) {
						return class_2778.field_12712;
					}

					return class_2778.field_12713;
				}

				if (isVerticalStairs(downState) && downState.method_11654(FACING) == direction.method_10170() && state.method_11654(HALF) == class_2760.field_12619) {
					if (downState.method_11654(VerticalStairsBlock.SIDE) == BlockSide.LEFT) {
						return class_2778.field_12713;
					}

					return class_2778.field_12710;
				}

				if (isVerticalStairs(downState) && downState.method_11654(FACING) == direction.method_10160() && state.method_11654(HALF) == class_2760.field_12619) {
					if (downState.method_11654(VerticalStairsBlock.SIDE) == BlockSide.RIGHT) {
						return class_2778.field_12712;
					}

					return class_2778.field_12710;
				}
			}
		}

		class_2350 direction1 = state.method_11654(FACING);
		class_2680 blockState = world.method_8320(pos.method_10093(direction1));

		if (isStairs(blockState) && state.method_11654(HALF) == blockState.method_11654(HALF)) {
			class_2350 direction2 = blockState.method_11654(FACING);

			if (direction2.method_10166() != state.method_11654(FACING).method_10166() && isDifferentOrientation(state, world, pos, direction2.method_10153())) {
				if (direction2 == direction1.method_10160()) {
					return class_2778.field_12708;
				}

				return class_2778.field_12709;
			}
		}

		class_2680 blockState2 = world.method_8320(pos.method_10093(direction1.method_10153()));

		if (isStairs(blockState2) && state.method_11654(HALF) == blockState2.method_11654(HALF)) {
			class_2350 direction3 = blockState2.method_11654(FACING);

			if (direction3.method_10166() != state.method_11654(FACING).method_10166() && isDifferentOrientation(state, world, pos, direction3)) {
				if (direction3 == direction1.method_10160()) {
					return class_2778.field_12712;
				}

				return class_2778.field_12713;
			}
		}

		return class_2778.field_12710;
	}

	@Inject(method = "getStairShape", at = @At("HEAD"), cancellable = true)
	private static void getStairShape(class_2680 state, class_1922 world, class_2338 pos, CallbackInfoReturnable<class_2778> cir) {
		class_2680 upState = world.method_8320(pos.method_10084());
		class_2680 downState = world.method_8320(pos.method_10074());

		if (isVerticalStairs(upState) || isVerticalStairs(downState)) {
			cir.setReturnValue(fellter$getStairShape(state, world, pos));
		}
	}

	@Unique
	private static boolean isVerticalStairs(class_2680 state) {
		return state.method_26204() instanceof VerticalStairsBlock;
	}
}
