package net.fellter.vanillavsplus.registry;

import java.util.LinkedHashMap;
import java.util.Map;

import net.fellter.vanillavsplus.block.ModBlocks;
import net.minecraft.class_10396;
import net.minecraft.class_10400;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_3481;
import net.minecraft.class_4944;

import static net.fellter.vanillavsplus.util.ModTextureMap.*;

public final class Args {
	public static final Map<class_2248, DatagenArgs> DATAGEN_ARGS = new LinkedHashMap<>();
	public static final Map<class_2248, RegistryArgs> REGISTRY_ARGS = new LinkedHashMap<>();

	private static void putInDatagenArgs(class_2248 block, DatagenArgs datagenArgs) {
		DatagenArgs oldArgs = DATAGEN_ARGS.get(block);

		if (oldArgs == null) {
			DATAGEN_ARGS.put(block, datagenArgs);
		} else {
			throw new IllegalStateException("Block " + block.method_9518() + " has already been put in DatagenArgs source map.");
		}
	}

	private static void putInRegistryArgs(class_2248 block, RegistryArgs registryArgs) {
		RegistryArgs oldArgs = REGISTRY_ARGS.get(block);

		if (oldArgs == null) {
			REGISTRY_ARGS.put(block, registryArgs);
		} else {
			throw new IllegalStateException("Block " + block.method_9518() + " has already been put in RegistryArgs source map.");
		}
	}

	public static void registerRegistryArgs() {
		putInRegistryArgs(ModBlocks.VERTICAL_OAK_SLAB, new RegistryArgs().flammable(5, 20));
		putInRegistryArgs(ModBlocks.VERTICAL_OAK_STAIRS, new RegistryArgs().flammable(5, 20));
		putInRegistryArgs(ModBlocks.VERTICAL_STRIPPED_OAK_LOG_SLAB, new RegistryArgs().flammable(5, 5));
		putInRegistryArgs(ModBlocks.VERTICAL_STRIPPED_OAK_LOG_STAIRS, new RegistryArgs().flammable(5, 5));
		putInRegistryArgs(ModBlocks.VERTICAL_STRIPPED_OAK_WOOD_SLAB, new RegistryArgs().flammable(5, 5));
		putInRegistryArgs(ModBlocks.VERTICAL_STRIPPED_OAK_WOOD_STAIRS, new RegistryArgs().flammable(5, 5));
		putInRegistryArgs(ModBlocks.VERTICAL_OAK_LOG_SLAB, new RegistryArgs().strippable(ModBlocks.VERTICAL_STRIPPED_OAK_LOG_SLAB).flammable(5, 5));
		putInRegistryArgs(ModBlocks.VERTICAL_OAK_LOG_STAIRS, new RegistryArgs().strippable(ModBlocks.VERTICAL_STRIPPED_OAK_LOG_STAIRS).flammable(5, 5));
		putInRegistryArgs(ModBlocks.VERTICAL_OAK_WOOD_SLAB, new RegistryArgs().strippable(ModBlocks.VERTICAL_STRIPPED_OAK_WOOD_SLAB).flammable(5, 5));
		putInRegistryArgs(ModBlocks.VERTICAL_OAK_WOOD_STAIRS, new RegistryArgs().strippable(ModBlocks.VERTICAL_STRIPPED_OAK_WOOD_STAIRS).flammable(5, 5));
		putInRegistryArgs(ModBlocks.VERTICAL_SPRUCE_SLAB, new RegistryArgs().flammable(5, 20));
		putInRegistryArgs(ModBlocks.VERTICAL_SPRUCE_STAIRS, new RegistryArgs().flammable(5, 20));
		putInRegistryArgs(ModBlocks.VERTICAL_STRIPPED_SPRUCE_LOG_SLAB, new RegistryArgs().flammable(5, 5));
		putInRegistryArgs(ModBlocks.VERTICAL_STRIPPED_SPRUCE_LOG_STAIRS, new RegistryArgs().flammable(5, 5));
		putInRegistryArgs(ModBlocks.VERTICAL_STRIPPED_SPRUCE_WOOD_SLAB, new RegistryArgs().flammable(5, 5));
		putInRegistryArgs(ModBlocks.VERTICAL_STRIPPED_SPRUCE_WOOD_STAIRS, new RegistryArgs().flammable(5, 5));
		putInRegistryArgs(ModBlocks.VERTICAL_SPRUCE_LOG_SLAB, new RegistryArgs().strippable(ModBlocks.VERTICAL_STRIPPED_SPRUCE_LOG_SLAB).flammable(5, 5));
		putInRegistryArgs(ModBlocks.VERTICAL_SPRUCE_LOG_STAIRS, new RegistryArgs().strippable(ModBlocks.VERTICAL_STRIPPED_SPRUCE_LOG_STAIRS).flammable(5, 5));
		putInRegistryArgs(ModBlocks.VERTICAL_SPRUCE_WOOD_SLAB, new RegistryArgs().strippable(ModBlocks.VERTICAL_STRIPPED_SPRUCE_WOOD_SLAB).flammable(5, 5));
		putInRegistryArgs(ModBlocks.VERTICAL_SPRUCE_WOOD_STAIRS, new RegistryArgs().strippable(ModBlocks.VERTICAL_STRIPPED_SPRUCE_WOOD_STAIRS).flammable(5, 5));
		putInRegistryArgs(ModBlocks.VERTICAL_BIRCH_SLAB, new RegistryArgs().flammable(5, 20));
		putInRegistryArgs(ModBlocks.VERTICAL_BIRCH_STAIRS, new RegistryArgs().flammable(5, 20));
		putInRegistryArgs(ModBlocks.VERTICAL_STRIPPED_BIRCH_LOG_SLAB, new RegistryArgs().flammable(5, 5));
		putInRegistryArgs(ModBlocks.VERTICAL_STRIPPED_BIRCH_LOG_STAIRS, new RegistryArgs().flammable(5, 5));
		putInRegistryArgs(ModBlocks.VERTICAL_STRIPPED_BIRCH_WOOD_SLAB, new RegistryArgs().flammable(5, 5));
		putInRegistryArgs(ModBlocks.VERTICAL_STRIPPED_BIRCH_WOOD_STAIRS, new RegistryArgs().flammable(5, 5));
		putInRegistryArgs(ModBlocks.VERTICAL_BIRCH_LOG_SLAB, new RegistryArgs().strippable(ModBlocks.VERTICAL_STRIPPED_BIRCH_LOG_SLAB).flammable(5, 5));
		putInRegistryArgs(ModBlocks.VERTICAL_BIRCH_LOG_STAIRS, new RegistryArgs().strippable(ModBlocks.VERTICAL_STRIPPED_BIRCH_LOG_STAIRS).flammable(5, 5));
		putInRegistryArgs(ModBlocks.VERTICAL_BIRCH_WOOD_SLAB, new RegistryArgs().strippable(ModBlocks.VERTICAL_STRIPPED_BIRCH_WOOD_SLAB).flammable(5, 5));
		putInRegistryArgs(ModBlocks.VERTICAL_BIRCH_WOOD_STAIRS, new RegistryArgs().strippable(ModBlocks.VERTICAL_STRIPPED_BIRCH_WOOD_STAIRS).flammable(5, 5));
		putInRegistryArgs(ModBlocks.VERTICAL_JUNGLE_SLAB, new RegistryArgs().flammable(5, 20));
		putInRegistryArgs(ModBlocks.VERTICAL_JUNGLE_STAIRS, new RegistryArgs().flammable(5, 20));
		putInRegistryArgs(ModBlocks.VERTICAL_STRIPPED_JUNGLE_LOG_SLAB, new RegistryArgs().flammable(5, 5));
		putInRegistryArgs(ModBlocks.VERTICAL_STRIPPED_JUNGLE_LOG_STAIRS, new RegistryArgs().flammable(5, 5));
		putInRegistryArgs(ModBlocks.VERTICAL_STRIPPED_JUNGLE_WOOD_SLAB, new RegistryArgs().flammable(5, 5));
		putInRegistryArgs(ModBlocks.VERTICAL_STRIPPED_JUNGLE_WOOD_STAIRS, new RegistryArgs().flammable(5, 5));
		putInRegistryArgs(ModBlocks.VERTICAL_JUNGLE_LOG_SLAB, new RegistryArgs().strippable(ModBlocks.VERTICAL_STRIPPED_JUNGLE_LOG_SLAB).flammable(5, 5));
		putInRegistryArgs(ModBlocks.VERTICAL_JUNGLE_LOG_STAIRS, new RegistryArgs().strippable(ModBlocks.VERTICAL_STRIPPED_JUNGLE_LOG_STAIRS).flammable(5, 5));
		putInRegistryArgs(ModBlocks.VERTICAL_JUNGLE_WOOD_SLAB, new RegistryArgs().strippable(ModBlocks.VERTICAL_STRIPPED_JUNGLE_WOOD_SLAB).flammable(5, 5));
		putInRegistryArgs(ModBlocks.VERTICAL_JUNGLE_WOOD_STAIRS, new RegistryArgs().strippable(ModBlocks.VERTICAL_STRIPPED_JUNGLE_WOOD_STAIRS).flammable(5, 5));
		putInRegistryArgs(ModBlocks.VERTICAL_ACACIA_SLAB, new RegistryArgs().flammable(5, 20));
		putInRegistryArgs(ModBlocks.VERTICAL_ACACIA_STAIRS, new RegistryArgs().flammable(5, 20));
		putInRegistryArgs(ModBlocks.VERTICAL_STRIPPED_ACACIA_LOG_SLAB, new RegistryArgs().flammable(5, 5));
		putInRegistryArgs(ModBlocks.VERTICAL_STRIPPED_ACACIA_LOG_STAIRS, new RegistryArgs().flammable(5, 5));
		putInRegistryArgs(ModBlocks.VERTICAL_STRIPPED_ACACIA_WOOD_SLAB, new RegistryArgs().flammable(5, 5));
		putInRegistryArgs(ModBlocks.VERTICAL_STRIPPED_ACACIA_WOOD_STAIRS, new RegistryArgs().flammable(5, 5));
		putInRegistryArgs(ModBlocks.VERTICAL_ACACIA_LOG_SLAB, new RegistryArgs().strippable(ModBlocks.VERTICAL_STRIPPED_ACACIA_LOG_SLAB).flammable(5, 5));
		putInRegistryArgs(ModBlocks.VERTICAL_ACACIA_LOG_STAIRS, new RegistryArgs().strippable(ModBlocks.VERTICAL_STRIPPED_ACACIA_LOG_STAIRS).flammable(5, 5));
		putInRegistryArgs(ModBlocks.VERTICAL_ACACIA_WOOD_SLAB, new RegistryArgs().strippable(ModBlocks.VERTICAL_STRIPPED_ACACIA_WOOD_SLAB).flammable(5, 5));
		putInRegistryArgs(ModBlocks.VERTICAL_ACACIA_WOOD_STAIRS, new RegistryArgs().strippable(ModBlocks.VERTICAL_STRIPPED_ACACIA_WOOD_STAIRS).flammable(5, 5));
		putInRegistryArgs(ModBlocks.VERTICAL_DARK_OAK_SLAB, new RegistryArgs().flammable(5, 20));
		putInRegistryArgs(ModBlocks.VERTICAL_DARK_OAK_STAIRS, new RegistryArgs().flammable(5, 20));
		putInRegistryArgs(ModBlocks.VERTICAL_STRIPPED_DARK_OAK_LOG_SLAB, new RegistryArgs().flammable(5, 5));
		putInRegistryArgs(ModBlocks.VERTICAL_STRIPPED_DARK_OAK_LOG_STAIRS, new RegistryArgs().flammable(5, 5));
		putInRegistryArgs(ModBlocks.VERTICAL_STRIPPED_DARK_OAK_WOOD_SLAB, new RegistryArgs().flammable(5, 5));
		putInRegistryArgs(ModBlocks.VERTICAL_STRIPPED_DARK_OAK_WOOD_STAIRS, new RegistryArgs().flammable(5, 5));
		putInRegistryArgs(ModBlocks.VERTICAL_DARK_OAK_LOG_SLAB, new RegistryArgs().strippable(ModBlocks.VERTICAL_STRIPPED_DARK_OAK_LOG_SLAB).flammable(5, 5));
		putInRegistryArgs(ModBlocks.VERTICAL_DARK_OAK_LOG_STAIRS, new RegistryArgs().strippable(ModBlocks.VERTICAL_STRIPPED_DARK_OAK_LOG_STAIRS).flammable(5, 5));
		putInRegistryArgs(ModBlocks.VERTICAL_DARK_OAK_WOOD_SLAB, new RegistryArgs().strippable(ModBlocks.VERTICAL_STRIPPED_DARK_OAK_WOOD_SLAB).flammable(5, 5));
		putInRegistryArgs(ModBlocks.VERTICAL_DARK_OAK_WOOD_STAIRS, new RegistryArgs().strippable(ModBlocks.VERTICAL_STRIPPED_DARK_OAK_WOOD_STAIRS).flammable(5, 5));
		putInRegistryArgs(ModBlocks.VERTICAL_MANGROVE_SLAB, new RegistryArgs().flammable(5, 20));
		putInRegistryArgs(ModBlocks.VERTICAL_MANGROVE_STAIRS, new RegistryArgs().flammable(5, 20));
		putInRegistryArgs(ModBlocks.VERTICAL_STRIPPED_MANGROVE_LOG_SLAB, new RegistryArgs().flammable(5, 5));
		putInRegistryArgs(ModBlocks.VERTICAL_STRIPPED_MANGROVE_LOG_STAIRS, new RegistryArgs().flammable(5, 5));
		putInRegistryArgs(ModBlocks.VERTICAL_STRIPPED_MANGROVE_WOOD_SLAB, new RegistryArgs().flammable(5, 5));
		putInRegistryArgs(ModBlocks.VERTICAL_STRIPPED_MANGROVE_WOOD_STAIRS, new RegistryArgs().flammable(5, 5));
		putInRegistryArgs(ModBlocks.VERTICAL_MANGROVE_LOG_SLAB, new RegistryArgs().strippable(ModBlocks.VERTICAL_STRIPPED_MANGROVE_LOG_SLAB).flammable(5, 5));
		putInRegistryArgs(ModBlocks.VERTICAL_MANGROVE_LOG_STAIRS, new RegistryArgs().strippable(ModBlocks.VERTICAL_STRIPPED_MANGROVE_LOG_STAIRS).flammable(5, 5));
		putInRegistryArgs(ModBlocks.VERTICAL_MANGROVE_WOOD_SLAB, new RegistryArgs().strippable(ModBlocks.VERTICAL_STRIPPED_MANGROVE_WOOD_SLAB).flammable(5, 5));
		putInRegistryArgs(ModBlocks.VERTICAL_MANGROVE_WOOD_STAIRS, new RegistryArgs().strippable(ModBlocks.VERTICAL_STRIPPED_MANGROVE_WOOD_STAIRS).flammable(5, 5));
		putInRegistryArgs(ModBlocks.VERTICAL_CHERRY_SLAB, new RegistryArgs().flammable(5, 20));
		putInRegistryArgs(ModBlocks.VERTICAL_CHERRY_STAIRS, new RegistryArgs().flammable(5, 20));
		putInRegistryArgs(ModBlocks.VERTICAL_STRIPPED_CHERRY_LOG_SLAB, new RegistryArgs().flammable(5, 5));
		putInRegistryArgs(ModBlocks.VERTICAL_STRIPPED_CHERRY_LOG_STAIRS, new RegistryArgs().flammable(5, 5));
		putInRegistryArgs(ModBlocks.VERTICAL_STRIPPED_CHERRY_WOOD_SLAB, new RegistryArgs().flammable(5, 5));
		putInRegistryArgs(ModBlocks.VERTICAL_STRIPPED_CHERRY_WOOD_STAIRS, new RegistryArgs().flammable(5, 5));
		putInRegistryArgs(ModBlocks.VERTICAL_CHERRY_LOG_SLAB, new RegistryArgs().strippable(ModBlocks.VERTICAL_STRIPPED_CHERRY_LOG_SLAB).flammable(5, 5));
		putInRegistryArgs(ModBlocks.VERTICAL_CHERRY_LOG_STAIRS, new RegistryArgs().strippable(ModBlocks.VERTICAL_STRIPPED_CHERRY_LOG_STAIRS).flammable(5, 5));
		putInRegistryArgs(ModBlocks.VERTICAL_CHERRY_WOOD_SLAB, new RegistryArgs().strippable(ModBlocks.VERTICAL_STRIPPED_CHERRY_WOOD_SLAB).flammable(5, 5));
		putInRegistryArgs(ModBlocks.VERTICAL_CHERRY_WOOD_STAIRS, new RegistryArgs().strippable(ModBlocks.VERTICAL_STRIPPED_CHERRY_WOOD_STAIRS).flammable(5, 5));
		putInRegistryArgs(ModBlocks.VERTICAL_PALE_OAK_SLAB, new RegistryArgs().flammable(5, 20));
		putInRegistryArgs(ModBlocks.VERTICAL_PALE_OAK_STAIRS, new RegistryArgs().flammable(5, 20));
		putInRegistryArgs(ModBlocks.VERTICAL_STRIPPED_PALE_OAK_LOG_SLAB, new RegistryArgs().flammable(5, 5));
		putInRegistryArgs(ModBlocks.VERTICAL_STRIPPED_PALE_OAK_LOG_STAIRS, new RegistryArgs().flammable(5, 5));
		putInRegistryArgs(ModBlocks.VERTICAL_STRIPPED_PALE_OAK_WOOD_SLAB, new RegistryArgs().flammable(5, 5));
		putInRegistryArgs(ModBlocks.VERTICAL_STRIPPED_PALE_OAK_WOOD_STAIRS, new RegistryArgs().flammable(5, 5));
		putInRegistryArgs(ModBlocks.VERTICAL_PALE_OAK_LOG_SLAB, new RegistryArgs().strippable(ModBlocks.VERTICAL_STRIPPED_PALE_OAK_LOG_SLAB).flammable(5, 5));
		putInRegistryArgs(ModBlocks.VERTICAL_PALE_OAK_LOG_STAIRS, new RegistryArgs().strippable(ModBlocks.VERTICAL_STRIPPED_PALE_OAK_LOG_STAIRS).flammable(5, 5));
		putInRegistryArgs(ModBlocks.VERTICAL_PALE_OAK_WOOD_SLAB, new RegistryArgs().strippable(ModBlocks.VERTICAL_STRIPPED_PALE_OAK_WOOD_SLAB).flammable(5, 5));
		putInRegistryArgs(ModBlocks.VERTICAL_PALE_OAK_WOOD_STAIRS, new RegistryArgs().strippable(ModBlocks.VERTICAL_STRIPPED_PALE_OAK_WOOD_STAIRS).flammable(5, 5));
		putInRegistryArgs(ModBlocks.VERTICAL_BAMBOO_SLAB, new RegistryArgs().flammable(5, 20));
		putInRegistryArgs(ModBlocks.VERTICAL_BAMBOO_STAIRS, new RegistryArgs().flammable(5, 20));
		putInRegistryArgs(ModBlocks.VERTICAL_BAMBOO_MOSAIC_SLAB, new RegistryArgs().flammable(5, 20));
		putInRegistryArgs(ModBlocks.VERTICAL_BAMBOO_MOSAIC_STAIRS, new RegistryArgs().flammable(5, 20));
		putInRegistryArgs(ModBlocks.VERTICAL_STRIPPED_BAMBOO_BLOCK_SLAB, new RegistryArgs().flammable(5, 5));
		putInRegistryArgs(ModBlocks.VERTICAL_STRIPPED_BAMBOO_BLOCK_STAIRS, new RegistryArgs().flammable(5, 5));
		putInRegistryArgs(ModBlocks.VERTICAL_BAMBOO_BLOCK_SLAB, new RegistryArgs().strippable(ModBlocks.VERTICAL_STRIPPED_PALE_OAK_WOOD_STAIRS).flammable(5, 5));
		putInRegistryArgs(ModBlocks.VERTICAL_BAMBOO_BLOCK_STAIRS, new RegistryArgs().strippable(ModBlocks.VERTICAL_STRIPPED_PALE_OAK_WOOD_STAIRS).flammable(5, 5));
		putInRegistryArgs(ModBlocks.VERTICAL_CRIMSON_STEM_SLAB, new RegistryArgs().strippable(ModBlocks.VERTICAL_STRIPPED_CRIMSON_STEM_SLAB));
		putInRegistryArgs(ModBlocks.VERTICAL_CRIMSON_STEM_STAIRS, new RegistryArgs().strippable(ModBlocks.VERTICAL_STRIPPED_CRIMSON_STEM_STAIRS));
		putInRegistryArgs(ModBlocks.VERTICAL_CRIMSON_HYPHAE_SLAB, new RegistryArgs().strippable(ModBlocks.VERTICAL_STRIPPED_CRIMSON_HYPHAE_SLAB));
		putInRegistryArgs(ModBlocks.VERTICAL_CRIMSON_HYPHAE_STAIRS, new RegistryArgs().strippable(ModBlocks.VERTICAL_STRIPPED_CRIMSON_HYPHAE_STAIRS));
		putInRegistryArgs(ModBlocks.VERTICAL_WARPED_STEM_SLAB, new RegistryArgs().strippable(ModBlocks.VERTICAL_STRIPPED_WARPED_STEM_SLAB));
		putInRegistryArgs(ModBlocks.VERTICAL_WARPED_STEM_STAIRS, new RegistryArgs().strippable(ModBlocks.VERTICAL_STRIPPED_WARPED_STEM_STAIRS));
		putInRegistryArgs(ModBlocks.VERTICAL_WARPED_HYPHAE_SLAB, new RegistryArgs().strippable(ModBlocks.VERTICAL_STRIPPED_WARPED_HYPHAE_SLAB));
		putInRegistryArgs(ModBlocks.VERTICAL_WARPED_HYPHAE_STAIRS, new RegistryArgs().strippable(ModBlocks.VERTICAL_STRIPPED_WARPED_HYPHAE_STAIRS));
		putInRegistryArgs(ModBlocks.VERTICAL_COAL_SLAB, new RegistryArgs().flammable(5, 5));
		putInRegistryArgs(ModBlocks.VERTICAL_COAL_STAIRS, new RegistryArgs().flammable(5, 5));
		putInRegistryArgs(ModBlocks.VERTICAL_WAXED_COPPER_GRATE_SLAB, new RegistryArgs().transparent());
		putInRegistryArgs(ModBlocks.VERTICAL_WAXED_COPPER_GRATE_STAIRS, new RegistryArgs().transparent());
		putInRegistryArgs(ModBlocks.VERTICAL_WAXED_EXPOSED_COPPER_GRATE_SLAB, new RegistryArgs().transparent());
		putInRegistryArgs(ModBlocks.VERTICAL_WAXED_EXPOSED_COPPER_GRATE_STAIRS, new RegistryArgs().transparent());
		putInRegistryArgs(ModBlocks.VERTICAL_WAXED_WEATHERED_COPPER_GRATE_SLAB, new RegistryArgs().transparent());
		putInRegistryArgs(ModBlocks.VERTICAL_WAXED_WEATHERED_COPPER_GRATE_STAIRS, new RegistryArgs().transparent());
		putInRegistryArgs(ModBlocks.VERTICAL_WAXED_OXIDIZED_COPPER_GRATE_SLAB, new RegistryArgs().transparent());
		putInRegistryArgs(ModBlocks.VERTICAL_WAXED_OXIDIZED_COPPER_GRATE_STAIRS, new RegistryArgs().transparent());
		putInRegistryArgs(ModBlocks.VERTICAL_COPPER_SLAB, new RegistryArgs().oxidizable(ModBlocks.VERTICAL_EXPOSED_COPPER_SLAB, ModBlocks.VERTICAL_WEATHERED_COPPER_SLAB, ModBlocks.VERTICAL_OXIDIZED_COPPER_SLAB, ModBlocks.VERTICAL_WAXED_COPPER_SLAB, ModBlocks.VERTICAL_WAXED_EXPOSED_COPPER_SLAB, ModBlocks.VERTICAL_WAXED_WEATHERED_COPPER_SLAB, ModBlocks.VERTICAL_WAXED_OXIDIZED_COPPER_SLAB));
		putInRegistryArgs(ModBlocks.VERTICAL_COPPER_STAIRS, new RegistryArgs().oxidizable(ModBlocks.VERTICAL_EXPOSED_COPPER_STAIRS, ModBlocks.VERTICAL_WEATHERED_COPPER_STAIRS, ModBlocks.VERTICAL_OXIDIZED_COPPER_STAIRS, ModBlocks.VERTICAL_WAXED_COPPER_STAIRS, ModBlocks.VERTICAL_WAXED_EXPOSED_COPPER_STAIRS, ModBlocks.VERTICAL_WAXED_WEATHERED_COPPER_STAIRS, ModBlocks.VERTICAL_WAXED_OXIDIZED_COPPER_STAIRS));
		putInRegistryArgs(ModBlocks.VERTICAL_CHISELED_COPPER_SLAB, new RegistryArgs().oxidizable(ModBlocks.VERTICAL_EXPOSED_CHISELED_COPPER_SLAB, ModBlocks.VERTICAL_WEATHERED_CHISELED_COPPER_SLAB, ModBlocks.VERTICAL_OXIDIZED_CHISELED_COPPER_SLAB, ModBlocks.VERTICAL_WAXED_CHISELED_COPPER_SLAB, ModBlocks.VERTICAL_WAXED_EXPOSED_CHISELED_COPPER_SLAB, ModBlocks.VERTICAL_WAXED_WEATHERED_CHISELED_COPPER_SLAB, ModBlocks.VERTICAL_WAXED_OXIDIZED_CHISELED_COPPER_SLAB));
		putInRegistryArgs(ModBlocks.VERTICAL_CHISELED_COPPER_STAIRS, new RegistryArgs().oxidizable(ModBlocks.VERTICAL_EXPOSED_CHISELED_COPPER_STAIRS, ModBlocks.VERTICAL_WEATHERED_CHISELED_COPPER_STAIRS, ModBlocks.VERTICAL_OXIDIZED_CHISELED_COPPER_STAIRS, ModBlocks.VERTICAL_WAXED_CHISELED_COPPER_STAIRS, ModBlocks.VERTICAL_WAXED_EXPOSED_CHISELED_COPPER_STAIRS, ModBlocks.VERTICAL_WAXED_WEATHERED_CHISELED_COPPER_STAIRS, ModBlocks.VERTICAL_WAXED_OXIDIZED_CHISELED_COPPER_STAIRS));
		putInRegistryArgs(ModBlocks.VERTICAL_EXPOSED_COPPER_GRATE_SLAB, new RegistryArgs().transparent());
		putInRegistryArgs(ModBlocks.VERTICAL_EXPOSED_COPPER_GRATE_STAIRS, new RegistryArgs().transparent());
		putInRegistryArgs(ModBlocks.VERTICAL_WEATHERED_COPPER_GRATE_SLAB, new RegistryArgs().transparent());
		putInRegistryArgs(ModBlocks.VERTICAL_WEATHERED_COPPER_GRATE_STAIRS, new RegistryArgs().transparent());
		putInRegistryArgs(ModBlocks.VERTICAL_OXIDIZED_COPPER_GRATE_SLAB, new RegistryArgs().transparent());
		putInRegistryArgs(ModBlocks.VERTICAL_OXIDIZED_COPPER_GRATE_STAIRS, new RegistryArgs().transparent());
		putInRegistryArgs(ModBlocks.VERTICAL_COPPER_GRATE_SLAB, new RegistryArgs().oxidizable(ModBlocks.VERTICAL_EXPOSED_COPPER_GRATE_SLAB, ModBlocks.VERTICAL_WEATHERED_COPPER_GRATE_SLAB, ModBlocks.VERTICAL_OXIDIZED_COPPER_GRATE_SLAB, ModBlocks.VERTICAL_WAXED_COPPER_GRATE_SLAB, ModBlocks.VERTICAL_WAXED_EXPOSED_COPPER_GRATE_SLAB, ModBlocks.VERTICAL_WAXED_WEATHERED_COPPER_GRATE_SLAB, ModBlocks.VERTICAL_WAXED_OXIDIZED_COPPER_GRATE_SLAB).transparent());
		putInRegistryArgs(ModBlocks.VERTICAL_COPPER_GRATE_STAIRS, new RegistryArgs().oxidizable(ModBlocks.VERTICAL_EXPOSED_COPPER_GRATE_STAIRS, ModBlocks.VERTICAL_WEATHERED_COPPER_GRATE_STAIRS, ModBlocks.VERTICAL_OXIDIZED_COPPER_GRATE_STAIRS, ModBlocks.VERTICAL_WAXED_COPPER_GRATE_STAIRS, ModBlocks.VERTICAL_WAXED_EXPOSED_COPPER_GRATE_STAIRS, ModBlocks.VERTICAL_WAXED_WEATHERED_COPPER_GRATE_STAIRS, ModBlocks.VERTICAL_WAXED_OXIDIZED_COPPER_GRATE_STAIRS).transparent());
		putInRegistryArgs(ModBlocks.VERTICAL_CUT_COPPER_SLAB, new RegistryArgs().oxidizable(ModBlocks.VERTICAL_EXPOSED_CUT_COPPER_SLAB, ModBlocks.VERTICAL_WEATHERED_CUT_COPPER_SLAB, ModBlocks.VERTICAL_OXIDIZED_CUT_COPPER_SLAB, ModBlocks.VERTICAL_WAXED_CUT_COPPER_SLAB, ModBlocks.VERTICAL_WAXED_EXPOSED_CUT_COPPER_SLAB, ModBlocks.VERTICAL_WAXED_WEATHERED_CUT_COPPER_SLAB, ModBlocks.VERTICAL_WAXED_OXIDIZED_CUT_COPPER_SLAB));
		putInRegistryArgs(ModBlocks.VERTICAL_CUT_COPPER_STAIRS, new RegistryArgs().oxidizable(ModBlocks.VERTICAL_EXPOSED_CUT_COPPER_STAIRS, ModBlocks.VERTICAL_WEATHERED_CUT_COPPER_STAIRS, ModBlocks.VERTICAL_OXIDIZED_CUT_COPPER_STAIRS, ModBlocks.VERTICAL_WAXED_CUT_COPPER_STAIRS, ModBlocks.VERTICAL_WAXED_EXPOSED_CUT_COPPER_STAIRS, ModBlocks.VERTICAL_WAXED_WEATHERED_CUT_COPPER_STAIRS, ModBlocks.VERTICAL_WAXED_OXIDIZED_CUT_COPPER_STAIRS));
		putInRegistryArgs(ModBlocks.VERTICAL_WHITE_WOOL_SLAB, new RegistryArgs().flammable(30, 60));
		putInRegistryArgs(ModBlocks.VERTICAL_WHITE_WOOL_STAIRS, new RegistryArgs().flammable(30, 60));
		putInRegistryArgs(ModBlocks.VERTICAL_LIGHT_GRAY_WOOL_SLAB, new RegistryArgs().flammable(30, 60));
		putInRegistryArgs(ModBlocks.VERTICAL_LIGHT_GRAY_WOOL_STAIRS, new RegistryArgs().flammable(30, 60));
		putInRegistryArgs(ModBlocks.VERTICAL_GRAY_WOOL_SLAB, new RegistryArgs().flammable(30, 60));
		putInRegistryArgs(ModBlocks.VERTICAL_GRAY_WOOL_STAIRS, new RegistryArgs().flammable(30, 60));
		putInRegistryArgs(ModBlocks.VERTICAL_BLACK_WOOL_SLAB, new RegistryArgs().flammable(30, 60));
		putInRegistryArgs(ModBlocks.VERTICAL_BLACK_WOOL_STAIRS, new RegistryArgs().flammable(30, 60));
		putInRegistryArgs(ModBlocks.VERTICAL_BROWN_WOOL_SLAB, new RegistryArgs().flammable(30, 60));
		putInRegistryArgs(ModBlocks.VERTICAL_BROWN_WOOL_STAIRS, new RegistryArgs().flammable(30, 60));
		putInRegistryArgs(ModBlocks.VERTICAL_RED_WOOL_SLAB, new RegistryArgs().flammable(30, 60));
		putInRegistryArgs(ModBlocks.VERTICAL_RED_WOOL_STAIRS, new RegistryArgs().flammable(30, 60));
		putInRegistryArgs(ModBlocks.VERTICAL_ORANGE_WOOL_SLAB, new RegistryArgs().flammable(30, 60));
		putInRegistryArgs(ModBlocks.VERTICAL_ORANGE_WOOL_STAIRS, new RegistryArgs().flammable(30, 60));
		putInRegistryArgs(ModBlocks.VERTICAL_YELLOW_WOOL_SLAB, new RegistryArgs().flammable(30, 60));
		putInRegistryArgs(ModBlocks.VERTICAL_YELLOW_WOOL_STAIRS, new RegistryArgs().flammable(30, 60));
		putInRegistryArgs(ModBlocks.VERTICAL_LIME_WOOL_SLAB, new RegistryArgs().flammable(30, 60));
		putInRegistryArgs(ModBlocks.VERTICAL_LIME_WOOL_STAIRS, new RegistryArgs().flammable(30, 60));
		putInRegistryArgs(ModBlocks.VERTICAL_GREEN_WOOL_SLAB, new RegistryArgs().flammable(30, 60));
		putInRegistryArgs(ModBlocks.VERTICAL_GREEN_WOOL_STAIRS, new RegistryArgs().flammable(30, 60));
		putInRegistryArgs(ModBlocks.VERTICAL_CYAN_WOOL_SLAB, new RegistryArgs().flammable(30, 60));
		putInRegistryArgs(ModBlocks.VERTICAL_CYAN_WOOL_STAIRS, new RegistryArgs().flammable(30, 60));
		putInRegistryArgs(ModBlocks.VERTICAL_LIGHT_BLUE_WOOL_SLAB, new RegistryArgs().flammable(30, 60));
		putInRegistryArgs(ModBlocks.VERTICAL_LIGHT_BLUE_WOOL_STAIRS, new RegistryArgs().flammable(30, 60));
		putInRegistryArgs(ModBlocks.VERTICAL_BLUE_WOOL_SLAB, new RegistryArgs().flammable(30, 60));
		putInRegistryArgs(ModBlocks.VERTICAL_BLUE_WOOL_STAIRS, new RegistryArgs().flammable(30, 60));
		putInRegistryArgs(ModBlocks.VERTICAL_PURPLE_WOOL_SLAB, new RegistryArgs().flammable(30, 60));
		putInRegistryArgs(ModBlocks.VERTICAL_PURPLE_WOOL_STAIRS, new RegistryArgs().flammable(30, 60));
		putInRegistryArgs(ModBlocks.VERTICAL_MAGENTA_WOOL_SLAB, new RegistryArgs().flammable(30, 60));
		putInRegistryArgs(ModBlocks.VERTICAL_MAGENTA_WOOL_STAIRS, new RegistryArgs().flammable(30, 60));
		putInRegistryArgs(ModBlocks.VERTICAL_PINK_WOOL_SLAB, new RegistryArgs().flammable(30, 60));
		putInRegistryArgs(ModBlocks.VERTICAL_PINK_WOOL_STAIRS, new RegistryArgs().flammable(30, 60));
		putInRegistryArgs(ModBlocks.VERTICAL_GLASS_SLAB, new RegistryArgs().transparent());
		putInRegistryArgs(ModBlocks.VERTICAL_GLASS_STAIRS, new RegistryArgs().transparent());
		putInRegistryArgs(ModBlocks.VERTICAL_WHITE_STAINED_GLASS_SLAB, new RegistryArgs().translucent());
		putInRegistryArgs(ModBlocks.VERTICAL_WHITE_STAINED_GLASS_STAIRS, new RegistryArgs().translucent());
		putInRegistryArgs(ModBlocks.VERTICAL_LIGHT_GRAY_STAINED_GLASS_SLAB, new RegistryArgs().translucent());
		putInRegistryArgs(ModBlocks.VERTICAL_LIGHT_GRAY_STAINED_GLASS_STAIRS, new RegistryArgs().translucent());
		putInRegistryArgs(ModBlocks.VERTICAL_GRAY_STAINED_GLASS_SLAB, new RegistryArgs().translucent());
		putInRegistryArgs(ModBlocks.VERTICAL_GRAY_STAINED_GLASS_STAIRS, new RegistryArgs().translucent());
		putInRegistryArgs(ModBlocks.VERTICAL_BLACK_STAINED_GLASS_SLAB, new RegistryArgs().translucent());
		putInRegistryArgs(ModBlocks.VERTICAL_BLACK_STAINED_GLASS_STAIRS, new RegistryArgs().translucent());
		putInRegistryArgs(ModBlocks.VERTICAL_BROWN_STAINED_GLASS_SLAB, new RegistryArgs().translucent());
		putInRegistryArgs(ModBlocks.VERTICAL_BROWN_STAINED_GLASS_STAIRS, new RegistryArgs().translucent());
		putInRegistryArgs(ModBlocks.VERTICAL_RED_STAINED_GLASS_SLAB, new RegistryArgs().translucent());
		putInRegistryArgs(ModBlocks.VERTICAL_RED_STAINED_GLASS_STAIRS, new RegistryArgs().translucent());
		putInRegistryArgs(ModBlocks.VERTICAL_ORANGE_STAINED_GLASS_SLAB, new RegistryArgs().translucent());
		putInRegistryArgs(ModBlocks.VERTICAL_ORANGE_STAINED_GLASS_STAIRS, new RegistryArgs().translucent());
		putInRegistryArgs(ModBlocks.VERTICAL_YELLOW_STAINED_GLASS_SLAB, new RegistryArgs().translucent());
		putInRegistryArgs(ModBlocks.VERTICAL_YELLOW_STAINED_GLASS_STAIRS, new RegistryArgs().translucent());
		putInRegistryArgs(ModBlocks.VERTICAL_LIME_STAINED_GLASS_SLAB, new RegistryArgs().translucent());
		putInRegistryArgs(ModBlocks.VERTICAL_LIME_STAINED_GLASS_STAIRS, new RegistryArgs().translucent());
		putInRegistryArgs(ModBlocks.VERTICAL_GREEN_STAINED_GLASS_SLAB, new RegistryArgs().translucent());
		putInRegistryArgs(ModBlocks.VERTICAL_GREEN_STAINED_GLASS_STAIRS, new RegistryArgs().translucent());
		putInRegistryArgs(ModBlocks.VERTICAL_CYAN_STAINED_GLASS_SLAB, new RegistryArgs().translucent());
		putInRegistryArgs(ModBlocks.VERTICAL_CYAN_STAINED_GLASS_STAIRS, new RegistryArgs().translucent());
		putInRegistryArgs(ModBlocks.VERTICAL_LIGHT_BLUE_STAINED_GLASS_SLAB, new RegistryArgs().translucent());
		putInRegistryArgs(ModBlocks.VERTICAL_LIGHT_BLUE_STAINED_GLASS_STAIRS, new RegistryArgs().translucent());
		putInRegistryArgs(ModBlocks.VERTICAL_BLUE_STAINED_GLASS_SLAB, new RegistryArgs().translucent());
		putInRegistryArgs(ModBlocks.VERTICAL_BLUE_STAINED_GLASS_STAIRS, new RegistryArgs().translucent());
		putInRegistryArgs(ModBlocks.VERTICAL_PURPLE_STAINED_GLASS_SLAB, new RegistryArgs().translucent());
		putInRegistryArgs(ModBlocks.VERTICAL_PURPLE_STAINED_GLASS_STAIRS, new RegistryArgs().translucent());
		putInRegistryArgs(ModBlocks.VERTICAL_MAGENTA_STAINED_GLASS_SLAB, new RegistryArgs().translucent());
		putInRegistryArgs(ModBlocks.VERTICAL_MAGENTA_STAINED_GLASS_STAIRS, new RegistryArgs().translucent());
		putInRegistryArgs(ModBlocks.VERTICAL_PINK_STAINED_GLASS_SLAB, new RegistryArgs().translucent());
		putInRegistryArgs(ModBlocks.VERTICAL_PINK_STAINED_GLASS_STAIRS, new RegistryArgs().translucent());
		putInRegistryArgs(ModBlocks.VERTICAL_DIRT_PATH_SLAB, new RegistryArgs().tillable(ModBlocks.VERTICAL_FARMLAND_SLAB));
		putInRegistryArgs(ModBlocks.VERTICAL_DIRT_PATH_STAIRS, new RegistryArgs().tillable(ModBlocks.VERTICAL_FARMLAND_STAIRS));
		putInRegistryArgs(ModBlocks.VERTICAL_GRASS_SLAB, new RegistryArgs().grassTinted().tillable(ModBlocks.VERTICAL_FARMLAND_SLAB).flattenable(ModBlocks.VERTICAL_DIRT_PATH_SLAB).transparent());
		putInRegistryArgs(ModBlocks.VERTICAL_GRASS_STAIRS, new RegistryArgs().grassTinted().tillable(ModBlocks.VERTICAL_FARMLAND_STAIRS).flattenable(ModBlocks.VERTICAL_DIRT_PATH_STAIRS).transparent());
		putInRegistryArgs(ModBlocks.VERTICAL_PODZOL_SLAB, new RegistryArgs().flattenable(ModBlocks.VERTICAL_DIRT_PATH_SLAB));
		putInRegistryArgs(ModBlocks.VERTICAL_PODZOL_STAIRS, new RegistryArgs().flattenable(ModBlocks.VERTICAL_DIRT_PATH_STAIRS));
		putInRegistryArgs(ModBlocks.VERTICAL_MYCELIUM_SLAB, new RegistryArgs().flattenable(ModBlocks.VERTICAL_DIRT_PATH_SLAB));
		putInRegistryArgs(ModBlocks.VERTICAL_MYCELIUM_STAIRS, new RegistryArgs().flattenable(ModBlocks.VERTICAL_DIRT_PATH_STAIRS));
		putInRegistryArgs(ModBlocks.VERTICAL_DIRT_SLAB, new RegistryArgs().flattenable(ModBlocks.VERTICAL_DIRT_PATH_SLAB).tillable(ModBlocks.VERTICAL_FARMLAND_SLAB));
		putInRegistryArgs(ModBlocks.VERTICAL_DIRT_STAIRS, new RegistryArgs().flattenable(ModBlocks.VERTICAL_DIRT_PATH_STAIRS).tillable(ModBlocks.VERTICAL_FARMLAND_STAIRS));
		putInRegistryArgs(ModBlocks.VERTICAL_COARSE_DIRT_SLAB, new RegistryArgs().flattenable(ModBlocks.VERTICAL_DIRT_PATH_SLAB));
		putInRegistryArgs(ModBlocks.VERTICAL_COARSE_DIRT_STAIRS, new RegistryArgs().flattenable(ModBlocks.VERTICAL_DIRT_PATH_STAIRS));
		putInRegistryArgs(ModBlocks.VERTICAL_ROOTED_DIRT_SLAB, new RegistryArgs().flattenable(ModBlocks.VERTICAL_DIRT_PATH_SLAB));
		putInRegistryArgs(ModBlocks.VERTICAL_ROOTED_DIRT_STAIRS, new RegistryArgs().flattenable(ModBlocks.VERTICAL_DIRT_PATH_STAIRS));
		putInRegistryArgs(ModBlocks.VERTICAL_PALE_MOSS_SLAB, new RegistryArgs().flammable(5, 100));
		putInRegistryArgs(ModBlocks.VERTICAL_PALE_MOSS_STAIRS, new RegistryArgs().flammable(5, 100));
		putInRegistryArgs(ModBlocks.VERTICAL_OAK_LEAVES_SLAB, new RegistryArgs().transparent().foliageTinted());
		putInRegistryArgs(ModBlocks.VERTICAL_OAK_LEAVES_STAIRS, new RegistryArgs().copy(ModBlocks.VERTICAL_OAK_LEAVES_SLAB));
		putInRegistryArgs(ModBlocks.VERTICAL_SPRUCE_LEAVES_SLAB, new RegistryArgs().transparent().foliageTinted());
		putInRegistryArgs(ModBlocks.VERTICAL_SPRUCE_LEAVES_STAIRS, new RegistryArgs().copy(ModBlocks.VERTICAL_SPRUCE_LEAVES_SLAB));
		putInRegistryArgs(ModBlocks.VERTICAL_BIRCH_LEAVES_SLAB, new RegistryArgs().transparent().foliageTinted());
		putInRegistryArgs(ModBlocks.VERTICAL_BIRCH_LEAVES_STAIRS, new RegistryArgs().copy(ModBlocks.VERTICAL_BIRCH_LEAVES_SLAB));
		putInRegistryArgs(ModBlocks.VERTICAL_JUNGLE_LEAVES_SLAB, new RegistryArgs().transparent().foliageTinted());
		putInRegistryArgs(ModBlocks.VERTICAL_JUNGLE_LEAVES_STAIRS, new RegistryArgs().copy(ModBlocks.VERTICAL_JUNGLE_LEAVES_SLAB));
		putInRegistryArgs(ModBlocks.VERTICAL_ACACIA_LEAVES_SLAB, new RegistryArgs().transparent().foliageTinted());
		putInRegistryArgs(ModBlocks.VERTICAL_ACACIA_LEAVES_STAIRS, new RegistryArgs().copy(ModBlocks.VERTICAL_ACACIA_LEAVES_SLAB));
		putInRegistryArgs(ModBlocks.VERTICAL_DARK_OAK_LEAVES_SLAB, new RegistryArgs().transparent().foliageTinted());
		putInRegistryArgs(ModBlocks.VERTICAL_DARK_OAK_LEAVES_STAIRS, new RegistryArgs().copy(ModBlocks.VERTICAL_DARK_OAK_LEAVES_SLAB));
		putInRegistryArgs(ModBlocks.VERTICAL_MANGROVE_LEAVES_SLAB, new RegistryArgs().transparent().foliageTinted());
		putInRegistryArgs(ModBlocks.VERTICAL_MANGROVE_LEAVES_STAIRS, new RegistryArgs().copy(ModBlocks.VERTICAL_MANGROVE_LEAVES_SLAB));
		putInRegistryArgs(ModBlocks.VERTICAL_CHERRY_LEAVES_SLAB, new RegistryArgs().transparent());
		putInRegistryArgs(ModBlocks.VERTICAL_CHERRY_LEAVES_STAIRS, new RegistryArgs().copy(ModBlocks.VERTICAL_CHERRY_LEAVES_SLAB));
		putInRegistryArgs(ModBlocks.VERTICAL_PALE_OAK_LEAVES_SLAB, new RegistryArgs().transparent());
		putInRegistryArgs(ModBlocks.VERTICAL_PALE_OAK_LEAVES_STAIRS, new RegistryArgs().copy(ModBlocks.VERTICAL_PALE_OAK_LEAVES_SLAB));
		putInRegistryArgs(ModBlocks.VERTICAL_AZALEA_LEAVES_SLAB, new RegistryArgs().transparent());
		putInRegistryArgs(ModBlocks.VERTICAL_AZALEA_LEAVES_STAIRS, new RegistryArgs().copy(ModBlocks.VERTICAL_AZALEA_LEAVES_SLAB));
		putInRegistryArgs(ModBlocks.VERTICAL_FLOWERING_AZALEA_LEAVES_SLAB, new RegistryArgs().transparent());
		putInRegistryArgs(ModBlocks.VERTICAL_FLOWERING_AZALEA_LEAVES_STAIRS, new RegistryArgs().copy(ModBlocks.VERTICAL_FLOWERING_AZALEA_LEAVES_SLAB));
		putInRegistryArgs(ModBlocks.VERTICAL_ICE_SLAB, new RegistryArgs().translucent());
		putInRegistryArgs(ModBlocks.VERTICAL_ICE_STAIRS, new RegistryArgs().copy(ModBlocks.VERTICAL_ICE_SLAB));
	}

	public static void registerDatagenArgs() {
		putInDatagenArgs(ModBlocks.VERTICAL_OAK_SLAB, new DatagenArgs().blockTags(class_3481.field_33713).textureMap(class_4944.method_25864(class_2246.field_10161)).parentBlock(class_2246.field_10161));
		putInDatagenArgs(ModBlocks.VERTICAL_OAK_STAIRS, new DatagenArgs().blockTags(class_3481.field_33713).textureMap(class_4944.method_25864(class_2246.field_10161)).parentBlock(class_2246.field_10161));
		putInDatagenArgs(ModBlocks.VERTICAL_STRIPPED_OAK_LOG_SLAB, new DatagenArgs().blockTags(class_3481.field_33713).textureMap(blockAndTopForEnds(class_2246.field_10519)).parentBlock(class_2246.field_10519));
		putInDatagenArgs(ModBlocks.VERTICAL_STRIPPED_OAK_LOG_STAIRS, new DatagenArgs().blockTags(class_3481.field_33713).textureMap(blockAndTopForEnds(class_2246.field_10519)).parentBlock(class_2246.field_10519));
		putInDatagenArgs(ModBlocks.VERTICAL_STRIPPED_OAK_WOOD_SLAB, new DatagenArgs().blockTags(class_3481.field_33713).textureMap(class_4944.method_25864(class_2246.field_10519)).parentBlock(class_2246.field_10250));
		putInDatagenArgs(ModBlocks.VERTICAL_STRIPPED_OAK_WOOD_STAIRS, new DatagenArgs().blockTags(class_3481.field_33713).textureMap(class_4944.method_25864(class_2246.field_10519)).parentBlock(class_2246.field_10250));
		putInDatagenArgs(ModBlocks.VERTICAL_OAK_LOG_SLAB, new DatagenArgs().blockTags(class_3481.field_33713).textureMap(blockAndTopForEnds(class_2246.field_10431)).parentBlock(class_2246.field_10431));
		putInDatagenArgs(ModBlocks.VERTICAL_OAK_LOG_STAIRS, new DatagenArgs().blockTags(class_3481.field_33713).textureMap(blockAndTopForEnds(class_2246.field_10431)).parentBlock(class_2246.field_10431));
		putInDatagenArgs(ModBlocks.VERTICAL_OAK_WOOD_SLAB, new DatagenArgs().blockTags(class_3481.field_33713).textureMap(class_4944.method_25864(class_2246.field_10431)).parentBlock(class_2246.field_10126));
		putInDatagenArgs(ModBlocks.VERTICAL_OAK_WOOD_STAIRS, new DatagenArgs().blockTags(class_3481.field_33713).textureMap(class_4944.method_25864(class_2246.field_10431)).parentBlock(class_2246.field_10126));
		putInDatagenArgs(ModBlocks.VERTICAL_SPRUCE_SLAB, new DatagenArgs().blockTags(class_3481.field_33713).textureMap(class_4944.method_25864(class_2246.field_9975)).parentBlock(class_2246.field_9975));
		putInDatagenArgs(ModBlocks.VERTICAL_SPRUCE_STAIRS, new DatagenArgs().blockTags(class_3481.field_33713).textureMap(class_4944.method_25864(class_2246.field_9975)).parentBlock(class_2246.field_9975));
		putInDatagenArgs(ModBlocks.VERTICAL_STRIPPED_SPRUCE_LOG_SLAB, new DatagenArgs().blockTags(class_3481.field_33713).textureMap(blockAndTopForEnds(class_2246.field_10436)).parentBlock(class_2246.field_10436));
		putInDatagenArgs(ModBlocks.VERTICAL_STRIPPED_SPRUCE_LOG_STAIRS, new DatagenArgs().blockTags(class_3481.field_33713).textureMap(blockAndTopForEnds(class_2246.field_10436)).parentBlock(class_2246.field_10436));
		putInDatagenArgs(ModBlocks.VERTICAL_STRIPPED_SPRUCE_WOOD_SLAB, new DatagenArgs().blockTags(class_3481.field_33713).textureMap(class_4944.method_25864(class_2246.field_10436)).parentBlock(class_2246.field_10558));
		putInDatagenArgs(ModBlocks.VERTICAL_STRIPPED_SPRUCE_WOOD_STAIRS, new DatagenArgs().blockTags(class_3481.field_33713).textureMap(class_4944.method_25864(class_2246.field_10436)).parentBlock(class_2246.field_10558));
		putInDatagenArgs(ModBlocks.VERTICAL_SPRUCE_LOG_SLAB, new DatagenArgs().blockTags(class_3481.field_33713).textureMap(blockAndTopForEnds(class_2246.field_10037)).parentBlock(class_2246.field_10037));
		putInDatagenArgs(ModBlocks.VERTICAL_SPRUCE_LOG_STAIRS, new DatagenArgs().blockTags(class_3481.field_33713).textureMap(blockAndTopForEnds(class_2246.field_10037)).parentBlock(class_2246.field_10037));
		putInDatagenArgs(ModBlocks.VERTICAL_SPRUCE_WOOD_SLAB, new DatagenArgs().blockTags(class_3481.field_33713).textureMap(class_4944.method_25864(class_2246.field_10037)).parentBlock(class_2246.field_10155));
		putInDatagenArgs(ModBlocks.VERTICAL_SPRUCE_WOOD_STAIRS, new DatagenArgs().blockTags(class_3481.field_33713).textureMap(class_4944.method_25864(class_2246.field_10037)).parentBlock(class_2246.field_10155));
		putInDatagenArgs(ModBlocks.VERTICAL_BIRCH_SLAB, new DatagenArgs().blockTags(class_3481.field_33713).textureMap(class_4944.method_25864(class_2246.field_10148)).parentBlock(class_2246.field_10148));
		putInDatagenArgs(ModBlocks.VERTICAL_BIRCH_STAIRS, new DatagenArgs().blockTags(class_3481.field_33713).textureMap(class_4944.method_25864(class_2246.field_10148)).parentBlock(class_2246.field_10148));
		putInDatagenArgs(ModBlocks.VERTICAL_STRIPPED_BIRCH_LOG_SLAB, new DatagenArgs().blockTags(class_3481.field_33713).textureMap(blockAndTopForEnds(class_2246.field_10366)).parentBlock(class_2246.field_10366));
		putInDatagenArgs(ModBlocks.VERTICAL_STRIPPED_BIRCH_LOG_STAIRS, new DatagenArgs().blockTags(class_3481.field_33713).textureMap(blockAndTopForEnds(class_2246.field_10366)).parentBlock(class_2246.field_10366));
		putInDatagenArgs(ModBlocks.VERTICAL_STRIPPED_BIRCH_WOOD_SLAB, new DatagenArgs().blockTags(class_3481.field_33713).textureMap(class_4944.method_25864(class_2246.field_10366)).parentBlock(class_2246.field_10204));
		putInDatagenArgs(ModBlocks.VERTICAL_STRIPPED_BIRCH_WOOD_STAIRS, new DatagenArgs().blockTags(class_3481.field_33713).textureMap(class_4944.method_25864(class_2246.field_10366)).parentBlock(class_2246.field_10204));
		putInDatagenArgs(ModBlocks.VERTICAL_BIRCH_LOG_SLAB, new DatagenArgs().blockTags(class_3481.field_33713).textureMap(blockAndTopForEnds(class_2246.field_10511)).parentBlock(class_2246.field_10511));
		putInDatagenArgs(ModBlocks.VERTICAL_BIRCH_LOG_STAIRS, new DatagenArgs().blockTags(class_3481.field_33713).textureMap(blockAndTopForEnds(class_2246.field_10511)).parentBlock(class_2246.field_10511));
		putInDatagenArgs(ModBlocks.VERTICAL_BIRCH_WOOD_SLAB, new DatagenArgs().blockTags(class_3481.field_33713).textureMap(class_4944.method_25864(class_2246.field_10511)).parentBlock(class_2246.field_10307));
		putInDatagenArgs(ModBlocks.VERTICAL_BIRCH_WOOD_STAIRS, new DatagenArgs().blockTags(class_3481.field_33713).textureMap(class_4944.method_25864(class_2246.field_10511)).parentBlock(class_2246.field_10307));
		putInDatagenArgs(ModBlocks.VERTICAL_JUNGLE_SLAB, new DatagenArgs().blockTags(class_3481.field_33713).textureMap(class_4944.method_25864(class_2246.field_10334)).parentBlock(class_2246.field_10334));
		putInDatagenArgs(ModBlocks.VERTICAL_JUNGLE_STAIRS, new DatagenArgs().blockTags(class_3481.field_33713).textureMap(class_4944.method_25864(class_2246.field_10334)).parentBlock(class_2246.field_10334));
		putInDatagenArgs(ModBlocks.VERTICAL_STRIPPED_JUNGLE_LOG_SLAB, new DatagenArgs().blockTags(class_3481.field_33713).textureMap(blockAndTopForEnds(class_2246.field_10254)).parentBlock(class_2246.field_10254));
		putInDatagenArgs(ModBlocks.VERTICAL_STRIPPED_JUNGLE_LOG_STAIRS, new DatagenArgs().blockTags(class_3481.field_33713).textureMap(blockAndTopForEnds(class_2246.field_10254)).parentBlock(class_2246.field_10254));
		putInDatagenArgs(ModBlocks.VERTICAL_STRIPPED_JUNGLE_WOOD_SLAB, new DatagenArgs().blockTags(class_3481.field_33713).textureMap(class_4944.method_25864(class_2246.field_10254)).parentBlock(class_2246.field_10084));
		putInDatagenArgs(ModBlocks.VERTICAL_STRIPPED_JUNGLE_WOOD_STAIRS, new DatagenArgs().blockTags(class_3481.field_33713).textureMap(class_4944.method_25864(class_2246.field_10254)).parentBlock(class_2246.field_10084));
		putInDatagenArgs(ModBlocks.VERTICAL_JUNGLE_LOG_SLAB, new DatagenArgs().blockTags(class_3481.field_33713).textureMap(blockAndTopForEnds(class_2246.field_10306)).parentBlock(class_2246.field_10306));
		putInDatagenArgs(ModBlocks.VERTICAL_JUNGLE_LOG_STAIRS, new DatagenArgs().blockTags(class_3481.field_33713).textureMap(blockAndTopForEnds(class_2246.field_10306)).parentBlock(class_2246.field_10306));
		putInDatagenArgs(ModBlocks.VERTICAL_JUNGLE_WOOD_SLAB, new DatagenArgs().blockTags(class_3481.field_33713).textureMap(class_4944.method_25864(class_2246.field_10306)).parentBlock(class_2246.field_10303));
		putInDatagenArgs(ModBlocks.VERTICAL_JUNGLE_WOOD_STAIRS, new DatagenArgs().blockTags(class_3481.field_33713).textureMap(class_4944.method_25864(class_2246.field_10306)).parentBlock(class_2246.field_10303));
		putInDatagenArgs(ModBlocks.VERTICAL_ACACIA_SLAB, new DatagenArgs().blockTags(class_3481.field_33713).textureMap(class_4944.method_25864(class_2246.field_10218)).parentBlock(class_2246.field_10218));
		putInDatagenArgs(ModBlocks.VERTICAL_ACACIA_STAIRS, new DatagenArgs().blockTags(class_3481.field_33713).textureMap(class_4944.method_25864(class_2246.field_10218)).parentBlock(class_2246.field_10218));
		putInDatagenArgs(ModBlocks.VERTICAL_STRIPPED_ACACIA_LOG_SLAB, new DatagenArgs().blockTags(class_3481.field_33713).textureMap(blockAndTopForEnds(class_2246.field_10622)).parentBlock(class_2246.field_10622));
		putInDatagenArgs(ModBlocks.VERTICAL_STRIPPED_ACACIA_LOG_STAIRS, new DatagenArgs().blockTags(class_3481.field_33713).textureMap(blockAndTopForEnds(class_2246.field_10622)).parentBlock(class_2246.field_10622));
		putInDatagenArgs(ModBlocks.VERTICAL_STRIPPED_ACACIA_WOOD_SLAB, new DatagenArgs().blockTags(class_3481.field_33713).textureMap(class_4944.method_25864(class_2246.field_10622)).parentBlock(class_2246.field_10103));
		putInDatagenArgs(ModBlocks.VERTICAL_STRIPPED_ACACIA_WOOD_STAIRS, new DatagenArgs().blockTags(class_3481.field_33713).textureMap(class_4944.method_25864(class_2246.field_10622)).parentBlock(class_2246.field_10103));
		putInDatagenArgs(ModBlocks.VERTICAL_ACACIA_LOG_SLAB, new DatagenArgs().blockTags(class_3481.field_33713).textureMap(blockAndTopForEnds(class_2246.field_10533)).parentBlock(class_2246.field_10533));
		putInDatagenArgs(ModBlocks.VERTICAL_ACACIA_LOG_STAIRS, new DatagenArgs().blockTags(class_3481.field_33713).textureMap(blockAndTopForEnds(class_2246.field_10533)).parentBlock(class_2246.field_10533));
		putInDatagenArgs(ModBlocks.VERTICAL_ACACIA_WOOD_SLAB, new DatagenArgs().blockTags(class_3481.field_33713).textureMap(class_4944.method_25864(class_2246.field_10533)).parentBlock(class_2246.field_9999));
		putInDatagenArgs(ModBlocks.VERTICAL_ACACIA_WOOD_STAIRS, new DatagenArgs().blockTags(class_3481.field_33713).textureMap(class_4944.method_25864(class_2246.field_10533)).parentBlock(class_2246.field_9999));
		putInDatagenArgs(ModBlocks.VERTICAL_DARK_OAK_SLAB, new DatagenArgs().blockTags(class_3481.field_33713).textureMap(class_4944.method_25864(class_2246.field_10075)).parentBlock(class_2246.field_10075));
		putInDatagenArgs(ModBlocks.VERTICAL_DARK_OAK_STAIRS, new DatagenArgs().blockTags(class_3481.field_33713).textureMap(class_4944.method_25864(class_2246.field_10075)).parentBlock(class_2246.field_10075));
		putInDatagenArgs(ModBlocks.VERTICAL_STRIPPED_DARK_OAK_LOG_SLAB, new DatagenArgs().blockTags(class_3481.field_33713).textureMap(blockAndTopForEnds(class_2246.field_10244)).parentBlock(class_2246.field_10244));
		putInDatagenArgs(ModBlocks.VERTICAL_STRIPPED_DARK_OAK_LOG_STAIRS, new DatagenArgs().blockTags(class_3481.field_33713).textureMap(blockAndTopForEnds(class_2246.field_10244)).parentBlock(class_2246.field_10244));
		putInDatagenArgs(ModBlocks.VERTICAL_STRIPPED_DARK_OAK_WOOD_SLAB, new DatagenArgs().blockTags(class_3481.field_33713).textureMap(class_4944.method_25864(class_2246.field_10244)).parentBlock(class_2246.field_10374));
		putInDatagenArgs(ModBlocks.VERTICAL_STRIPPED_DARK_OAK_WOOD_STAIRS, new DatagenArgs().blockTags(class_3481.field_33713).textureMap(class_4944.method_25864(class_2246.field_10244)).parentBlock(class_2246.field_10374));
		putInDatagenArgs(ModBlocks.VERTICAL_DARK_OAK_LOG_SLAB, new DatagenArgs().blockTags(class_3481.field_33713).textureMap(blockAndTopForEnds(class_2246.field_10010)).parentBlock(class_2246.field_10010));
		putInDatagenArgs(ModBlocks.VERTICAL_DARK_OAK_LOG_STAIRS, new DatagenArgs().blockTags(class_3481.field_33713).textureMap(blockAndTopForEnds(class_2246.field_10010)).parentBlock(class_2246.field_10010));
		putInDatagenArgs(ModBlocks.VERTICAL_DARK_OAK_WOOD_SLAB, new DatagenArgs().blockTags(class_3481.field_33713).textureMap(class_4944.method_25864(class_2246.field_10010)).parentBlock(class_2246.field_10178));
		putInDatagenArgs(ModBlocks.VERTICAL_DARK_OAK_WOOD_STAIRS, new DatagenArgs().blockTags(class_3481.field_33713).textureMap(class_4944.method_25864(class_2246.field_10010)).parentBlock(class_2246.field_10178));
		putInDatagenArgs(ModBlocks.VERTICAL_MANGROVE_SLAB, new DatagenArgs().blockTags(class_3481.field_33713).textureMap(class_4944.method_25864(class_2246.field_37577)).parentBlock(class_2246.field_37577));
		putInDatagenArgs(ModBlocks.VERTICAL_MANGROVE_STAIRS, new DatagenArgs().blockTags(class_3481.field_33713).textureMap(class_4944.method_25864(class_2246.field_37577)).parentBlock(class_2246.field_37577));
		putInDatagenArgs(ModBlocks.VERTICAL_STRIPPED_MANGROVE_LOG_SLAB, new DatagenArgs().blockTags(class_3481.field_33713).textureMap(blockAndTopForEnds(class_2246.field_37548)).parentBlock(class_2246.field_37548));
		putInDatagenArgs(ModBlocks.VERTICAL_STRIPPED_MANGROVE_LOG_STAIRS, new DatagenArgs().blockTags(class_3481.field_33713).textureMap(blockAndTopForEnds(class_2246.field_37548)).parentBlock(class_2246.field_37548));
		putInDatagenArgs(ModBlocks.VERTICAL_STRIPPED_MANGROVE_WOOD_SLAB, new DatagenArgs().blockTags(class_3481.field_33713).textureMap(class_4944.method_25864(class_2246.field_37548)).parentBlock(class_2246.field_37550));
		putInDatagenArgs(ModBlocks.VERTICAL_STRIPPED_MANGROVE_WOOD_STAIRS, new DatagenArgs().blockTags(class_3481.field_33713).textureMap(class_4944.method_25864(class_2246.field_37548)).parentBlock(class_2246.field_37550));
		putInDatagenArgs(ModBlocks.VERTICAL_MANGROVE_LOG_SLAB, new DatagenArgs().blockTags(class_3481.field_33713).textureMap(blockAndTopForEnds(class_2246.field_37545)).parentBlock(class_2246.field_37545));
		putInDatagenArgs(ModBlocks.VERTICAL_MANGROVE_LOG_STAIRS, new DatagenArgs().blockTags(class_3481.field_33713).textureMap(blockAndTopForEnds(class_2246.field_37545)).parentBlock(class_2246.field_37545));
		putInDatagenArgs(ModBlocks.VERTICAL_MANGROVE_WOOD_SLAB, new DatagenArgs().blockTags(class_3481.field_33713).textureMap(class_4944.method_25864(class_2246.field_37545)).parentBlock(class_2246.field_37549));
		putInDatagenArgs(ModBlocks.VERTICAL_MANGROVE_WOOD_STAIRS, new DatagenArgs().blockTags(class_3481.field_33713).textureMap(class_4944.method_25864(class_2246.field_37545)).parentBlock(class_2246.field_37549));
		putInDatagenArgs(ModBlocks.VERTICAL_CHERRY_SLAB, new DatagenArgs().blockTags(class_3481.field_33713).textureMap(class_4944.method_25864(class_2246.field_42751)).parentBlock(class_2246.field_42751));
		putInDatagenArgs(ModBlocks.VERTICAL_CHERRY_STAIRS, new DatagenArgs().blockTags(class_3481.field_33713).textureMap(class_4944.method_25864(class_2246.field_42751)).parentBlock(class_2246.field_42751));
		putInDatagenArgs(ModBlocks.VERTICAL_STRIPPED_CHERRY_LOG_SLAB, new DatagenArgs().blockTags(class_3481.field_33713).textureMap(blockAndTopForEnds(class_2246.field_42732)).parentBlock(class_2246.field_42732));
		putInDatagenArgs(ModBlocks.VERTICAL_STRIPPED_CHERRY_LOG_STAIRS, new DatagenArgs().blockTags(class_3481.field_33713).textureMap(blockAndTopForEnds(class_2246.field_42732)).parentBlock(class_2246.field_42732));
		putInDatagenArgs(ModBlocks.VERTICAL_STRIPPED_CHERRY_WOOD_SLAB, new DatagenArgs().blockTags(class_3481.field_33713).textureMap(class_4944.method_25864(class_2246.field_42732)).parentBlock(class_2246.field_42730));
		putInDatagenArgs(ModBlocks.VERTICAL_STRIPPED_CHERRY_WOOD_STAIRS, new DatagenArgs().blockTags(class_3481.field_33713).textureMap(class_4944.method_25864(class_2246.field_42732)).parentBlock(class_2246.field_42730));
		putInDatagenArgs(ModBlocks.VERTICAL_CHERRY_LOG_SLAB, new DatagenArgs().blockTags(class_3481.field_33713).textureMap(blockAndTopForEnds(class_2246.field_42729)).parentBlock(class_2246.field_42729));
		putInDatagenArgs(ModBlocks.VERTICAL_CHERRY_LOG_STAIRS, new DatagenArgs().blockTags(class_3481.field_33713).textureMap(blockAndTopForEnds(class_2246.field_42729)).parentBlock(class_2246.field_42729));
		putInDatagenArgs(ModBlocks.VERTICAL_CHERRY_WOOD_SLAB, new DatagenArgs().blockTags(class_3481.field_33713).textureMap(class_4944.method_25864(class_2246.field_42729)).parentBlock(class_2246.field_42733));
		putInDatagenArgs(ModBlocks.VERTICAL_CHERRY_WOOD_STAIRS, new DatagenArgs().blockTags(class_3481.field_33713).textureMap(class_4944.method_25864(class_2246.field_42729)).parentBlock(class_2246.field_42733));
		putInDatagenArgs(ModBlocks.VERTICAL_PALE_OAK_SLAB, new DatagenArgs().blockTags(class_3481.field_33713).textureMap(class_4944.method_25864(class_2246.field_54735)).parentBlock(class_2246.field_54735));
		putInDatagenArgs(ModBlocks.VERTICAL_PALE_OAK_STAIRS, new DatagenArgs().blockTags(class_3481.field_33713).textureMap(class_4944.method_25864(class_2246.field_54735)).parentBlock(class_2246.field_54735));
		putInDatagenArgs(ModBlocks.VERTICAL_STRIPPED_PALE_OAK_LOG_SLAB, new DatagenArgs().blockTags(class_3481.field_33713).textureMap(blockAndTopForEnds(class_2246.field_54716)).parentBlock(class_2246.field_54716));
		putInDatagenArgs(ModBlocks.VERTICAL_STRIPPED_PALE_OAK_LOG_STAIRS, new DatagenArgs().blockTags(class_3481.field_33713).textureMap(blockAndTopForEnds(class_2246.field_54716)).parentBlock(class_2246.field_54716));
		putInDatagenArgs(ModBlocks.VERTICAL_STRIPPED_PALE_OAK_WOOD_SLAB, new DatagenArgs().blockTags(class_3481.field_33713).textureMap(class_4944.method_25864(class_2246.field_54716)).parentBlock(class_2246.field_54713));
		putInDatagenArgs(ModBlocks.VERTICAL_STRIPPED_PALE_OAK_WOOD_STAIRS, new DatagenArgs().blockTags(class_3481.field_33713).textureMap(class_4944.method_25864(class_2246.field_54716)).parentBlock(class_2246.field_54713));
		putInDatagenArgs(ModBlocks.VERTICAL_PALE_OAK_LOG_SLAB, new DatagenArgs().blockTags(class_3481.field_33713).textureMap(blockAndTopForEnds(class_2246.field_54715)).parentBlock(class_2246.field_54715));
		putInDatagenArgs(ModBlocks.VERTICAL_PALE_OAK_LOG_STAIRS, new DatagenArgs().blockTags(class_3481.field_33713).textureMap(blockAndTopForEnds(class_2246.field_54715)).parentBlock(class_2246.field_54715));
		putInDatagenArgs(ModBlocks.VERTICAL_PALE_OAK_WOOD_SLAB, new DatagenArgs().blockTags(class_3481.field_33713).textureMap(class_4944.method_25864(class_2246.field_54715)).parentBlock(class_2246.field_54734));
		putInDatagenArgs(ModBlocks.VERTICAL_PALE_OAK_WOOD_STAIRS, new DatagenArgs().blockTags(class_3481.field_33713).textureMap(class_4944.method_25864(class_2246.field_54715)).parentBlock(class_2246.field_54734));
		putInDatagenArgs(ModBlocks.VERTICAL_BAMBOO_SLAB, new DatagenArgs().blockTags(class_3481.field_33713).textureMap(class_4944.method_25864(class_2246.field_40294)).parentBlock(class_2246.field_40294));
		putInDatagenArgs(ModBlocks.VERTICAL_BAMBOO_STAIRS, new DatagenArgs().blockTags(class_3481.field_33713).textureMap(class_4944.method_25864(class_2246.field_40294)).parentBlock(class_2246.field_40294));
		putInDatagenArgs(ModBlocks.VERTICAL_BAMBOO_MOSAIC_SLAB, new DatagenArgs().blockTags(class_3481.field_33713).textureMap(class_4944.method_25864(class_2246.field_40295)).parentBlock(class_2246.field_40295));
		putInDatagenArgs(ModBlocks.VERTICAL_BAMBOO_MOSAIC_STAIRS, new DatagenArgs().blockTags(class_3481.field_33713).textureMap(class_4944.method_25864(class_2246.field_40295)).parentBlock(class_2246.field_40295));
		putInDatagenArgs(ModBlocks.VERTICAL_STRIPPED_BAMBOO_BLOCK_SLAB, new DatagenArgs().blockTags(class_3481.field_33713).textureMap(blockAndTopForEnds(class_2246.field_41073)).parentBlock(class_2246.field_41073));
		putInDatagenArgs(ModBlocks.VERTICAL_STRIPPED_BAMBOO_BLOCK_STAIRS, new DatagenArgs().blockTags(class_3481.field_33713).textureMap(blockAndTopForEnds(class_2246.field_41073)).parentBlock(class_2246.field_41073));
		putInDatagenArgs(ModBlocks.VERTICAL_BAMBOO_BLOCK_SLAB, new DatagenArgs().blockTags(class_3481.field_33713).textureMap(blockAndTopForEnds(class_2246.field_41072)).parentBlock(class_2246.field_41072));
		putInDatagenArgs(ModBlocks.VERTICAL_BAMBOO_BLOCK_STAIRS, new DatagenArgs().blockTags(class_3481.field_33713).textureMap(blockAndTopForEnds(class_2246.field_41072)).parentBlock(class_2246.field_41072));
		putInDatagenArgs(ModBlocks.VERTICAL_CRIMSON_SLAB, new DatagenArgs().blockTags(class_3481.field_33713).textureMap(class_4944.method_25864(class_2246.field_22126)).parentBlock(class_2246.field_22126));
		putInDatagenArgs(ModBlocks.VERTICAL_CRIMSON_STAIRS, new DatagenArgs().blockTags(class_3481.field_33713).textureMap(class_4944.method_25864(class_2246.field_22126)).parentBlock(class_2246.field_22126));
		putInDatagenArgs(ModBlocks.VERTICAL_STRIPPED_CRIMSON_STEM_SLAB, new DatagenArgs().blockTags(class_3481.field_33713).textureMap(blockAndTopForEnds(class_2246.field_22119)).parentBlock(class_2246.field_22119));
		putInDatagenArgs(ModBlocks.VERTICAL_STRIPPED_CRIMSON_STEM_STAIRS, new DatagenArgs().blockTags(class_3481.field_33713).textureMap(blockAndTopForEnds(class_2246.field_22119)).parentBlock(class_2246.field_22119));
		putInDatagenArgs(ModBlocks.VERTICAL_STRIPPED_CRIMSON_HYPHAE_SLAB, new DatagenArgs().blockTags(class_3481.field_33713).textureMap(class_4944.method_25864(class_2246.field_22119)).parentBlock(class_2246.field_22506));
		putInDatagenArgs(ModBlocks.VERTICAL_STRIPPED_CRIMSON_HYPHAE_STAIRS, new DatagenArgs().blockTags(class_3481.field_33713).textureMap(class_4944.method_25864(class_2246.field_22119)).parentBlock(class_2246.field_22506));
		putInDatagenArgs(ModBlocks.VERTICAL_CRIMSON_STEM_SLAB, new DatagenArgs().blockTags(class_3481.field_33713).textureMap(blockAndTopForEnds(class_2246.field_22118)).parentBlock(class_2246.field_22118));
		putInDatagenArgs(ModBlocks.VERTICAL_CRIMSON_STEM_STAIRS, new DatagenArgs().blockTags(class_3481.field_33713).textureMap(blockAndTopForEnds(class_2246.field_22118)).parentBlock(class_2246.field_22118));
		putInDatagenArgs(ModBlocks.VERTICAL_CRIMSON_HYPHAE_SLAB, new DatagenArgs().blockTags(class_3481.field_33713).textureMap(class_4944.method_25864(class_2246.field_22118)).parentBlock(class_2246.field_22505));
		putInDatagenArgs(ModBlocks.VERTICAL_CRIMSON_HYPHAE_STAIRS, new DatagenArgs().blockTags(class_3481.field_33713).textureMap(class_4944.method_25864(class_2246.field_22118)).parentBlock(class_2246.field_22505));
		putInDatagenArgs(ModBlocks.VERTICAL_WARPED_SLAB, new DatagenArgs().blockTags(class_3481.field_33713).textureMap(class_4944.method_25864(class_2246.field_22127)).parentBlock(class_2246.field_22127));
		putInDatagenArgs(ModBlocks.VERTICAL_WARPED_STAIRS, new DatagenArgs().blockTags(class_3481.field_33713).textureMap(class_4944.method_25864(class_2246.field_22127)).parentBlock(class_2246.field_22127));
		putInDatagenArgs(ModBlocks.VERTICAL_STRIPPED_WARPED_STEM_SLAB, new DatagenArgs().blockTags(class_3481.field_33713).textureMap(blockAndTopForEnds(class_2246.field_22112)).parentBlock(class_2246.field_22112));
		putInDatagenArgs(ModBlocks.VERTICAL_STRIPPED_WARPED_STEM_STAIRS, new DatagenArgs().blockTags(class_3481.field_33713).textureMap(blockAndTopForEnds(class_2246.field_22112)).parentBlock(class_2246.field_22112));
		putInDatagenArgs(ModBlocks.VERTICAL_STRIPPED_WARPED_HYPHAE_SLAB, new DatagenArgs().blockTags(class_3481.field_33713).textureMap(class_4944.method_25864(class_2246.field_22112)).parentBlock(class_2246.field_22504));
		putInDatagenArgs(ModBlocks.VERTICAL_STRIPPED_WARPED_HYPHAE_STAIRS, new DatagenArgs().blockTags(class_3481.field_33713).textureMap(class_4944.method_25864(class_2246.field_22112)).parentBlock(class_2246.field_22504));
		putInDatagenArgs(ModBlocks.VERTICAL_WARPED_STEM_SLAB, new DatagenArgs().blockTags(class_3481.field_33713).textureMap(blockAndTopForEnds(class_2246.field_22111)).parentBlock(class_2246.field_22111));
		putInDatagenArgs(ModBlocks.VERTICAL_WARPED_STEM_STAIRS, new DatagenArgs().blockTags(class_3481.field_33713).textureMap(blockAndTopForEnds(class_2246.field_22111)).parentBlock(class_2246.field_22111));
		putInDatagenArgs(ModBlocks.VERTICAL_WARPED_HYPHAE_SLAB, new DatagenArgs().blockTags(class_3481.field_33713).textureMap(class_4944.method_25864(class_2246.field_22111)).parentBlock(class_2246.field_22503));
		putInDatagenArgs(ModBlocks.VERTICAL_WARPED_HYPHAE_STAIRS, new DatagenArgs().blockTags(class_3481.field_33713).textureMap(class_4944.method_25864(class_2246.field_22111)).parentBlock(class_2246.field_22503));
		putInDatagenArgs(ModBlocks.VERTICAL_STONE_SLAB, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_10340)).parentBlock(class_2246.field_10340).stonecutting());
		putInDatagenArgs(ModBlocks.VERTICAL_STONE_STAIRS, new DatagenArgs().copy(ModBlocks.VERTICAL_STONE_SLAB));
		putInDatagenArgs(ModBlocks.VERTICAL_COBBLESTONE_SLAB, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_10445)).parentBlock(class_2246.field_10445).stonecutting());
		putInDatagenArgs(ModBlocks.VERTICAL_COBBLESTONE_STAIRS, new DatagenArgs().copy(ModBlocks.VERTICAL_COBBLESTONE_SLAB));
		putInDatagenArgs(ModBlocks.VERTICAL_MOSSY_COBBLESTONE_SLAB, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_9989)).parentBlock(class_2246.field_9989).stonecutting());
		putInDatagenArgs(ModBlocks.VERTICAL_MOSSY_COBBLESTONE_STAIRS, new DatagenArgs().copy(ModBlocks.VERTICAL_MOSSY_COBBLESTONE_SLAB));
		putInDatagenArgs(ModBlocks.VERTICAL_SMOOTH_STONE_SLAB, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_10360)).parentBlock(class_2246.field_10360).stonecutting());
		putInDatagenArgs(ModBlocks.VERTICAL_SMOOTH_STONE_STAIRS, new DatagenArgs().copy(ModBlocks.VERTICAL_SMOOTH_STONE_SLAB));
		putInDatagenArgs(ModBlocks.VERTICAL_STONE_BRICKS_SLAB, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_10056)).parentBlock(class_2246.field_10056).stonecutting(class_2246.field_10340));
		putInDatagenArgs(ModBlocks.VERTICAL_STONE_BRICKS_STAIRS, new DatagenArgs().copy(ModBlocks.VERTICAL_STONE_BRICKS_SLAB));
		putInDatagenArgs(ModBlocks.VERTICAL_CRACKED_STONE_BRICKS_SLAB, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_10416)).parentBlock(class_2246.field_10416));
		putInDatagenArgs(ModBlocks.VERTICAL_CRACKED_STONE_BRICKS_STAIRS, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_10416)).parentBlock(class_2246.field_10416));
		putInDatagenArgs(ModBlocks.VERTICAL_CHISELED_STONE_BRICKS_SLAB, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_10552)).parentBlock(class_2246.field_10552).stonecutting(class_2246.field_10340, class_2246.field_10056));
		putInDatagenArgs(ModBlocks.VERTICAL_CHISELED_STONE_BRICKS_STAIRS, new DatagenArgs().copy(ModBlocks.VERTICAL_CHISELED_STONE_BRICKS_SLAB));
		putInDatagenArgs(ModBlocks.VERTICAL_MOSSY_STONE_BRICKS_SLAB, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_10065)).parentBlock(class_2246.field_10065).stonecutting());
		putInDatagenArgs(ModBlocks.VERTICAL_MOSSY_STONE_BRICKS_STAIRS, new DatagenArgs().copy(ModBlocks.VERTICAL_MOSSY_STONE_BRICKS_SLAB));
		putInDatagenArgs(ModBlocks.VERTICAL_GRANITE_SLAB, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_10474)).parentBlock(class_2246.field_10474).stonecutting());
		putInDatagenArgs(ModBlocks.VERTICAL_GRANITE_STAIRS, new DatagenArgs().copy(ModBlocks.VERTICAL_GRANITE_SLAB));
		putInDatagenArgs(ModBlocks.VERTICAL_POLISHED_GRANITE_SLAB, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_10289)).parentBlock(class_2246.field_10289).stonecutting(class_2246.field_10474));
		putInDatagenArgs(ModBlocks.VERTICAL_POLISHED_GRANITE_STAIRS, new DatagenArgs().copy(ModBlocks.VERTICAL_POLISHED_GRANITE_SLAB));
		putInDatagenArgs(ModBlocks.VERTICAL_DIORITE_SLAB, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_10508)).parentBlock(class_2246.field_10508).stonecutting());
		putInDatagenArgs(ModBlocks.VERTICAL_DIORITE_STAIRS, new DatagenArgs().copy(ModBlocks.VERTICAL_DIORITE_SLAB));
		putInDatagenArgs(ModBlocks.VERTICAL_POLISHED_DIORITE_SLAB, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_10346)).parentBlock(class_2246.field_10346).stonecutting(class_2246.field_10508));
		putInDatagenArgs(ModBlocks.VERTICAL_POLISHED_DIORITE_STAIRS, new DatagenArgs().copy(ModBlocks.VERTICAL_POLISHED_DIORITE_SLAB));
		putInDatagenArgs(ModBlocks.VERTICAL_ANDESITE_SLAB, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_10115)).parentBlock(class_2246.field_10115).stonecutting());
		putInDatagenArgs(ModBlocks.VERTICAL_ANDESITE_STAIRS, new DatagenArgs().copy(ModBlocks.VERTICAL_ANDESITE_SLAB));
		putInDatagenArgs(ModBlocks.VERTICAL_POLISHED_ANDESITE_SLAB, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_10093)).parentBlock(class_2246.field_10093).stonecutting(class_2246.field_10115));
		putInDatagenArgs(ModBlocks.VERTICAL_POLISHED_ANDESITE_STAIRS, new DatagenArgs().copy(ModBlocks.VERTICAL_POLISHED_ANDESITE_SLAB));
		putInDatagenArgs(ModBlocks.VERTICAL_DEEPSLATE_SLAB, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(blockAndTopForEnds(class_2246.field_28888)).parentBlock(class_2246.field_28888));
		putInDatagenArgs(ModBlocks.VERTICAL_DEEPSLATE_STAIRS, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(blockAndTopForEnds(class_2246.field_28888)).parentBlock(class_2246.field_28888));
		putInDatagenArgs(ModBlocks.VERTICAL_COBBLED_DEEPSLATE_SLAB, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_29031)).parentBlock(class_2246.field_29031).stonecutting());
		putInDatagenArgs(ModBlocks.VERTICAL_COBBLED_DEEPSLATE_STAIRS, new DatagenArgs().copy(ModBlocks.VERTICAL_COBBLED_DEEPSLATE_SLAB));
		putInDatagenArgs(ModBlocks.VERTICAL_CHISELED_DEEPSLATE_SLAB, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_28904)).parentBlock(class_2246.field_28904).stonecutting(class_2246.field_29031));
		putInDatagenArgs(ModBlocks.VERTICAL_CHISELED_DEEPSLATE_STAIRS, new DatagenArgs().copy(ModBlocks.VERTICAL_CHISELED_DEEPSLATE_SLAB));
		putInDatagenArgs(ModBlocks.VERTICAL_POLISHED_DEEPSLATE_SLAB, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_28892)).parentBlock(class_2246.field_28892).stonecutting());
		putInDatagenArgs(ModBlocks.VERTICAL_POLISHED_DEEPSLATE_STAIRS, new DatagenArgs().copy(ModBlocks.VERTICAL_POLISHED_DEEPSLATE_SLAB));
		putInDatagenArgs(ModBlocks.VERTICAL_DEEPSLATE_BRICKS_SLAB, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_28900)).parentBlock(class_2246.field_28900).stonecutting(class_2246.field_29031, class_2246.field_28892));
		putInDatagenArgs(ModBlocks.VERTICAL_DEEPSLATE_BRICKS_STAIRS, new DatagenArgs().copy(ModBlocks.VERTICAL_DEEPSLATE_BRICKS_SLAB));
		putInDatagenArgs(ModBlocks.VERTICAL_CRACKED_DEEPSLATE_BRICKS_SLAB, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_29222)).parentBlock(class_2246.field_29222).stonecutting());
		putInDatagenArgs(ModBlocks.VERTICAL_CRACKED_DEEPSLATE_BRICKS_STAIRS, new DatagenArgs().copy(ModBlocks.VERTICAL_CRACKED_DEEPSLATE_BRICKS_SLAB));
		putInDatagenArgs(ModBlocks.VERTICAL_DEEPSLATE_TILES_SLAB, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_28896)).parentBlock(class_2246.field_28896).stonecutting(class_2246.field_28892, class_2246.field_28900));
		putInDatagenArgs(ModBlocks.VERTICAL_DEEPSLATE_TILES_STAIRS, new DatagenArgs().copy(ModBlocks.VERTICAL_DEEPSLATE_TILES_SLAB));
		putInDatagenArgs(ModBlocks.VERTICAL_CRACKED_DEEPSLATE_TILES_SLAB, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_29223)).parentBlock(class_2246.field_29223));
		putInDatagenArgs(ModBlocks.VERTICAL_CRACKED_DEEPSLATE_TILES_STAIRS, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_29223)).parentBlock(class_2246.field_29223));
		putInDatagenArgs(ModBlocks.VERTICAL_TUFF_SLAB, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_27165)).parentBlock(class_2246.field_27165).stonecutting());
		putInDatagenArgs(ModBlocks.VERTICAL_TUFF_STAIRS, new DatagenArgs().copy(ModBlocks.VERTICAL_TUFF_SLAB));
		putInDatagenArgs(ModBlocks.VERTICAL_CHISELED_TUFF_SLAB, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(blockAndTopForEnds(class_2246.field_47034)).parentBlock(class_2246.field_47034).stonecutting(class_2246.field_27165));
		putInDatagenArgs(ModBlocks.VERTICAL_CHISELED_TUFF_STAIRS, new DatagenArgs().copy(ModBlocks.VERTICAL_CHISELED_TUFF_SLAB));
		putInDatagenArgs(ModBlocks.VERTICAL_POLISHED_TUFF_SLAB, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_47030)).parentBlock(class_2246.field_47030).stonecutting(class_2246.field_27165));
		putInDatagenArgs(ModBlocks.VERTICAL_POLISHED_TUFF_STAIRS, new DatagenArgs().copy(ModBlocks.VERTICAL_POLISHED_TUFF_SLAB));
		putInDatagenArgs(ModBlocks.VERTICAL_TUFF_BRICKS_SLAB, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_47035)).parentBlock(class_2246.field_47035).stonecutting(class_2246.field_47030, class_2246.field_27165));
		putInDatagenArgs(ModBlocks.VERTICAL_TUFF_BRICKS_STAIRS, new DatagenArgs().copy(ModBlocks.VERTICAL_TUFF_BRICKS_SLAB));
		putInDatagenArgs(ModBlocks.VERTICAL_CHISELED_TUFF_BRICKS_SLAB, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(blockAndTopForEnds(class_2246.field_47039)).parentBlock(class_2246.field_47039).stonecutting(class_2246.field_47030, class_2246.field_47035, class_2246.field_27165));
		putInDatagenArgs(ModBlocks.VERTICAL_CHISELED_TUFF_BRICKS_STAIRS, new DatagenArgs().copy(ModBlocks.VERTICAL_CHISELED_TUFF_BRICKS_SLAB));
		putInDatagenArgs(ModBlocks.VERTICAL_BRICKS_SLAB, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_10104)).parentBlock(class_2246.field_10104).stonecutting());
		putInDatagenArgs(ModBlocks.VERTICAL_BRICKS_STAIRS, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_10104)).parentBlock(class_2246.field_10104).stonecutting());
		putInDatagenArgs(ModBlocks.VERTICAL_PACKED_MUD_SLAB, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_37556)).parentBlock(class_2246.field_37556));
		putInDatagenArgs(ModBlocks.VERTICAL_PACKED_MUD_STAIRS, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_37556)).parentBlock(class_2246.field_37556));
		putInDatagenArgs(ModBlocks.VERTICAL_MUD_BRICKS_SLAB, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_37557)).parentBlock(class_2246.field_37557).stonecutting());
		putInDatagenArgs(ModBlocks.VERTICAL_MUD_BRICKS_STAIRS, new DatagenArgs().copy(ModBlocks.VERTICAL_MUD_BRICKS_SLAB));
		putInDatagenArgs(ModBlocks.VERTICAL_RESIN_BRICKS_SLAB, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_55054)).parentBlock(class_2246.field_55054).stonecutting());
		putInDatagenArgs(ModBlocks.VERTICAL_RESIN_BRICKS_STAIRS, new DatagenArgs().copy(ModBlocks.VERTICAL_RESIN_BRICKS_SLAB));
		putInDatagenArgs(ModBlocks.VERTICAL_CHISELED_RESIN_BRICKS_SLAB, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_55058)).parentBlock(class_2246.field_55058).stonecutting(class_2246.field_55054));
		putInDatagenArgs(ModBlocks.VERTICAL_CHISELED_RESIN_BRICKS_STAIRS, new DatagenArgs().copy(ModBlocks.VERTICAL_CHISELED_RESIN_BRICKS_SLAB));
		putInDatagenArgs(ModBlocks.VERTICAL_SANDSTONE_SLAB, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(blockTB(class_2246.field_9979)).parentBlock(class_2246.field_9979).stonecutting());
		putInDatagenArgs(ModBlocks.VERTICAL_SANDSTONE_STAIRS, new DatagenArgs().copy(ModBlocks.VERTICAL_SANDSTONE_SLAB));
		putInDatagenArgs(ModBlocks.VERTICAL_CHISELED_SANDSTONE_SLAB, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(custom(class_2246.field_10292, class_2246.field_9979, class_2246.field_9979, "", "_top", "_top")).parentBlock(class_2246.field_10292).stonecutting(class_2246.field_9979));
		putInDatagenArgs(ModBlocks.VERTICAL_CHISELED_SANDSTONE_STAIRS, new DatagenArgs().copy(ModBlocks.VERTICAL_CHISELED_SANDSTONE_SLAB));
		putInDatagenArgs(ModBlocks.VERTICAL_SMOOTH_SANDSTONE_SLAB, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(allWithSuffix(class_2246.field_9979, "_top")).parentBlock(class_2246.field_10142).stonecutting());
		putInDatagenArgs(ModBlocks.VERTICAL_SMOOTH_SANDSTONE_STAIRS, new DatagenArgs().copy(ModBlocks.VERTICAL_SMOOTH_SANDSTONE_SLAB));
		putInDatagenArgs(ModBlocks.VERTICAL_CUT_SANDSTONE_SLAB, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(custom(class_2246.field_10361, class_2246.field_9979, class_2246.field_9979, "", "_top", "_top")).parentBlock(class_2246.field_10361).stonecutting());
		putInDatagenArgs(ModBlocks.VERTICAL_CUT_SANDSTONE_STAIRS, new DatagenArgs().copy(ModBlocks.VERTICAL_CUT_SANDSTONE_SLAB));
		putInDatagenArgs(ModBlocks.VERTICAL_RED_SANDSTONE_SLAB, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(blockTB(class_2246.field_10344)).parentBlock(class_2246.field_10344).stonecutting());
		putInDatagenArgs(ModBlocks.VERTICAL_RED_SANDSTONE_STAIRS, new DatagenArgs().copy(ModBlocks.VERTICAL_RED_SANDSTONE_SLAB));
		putInDatagenArgs(ModBlocks.VERTICAL_CHISELED_RED_SANDSTONE_SLAB, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(custom(class_2246.field_10117, class_2246.field_10344, class_2246.field_10344, "", "_top", "_top")).parentBlock(class_2246.field_10117).stonecutting(class_2246.field_10344));
		putInDatagenArgs(ModBlocks.VERTICAL_CHISELED_RED_SANDSTONE_STAIRS, new DatagenArgs().copy(ModBlocks.VERTICAL_CHISELED_RED_SANDSTONE_SLAB));
		putInDatagenArgs(ModBlocks.VERTICAL_SMOOTH_RED_SANDSTONE_SLAB, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(allWithSuffix(class_2246.field_10344, "_top")).parentBlock(class_2246.field_10483).stonecutting());
		putInDatagenArgs(ModBlocks.VERTICAL_SMOOTH_RED_SANDSTONE_STAIRS, new DatagenArgs().copy(ModBlocks.VERTICAL_SMOOTH_RED_SANDSTONE_SLAB));
		putInDatagenArgs(ModBlocks.VERTICAL_CUT_RED_SANDSTONE_SLAB, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(custom(class_2246.field_10518, class_2246.field_10344, class_2246.field_10344, "", "_top", "_top")).parentBlock(class_2246.field_10518).stonecutting());
		putInDatagenArgs(ModBlocks.VERTICAL_CUT_RED_SANDSTONE_STAIRS, new DatagenArgs().copy(ModBlocks.VERTICAL_CUT_RED_SANDSTONE_SLAB));
		putInDatagenArgs(ModBlocks.VERTICAL_SEA_LANTERN_SLAB, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_10174)).parentBlock(class_2246.field_10174));
		putInDatagenArgs(ModBlocks.VERTICAL_SEA_LANTERN_STAIRS, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_10174)).parentBlock(class_2246.field_10174));
		putInDatagenArgs(ModBlocks.VERTICAL_PRISMARINE_SLAB, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_10135)).parentBlock(class_2246.field_10135).stonecutting());
		putInDatagenArgs(ModBlocks.VERTICAL_PRISMARINE_STAIRS, new DatagenArgs().copy(ModBlocks.VERTICAL_PRISMARINE_SLAB));
		putInDatagenArgs(ModBlocks.VERTICAL_PRISMARINE_BRICKS_SLAB, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_10006)).parentBlock(class_2246.field_10006).stonecutting());
		putInDatagenArgs(ModBlocks.VERTICAL_PRISMARINE_BRICKS_STAIRS, new DatagenArgs().copy(ModBlocks.VERTICAL_PRISMARINE_BRICKS_SLAB));
		putInDatagenArgs(ModBlocks.VERTICAL_DARK_PRISMARINE_SLAB, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_10297)).parentBlock(class_2246.field_10297).stonecutting());
		putInDatagenArgs(ModBlocks.VERTICAL_DARK_PRISMARINE_STAIRS, new DatagenArgs().copy(ModBlocks.VERTICAL_DARK_PRISMARINE_SLAB));
		putInDatagenArgs(ModBlocks.VERTICAL_NETHERRACK_SLAB, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_10515)).parentBlock(class_2246.field_10515));
		putInDatagenArgs(ModBlocks.VERTICAL_NETHERRACK_STAIRS, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_10515)).parentBlock(class_2246.field_10515));
		putInDatagenArgs(ModBlocks.VERTICAL_NETHER_BRICKS_SLAB, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_10266)).parentBlock(class_2246.field_10266));
		putInDatagenArgs(ModBlocks.VERTICAL_NETHER_BRICKS_STAIRS, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_10266)).parentBlock(class_2246.field_10266));
		putInDatagenArgs(ModBlocks.VERTICAL_CRACKED_NETHER_BRICKS_SLAB, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_23867)).parentBlock(class_2246.field_23867));
		putInDatagenArgs(ModBlocks.VERTICAL_CRACKED_NETHER_BRICKS_STAIRS, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_23867)).parentBlock(class_2246.field_23867));
		putInDatagenArgs(ModBlocks.VERTICAL_CHISELED_NETHER_BRICKS_SLAB, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_23866)).parentBlock(class_2246.field_23866));
		putInDatagenArgs(ModBlocks.VERTICAL_CHISELED_NETHER_BRICKS_STAIRS, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_23866)).parentBlock(class_2246.field_23866));
		putInDatagenArgs(ModBlocks.VERTICAL_RED_NETHER_BRICKS_SLAB, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_9986)).parentBlock(class_2246.field_9986));
		putInDatagenArgs(ModBlocks.VERTICAL_RED_NETHER_BRICKS_STAIRS, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_9986)).parentBlock(class_2246.field_9986));
		putInDatagenArgs(ModBlocks.VERTICAL_BASALT_SLAB, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(sideAndTopForEnds(class_2246.field_22091)).parentBlock(class_2246.field_22091));
		putInDatagenArgs(ModBlocks.VERTICAL_BASALT_STAIRS, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(sideAndTopForEnds(class_2246.field_22091)).parentBlock(class_2246.field_22091));
		putInDatagenArgs(ModBlocks.VERTICAL_SMOOTH_BASALT_SLAB, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_29032)).parentBlock(class_2246.field_29032));
		putInDatagenArgs(ModBlocks.VERTICAL_SMOOTH_BASALT_STAIRS, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_29032)).parentBlock(class_2246.field_29032));
		putInDatagenArgs(ModBlocks.VERTICAL_POLISHED_BASALT_SLAB, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(sideAndTopForEnds(class_2246.field_23151)).parentBlock(class_2246.field_23151));
		putInDatagenArgs(ModBlocks.VERTICAL_POLISHED_BASALT_STAIRS, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(sideAndTopForEnds(class_2246.field_23151)).parentBlock(class_2246.field_23151));
		putInDatagenArgs(ModBlocks.VERTICAL_BLACKSTONE_SLAB, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(blockAndTopForEnds(class_2246.field_23869)).parentBlock(class_2246.field_23869).stonecutting());
		putInDatagenArgs(ModBlocks.VERTICAL_BLACKSTONE_STAIRS, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(blockAndTopForEnds(class_2246.field_23869)).parentBlock(class_2246.field_23869).stonecutting());
		putInDatagenArgs(ModBlocks.VERTICAL_GILDED_BLACKSTONE_SLAB, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_23880)).parentBlock(class_2246.field_23880));
		putInDatagenArgs(ModBlocks.VERTICAL_GILDED_BLACKSTONE_STAIRS, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_23880)).parentBlock(class_2246.field_23880));
		putInDatagenArgs(ModBlocks.VERTICAL_CHISELED_POLISHED_BLACKSTONE_SLAB, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_23876)).parentBlock(class_2246.field_23876).stonecutting(class_2246.field_23873, class_2246.field_23869));
		putInDatagenArgs(ModBlocks.VERTICAL_CHISELED_POLISHED_BLACKSTONE_STAIRS, new DatagenArgs().copy(ModBlocks.VERTICAL_CHISELED_POLISHED_BLACKSTONE_SLAB));
		putInDatagenArgs(ModBlocks.VERTICAL_POLISHED_BLACKSTONE_SLAB, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_23873)).parentBlock(class_2246.field_23873).stonecutting(class_2246.field_23869));
		putInDatagenArgs(ModBlocks.VERTICAL_POLISHED_BLACKSTONE_STAIRS, new DatagenArgs().copy(ModBlocks.VERTICAL_POLISHED_BLACKSTONE_SLAB));
		putInDatagenArgs(ModBlocks.VERTICAL_POLISHED_BLACKSTONE_BRICKS_SLAB, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_23874)).parentBlock(class_2246.field_23874).stonecutting(class_2246.field_23873));
		putInDatagenArgs(ModBlocks.VERTICAL_POLISHED_BLACKSTONE_BRICKS_STAIRS, new DatagenArgs().copy(ModBlocks.VERTICAL_POLISHED_BLACKSTONE_BRICKS_SLAB));
		putInDatagenArgs(ModBlocks.VERTICAL_CRACKED_POLISHED_BLACKSTONE_BRICKS_SLAB, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_23875)).parentBlock(class_2246.field_23875));
		putInDatagenArgs(ModBlocks.VERTICAL_CRACKED_POLISHED_BLACKSTONE_BRICKS_STAIRS, new DatagenArgs().copy(ModBlocks.VERTICAL_CRACKED_POLISHED_BLACKSTONE_BRICKS_SLAB));
		putInDatagenArgs(ModBlocks.VERTICAL_END_STONE_SLAB, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_10471)).parentBlock(class_2246.field_10471).stonecutting());
		putInDatagenArgs(ModBlocks.VERTICAL_END_STONE_STAIRS, new DatagenArgs().copy(ModBlocks.VERTICAL_END_STONE_SLAB));
		putInDatagenArgs(ModBlocks.VERTICAL_END_STONE_BRICKS_SLAB, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_10462)).parentBlock(class_2246.field_10462).stonecutting(class_2246.field_10471));
		putInDatagenArgs(ModBlocks.VERTICAL_END_STONE_BRICKS_STAIRS, new DatagenArgs().copy(ModBlocks.VERTICAL_END_STONE_BRICKS_SLAB));
		putInDatagenArgs(ModBlocks.VERTICAL_PURPUR_SLAB, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_10286)).parentBlock(class_2246.field_10286));
		putInDatagenArgs(ModBlocks.VERTICAL_PURPUR_STAIRS, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_10286)).parentBlock(class_2246.field_10286));
		putInDatagenArgs(ModBlocks.VERTICAL_PURPUR_PILLAR_SLAB, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(blockAndTopForEnds(class_2246.field_10505)).parentBlock(class_2246.field_10505));
		putInDatagenArgs(ModBlocks.VERTICAL_PURPUR_PILLAR_STAIRS, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(blockAndTopForEnds(class_2246.field_10505)).parentBlock(class_2246.field_10505));
		putInDatagenArgs(ModBlocks.VERTICAL_COAL_SLAB, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_10381)).parentBlock(class_2246.field_10381));
		putInDatagenArgs(ModBlocks.VERTICAL_COAL_STAIRS, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_10381)).parentBlock(class_2246.field_10381));
		putInDatagenArgs(ModBlocks.VERTICAL_IRON_SLAB, new DatagenArgs().blockTags(class_3481.field_33719, class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_10085)).parentBlock(class_2246.field_10085));
		putInDatagenArgs(ModBlocks.VERTICAL_IRON_STAIRS, new DatagenArgs().blockTags(class_3481.field_33719, class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_10085)).parentBlock(class_2246.field_10085));
		putInDatagenArgs(ModBlocks.VERTICAL_GOLD_SLAB, new DatagenArgs().blockTags(class_3481.field_33718, class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_10205)).parentBlock(class_2246.field_10205));
		putInDatagenArgs(ModBlocks.VERTICAL_GOLD_STAIRS, new DatagenArgs().blockTags(class_3481.field_33718, class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_10205)).parentBlock(class_2246.field_10205));
		putInDatagenArgs(ModBlocks.VERTICAL_REDSTONE_SLAB, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_10002)).parentBlock(class_2246.field_10002));
		putInDatagenArgs(ModBlocks.VERTICAL_REDSTONE_STAIRS, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_10002)).parentBlock(class_2246.field_10002));
		putInDatagenArgs(ModBlocks.VERTICAL_EMERALD_SLAB, new DatagenArgs().blockTags(class_3481.field_33718, class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_10234)).parentBlock(class_2246.field_10234));
		putInDatagenArgs(ModBlocks.VERTICAL_EMERALD_STAIRS, new DatagenArgs().blockTags(class_3481.field_33718, class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_10234)).parentBlock(class_2246.field_10234));
		putInDatagenArgs(ModBlocks.VERTICAL_LAPIS_SLAB, new DatagenArgs().blockTags(class_3481.field_33719, class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_10441)).parentBlock(class_2246.field_10441));
		putInDatagenArgs(ModBlocks.VERTICAL_LAPIS_STAIRS, new DatagenArgs().blockTags(class_3481.field_33719, class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_10441)).parentBlock(class_2246.field_10441));
		putInDatagenArgs(ModBlocks.VERTICAL_DIAMOND_SLAB, new DatagenArgs().blockTags(class_3481.field_33718, class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_10201)).parentBlock(class_2246.field_10201));
		putInDatagenArgs(ModBlocks.VERTICAL_DIAMOND_STAIRS, new DatagenArgs().blockTags(class_3481.field_33718, class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_10201)).parentBlock(class_2246.field_10201));
		putInDatagenArgs(ModBlocks.VERTICAL_NETHERITE_SLAB, new DatagenArgs().blockTags(class_3481.field_33717, class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_22108)).parentBlock(class_2246.field_22108));
		putInDatagenArgs(ModBlocks.VERTICAL_NETHERITE_STAIRS, new DatagenArgs().blockTags(class_3481.field_33717, class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_22108)).parentBlock(class_2246.field_22108));
		putInDatagenArgs(ModBlocks.VERTICAL_QUARTZ_SLAB, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(blockSTB(class_2246.field_10153)).parentBlock(class_2246.field_10153).stonecutting());
		putInDatagenArgs(ModBlocks.VERTICAL_QUARTZ_STAIRS, new DatagenArgs().copy(ModBlocks.VERTICAL_QUARTZ_SLAB));
		putInDatagenArgs(ModBlocks.VERTICAL_CHISELED_QUARTZ_SLAB, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(blockAndTopForEnds(class_2246.field_10044)).parentBlock(class_2246.field_10044).stonecutting(class_2246.field_10153));
		putInDatagenArgs(ModBlocks.VERTICAL_CHISELED_QUARTZ_STAIRS, new DatagenArgs().copy(ModBlocks.VERTICAL_CHISELED_QUARTZ_SLAB));
		putInDatagenArgs(ModBlocks.VERTICAL_QUARTZ_BRICKS_SLAB, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_23868)).parentBlock(class_2246.field_23868).stonecutting(class_2246.field_10153));
		putInDatagenArgs(ModBlocks.VERTICAL_QUARTZ_BRICKS_STAIRS, new DatagenArgs().copy(ModBlocks.VERTICAL_QUARTZ_BRICKS_SLAB));
		putInDatagenArgs(ModBlocks.VERTICAL_QUARTZ_PILLAR_SLAB, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(blockAndTopForEnds(class_2246.field_10437)).parentBlock(class_2246.field_10437).stonecutting(class_2246.field_10153));
		putInDatagenArgs(ModBlocks.VERTICAL_QUARTZ_PILLAR_STAIRS, new DatagenArgs().copy(ModBlocks.VERTICAL_QUARTZ_PILLAR_SLAB));
		putInDatagenArgs(ModBlocks.VERTICAL_SMOOTH_QUARTZ_SLAB, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(allWithSuffix(class_2246.field_10153, "_bottom")).parentBlock(class_2246.field_9978).stonecutting());
		putInDatagenArgs(ModBlocks.VERTICAL_SMOOTH_QUARTZ_STAIRS, new DatagenArgs().copy(ModBlocks.VERTICAL_SMOOTH_QUARTZ_SLAB));
		putInDatagenArgs(ModBlocks.VERTICAL_AMETHYST_SLAB, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_27159)).parentBlock(class_2246.field_27159));
		putInDatagenArgs(ModBlocks.VERTICAL_AMETHYST_STAIRS, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_27159)).parentBlock(class_2246.field_27159));
		putInDatagenArgs(ModBlocks.VERTICAL_WAXED_COPPER_SLAB, new DatagenArgs().blockTags(class_3481.field_33719, class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_27119)).parentBlock(class_2246.field_27133, class_2246.field_27119).stonecutting());
		putInDatagenArgs(ModBlocks.VERTICAL_WAXED_COPPER_STAIRS, new DatagenArgs().copy(ModBlocks.VERTICAL_WAXED_COPPER_SLAB));
		putInDatagenArgs(ModBlocks.VERTICAL_WAXED_EXPOSED_COPPER_SLAB, new DatagenArgs().blockTags(class_3481.field_33719, class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_27118)).parentBlock(class_2246.field_27135, class_2246.field_27118).stonecutting());
		putInDatagenArgs(ModBlocks.VERTICAL_WAXED_EXPOSED_COPPER_STAIRS, new DatagenArgs().copy(ModBlocks.VERTICAL_WAXED_EXPOSED_COPPER_SLAB));
		putInDatagenArgs(ModBlocks.VERTICAL_WAXED_WEATHERED_COPPER_SLAB, new DatagenArgs().blockTags(class_3481.field_33719, class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_27117)).parentBlock(class_2246.field_27134, class_2246.field_27117).stonecutting());
		putInDatagenArgs(ModBlocks.VERTICAL_WAXED_WEATHERED_COPPER_STAIRS, new DatagenArgs().copy(ModBlocks.VERTICAL_WAXED_WEATHERED_COPPER_SLAB));
		putInDatagenArgs(ModBlocks.VERTICAL_WAXED_OXIDIZED_COPPER_SLAB, new DatagenArgs().blockTags(class_3481.field_33719, class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_27116)).parentBlock(class_2246.field_33407, class_2246.field_27116).stonecutting());
		putInDatagenArgs(ModBlocks.VERTICAL_WAXED_OXIDIZED_COPPER_STAIRS, new DatagenArgs().copy(ModBlocks.VERTICAL_WAXED_OXIDIZED_COPPER_SLAB));
		putInDatagenArgs(ModBlocks.VERTICAL_WAXED_CHISELED_COPPER_SLAB, new DatagenArgs().blockTags(class_3481.field_33719, class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_47057)).parentBlock(class_2246.field_47061, class_2246.field_47057).stonecutting(class_2246.field_27133));
		putInDatagenArgs(ModBlocks.VERTICAL_WAXED_CHISELED_COPPER_STAIRS, new DatagenArgs().copy(ModBlocks.VERTICAL_WAXED_CHISELED_COPPER_SLAB));
		putInDatagenArgs(ModBlocks.VERTICAL_WAXED_EXPOSED_CHISELED_COPPER_SLAB, new DatagenArgs().blockTags(class_3481.field_33719, class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_47056)).parentBlock(class_2246.field_47060, class_2246.field_47056).stonecutting(class_2246.field_27135));
		putInDatagenArgs(ModBlocks.VERTICAL_WAXED_EXPOSED_CHISELED_COPPER_STAIRS, new DatagenArgs().copy(ModBlocks.VERTICAL_WAXED_EXPOSED_CHISELED_COPPER_SLAB));
		putInDatagenArgs(ModBlocks.VERTICAL_WAXED_WEATHERED_CHISELED_COPPER_SLAB, new DatagenArgs().blockTags(class_3481.field_33719, class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_47055)).parentBlock(class_2246.field_47059, class_2246.field_47055).stonecutting(class_2246.field_27134));
		putInDatagenArgs(ModBlocks.VERTICAL_WAXED_WEATHERED_CHISELED_COPPER_STAIRS, new DatagenArgs().copy(ModBlocks.VERTICAL_WAXED_WEATHERED_CHISELED_COPPER_SLAB));
		putInDatagenArgs(ModBlocks.VERTICAL_WAXED_OXIDIZED_CHISELED_COPPER_SLAB, new DatagenArgs().blockTags(class_3481.field_33719, class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_47054)).parentBlock(class_2246.field_47058, class_2246.field_47054).stonecutting(class_2246.field_33407));
		putInDatagenArgs(ModBlocks.VERTICAL_WAXED_OXIDIZED_CHISELED_COPPER_STAIRS, new DatagenArgs().copy(ModBlocks.VERTICAL_WAXED_OXIDIZED_CHISELED_COPPER_SLAB));
		putInDatagenArgs(ModBlocks.VERTICAL_WAXED_COPPER_GRATE_SLAB, new DatagenArgs().blockTags(class_3481.field_33719, class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_47064)).parentBlock(class_2246.field_47068, class_2246.field_47064).stonecutting(class_2246.field_27133));
		putInDatagenArgs(ModBlocks.VERTICAL_WAXED_COPPER_GRATE_STAIRS, new DatagenArgs().copy(ModBlocks.VERTICAL_WAXED_COPPER_GRATE_SLAB));
		putInDatagenArgs(ModBlocks.VERTICAL_WAXED_EXPOSED_COPPER_GRATE_SLAB, new DatagenArgs().blockTags(class_3481.field_33719, class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_47065)).parentBlock(class_2246.field_47069, class_2246.field_47065).stonecutting(class_2246.field_27135));
		putInDatagenArgs(ModBlocks.VERTICAL_WAXED_EXPOSED_COPPER_GRATE_STAIRS, new DatagenArgs().copy(ModBlocks.VERTICAL_WAXED_EXPOSED_COPPER_GRATE_SLAB));
		putInDatagenArgs(ModBlocks.VERTICAL_WAXED_WEATHERED_COPPER_GRATE_SLAB, new DatagenArgs().blockTags(class_3481.field_33719, class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_47066)).parentBlock(class_2246.field_47070, class_2246.field_47066).stonecutting(class_2246.field_27134));
		putInDatagenArgs(ModBlocks.VERTICAL_WAXED_WEATHERED_COPPER_GRATE_STAIRS, new DatagenArgs().copy(ModBlocks.VERTICAL_WAXED_WEATHERED_COPPER_GRATE_SLAB));
		putInDatagenArgs(ModBlocks.VERTICAL_WAXED_OXIDIZED_COPPER_GRATE_SLAB, new DatagenArgs().blockTags(class_3481.field_33719, class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_47067)).parentBlock(class_2246.field_47071, class_2246.field_47067).stonecutting(class_2246.field_33407));
		putInDatagenArgs(ModBlocks.VERTICAL_WAXED_OXIDIZED_COPPER_GRATE_STAIRS, new DatagenArgs().copy(ModBlocks.VERTICAL_WAXED_OXIDIZED_COPPER_GRATE_SLAB));
		putInDatagenArgs(ModBlocks.VERTICAL_WAXED_CUT_COPPER_SLAB, new DatagenArgs().blockTags(class_3481.field_33719, class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_27124)).parentBlock(class_2246.field_27138, class_2246.field_27124).stonecutting(class_2246.field_27133));
		putInDatagenArgs(ModBlocks.VERTICAL_WAXED_CUT_COPPER_STAIRS, new DatagenArgs().copy(ModBlocks.VERTICAL_WAXED_CUT_COPPER_SLAB));
		putInDatagenArgs(ModBlocks.VERTICAL_WAXED_EXPOSED_CUT_COPPER_SLAB, new DatagenArgs().blockTags(class_3481.field_33719, class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_27123)).parentBlock(class_2246.field_27137, class_2246.field_27123).stonecutting(class_2246.field_27135));
		putInDatagenArgs(ModBlocks.VERTICAL_WAXED_EXPOSED_CUT_COPPER_STAIRS, new DatagenArgs().copy(ModBlocks.VERTICAL_WAXED_EXPOSED_CUT_COPPER_SLAB));
		putInDatagenArgs(ModBlocks.VERTICAL_WAXED_WEATHERED_CUT_COPPER_SLAB, new DatagenArgs().blockTags(class_3481.field_33719, class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_27122)).parentBlock(class_2246.field_27136, class_2246.field_27122).stonecutting(class_2246.field_27134));
		putInDatagenArgs(ModBlocks.VERTICAL_WAXED_WEATHERED_CUT_COPPER_STAIRS, new DatagenArgs().copy(ModBlocks.VERTICAL_WAXED_WEATHERED_CUT_COPPER_SLAB));
		putInDatagenArgs(ModBlocks.VERTICAL_WAXED_OXIDIZED_CUT_COPPER_SLAB, new DatagenArgs().blockTags(class_3481.field_33719, class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_27121)).parentBlock(class_2246.field_33408, class_2246.field_27121).stonecutting(class_2246.field_33407));
		putInDatagenArgs(ModBlocks.VERTICAL_WAXED_OXIDIZED_CUT_COPPER_STAIRS, new DatagenArgs().copy(ModBlocks.VERTICAL_WAXED_OXIDIZED_CUT_COPPER_SLAB));
		putInDatagenArgs(ModBlocks.VERTICAL_EXPOSED_COPPER_SLAB, new DatagenArgs().blockTags(class_3481.field_33719, class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_27118)).parentBlock(class_2246.field_27118).stonecutting());
		putInDatagenArgs(ModBlocks.VERTICAL_EXPOSED_COPPER_STAIRS, new DatagenArgs().copy(ModBlocks.VERTICAL_EXPOSED_COPPER_SLAB));
		putInDatagenArgs(ModBlocks.VERTICAL_WEATHERED_COPPER_SLAB, new DatagenArgs().blockTags(class_3481.field_33719, class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_27117)).parentBlock(class_2246.field_27117).stonecutting());
		putInDatagenArgs(ModBlocks.VERTICAL_WEATHERED_COPPER_STAIRS, new DatagenArgs().copy(ModBlocks.VERTICAL_WEATHERED_COPPER_SLAB));
		putInDatagenArgs(ModBlocks.VERTICAL_OXIDIZED_COPPER_SLAB, new DatagenArgs().blockTags(class_3481.field_33719, class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_27116)).parentBlock(class_2246.field_27116).stonecutting());
		putInDatagenArgs(ModBlocks.VERTICAL_OXIDIZED_COPPER_STAIRS, new DatagenArgs().copy(ModBlocks.VERTICAL_OXIDIZED_COPPER_SLAB));
		putInDatagenArgs(ModBlocks.VERTICAL_COPPER_SLAB, new DatagenArgs().blockTags(class_3481.field_33719, class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_27119)).parentBlock(class_2246.field_27119).stonecutting());
		putInDatagenArgs(ModBlocks.VERTICAL_COPPER_STAIRS, new DatagenArgs().copy(ModBlocks.VERTICAL_COPPER_SLAB));
		putInDatagenArgs(ModBlocks.VERTICAL_EXPOSED_CHISELED_COPPER_SLAB, new DatagenArgs().blockTags(class_3481.field_33719, class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_47056)).parentBlock(class_2246.field_47056).stonecutting(class_2246.field_27118));
		putInDatagenArgs(ModBlocks.VERTICAL_EXPOSED_CHISELED_COPPER_STAIRS, new DatagenArgs().copy(ModBlocks.VERTICAL_EXPOSED_CHISELED_COPPER_SLAB));
		putInDatagenArgs(ModBlocks.VERTICAL_WEATHERED_CHISELED_COPPER_SLAB, new DatagenArgs().blockTags(class_3481.field_33719, class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_47055)).parentBlock(class_2246.field_47055).stonecutting(class_2246.field_27117));
		putInDatagenArgs(ModBlocks.VERTICAL_WEATHERED_CHISELED_COPPER_STAIRS, new DatagenArgs().copy(ModBlocks.VERTICAL_WEATHERED_CHISELED_COPPER_SLAB));
		putInDatagenArgs(ModBlocks.VERTICAL_OXIDIZED_CHISELED_COPPER_SLAB, new DatagenArgs().blockTags(class_3481.field_33719, class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_47054)).parentBlock(class_2246.field_47054).stonecutting(class_2246.field_27116));
		putInDatagenArgs(ModBlocks.VERTICAL_OXIDIZED_CHISELED_COPPER_STAIRS, new DatagenArgs().copy(ModBlocks.VERTICAL_OXIDIZED_CHISELED_COPPER_SLAB));
		putInDatagenArgs(ModBlocks.VERTICAL_CHISELED_COPPER_SLAB, new DatagenArgs().blockTags(class_3481.field_33719, class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_47057)).parentBlock(class_2246.field_47057).stonecutting(class_2246.field_27119));
		putInDatagenArgs(ModBlocks.VERTICAL_CHISELED_COPPER_STAIRS, new DatagenArgs().copy(ModBlocks.VERTICAL_CHISELED_COPPER_SLAB));
		putInDatagenArgs(ModBlocks.VERTICAL_EXPOSED_COPPER_GRATE_SLAB, new DatagenArgs().blockTags(class_3481.field_33719, class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_47065)).parentBlock(class_2246.field_47065).stonecutting(class_2246.field_27118));
		putInDatagenArgs(ModBlocks.VERTICAL_EXPOSED_COPPER_GRATE_STAIRS, new DatagenArgs().copy(ModBlocks.VERTICAL_EXPOSED_COPPER_GRATE_SLAB));
		putInDatagenArgs(ModBlocks.VERTICAL_WEATHERED_COPPER_GRATE_SLAB, new DatagenArgs().blockTags(class_3481.field_33719, class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_47066)).parentBlock(class_2246.field_47066).stonecutting(class_2246.field_27117));
		putInDatagenArgs(ModBlocks.VERTICAL_WEATHERED_COPPER_GRATE_STAIRS, new DatagenArgs().copy(ModBlocks.VERTICAL_WEATHERED_COPPER_GRATE_SLAB));
		putInDatagenArgs(ModBlocks.VERTICAL_OXIDIZED_COPPER_GRATE_SLAB, new DatagenArgs().blockTags(class_3481.field_33719, class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_47067)).parentBlock(class_2246.field_47067).stonecutting(class_2246.field_27116));
		putInDatagenArgs(ModBlocks.VERTICAL_OXIDIZED_COPPER_GRATE_STAIRS, new DatagenArgs().copy(ModBlocks.VERTICAL_OXIDIZED_COPPER_GRATE_SLAB));
		putInDatagenArgs(ModBlocks.VERTICAL_COPPER_GRATE_SLAB, new DatagenArgs().blockTags(class_3481.field_33719, class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_47064)).parentBlock(class_2246.field_47064).stonecutting(class_2246.field_27119));
		putInDatagenArgs(ModBlocks.VERTICAL_COPPER_GRATE_STAIRS, new DatagenArgs().copy(ModBlocks.VERTICAL_COPPER_GRATE_SLAB));
		putInDatagenArgs(ModBlocks.VERTICAL_EXPOSED_CUT_COPPER_SLAB, new DatagenArgs().blockTags(class_3481.field_33719, class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_27123)).parentBlock(class_2246.field_27123).stonecutting(class_2246.field_27118));
		putInDatagenArgs(ModBlocks.VERTICAL_EXPOSED_CUT_COPPER_STAIRS, new DatagenArgs().copy(ModBlocks.VERTICAL_EXPOSED_CUT_COPPER_SLAB));
		putInDatagenArgs(ModBlocks.VERTICAL_WEATHERED_CUT_COPPER_SLAB, new DatagenArgs().blockTags(class_3481.field_33719, class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_27122)).parentBlock(class_2246.field_27122).stonecutting(class_2246.field_27117));
		putInDatagenArgs(ModBlocks.VERTICAL_WEATHERED_CUT_COPPER_STAIRS, new DatagenArgs().copy(ModBlocks.VERTICAL_WEATHERED_CUT_COPPER_SLAB));
		putInDatagenArgs(ModBlocks.VERTICAL_OXIDIZED_CUT_COPPER_SLAB, new DatagenArgs().blockTags(class_3481.field_33719, class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_27121)).parentBlock(class_2246.field_27121).stonecutting(class_2246.field_27116));
		putInDatagenArgs(ModBlocks.VERTICAL_OXIDIZED_CUT_COPPER_STAIRS, new DatagenArgs().copy(ModBlocks.VERTICAL_OXIDIZED_CUT_COPPER_SLAB));
		putInDatagenArgs(ModBlocks.VERTICAL_CUT_COPPER_SLAB, new DatagenArgs().blockTags(class_3481.field_33719, class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_27124)).parentBlock(class_2246.field_27124).stonecutting(class_2246.field_27119));
		putInDatagenArgs(ModBlocks.VERTICAL_CUT_COPPER_STAIRS, new DatagenArgs().copy(ModBlocks.VERTICAL_CUT_COPPER_SLAB));
		putInDatagenArgs(ModBlocks.VERTICAL_WHITE_WOOL_SLAB, new DatagenArgs().blockTags().textureMap(class_4944.method_25864(class_2246.field_10446)).parentBlock(class_2246.field_10446));
		putInDatagenArgs(ModBlocks.VERTICAL_WHITE_WOOL_STAIRS, new DatagenArgs().blockTags().textureMap(class_4944.method_25864(class_2246.field_10446)).parentBlock(class_2246.field_10446));
		putInDatagenArgs(ModBlocks.VERTICAL_LIGHT_GRAY_WOOL_SLAB, new DatagenArgs().blockTags().textureMap(class_4944.method_25864(class_2246.field_10222)).parentBlock(class_2246.field_10222));
		putInDatagenArgs(ModBlocks.VERTICAL_LIGHT_GRAY_WOOL_STAIRS, new DatagenArgs().blockTags().textureMap(class_4944.method_25864(class_2246.field_10222)).parentBlock(class_2246.field_10222));
		putInDatagenArgs(ModBlocks.VERTICAL_GRAY_WOOL_SLAB, new DatagenArgs().blockTags().textureMap(class_4944.method_25864(class_2246.field_10423)).parentBlock(class_2246.field_10423));
		putInDatagenArgs(ModBlocks.VERTICAL_GRAY_WOOL_STAIRS, new DatagenArgs().blockTags().textureMap(class_4944.method_25864(class_2246.field_10423)).parentBlock(class_2246.field_10423));
		putInDatagenArgs(ModBlocks.VERTICAL_BLACK_WOOL_SLAB, new DatagenArgs().blockTags().textureMap(class_4944.method_25864(class_2246.field_10146)).parentBlock(class_2246.field_10146));
		putInDatagenArgs(ModBlocks.VERTICAL_BLACK_WOOL_STAIRS, new DatagenArgs().blockTags().textureMap(class_4944.method_25864(class_2246.field_10146)).parentBlock(class_2246.field_10146));
		putInDatagenArgs(ModBlocks.VERTICAL_BROWN_WOOL_SLAB, new DatagenArgs().blockTags().textureMap(class_4944.method_25864(class_2246.field_10113)).parentBlock(class_2246.field_10113));
		putInDatagenArgs(ModBlocks.VERTICAL_BROWN_WOOL_STAIRS, new DatagenArgs().blockTags().textureMap(class_4944.method_25864(class_2246.field_10113)).parentBlock(class_2246.field_10113));
		putInDatagenArgs(ModBlocks.VERTICAL_RED_WOOL_SLAB, new DatagenArgs().blockTags().textureMap(class_4944.method_25864(class_2246.field_10314)).parentBlock(class_2246.field_10314));
		putInDatagenArgs(ModBlocks.VERTICAL_RED_WOOL_STAIRS, new DatagenArgs().blockTags().textureMap(class_4944.method_25864(class_2246.field_10314)).parentBlock(class_2246.field_10314));
		putInDatagenArgs(ModBlocks.VERTICAL_ORANGE_WOOL_SLAB, new DatagenArgs().blockTags().textureMap(class_4944.method_25864(class_2246.field_10095)).parentBlock(class_2246.field_10095));
		putInDatagenArgs(ModBlocks.VERTICAL_ORANGE_WOOL_STAIRS, new DatagenArgs().blockTags().textureMap(class_4944.method_25864(class_2246.field_10095)).parentBlock(class_2246.field_10095));
		putInDatagenArgs(ModBlocks.VERTICAL_YELLOW_WOOL_SLAB, new DatagenArgs().blockTags().textureMap(class_4944.method_25864(class_2246.field_10490)).parentBlock(class_2246.field_10490));
		putInDatagenArgs(ModBlocks.VERTICAL_YELLOW_WOOL_STAIRS, new DatagenArgs().blockTags().textureMap(class_4944.method_25864(class_2246.field_10490)).parentBlock(class_2246.field_10490));
		putInDatagenArgs(ModBlocks.VERTICAL_LIME_WOOL_SLAB, new DatagenArgs().blockTags().textureMap(class_4944.method_25864(class_2246.field_10028)).parentBlock(class_2246.field_10028));
		putInDatagenArgs(ModBlocks.VERTICAL_LIME_WOOL_STAIRS, new DatagenArgs().blockTags().textureMap(class_4944.method_25864(class_2246.field_10028)).parentBlock(class_2246.field_10028));
		putInDatagenArgs(ModBlocks.VERTICAL_GREEN_WOOL_SLAB, new DatagenArgs().blockTags().textureMap(class_4944.method_25864(class_2246.field_10170)).parentBlock(class_2246.field_10170));
		putInDatagenArgs(ModBlocks.VERTICAL_GREEN_WOOL_STAIRS, new DatagenArgs().blockTags().textureMap(class_4944.method_25864(class_2246.field_10170)).parentBlock(class_2246.field_10170));
		putInDatagenArgs(ModBlocks.VERTICAL_CYAN_WOOL_SLAB, new DatagenArgs().blockTags().textureMap(class_4944.method_25864(class_2246.field_10619)).parentBlock(class_2246.field_10619));
		putInDatagenArgs(ModBlocks.VERTICAL_CYAN_WOOL_STAIRS, new DatagenArgs().blockTags().textureMap(class_4944.method_25864(class_2246.field_10619)).parentBlock(class_2246.field_10619));
		putInDatagenArgs(ModBlocks.VERTICAL_LIGHT_BLUE_WOOL_SLAB, new DatagenArgs().blockTags().textureMap(class_4944.method_25864(class_2246.field_10294)).parentBlock(class_2246.field_10294));
		putInDatagenArgs(ModBlocks.VERTICAL_LIGHT_BLUE_WOOL_STAIRS, new DatagenArgs().blockTags().textureMap(class_4944.method_25864(class_2246.field_10294)).parentBlock(class_2246.field_10294));
		putInDatagenArgs(ModBlocks.VERTICAL_BLUE_WOOL_SLAB, new DatagenArgs().blockTags().textureMap(class_4944.method_25864(class_2246.field_10514)).parentBlock(class_2246.field_10514));
		putInDatagenArgs(ModBlocks.VERTICAL_BLUE_WOOL_STAIRS, new DatagenArgs().blockTags().textureMap(class_4944.method_25864(class_2246.field_10514)).parentBlock(class_2246.field_10514));
		putInDatagenArgs(ModBlocks.VERTICAL_PURPLE_WOOL_SLAB, new DatagenArgs().blockTags().textureMap(class_4944.method_25864(class_2246.field_10259)).parentBlock(class_2246.field_10259));
		putInDatagenArgs(ModBlocks.VERTICAL_PURPLE_WOOL_STAIRS, new DatagenArgs().blockTags().textureMap(class_4944.method_25864(class_2246.field_10259)).parentBlock(class_2246.field_10259));
		putInDatagenArgs(ModBlocks.VERTICAL_MAGENTA_WOOL_SLAB, new DatagenArgs().blockTags().textureMap(class_4944.method_25864(class_2246.field_10215)).parentBlock(class_2246.field_10215));
		putInDatagenArgs(ModBlocks.VERTICAL_MAGENTA_WOOL_STAIRS, new DatagenArgs().blockTags().textureMap(class_4944.method_25864(class_2246.field_10215)).parentBlock(class_2246.field_10215));
		putInDatagenArgs(ModBlocks.VERTICAL_PINK_WOOL_SLAB, new DatagenArgs().blockTags().textureMap(class_4944.method_25864(class_2246.field_10459)).parentBlock(class_2246.field_10459));
		putInDatagenArgs(ModBlocks.VERTICAL_PINK_WOOL_STAIRS, new DatagenArgs().blockTags().textureMap(class_4944.method_25864(class_2246.field_10459)).parentBlock(class_2246.field_10459));
		putInDatagenArgs(ModBlocks.VERTICAL_TERRACOTTA_SLAB, new DatagenArgs().blockTags(class_3481.field_33715, class_3481.field_36265).textureMap(class_4944.method_25864(class_2246.field_10415)).parentBlock(class_2246.field_10415));
		putInDatagenArgs(ModBlocks.VERTICAL_TERRACOTTA_STAIRS, new DatagenArgs().blockTags(class_3481.field_33715, class_3481.field_36265).textureMap(class_4944.method_25864(class_2246.field_10415)).parentBlock(class_2246.field_10415));
		putInDatagenArgs(ModBlocks.VERTICAL_WHITE_TERRACOTTA_SLAB, new DatagenArgs().blockTags(class_3481.field_33715, class_3481.field_36265).textureMap(class_4944.method_25864(class_2246.field_10611)).parentBlock(class_2246.field_10611));
		putInDatagenArgs(ModBlocks.VERTICAL_WHITE_TERRACOTTA_STAIRS, new DatagenArgs().blockTags(class_3481.field_33715, class_3481.field_36265).textureMap(class_4944.method_25864(class_2246.field_10611)).parentBlock(class_2246.field_10611));
		putInDatagenArgs(ModBlocks.VERTICAL_LIGHT_GRAY_TERRACOTTA_SLAB, new DatagenArgs().blockTags(class_3481.field_33715, class_3481.field_36265).textureMap(class_4944.method_25864(class_2246.field_10590)).parentBlock(class_2246.field_10590));
		putInDatagenArgs(ModBlocks.VERTICAL_LIGHT_GRAY_TERRACOTTA_STAIRS, new DatagenArgs().blockTags(class_3481.field_33715, class_3481.field_36265).textureMap(class_4944.method_25864(class_2246.field_10590)).parentBlock(class_2246.field_10590));
		putInDatagenArgs(ModBlocks.VERTICAL_GRAY_TERRACOTTA_SLAB, new DatagenArgs().blockTags(class_3481.field_33715, class_3481.field_36265).textureMap(class_4944.method_25864(class_2246.field_10349)).parentBlock(class_2246.field_10349));
		putInDatagenArgs(ModBlocks.VERTICAL_GRAY_TERRACOTTA_STAIRS, new DatagenArgs().blockTags(class_3481.field_33715, class_3481.field_36265).textureMap(class_4944.method_25864(class_2246.field_10349)).parentBlock(class_2246.field_10349));
		putInDatagenArgs(ModBlocks.VERTICAL_BLACK_TERRACOTTA_SLAB, new DatagenArgs().blockTags(class_3481.field_33715, class_3481.field_36265).textureMap(class_4944.method_25864(class_2246.field_10626)).parentBlock(class_2246.field_10626));
		putInDatagenArgs(ModBlocks.VERTICAL_BLACK_TERRACOTTA_STAIRS, new DatagenArgs().blockTags(class_3481.field_33715, class_3481.field_36265).textureMap(class_4944.method_25864(class_2246.field_10626)).parentBlock(class_2246.field_10626));
		putInDatagenArgs(ModBlocks.VERTICAL_BROWN_TERRACOTTA_SLAB, new DatagenArgs().blockTags(class_3481.field_33715, class_3481.field_36265).textureMap(class_4944.method_25864(class_2246.field_10123)).parentBlock(class_2246.field_10123));
		putInDatagenArgs(ModBlocks.VERTICAL_BROWN_TERRACOTTA_STAIRS, new DatagenArgs().blockTags(class_3481.field_33715, class_3481.field_36265).textureMap(class_4944.method_25864(class_2246.field_10123)).parentBlock(class_2246.field_10123));
		putInDatagenArgs(ModBlocks.VERTICAL_RED_TERRACOTTA_SLAB, new DatagenArgs().blockTags(class_3481.field_33715, class_3481.field_36265).textureMap(class_4944.method_25864(class_2246.field_10328)).parentBlock(class_2246.field_10328));
		putInDatagenArgs(ModBlocks.VERTICAL_RED_TERRACOTTA_STAIRS, new DatagenArgs().blockTags(class_3481.field_33715, class_3481.field_36265).textureMap(class_4944.method_25864(class_2246.field_10328)).parentBlock(class_2246.field_10328));
		putInDatagenArgs(ModBlocks.VERTICAL_ORANGE_TERRACOTTA_SLAB, new DatagenArgs().blockTags(class_3481.field_33715, class_3481.field_36265).textureMap(class_4944.method_25864(class_2246.field_10184)).parentBlock(class_2246.field_10184));
		putInDatagenArgs(ModBlocks.VERTICAL_ORANGE_TERRACOTTA_STAIRS, new DatagenArgs().blockTags(class_3481.field_33715, class_3481.field_36265).textureMap(class_4944.method_25864(class_2246.field_10184)).parentBlock(class_2246.field_10184));
		putInDatagenArgs(ModBlocks.VERTICAL_YELLOW_TERRACOTTA_SLAB, new DatagenArgs().blockTags(class_3481.field_33715, class_3481.field_36265).textureMap(class_4944.method_25864(class_2246.field_10143)).parentBlock(class_2246.field_10143));
		putInDatagenArgs(ModBlocks.VERTICAL_YELLOW_TERRACOTTA_STAIRS, new DatagenArgs().blockTags(class_3481.field_33715, class_3481.field_36265).textureMap(class_4944.method_25864(class_2246.field_10143)).parentBlock(class_2246.field_10143));
		putInDatagenArgs(ModBlocks.VERTICAL_LIME_TERRACOTTA_SLAB, new DatagenArgs().blockTags(class_3481.field_33715, class_3481.field_36265).textureMap(class_4944.method_25864(class_2246.field_10014)).parentBlock(class_2246.field_10014));
		putInDatagenArgs(ModBlocks.VERTICAL_LIME_TERRACOTTA_STAIRS, new DatagenArgs().blockTags(class_3481.field_33715, class_3481.field_36265).textureMap(class_4944.method_25864(class_2246.field_10014)).parentBlock(class_2246.field_10014));
		putInDatagenArgs(ModBlocks.VERTICAL_GREEN_TERRACOTTA_SLAB, new DatagenArgs().blockTags(class_3481.field_33715, class_3481.field_36265).textureMap(class_4944.method_25864(class_2246.field_10526)).parentBlock(class_2246.field_10526));
		putInDatagenArgs(ModBlocks.VERTICAL_GREEN_TERRACOTTA_STAIRS, new DatagenArgs().blockTags(class_3481.field_33715, class_3481.field_36265).textureMap(class_4944.method_25864(class_2246.field_10526)).parentBlock(class_2246.field_10526));
		putInDatagenArgs(ModBlocks.VERTICAL_CYAN_TERRACOTTA_SLAB, new DatagenArgs().blockTags(class_3481.field_33715, class_3481.field_36265).textureMap(class_4944.method_25864(class_2246.field_10235)).parentBlock(class_2246.field_10235));
		putInDatagenArgs(ModBlocks.VERTICAL_CYAN_TERRACOTTA_STAIRS, new DatagenArgs().blockTags(class_3481.field_33715, class_3481.field_36265).textureMap(class_4944.method_25864(class_2246.field_10235)).parentBlock(class_2246.field_10235));
		putInDatagenArgs(ModBlocks.VERTICAL_LIGHT_BLUE_TERRACOTTA_SLAB, new DatagenArgs().blockTags(class_3481.field_33715, class_3481.field_36265).textureMap(class_4944.method_25864(class_2246.field_10325)).parentBlock(class_2246.field_10325));
		putInDatagenArgs(ModBlocks.VERTICAL_LIGHT_BLUE_TERRACOTTA_STAIRS, new DatagenArgs().blockTags(class_3481.field_33715, class_3481.field_36265).textureMap(class_4944.method_25864(class_2246.field_10325)).parentBlock(class_2246.field_10325));
		putInDatagenArgs(ModBlocks.VERTICAL_BLUE_TERRACOTTA_SLAB, new DatagenArgs().blockTags(class_3481.field_33715, class_3481.field_36265).textureMap(class_4944.method_25864(class_2246.field_10409)).parentBlock(class_2246.field_10409));
		putInDatagenArgs(ModBlocks.VERTICAL_BLUE_TERRACOTTA_STAIRS, new DatagenArgs().blockTags(class_3481.field_33715, class_3481.field_36265).textureMap(class_4944.method_25864(class_2246.field_10409)).parentBlock(class_2246.field_10409));
		putInDatagenArgs(ModBlocks.VERTICAL_PURPLE_TERRACOTTA_SLAB, new DatagenArgs().blockTags(class_3481.field_33715, class_3481.field_36265).textureMap(class_4944.method_25864(class_2246.field_10570)).parentBlock(class_2246.field_10570));
		putInDatagenArgs(ModBlocks.VERTICAL_PURPLE_TERRACOTTA_STAIRS, new DatagenArgs().blockTags(class_3481.field_33715, class_3481.field_36265).textureMap(class_4944.method_25864(class_2246.field_10570)).parentBlock(class_2246.field_10570));
		putInDatagenArgs(ModBlocks.VERTICAL_MAGENTA_TERRACOTTA_SLAB, new DatagenArgs().blockTags(class_3481.field_33715, class_3481.field_36265).textureMap(class_4944.method_25864(class_2246.field_10015)).parentBlock(class_2246.field_10015));
		putInDatagenArgs(ModBlocks.VERTICAL_MAGENTA_TERRACOTTA_STAIRS, new DatagenArgs().blockTags(class_3481.field_33715, class_3481.field_36265).textureMap(class_4944.method_25864(class_2246.field_10015)).parentBlock(class_2246.field_10015));
		putInDatagenArgs(ModBlocks.VERTICAL_PINK_TERRACOTTA_SLAB, new DatagenArgs().blockTags(class_3481.field_33715, class_3481.field_36265).textureMap(class_4944.method_25864(class_2246.field_10444)).parentBlock(class_2246.field_10444));
		putInDatagenArgs(ModBlocks.VERTICAL_PINK_TERRACOTTA_STAIRS, new DatagenArgs().blockTags(class_3481.field_33715, class_3481.field_36265).textureMap(class_4944.method_25864(class_2246.field_10444)).parentBlock(class_2246.field_10444));
		putInDatagenArgs(ModBlocks.VERTICAL_WHITE_CONCRETE_SLAB, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_10107)).parentBlock(class_2246.field_10107));
		putInDatagenArgs(ModBlocks.VERTICAL_WHITE_CONCRETE_STAIRS, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_10107)).parentBlock(class_2246.field_10107));
		putInDatagenArgs(ModBlocks.VERTICAL_LIGHT_GRAY_CONCRETE_SLAB, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_10172)).parentBlock(class_2246.field_10172));
		putInDatagenArgs(ModBlocks.VERTICAL_LIGHT_GRAY_CONCRETE_STAIRS, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_10172)).parentBlock(class_2246.field_10172));
		putInDatagenArgs(ModBlocks.VERTICAL_GRAY_CONCRETE_SLAB, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_10038)).parentBlock(class_2246.field_10038));
		putInDatagenArgs(ModBlocks.VERTICAL_GRAY_CONCRETE_STAIRS, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_10038)).parentBlock(class_2246.field_10038));
		putInDatagenArgs(ModBlocks.VERTICAL_BLACK_CONCRETE_SLAB, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_10458)).parentBlock(class_2246.field_10458));
		putInDatagenArgs(ModBlocks.VERTICAL_BLACK_CONCRETE_STAIRS, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_10458)).parentBlock(class_2246.field_10458));
		putInDatagenArgs(ModBlocks.VERTICAL_BROWN_CONCRETE_SLAB, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_10439)).parentBlock(class_2246.field_10439));
		putInDatagenArgs(ModBlocks.VERTICAL_BROWN_CONCRETE_STAIRS, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_10439)).parentBlock(class_2246.field_10439));
		putInDatagenArgs(ModBlocks.VERTICAL_RED_CONCRETE_SLAB, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_10058)).parentBlock(class_2246.field_10058));
		putInDatagenArgs(ModBlocks.VERTICAL_RED_CONCRETE_STAIRS, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_10058)).parentBlock(class_2246.field_10058));
		putInDatagenArgs(ModBlocks.VERTICAL_ORANGE_CONCRETE_SLAB, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_10210)).parentBlock(class_2246.field_10210));
		putInDatagenArgs(ModBlocks.VERTICAL_ORANGE_CONCRETE_STAIRS, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_10210)).parentBlock(class_2246.field_10210));
		putInDatagenArgs(ModBlocks.VERTICAL_YELLOW_CONCRETE_SLAB, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_10542)).parentBlock(class_2246.field_10542));
		putInDatagenArgs(ModBlocks.VERTICAL_YELLOW_CONCRETE_STAIRS, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_10542)).parentBlock(class_2246.field_10542));
		putInDatagenArgs(ModBlocks.VERTICAL_LIME_CONCRETE_SLAB, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_10421)).parentBlock(class_2246.field_10421));
		putInDatagenArgs(ModBlocks.VERTICAL_LIME_CONCRETE_STAIRS, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_10421)).parentBlock(class_2246.field_10421));
		putInDatagenArgs(ModBlocks.VERTICAL_GREEN_CONCRETE_SLAB, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_10367)).parentBlock(class_2246.field_10367));
		putInDatagenArgs(ModBlocks.VERTICAL_GREEN_CONCRETE_STAIRS, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_10367)).parentBlock(class_2246.field_10367));
		putInDatagenArgs(ModBlocks.VERTICAL_CYAN_CONCRETE_SLAB, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_10308)).parentBlock(class_2246.field_10308));
		putInDatagenArgs(ModBlocks.VERTICAL_CYAN_CONCRETE_STAIRS, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_10308)).parentBlock(class_2246.field_10308));
		putInDatagenArgs(ModBlocks.VERTICAL_LIGHT_BLUE_CONCRETE_SLAB, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_10242)).parentBlock(class_2246.field_10242));
		putInDatagenArgs(ModBlocks.VERTICAL_LIGHT_BLUE_CONCRETE_STAIRS, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_10242)).parentBlock(class_2246.field_10242));
		putInDatagenArgs(ModBlocks.VERTICAL_BLUE_CONCRETE_SLAB, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_10011)).parentBlock(class_2246.field_10011));
		putInDatagenArgs(ModBlocks.VERTICAL_BLUE_CONCRETE_STAIRS, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_10011)).parentBlock(class_2246.field_10011));
		putInDatagenArgs(ModBlocks.VERTICAL_PURPLE_CONCRETE_SLAB, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_10206)).parentBlock(class_2246.field_10206));
		putInDatagenArgs(ModBlocks.VERTICAL_PURPLE_CONCRETE_STAIRS, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_10206)).parentBlock(class_2246.field_10206));
		putInDatagenArgs(ModBlocks.VERTICAL_MAGENTA_CONCRETE_SLAB, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_10585)).parentBlock(class_2246.field_10585));
		putInDatagenArgs(ModBlocks.VERTICAL_MAGENTA_CONCRETE_STAIRS, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_10585)).parentBlock(class_2246.field_10585));
		putInDatagenArgs(ModBlocks.VERTICAL_PINK_CONCRETE_SLAB, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_10434)).parentBlock(class_2246.field_10434));
		putInDatagenArgs(ModBlocks.VERTICAL_PINK_CONCRETE_STAIRS, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_10434)).parentBlock(class_2246.field_10434));
		putInDatagenArgs(ModBlocks.VERTICAL_WHITE_CONCRETE_POWDER_SLAB, new DatagenArgs().blockTags(class_3481.field_33716, class_3481.field_45063).textureMap(class_4944.method_25864(class_2246.field_10197)).parentBlock(class_2246.field_10197));
		putInDatagenArgs(ModBlocks.VERTICAL_WHITE_CONCRETE_POWDER_STAIRS, new DatagenArgs().blockTags(class_3481.field_33716, class_3481.field_45063).textureMap(class_4944.method_25864(class_2246.field_10197)).parentBlock(class_2246.field_10197));
		putInDatagenArgs(ModBlocks.VERTICAL_LIGHT_GRAY_CONCRETE_POWDER_SLAB, new DatagenArgs().blockTags(class_3481.field_33716, class_3481.field_45063).textureMap(class_4944.method_25864(class_2246.field_10628)).parentBlock(class_2246.field_10628));
		putInDatagenArgs(ModBlocks.VERTICAL_LIGHT_GRAY_CONCRETE_POWDER_STAIRS, new DatagenArgs().blockTags(class_3481.field_33716, class_3481.field_45063).textureMap(class_4944.method_25864(class_2246.field_10628)).parentBlock(class_2246.field_10628));
		putInDatagenArgs(ModBlocks.VERTICAL_GRAY_CONCRETE_POWDER_SLAB, new DatagenArgs().blockTags(class_3481.field_33716, class_3481.field_45063).textureMap(class_4944.method_25864(class_2246.field_10353)).parentBlock(class_2246.field_10353));
		putInDatagenArgs(ModBlocks.VERTICAL_GRAY_CONCRETE_POWDER_STAIRS, new DatagenArgs().blockTags(class_3481.field_33716, class_3481.field_45063).textureMap(class_4944.method_25864(class_2246.field_10353)).parentBlock(class_2246.field_10353));
		putInDatagenArgs(ModBlocks.VERTICAL_BLACK_CONCRETE_POWDER_SLAB, new DatagenArgs().blockTags(class_3481.field_33716, class_3481.field_45063).textureMap(class_4944.method_25864(class_2246.field_10506)).parentBlock(class_2246.field_10506));
		putInDatagenArgs(ModBlocks.VERTICAL_BLACK_CONCRETE_POWDER_STAIRS, new DatagenArgs().blockTags(class_3481.field_33716, class_3481.field_45063).textureMap(class_4944.method_25864(class_2246.field_10506)).parentBlock(class_2246.field_10506));
		putInDatagenArgs(ModBlocks.VERTICAL_BROWN_CONCRETE_POWDER_SLAB, new DatagenArgs().blockTags(class_3481.field_33716, class_3481.field_45063).textureMap(class_4944.method_25864(class_2246.field_10023)).parentBlock(class_2246.field_10023));
		putInDatagenArgs(ModBlocks.VERTICAL_BROWN_CONCRETE_POWDER_STAIRS, new DatagenArgs().blockTags(class_3481.field_33716, class_3481.field_45063).textureMap(class_4944.method_25864(class_2246.field_10023)).parentBlock(class_2246.field_10023));
		putInDatagenArgs(ModBlocks.VERTICAL_RED_CONCRETE_POWDER_SLAB, new DatagenArgs().blockTags(class_3481.field_33716, class_3481.field_45063).textureMap(class_4944.method_25864(class_2246.field_10287)).parentBlock(class_2246.field_10287));
		putInDatagenArgs(ModBlocks.VERTICAL_RED_CONCRETE_POWDER_STAIRS, new DatagenArgs().blockTags(class_3481.field_33716, class_3481.field_45063).textureMap(class_4944.method_25864(class_2246.field_10287)).parentBlock(class_2246.field_10287));
		putInDatagenArgs(ModBlocks.VERTICAL_ORANGE_CONCRETE_POWDER_SLAB, new DatagenArgs().blockTags(class_3481.field_33716, class_3481.field_45063).textureMap(class_4944.method_25864(class_2246.field_10022)).parentBlock(class_2246.field_10022));
		putInDatagenArgs(ModBlocks.VERTICAL_ORANGE_CONCRETE_POWDER_STAIRS, new DatagenArgs().blockTags(class_3481.field_33716, class_3481.field_45063).textureMap(class_4944.method_25864(class_2246.field_10022)).parentBlock(class_2246.field_10022));
		putInDatagenArgs(ModBlocks.VERTICAL_YELLOW_CONCRETE_POWDER_SLAB, new DatagenArgs().blockTags(class_3481.field_33716, class_3481.field_45063).textureMap(class_4944.method_25864(class_2246.field_10145)).parentBlock(class_2246.field_10145));
		putInDatagenArgs(ModBlocks.VERTICAL_YELLOW_CONCRETE_POWDER_STAIRS, new DatagenArgs().blockTags(class_3481.field_33716, class_3481.field_45063).textureMap(class_4944.method_25864(class_2246.field_10145)).parentBlock(class_2246.field_10145));
		putInDatagenArgs(ModBlocks.VERTICAL_LIME_CONCRETE_POWDER_SLAB, new DatagenArgs().blockTags(class_3481.field_33716, class_3481.field_45063).textureMap(class_4944.method_25864(class_2246.field_10133)).parentBlock(class_2246.field_10133));
		putInDatagenArgs(ModBlocks.VERTICAL_LIME_CONCRETE_POWDER_STAIRS, new DatagenArgs().blockTags(class_3481.field_33716, class_3481.field_45063).textureMap(class_4944.method_25864(class_2246.field_10133)).parentBlock(class_2246.field_10133));
		putInDatagenArgs(ModBlocks.VERTICAL_GREEN_CONCRETE_POWDER_SLAB, new DatagenArgs().blockTags(class_3481.field_33716, class_3481.field_45063).textureMap(class_4944.method_25864(class_2246.field_10529)).parentBlock(class_2246.field_10529));
		putInDatagenArgs(ModBlocks.VERTICAL_GREEN_CONCRETE_POWDER_STAIRS, new DatagenArgs().blockTags(class_3481.field_33716, class_3481.field_45063).textureMap(class_4944.method_25864(class_2246.field_10529)).parentBlock(class_2246.field_10529));
		putInDatagenArgs(ModBlocks.VERTICAL_CYAN_CONCRETE_POWDER_SLAB, new DatagenArgs().blockTags(class_3481.field_33716, class_3481.field_45063).textureMap(class_4944.method_25864(class_2246.field_10233)).parentBlock(class_2246.field_10233));
		putInDatagenArgs(ModBlocks.VERTICAL_CYAN_CONCRETE_POWDER_STAIRS, new DatagenArgs().blockTags(class_3481.field_33716, class_3481.field_45063).textureMap(class_4944.method_25864(class_2246.field_10233)).parentBlock(class_2246.field_10233));
		putInDatagenArgs(ModBlocks.VERTICAL_LIGHT_BLUE_CONCRETE_POWDER_SLAB, new DatagenArgs().blockTags(class_3481.field_33716, class_3481.field_45063).textureMap(class_4944.method_25864(class_2246.field_10321)).parentBlock(class_2246.field_10321));
		putInDatagenArgs(ModBlocks.VERTICAL_LIGHT_BLUE_CONCRETE_POWDER_STAIRS, new DatagenArgs().blockTags(class_3481.field_33716, class_3481.field_45063).textureMap(class_4944.method_25864(class_2246.field_10321)).parentBlock(class_2246.field_10321));
		putInDatagenArgs(ModBlocks.VERTICAL_BLUE_CONCRETE_POWDER_SLAB, new DatagenArgs().blockTags(class_3481.field_33716, class_3481.field_45063).textureMap(class_4944.method_25864(class_2246.field_10456)).parentBlock(class_2246.field_10456));
		putInDatagenArgs(ModBlocks.VERTICAL_BLUE_CONCRETE_POWDER_STAIRS, new DatagenArgs().blockTags(class_3481.field_33716, class_3481.field_45063).textureMap(class_4944.method_25864(class_2246.field_10456)).parentBlock(class_2246.field_10456));
		putInDatagenArgs(ModBlocks.VERTICAL_PURPLE_CONCRETE_POWDER_SLAB, new DatagenArgs().blockTags(class_3481.field_33716, class_3481.field_45063).textureMap(class_4944.method_25864(class_2246.field_10404)).parentBlock(class_2246.field_10404));
		putInDatagenArgs(ModBlocks.VERTICAL_PURPLE_CONCRETE_POWDER_STAIRS, new DatagenArgs().blockTags(class_3481.field_33716, class_3481.field_45063).textureMap(class_4944.method_25864(class_2246.field_10404)).parentBlock(class_2246.field_10404));
		putInDatagenArgs(ModBlocks.VERTICAL_MAGENTA_CONCRETE_POWDER_SLAB, new DatagenArgs().blockTags(class_3481.field_33716, class_3481.field_45063).textureMap(class_4944.method_25864(class_2246.field_10300)).parentBlock(class_2246.field_10300));
		putInDatagenArgs(ModBlocks.VERTICAL_MAGENTA_CONCRETE_POWDER_STAIRS, new DatagenArgs().blockTags(class_3481.field_33716, class_3481.field_45063).textureMap(class_4944.method_25864(class_2246.field_10300)).parentBlock(class_2246.field_10300));
		putInDatagenArgs(ModBlocks.VERTICAL_PINK_CONCRETE_POWDER_SLAB, new DatagenArgs().blockTags(class_3481.field_33716, class_3481.field_45063).textureMap(class_4944.method_25864(class_2246.field_10522)).parentBlock(class_2246.field_10522));
		putInDatagenArgs(ModBlocks.VERTICAL_PINK_CONCRETE_POWDER_STAIRS, new DatagenArgs().blockTags(class_3481.field_33716, class_3481.field_45063).textureMap(class_4944.method_25864(class_2246.field_10522)).parentBlock(class_2246.field_10522));
		putInDatagenArgs(ModBlocks.VERTICAL_WHITE_GLAZED_TERRACOTTA_SLAB, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_10595)).parentBlock(class_2246.field_10595));
		putInDatagenArgs(ModBlocks.VERTICAL_WHITE_GLAZED_TERRACOTTA_STAIRS, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_10595)).parentBlock(class_2246.field_10595));
		putInDatagenArgs(ModBlocks.VERTICAL_LIGHT_GRAY_GLAZED_TERRACOTTA_SLAB, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_10052)).parentBlock(class_2246.field_10052));
		putInDatagenArgs(ModBlocks.VERTICAL_LIGHT_GRAY_GLAZED_TERRACOTTA_STAIRS, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_10052)).parentBlock(class_2246.field_10052));
		putInDatagenArgs(ModBlocks.VERTICAL_GRAY_GLAZED_TERRACOTTA_SLAB, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_10220)).parentBlock(class_2246.field_10220));
		putInDatagenArgs(ModBlocks.VERTICAL_GRAY_GLAZED_TERRACOTTA_STAIRS, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_10220)).parentBlock(class_2246.field_10220));
		putInDatagenArgs(ModBlocks.VERTICAL_BLACK_GLAZED_TERRACOTTA_SLAB, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_10501)).parentBlock(class_2246.field_10501));
		putInDatagenArgs(ModBlocks.VERTICAL_BLACK_GLAZED_TERRACOTTA_STAIRS, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_10501)).parentBlock(class_2246.field_10501));
		putInDatagenArgs(ModBlocks.VERTICAL_BROWN_GLAZED_TERRACOTTA_SLAB, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_10004)).parentBlock(class_2246.field_10004));
		putInDatagenArgs(ModBlocks.VERTICAL_BROWN_GLAZED_TERRACOTTA_STAIRS, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_10004)).parentBlock(class_2246.field_10004));
		putInDatagenArgs(ModBlocks.VERTICAL_RED_GLAZED_TERRACOTTA_SLAB, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_10383)).parentBlock(class_2246.field_10383));
		putInDatagenArgs(ModBlocks.VERTICAL_RED_GLAZED_TERRACOTTA_STAIRS, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_10383)).parentBlock(class_2246.field_10383));
		putInDatagenArgs(ModBlocks.VERTICAL_ORANGE_GLAZED_TERRACOTTA_SLAB, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_10280)).parentBlock(class_2246.field_10280));
		putInDatagenArgs(ModBlocks.VERTICAL_ORANGE_GLAZED_TERRACOTTA_STAIRS, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_10280)).parentBlock(class_2246.field_10280));
		putInDatagenArgs(ModBlocks.VERTICAL_YELLOW_GLAZED_TERRACOTTA_SLAB, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_10096)).parentBlock(class_2246.field_10096));
		putInDatagenArgs(ModBlocks.VERTICAL_YELLOW_GLAZED_TERRACOTTA_STAIRS, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_10096)).parentBlock(class_2246.field_10096));
		putInDatagenArgs(ModBlocks.VERTICAL_LIME_GLAZED_TERRACOTTA_SLAB, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_10046)).parentBlock(class_2246.field_10046));
		putInDatagenArgs(ModBlocks.VERTICAL_LIME_GLAZED_TERRACOTTA_STAIRS, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_10046)).parentBlock(class_2246.field_10046));
		putInDatagenArgs(ModBlocks.VERTICAL_GREEN_GLAZED_TERRACOTTA_SLAB, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_10475)).parentBlock(class_2246.field_10475));
		putInDatagenArgs(ModBlocks.VERTICAL_GREEN_GLAZED_TERRACOTTA_STAIRS, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_10475)).parentBlock(class_2246.field_10475));
		putInDatagenArgs(ModBlocks.VERTICAL_CYAN_GLAZED_TERRACOTTA_SLAB, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_10078)).parentBlock(class_2246.field_10078));
		putInDatagenArgs(ModBlocks.VERTICAL_CYAN_GLAZED_TERRACOTTA_STAIRS, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_10078)).parentBlock(class_2246.field_10078));
		putInDatagenArgs(ModBlocks.VERTICAL_LIGHT_BLUE_GLAZED_TERRACOTTA_SLAB, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_10345)).parentBlock(class_2246.field_10345));
		putInDatagenArgs(ModBlocks.VERTICAL_LIGHT_BLUE_GLAZED_TERRACOTTA_STAIRS, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_10345)).parentBlock(class_2246.field_10345));
		putInDatagenArgs(ModBlocks.VERTICAL_BLUE_GLAZED_TERRACOTTA_SLAB, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_10550)).parentBlock(class_2246.field_10550));
		putInDatagenArgs(ModBlocks.VERTICAL_BLUE_GLAZED_TERRACOTTA_STAIRS, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_10550)).parentBlock(class_2246.field_10550));
		putInDatagenArgs(ModBlocks.VERTICAL_PURPLE_GLAZED_TERRACOTTA_SLAB, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_10426)).parentBlock(class_2246.field_10426));
		putInDatagenArgs(ModBlocks.VERTICAL_PURPLE_GLAZED_TERRACOTTA_STAIRS, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_10426)).parentBlock(class_2246.field_10426));
		putInDatagenArgs(ModBlocks.VERTICAL_MAGENTA_GLAZED_TERRACOTTA_SLAB, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_10538)).parentBlock(class_2246.field_10538));
		putInDatagenArgs(ModBlocks.VERTICAL_MAGENTA_GLAZED_TERRACOTTA_STAIRS, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_10538)).parentBlock(class_2246.field_10538));
		putInDatagenArgs(ModBlocks.VERTICAL_PINK_GLAZED_TERRACOTTA_SLAB, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_10567)).parentBlock(class_2246.field_10567));
		putInDatagenArgs(ModBlocks.VERTICAL_PINK_GLAZED_TERRACOTTA_STAIRS, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_10567)).parentBlock(class_2246.field_10567));
		putInDatagenArgs(ModBlocks.VERTICAL_GLASS_SLAB, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_10033)).parentBlock(class_2246.field_10033).needsSilkTouch());
		putInDatagenArgs(ModBlocks.VERTICAL_GLASS_STAIRS, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_10033)).parentBlock(class_2246.field_10033).needsSilkTouch());
		putInDatagenArgs(ModBlocks.VERTICAL_WHITE_STAINED_GLASS_SLAB, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_10087)).parentBlock(class_2246.field_10087).needsSilkTouch());
		putInDatagenArgs(ModBlocks.VERTICAL_WHITE_STAINED_GLASS_STAIRS, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_10087)).parentBlock(class_2246.field_10087).needsSilkTouch());
		putInDatagenArgs(ModBlocks.VERTICAL_LIGHT_GRAY_STAINED_GLASS_SLAB, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_9996)).parentBlock(class_2246.field_9996).needsSilkTouch());
		putInDatagenArgs(ModBlocks.VERTICAL_LIGHT_GRAY_STAINED_GLASS_STAIRS, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_9996)).parentBlock(class_2246.field_9996).needsSilkTouch());
		putInDatagenArgs(ModBlocks.VERTICAL_GRAY_STAINED_GLASS_SLAB, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_10555)).parentBlock(class_2246.field_10555).needsSilkTouch());
		putInDatagenArgs(ModBlocks.VERTICAL_GRAY_STAINED_GLASS_STAIRS, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_10555)).parentBlock(class_2246.field_10555).needsSilkTouch());
		putInDatagenArgs(ModBlocks.VERTICAL_BLACK_STAINED_GLASS_SLAB, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_9997)).parentBlock(class_2246.field_9997).needsSilkTouch());
		putInDatagenArgs(ModBlocks.VERTICAL_BLACK_STAINED_GLASS_STAIRS, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_9997)).parentBlock(class_2246.field_9997).needsSilkTouch());
		putInDatagenArgs(ModBlocks.VERTICAL_BROWN_STAINED_GLASS_SLAB, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_10073)).parentBlock(class_2246.field_10073).needsSilkTouch());
		putInDatagenArgs(ModBlocks.VERTICAL_BROWN_STAINED_GLASS_STAIRS, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_10073)).parentBlock(class_2246.field_10073).needsSilkTouch());
		putInDatagenArgs(ModBlocks.VERTICAL_RED_STAINED_GLASS_SLAB, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_10272)).parentBlock(class_2246.field_10272).needsSilkTouch());
		putInDatagenArgs(ModBlocks.VERTICAL_RED_STAINED_GLASS_STAIRS, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_10272)).parentBlock(class_2246.field_10272).needsSilkTouch());
		putInDatagenArgs(ModBlocks.VERTICAL_ORANGE_STAINED_GLASS_SLAB, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_10227)).parentBlock(class_2246.field_10227).needsSilkTouch());
		putInDatagenArgs(ModBlocks.VERTICAL_ORANGE_STAINED_GLASS_STAIRS, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_10227)).parentBlock(class_2246.field_10227).needsSilkTouch());
		putInDatagenArgs(ModBlocks.VERTICAL_YELLOW_STAINED_GLASS_SLAB, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_10049)).parentBlock(class_2246.field_10049).needsSilkTouch());
		putInDatagenArgs(ModBlocks.VERTICAL_YELLOW_STAINED_GLASS_STAIRS, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_10049)).parentBlock(class_2246.field_10049).needsSilkTouch());
		putInDatagenArgs(ModBlocks.VERTICAL_LIME_STAINED_GLASS_SLAB, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_10157)).parentBlock(class_2246.field_10157).needsSilkTouch());
		putInDatagenArgs(ModBlocks.VERTICAL_LIME_STAINED_GLASS_STAIRS, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_10157)).parentBlock(class_2246.field_10157).needsSilkTouch());
		putInDatagenArgs(ModBlocks.VERTICAL_GREEN_STAINED_GLASS_SLAB, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_10357)).parentBlock(class_2246.field_10357).needsSilkTouch());
		putInDatagenArgs(ModBlocks.VERTICAL_GREEN_STAINED_GLASS_STAIRS, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_10357)).parentBlock(class_2246.field_10357).needsSilkTouch());
		putInDatagenArgs(ModBlocks.VERTICAL_CYAN_STAINED_GLASS_SLAB, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_10248)).parentBlock(class_2246.field_10248).needsSilkTouch());
		putInDatagenArgs(ModBlocks.VERTICAL_CYAN_STAINED_GLASS_STAIRS, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_10248)).parentBlock(class_2246.field_10248).needsSilkTouch());
		putInDatagenArgs(ModBlocks.VERTICAL_LIGHT_BLUE_STAINED_GLASS_SLAB, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_10271)).parentBlock(class_2246.field_10271).needsSilkTouch());
		putInDatagenArgs(ModBlocks.VERTICAL_LIGHT_BLUE_STAINED_GLASS_STAIRS, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_10271)).parentBlock(class_2246.field_10271).needsSilkTouch());
		putInDatagenArgs(ModBlocks.VERTICAL_BLUE_STAINED_GLASS_SLAB, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_10060)).parentBlock(class_2246.field_10060).needsSilkTouch());
		putInDatagenArgs(ModBlocks.VERTICAL_BLUE_STAINED_GLASS_STAIRS, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_10060)).parentBlock(class_2246.field_10060).needsSilkTouch());
		putInDatagenArgs(ModBlocks.VERTICAL_PURPLE_STAINED_GLASS_SLAB, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_10399)).parentBlock(class_2246.field_10399).needsSilkTouch());
		putInDatagenArgs(ModBlocks.VERTICAL_PURPLE_STAINED_GLASS_STAIRS, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_10399)).parentBlock(class_2246.field_10399).needsSilkTouch());
		putInDatagenArgs(ModBlocks.VERTICAL_MAGENTA_STAINED_GLASS_SLAB, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_10574)).parentBlock(class_2246.field_10574).needsSilkTouch());
		putInDatagenArgs(ModBlocks.VERTICAL_MAGENTA_STAINED_GLASS_STAIRS, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_10574)).parentBlock(class_2246.field_10574).needsSilkTouch());
		putInDatagenArgs(ModBlocks.VERTICAL_PINK_STAINED_GLASS_SLAB, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_10317)).parentBlock(class_2246.field_10317).needsSilkTouch());
		putInDatagenArgs(ModBlocks.VERTICAL_PINK_STAINED_GLASS_STAIRS, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_10317)).parentBlock(class_2246.field_10317).needsSilkTouch());
		putInDatagenArgs(ModBlocks.VERTICAL_FARMLAND_SLAB, new DatagenArgs().blockTags(class_3481.field_33716).textureMap(custom(class_2246.field_10566, class_2246.field_10362, class_2246.field_10566, "", "", "")).parentBlock(class_2246.field_10362).y15());
		putInDatagenArgs(ModBlocks.VERTICAL_FARMLAND_STAIRS, new DatagenArgs().blockTags(class_3481.field_33716).textureMap(custom(class_2246.field_10566, class_2246.field_10362, class_2246.field_10566, "", "", "")).parentBlock(class_2246.field_10362).y15());
		putInDatagenArgs(ModBlocks.VERTICAL_DIRT_PATH_SLAB, new DatagenArgs().blockTags(class_3481.field_33716).textureMap(custom(class_2246.field_10194, class_2246.field_10194, class_2246.field_10566, "_side", "_top", "")).parentBlock(class_2246.field_10194).y15());
		putInDatagenArgs(ModBlocks.VERTICAL_DIRT_PATH_STAIRS, new DatagenArgs().blockTags(class_3481.field_33716).textureMap(custom(class_2246.field_10194, class_2246.field_10194, class_2246.field_10566, "_side", "_top", "")).parentBlock(class_2246.field_10194).y15());
		putInDatagenArgs(ModBlocks.VERTICAL_GRASS_SLAB, new DatagenArgs().blockTags(class_3481.field_33716).parentBlock(class_2246.field_10219).tintSource(new class_10400()));
		putInDatagenArgs(ModBlocks.VERTICAL_GRASS_STAIRS, new DatagenArgs().blockTags(class_3481.field_33716).parentBlock(class_2246.field_10219).tintSource(new class_10400()));
		putInDatagenArgs(ModBlocks.VERTICAL_PODZOL_SLAB, new DatagenArgs().blockTags(class_3481.field_33716).textureMap(custom(class_2246.field_10520, class_2246.field_10520, class_2246.field_10566, "_side", "_top", "")).parentBlock(class_2246.field_10520));
		putInDatagenArgs(ModBlocks.VERTICAL_PODZOL_STAIRS, new DatagenArgs().blockTags(class_3481.field_33716).textureMap(custom(class_2246.field_10520, class_2246.field_10520, class_2246.field_10566, "_side", "_top", "")).parentBlock(class_2246.field_10520));
		putInDatagenArgs(ModBlocks.VERTICAL_MYCELIUM_SLAB, new DatagenArgs().blockTags(class_3481.field_33716).textureMap(custom(class_2246.field_10402, class_2246.field_10402, class_2246.field_10566, "_side", "_top", "")).parentBlock(class_2246.field_10402));
		putInDatagenArgs(ModBlocks.VERTICAL_MYCELIUM_STAIRS, new DatagenArgs().blockTags(class_3481.field_33716).textureMap(custom(class_2246.field_10402, class_2246.field_10402, class_2246.field_10566, "_side", "_top", "")).parentBlock(class_2246.field_10402));
		putInDatagenArgs(ModBlocks.VERTICAL_DIRT_SLAB, new DatagenArgs().blockTags(class_3481.field_33716).textureMap(class_4944.method_25864(class_2246.field_10566)).parentBlock(class_2246.field_10566));
		putInDatagenArgs(ModBlocks.VERTICAL_DIRT_STAIRS, new DatagenArgs().blockTags(class_3481.field_33716).textureMap(class_4944.method_25864(class_2246.field_10566)).parentBlock(class_2246.field_10566));
		putInDatagenArgs(ModBlocks.VERTICAL_COARSE_DIRT_SLAB, new DatagenArgs().blockTags(class_3481.field_33716).textureMap(class_4944.method_25864(class_2246.field_10253)).parentBlock(class_2246.field_10253));
		putInDatagenArgs(ModBlocks.VERTICAL_COARSE_DIRT_STAIRS, new DatagenArgs().blockTags(class_3481.field_33716).textureMap(class_4944.method_25864(class_2246.field_10253)).parentBlock(class_2246.field_10253));
		putInDatagenArgs(ModBlocks.VERTICAL_ROOTED_DIRT_SLAB, new DatagenArgs().blockTags(class_3481.field_33716).textureMap(class_4944.method_25864(class_2246.field_28685)).parentBlock(class_2246.field_28685));
		putInDatagenArgs(ModBlocks.VERTICAL_ROOTED_DIRT_STAIRS, new DatagenArgs().blockTags(class_3481.field_33716).textureMap(class_4944.method_25864(class_2246.field_28685)).parentBlock(class_2246.field_28685));
		putInDatagenArgs(ModBlocks.VERTICAL_MUD_SLAB, new DatagenArgs().blockTags(class_3481.field_33716).textureMap(class_4944.method_25864(class_2246.field_37576)).parentBlock(class_2246.field_37576));
		putInDatagenArgs(ModBlocks.VERTICAL_MUD_STAIRS, new DatagenArgs().blockTags(class_3481.field_33716).textureMap(class_4944.method_25864(class_2246.field_37576)).parentBlock(class_2246.field_37576));
		putInDatagenArgs(ModBlocks.VERTICAL_CLAY_SLAB, new DatagenArgs().blockTags(class_3481.field_33716).textureMap(class_4944.method_25864(class_2246.field_10460)).parentBlock(class_2246.field_10460));
		putInDatagenArgs(ModBlocks.VERTICAL_CLAY_STAIRS, new DatagenArgs().blockTags(class_3481.field_33716).textureMap(class_4944.method_25864(class_2246.field_10460)).parentBlock(class_2246.field_10460));
		putInDatagenArgs(ModBlocks.VERTICAL_GRAVEL_SLAB, new DatagenArgs().blockTags(class_3481.field_33716).textureMap(class_4944.method_25864(class_2246.field_10255)).parentBlock(class_2246.field_10255));
		putInDatagenArgs(ModBlocks.VERTICAL_GRAVEL_STAIRS, new DatagenArgs().blockTags(class_3481.field_33716).textureMap(class_4944.method_25864(class_2246.field_10255)).parentBlock(class_2246.field_10255));
		putInDatagenArgs(ModBlocks.VERTICAL_SAND_SLAB, new DatagenArgs().blockTags(class_3481.field_33716).textureMap(class_4944.method_25864(class_2246.field_10102)).parentBlock(class_2246.field_10102));
		putInDatagenArgs(ModBlocks.VERTICAL_SAND_STAIRS, new DatagenArgs().blockTags(class_3481.field_33716).textureMap(class_4944.method_25864(class_2246.field_10102)).parentBlock(class_2246.field_10102));
		putInDatagenArgs(ModBlocks.VERTICAL_RED_SAND_SLAB, new DatagenArgs().blockTags(class_3481.field_33716).textureMap(class_4944.method_25864(class_2246.field_10534)).parentBlock(class_2246.field_10534));
		putInDatagenArgs(ModBlocks.VERTICAL_RED_SAND_STAIRS, new DatagenArgs().blockTags(class_3481.field_33716).textureMap(class_4944.method_25864(class_2246.field_10534)).parentBlock(class_2246.field_10534));
		putInDatagenArgs(ModBlocks.VERTICAL_ICE_SLAB, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_10295)).parentBlock(class_2246.field_10295));
		putInDatagenArgs(ModBlocks.VERTICAL_ICE_STAIRS, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_10295)).parentBlock(class_2246.field_10295));
		putInDatagenArgs(ModBlocks.VERTICAL_PACKED_ICE_SLAB, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_10225)).parentBlock(class_2246.field_10225));
		putInDatagenArgs(ModBlocks.VERTICAL_PACKED_ICE_STAIRS, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_10225)).parentBlock(class_2246.field_10225));
		putInDatagenArgs(ModBlocks.VERTICAL_BLUE_ICE_SLAB, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_10384)).parentBlock(class_2246.field_10384));
		putInDatagenArgs(ModBlocks.VERTICAL_BLUE_ICE_STAIRS, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_10384)).parentBlock(class_2246.field_10384));
		putInDatagenArgs(ModBlocks.VERTICAL_SNOW_SLAB, new DatagenArgs().blockTags(class_3481.field_33716).textureMap(class_4944.method_25864(class_2246.field_10477)).parentBlock(class_2246.field_10491));
		putInDatagenArgs(ModBlocks.VERTICAL_SNOW_STAIRS, new DatagenArgs().blockTags(class_3481.field_33716).textureMap(class_4944.method_25864(class_2246.field_10477)).parentBlock(class_2246.field_10491));
		putInDatagenArgs(ModBlocks.VERTICAL_MOSS_SLAB, new DatagenArgs().blockTags(class_3481.field_33714).textureMap(class_4944.method_25864(class_2246.field_28681)).parentBlock(class_2246.field_28681));
		putInDatagenArgs(ModBlocks.VERTICAL_MOSS_STAIRS, new DatagenArgs().blockTags(class_3481.field_33714).textureMap(class_4944.method_25864(class_2246.field_28681)).parentBlock(class_2246.field_28681));
		putInDatagenArgs(ModBlocks.VERTICAL_PALE_MOSS_SLAB, new DatagenArgs().blockTags(class_3481.field_33714).textureMap(class_4944.method_25864(class_2246.field_54731)).parentBlock(class_2246.field_54731));
		putInDatagenArgs(ModBlocks.VERTICAL_PALE_MOSS_STAIRS, new DatagenArgs().blockTags(class_3481.field_33714).textureMap(class_4944.method_25864(class_2246.field_54731)).parentBlock(class_2246.field_54731));
		putInDatagenArgs(ModBlocks.VERTICAL_CALCITE_SLAB, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_27114)).parentBlock(class_2246.field_27114));
		putInDatagenArgs(ModBlocks.VERTICAL_CALCITE_STAIRS, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_27114)).parentBlock(class_2246.field_27114));
		putInDatagenArgs(ModBlocks.VERTICAL_DRIPSTONE_SLAB, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_28049)).parentBlock(class_2246.field_28049));
		putInDatagenArgs(ModBlocks.VERTICAL_DRIPSTONE_STAIRS, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_28049)).parentBlock(class_2246.field_28049));
		putInDatagenArgs(ModBlocks.VERTICAL_MAGMA_SLAB, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25875(class_2960.method_60656("block/magma"))).parentBlock(class_2246.field_10092));
		putInDatagenArgs(ModBlocks.VERTICAL_MAGMA_STAIRS, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25875(class_2960.method_60656("block/magma"))).parentBlock(class_2246.field_10092));
		putInDatagenArgs(ModBlocks.VERTICAL_OBSIDIAN_SLAB, new DatagenArgs().blockTags(class_3481.field_33717, class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_10540)).parentBlock(class_2246.field_10540));
		putInDatagenArgs(ModBlocks.VERTICAL_OBSIDIAN_STAIRS, new DatagenArgs().blockTags(class_3481.field_33717, class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_10540)).parentBlock(class_2246.field_10540));
		putInDatagenArgs(ModBlocks.VERTICAL_CRYING_OBSIDIAN_SLAB, new DatagenArgs().blockTags(class_3481.field_33717, class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_22423)).parentBlock(class_2246.field_22423));
		putInDatagenArgs(ModBlocks.VERTICAL_CRYING_OBSIDIAN_STAIRS, new DatagenArgs().blockTags(class_3481.field_33717, class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_22423)).parentBlock(class_2246.field_22423));
		putInDatagenArgs(ModBlocks.VERTICAL_CRIMSON_NYLIUM_SLAB, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(custom(class_2246.field_22120, class_2246.field_22120, class_2246.field_10515, "_side", "", "")).parentBlock(class_2246.field_22120));
		putInDatagenArgs(ModBlocks.VERTICAL_CRIMSON_NYLIUM_STAIRS, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(custom(class_2246.field_22120, class_2246.field_22120, class_2246.field_10515, "_side", "", "")).parentBlock(class_2246.field_22120));
		putInDatagenArgs(ModBlocks.VERTICAL_WARPED_NYLIUM_SLAB, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(custom(class_2246.field_22113, class_2246.field_22113, class_2246.field_10515, "_side", "", "")).parentBlock(class_2246.field_22113));
		putInDatagenArgs(ModBlocks.VERTICAL_WARPED_NYLIUM_STAIRS, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(custom(class_2246.field_22113, class_2246.field_22113, class_2246.field_10515, "_side", "", "")).parentBlock(class_2246.field_22113));
		putInDatagenArgs(ModBlocks.VERTICAL_SOUL_SAND_SLAB, new DatagenArgs().blockTags(class_3481.field_33716).textureMap(class_4944.method_25864(class_2246.field_10114)).parentBlock(class_2246.field_10114));
		putInDatagenArgs(ModBlocks.VERTICAL_SOUL_SAND_STAIRS, new DatagenArgs().blockTags(class_3481.field_33716).textureMap(class_4944.method_25864(class_2246.field_10114)).parentBlock(class_2246.field_10114));
		putInDatagenArgs(ModBlocks.VERTICAL_SOUL_SOIL_SLAB, new DatagenArgs().blockTags(class_3481.field_33716).textureMap(class_4944.method_25864(class_2246.field_22090)).parentBlock(class_2246.field_22090));
		putInDatagenArgs(ModBlocks.VERTICAL_SOUL_SOIL_STAIRS, new DatagenArgs().blockTags(class_3481.field_33716).textureMap(class_4944.method_25864(class_2246.field_22090)).parentBlock(class_2246.field_22090));
		putInDatagenArgs(ModBlocks.VERTICAL_BONE_BLOCK_SLAB, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(sideAndTopForEnds(class_2246.field_10166)).parentBlock(class_2246.field_10166));
		putInDatagenArgs(ModBlocks.VERTICAL_BONE_BLOCK_STAIRS, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(sideAndTopForEnds(class_2246.field_10166)).parentBlock(class_2246.field_10166));
		putInDatagenArgs(ModBlocks.VERTICAL_COAL_ORE_SLAB, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_10418)).parentBlock(class_2246.field_10418));
		putInDatagenArgs(ModBlocks.VERTICAL_COAL_ORE_STAIRS, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_10418)).parentBlock(class_2246.field_10418));
		putInDatagenArgs(ModBlocks.VERTICAL_DEEPSLATE_COAL_ORE_SLAB, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_29219)).parentBlock(class_2246.field_29219));
		putInDatagenArgs(ModBlocks.VERTICAL_DEEPSLATE_COAL_ORE_STAIRS, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_29219)).parentBlock(class_2246.field_29219));
		putInDatagenArgs(ModBlocks.VERTICAL_IRON_ORE_SLAB, new DatagenArgs().blockTags(class_3481.field_33719, class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_10212)).parentBlock(class_2246.field_10212));
		putInDatagenArgs(ModBlocks.VERTICAL_IRON_ORE_STAIRS, new DatagenArgs().blockTags(class_3481.field_33719, class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_10212)).parentBlock(class_2246.field_10212));
		putInDatagenArgs(ModBlocks.VERTICAL_DEEPSLATE_IRON_ORE_SLAB, new DatagenArgs().blockTags(class_3481.field_33719, class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_29027)).parentBlock(class_2246.field_29027));
		putInDatagenArgs(ModBlocks.VERTICAL_DEEPSLATE_IRON_ORE_STAIRS, new DatagenArgs().blockTags(class_3481.field_33719, class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_29027)).parentBlock(class_2246.field_29027));
		putInDatagenArgs(ModBlocks.VERTICAL_COPPER_ORE_SLAB, new DatagenArgs().blockTags(class_3481.field_33719, class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_27120)).parentBlock(class_2246.field_27120));
		putInDatagenArgs(ModBlocks.VERTICAL_COPPER_ORE_STAIRS, new DatagenArgs().blockTags(class_3481.field_33719, class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_27120)).parentBlock(class_2246.field_27120));
		putInDatagenArgs(ModBlocks.VERTICAL_DEEPSLATE_COPPER_ORE_SLAB, new DatagenArgs().blockTags(class_3481.field_33719, class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_29221)).parentBlock(class_2246.field_29221));
		putInDatagenArgs(ModBlocks.VERTICAL_DEEPSLATE_COPPER_ORE_STAIRS, new DatagenArgs().blockTags(class_3481.field_33719, class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_29221)).parentBlock(class_2246.field_29221));
		putInDatagenArgs(ModBlocks.VERTICAL_GOLD_ORE_SLAB, new DatagenArgs().blockTags(class_3481.field_33718, class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_10571)).parentBlock(class_2246.field_10571));
		putInDatagenArgs(ModBlocks.VERTICAL_GOLD_ORE_STAIRS, new DatagenArgs().blockTags(class_3481.field_33718, class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_10571)).parentBlock(class_2246.field_10571));
		putInDatagenArgs(ModBlocks.VERTICAL_DEEPSLATE_GOLD_ORE_SLAB, new DatagenArgs().blockTags(class_3481.field_33718, class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_29026)).parentBlock(class_2246.field_29026));
		putInDatagenArgs(ModBlocks.VERTICAL_DEEPSLATE_GOLD_ORE_STAIRS, new DatagenArgs().blockTags(class_3481.field_33718, class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_29026)).parentBlock(class_2246.field_29026));
		putInDatagenArgs(ModBlocks.VERTICAL_REDSTONE_ORE_SLAB, new DatagenArgs().blockTags(class_3481.field_33718, class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_10080)).parentBlock(class_2246.field_10080));
		putInDatagenArgs(ModBlocks.VERTICAL_REDSTONE_ORE_STAIRS, new DatagenArgs().blockTags(class_3481.field_33718, class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_10080)).parentBlock(class_2246.field_10080));
		putInDatagenArgs(ModBlocks.VERTICAL_DEEPSLATE_REDSTONE_ORE_SLAB, new DatagenArgs().blockTags(class_3481.field_33718, class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_29030)).parentBlock(class_2246.field_29030));
		putInDatagenArgs(ModBlocks.VERTICAL_DEEPSLATE_REDSTONE_ORE_STAIRS, new DatagenArgs().blockTags(class_3481.field_33718, class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_29030)).parentBlock(class_2246.field_29030));
		putInDatagenArgs(ModBlocks.VERTICAL_EMERALD_ORE_SLAB, new DatagenArgs().blockTags(class_3481.field_33718, class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_10013)).parentBlock(class_2246.field_10013));
		putInDatagenArgs(ModBlocks.VERTICAL_EMERALD_ORE_STAIRS, new DatagenArgs().blockTags(class_3481.field_33718, class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_10013)).parentBlock(class_2246.field_10013));
		putInDatagenArgs(ModBlocks.VERTICAL_DEEPSLATE_EMERALD_ORE_SLAB, new DatagenArgs().blockTags(class_3481.field_33718, class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_29220)).parentBlock(class_2246.field_29220));
		putInDatagenArgs(ModBlocks.VERTICAL_DEEPSLATE_EMERALD_ORE_STAIRS, new DatagenArgs().blockTags(class_3481.field_33718, class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_29220)).parentBlock(class_2246.field_29220));
		putInDatagenArgs(ModBlocks.VERTICAL_LAPIS_ORE_SLAB, new DatagenArgs().blockTags(class_3481.field_33719, class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_10090)).parentBlock(class_2246.field_10090));
		putInDatagenArgs(ModBlocks.VERTICAL_LAPIS_ORE_STAIRS, new DatagenArgs().blockTags(class_3481.field_33719, class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_10090)).parentBlock(class_2246.field_10090));
		putInDatagenArgs(ModBlocks.VERTICAL_DEEPSLATE_LAPIS_ORE_SLAB, new DatagenArgs().blockTags(class_3481.field_33719, class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_29028)).parentBlock(class_2246.field_29028));
		putInDatagenArgs(ModBlocks.VERTICAL_DEEPSLATE_LAPIS_ORE_STAIRS, new DatagenArgs().blockTags(class_3481.field_33719, class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_29028)).parentBlock(class_2246.field_29028));
		putInDatagenArgs(ModBlocks.VERTICAL_DIAMOND_ORE_SLAB, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_10442)).parentBlock(class_2246.field_10442));
		putInDatagenArgs(ModBlocks.VERTICAL_DIAMOND_ORE_STAIRS, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_10442)).parentBlock(class_2246.field_10442));
		putInDatagenArgs(ModBlocks.VERTICAL_DEEPSLATE_DIAMOND_ORE_SLAB, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_29029)).parentBlock(class_2246.field_29029));
		putInDatagenArgs(ModBlocks.VERTICAL_DEEPSLATE_DIAMOND_ORE_STAIRS, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_29029)).parentBlock(class_2246.field_29029));
		putInDatagenArgs(ModBlocks.VERTICAL_NETHER_GOLD_ORE_SLAB, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_23077)).parentBlock(class_2246.field_23077));
		putInDatagenArgs(ModBlocks.VERTICAL_NETHER_GOLD_ORE_STAIRS, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_23077)).parentBlock(class_2246.field_23077));
		putInDatagenArgs(ModBlocks.VERTICAL_NETHER_QUARTZ_ORE_SLAB, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_10213)).parentBlock(class_2246.field_10213));
		putInDatagenArgs(ModBlocks.VERTICAL_NETHER_QUARTZ_ORE_STAIRS, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_10213)).parentBlock(class_2246.field_10213));
		putInDatagenArgs(ModBlocks.VERTICAL_ANCIENT_DEBRIS_SLAB, new DatagenArgs().blockTags(class_3481.field_33717, class_3481.field_33715).textureMap(sideAndTopForEnds(class_2246.field_22109)).parentBlock(class_2246.field_22109));
		putInDatagenArgs(ModBlocks.VERTICAL_ANCIENT_DEBRIS_STAIRS, new DatagenArgs().blockTags(class_3481.field_33717, class_3481.field_33715).textureMap(sideAndTopForEnds(class_2246.field_22109)).parentBlock(class_2246.field_22109));
		putInDatagenArgs(ModBlocks.VERTICAL_RAW_IRON_BLOCK_SLAB, new DatagenArgs().blockTags(class_3481.field_33719, class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_33508)).parentBlock(class_2246.field_33508));
		putInDatagenArgs(ModBlocks.VERTICAL_RAW_IRON_BLOCK_STAIRS, new DatagenArgs().blockTags(class_3481.field_33719, class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_33508)).parentBlock(class_2246.field_33508));
		putInDatagenArgs(ModBlocks.VERTICAL_RAW_COPPER_BLOCK_SLAB, new DatagenArgs().blockTags(class_3481.field_33719, class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_33509)).parentBlock(class_2246.field_33509));
		putInDatagenArgs(ModBlocks.VERTICAL_RAW_COPPER_BLOCK_STAIRS, new DatagenArgs().blockTags(class_3481.field_33719, class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_33509)).parentBlock(class_2246.field_33509));
		putInDatagenArgs(ModBlocks.VERTICAL_RAW_GOLD_BLOCK_SLAB, new DatagenArgs().blockTags(class_3481.field_33718, class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_33510)).parentBlock(class_2246.field_33509));
		putInDatagenArgs(ModBlocks.VERTICAL_RAW_GOLD_BLOCK_STAIRS, new DatagenArgs().blockTags(class_3481.field_33718, class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_33510)).parentBlock(class_2246.field_33509));
		putInDatagenArgs(ModBlocks.VERTICAL_GLOWSTONE_SLAB, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_10171)).parentBlock(class_2246.field_10171));
		putInDatagenArgs(ModBlocks.VERTICAL_GLOWSTONE_STAIRS, new DatagenArgs().blockTags(class_3481.field_33715).textureMap(class_4944.method_25864(class_2246.field_10171)).parentBlock(class_2246.field_10171));
		putInDatagenArgs(ModBlocks.VERTICAL_OAK_LEAVES_SLAB, new DatagenArgs().blockTags(class_3481.field_33714, class_3481.field_15503).textureMap(class_4944.method_25864(class_2246.field_10503)).parentBlock(class_2246.field_10503).tintSource(new class_10396(-12012264)));
		putInDatagenArgs(ModBlocks.VERTICAL_OAK_LEAVES_STAIRS, new DatagenArgs().copy(ModBlocks.VERTICAL_OAK_LEAVES_SLAB));
		putInDatagenArgs(ModBlocks.VERTICAL_SPRUCE_LEAVES_SLAB, new DatagenArgs().blockTags(class_3481.field_33714, class_3481.field_15503).textureMap(class_4944.method_25864(class_2246.field_9988)).parentBlock(class_2246.field_9988).tintSource(new class_10396(-10380959)));
		putInDatagenArgs(ModBlocks.VERTICAL_SPRUCE_LEAVES_STAIRS, new DatagenArgs().copy(ModBlocks.VERTICAL_SPRUCE_LEAVES_SLAB));
		putInDatagenArgs(ModBlocks.VERTICAL_BIRCH_LEAVES_SLAB, new DatagenArgs().blockTags(class_3481.field_33714, class_3481.field_15503).textureMap(class_4944.method_25864(class_2246.field_10539)).parentBlock(class_2246.field_10539).tintSource(new class_10396(-8345771)));
		putInDatagenArgs(ModBlocks.VERTICAL_BIRCH_LEAVES_STAIRS, new DatagenArgs().copy(ModBlocks.VERTICAL_BIRCH_LEAVES_SLAB));
		putInDatagenArgs(ModBlocks.VERTICAL_JUNGLE_LEAVES_SLAB, new DatagenArgs().blockTags(class_3481.field_33714, class_3481.field_15503).textureMap(class_4944.method_25864(class_2246.field_10335)).parentBlock(class_2246.field_10335).tintSource(new class_10396(-12012264)));
		putInDatagenArgs(ModBlocks.VERTICAL_JUNGLE_LEAVES_STAIRS, new DatagenArgs().copy(ModBlocks.VERTICAL_JUNGLE_LEAVES_SLAB));
		putInDatagenArgs(ModBlocks.VERTICAL_ACACIA_LEAVES_SLAB, new DatagenArgs().blockTags(class_3481.field_33714, class_3481.field_15503).textureMap(class_4944.method_25864(class_2246.field_10098)).parentBlock(class_2246.field_10098).tintSource(new class_10396(-12012264)));
		putInDatagenArgs(ModBlocks.VERTICAL_ACACIA_LEAVES_STAIRS, new DatagenArgs().copy(ModBlocks.VERTICAL_ACACIA_LEAVES_SLAB));
		putInDatagenArgs(ModBlocks.VERTICAL_DARK_OAK_LEAVES_SLAB, new DatagenArgs().blockTags(class_3481.field_33714, class_3481.field_15503).textureMap(class_4944.method_25864(class_2246.field_10035)).parentBlock(class_2246.field_10035).tintSource(new class_10396(-12012264)));
		putInDatagenArgs(ModBlocks.VERTICAL_DARK_OAK_LEAVES_STAIRS, new DatagenArgs().copy(ModBlocks.VERTICAL_DARK_OAK_LEAVES_SLAB));
		putInDatagenArgs(ModBlocks.VERTICAL_MANGROVE_LEAVES_SLAB, new DatagenArgs().blockTags(class_3481.field_33714, class_3481.field_15503).textureMap(class_4944.method_25864(class_2246.field_37551)).parentBlock(class_2246.field_37551).tintSource(new class_10396(-7158200)));
		putInDatagenArgs(ModBlocks.VERTICAL_MANGROVE_LEAVES_STAIRS, new DatagenArgs().copy(ModBlocks.VERTICAL_MANGROVE_LEAVES_SLAB));
		putInDatagenArgs(ModBlocks.VERTICAL_CHERRY_LEAVES_SLAB, new DatagenArgs().blockTags(class_3481.field_33714, class_3481.field_15503).textureMap(class_4944.method_25864(class_2246.field_42731)).parentBlock(class_2246.field_42731));
		putInDatagenArgs(ModBlocks.VERTICAL_CHERRY_LEAVES_STAIRS, new DatagenArgs().copy(ModBlocks.VERTICAL_CHERRY_LEAVES_SLAB));
		putInDatagenArgs(ModBlocks.VERTICAL_PALE_OAK_LEAVES_SLAB, new DatagenArgs().blockTags(class_3481.field_33714, class_3481.field_15503).textureMap(class_4944.method_25864(class_2246.field_54714)).parentBlock(class_2246.field_54714));
		putInDatagenArgs(ModBlocks.VERTICAL_PALE_OAK_LEAVES_STAIRS, new DatagenArgs().copy(ModBlocks.VERTICAL_PALE_OAK_LEAVES_SLAB));
		putInDatagenArgs(ModBlocks.VERTICAL_AZALEA_LEAVES_SLAB, new DatagenArgs().blockTags(class_3481.field_33714, class_3481.field_15503).textureMap(class_4944.method_25864(class_2246.field_28673)).parentBlock(class_2246.field_28673));
		putInDatagenArgs(ModBlocks.VERTICAL_AZALEA_LEAVES_STAIRS, new DatagenArgs().copy(ModBlocks.VERTICAL_AZALEA_LEAVES_SLAB));
		putInDatagenArgs(ModBlocks.VERTICAL_FLOWERING_AZALEA_LEAVES_SLAB, new DatagenArgs().blockTags(class_3481.field_33714, class_3481.field_15503).textureMap(class_4944.method_25864(class_2246.field_28674)).parentBlock(class_2246.field_28674));
		putInDatagenArgs(ModBlocks.VERTICAL_FLOWERING_AZALEA_LEAVES_STAIRS, new DatagenArgs().copy(ModBlocks.VERTICAL_FLOWERING_AZALEA_LEAVES_SLAB));
		putInDatagenArgs(ModBlocks.VERTICAL_BROWN_MUSHROOM_SLAB, new DatagenArgs().blockTags(class_3481.field_33713).parentBlock(class_2246.field_10580));
		putInDatagenArgs(ModBlocks.VERTICAL_BROWN_MUSHROOM_STAIRS, new DatagenArgs().copy(ModBlocks.VERTICAL_BROWN_MUSHROOM_SLAB).textureMap(class_4944.method_25864(class_2246.field_10580)));
		putInDatagenArgs(ModBlocks.VERTICAL_RED_MUSHROOM_SLAB, new DatagenArgs().blockTags(class_3481.field_33713).parentBlock(class_2246.field_10240));
		putInDatagenArgs(ModBlocks.VERTICAL_RED_MUSHROOM_STAIRS, new DatagenArgs().copy(ModBlocks.VERTICAL_RED_MUSHROOM_SLAB).textureMap(class_4944.method_25864(class_2246.field_10240)));
		putInDatagenArgs(ModBlocks.VERTICAL_NETHER_WART_SLAB, new DatagenArgs().blockTags(class_3481.field_33714).textureMap(class_4944.method_25864(class_2246.field_10541)).parentBlock(class_2246.field_10541));
		putInDatagenArgs(ModBlocks.VERTICAL_NETHER_WART_STAIRS, new DatagenArgs().copy(ModBlocks.VERTICAL_NETHER_WART_SLAB));
		putInDatagenArgs(ModBlocks.VERTICAL_WARPED_WART_SLAB, new DatagenArgs().blockTags(class_3481.field_33714).textureMap(class_4944.method_25864(class_2246.field_22115)).parentBlock(class_2246.field_22115));
		putInDatagenArgs(ModBlocks.VERTICAL_WARPED_WART_STAIRS, new DatagenArgs().copy(ModBlocks.VERTICAL_WARPED_WART_SLAB));
		putInDatagenArgs(ModBlocks.VERTICAL_SHROOMLIGHT_SLAB, new DatagenArgs().blockTags(class_3481.field_33714).textureMap(class_4944.method_25864(class_2246.field_22122)).parentBlock(class_2246.field_22122));
		putInDatagenArgs(ModBlocks.VERTICAL_SHROOMLIGHT_STAIRS, new DatagenArgs().copy(ModBlocks.VERTICAL_SHROOMLIGHT_SLAB));
		putInDatagenArgs(ModBlocks.VERTICAL_DRIED_KELP_SLAB, new DatagenArgs().blockTags(class_3481.field_33714).textureMap(blockSTB(class_2960.method_60656("block/dried_kelp"))).parentBlock(class_2246.field_10342));
		putInDatagenArgs(ModBlocks.VERTICAL_DRIED_KELP_STAIRS, new DatagenArgs().copy(ModBlocks.VERTICAL_DRIED_KELP_SLAB));
		putInDatagenArgs(ModBlocks.VERTICAL_DEAD_TUBE_CORAL_SLAB, new DatagenArgs().blockTags(class_3481.field_33714).textureMap(class_4944.method_25864(class_2246.field_10614)).parentBlock(class_2246.field_10614));
		putInDatagenArgs(ModBlocks.VERTICAL_DEAD_TUBE_CORAL_STAIRS, new DatagenArgs().copy(ModBlocks.VERTICAL_DEAD_TUBE_CORAL_SLAB));
		putInDatagenArgs(ModBlocks.VERTICAL_DEAD_BRAIN_CORAL_SLAB, new DatagenArgs().blockTags(class_3481.field_33714).textureMap(class_4944.method_25864(class_2246.field_10264)).parentBlock(class_2246.field_10264));
		putInDatagenArgs(ModBlocks.VERTICAL_DEAD_BRAIN_CORAL_STAIRS, new DatagenArgs().copy(ModBlocks.VERTICAL_DEAD_BRAIN_CORAL_SLAB));
		putInDatagenArgs(ModBlocks.VERTICAL_DEAD_BUBBLE_CORAL_SLAB, new DatagenArgs().blockTags(class_3481.field_33714).textureMap(class_4944.method_25864(class_2246.field_10396)).parentBlock(class_2246.field_10396));
		putInDatagenArgs(ModBlocks.VERTICAL_DEAD_BUBBLE_CORAL_STAIRS, new DatagenArgs().copy(ModBlocks.VERTICAL_DEAD_BUBBLE_CORAL_SLAB));
		putInDatagenArgs(ModBlocks.VERTICAL_DEAD_FIRE_CORAL_SLAB, new DatagenArgs().blockTags(class_3481.field_33714).textureMap(class_4944.method_25864(class_2246.field_10111)).parentBlock(class_2246.field_10111));
		putInDatagenArgs(ModBlocks.VERTICAL_DEAD_FIRE_CORAL_STAIRS, new DatagenArgs().copy(ModBlocks.VERTICAL_DEAD_FIRE_CORAL_SLAB));
		putInDatagenArgs(ModBlocks.VERTICAL_DEAD_HORN_CORAL_SLAB, new DatagenArgs().blockTags(class_3481.field_33714).textureMap(class_4944.method_25864(class_2246.field_10488)).parentBlock(class_2246.field_10488));
		putInDatagenArgs(ModBlocks.VERTICAL_DEAD_HORN_CORAL_STAIRS, new DatagenArgs().copy(ModBlocks.VERTICAL_DEAD_HORN_CORAL_SLAB));
		putInDatagenArgs(ModBlocks.VERTICAL_TUBE_CORAL_SLAB, new DatagenArgs().blockTags(class_3481.field_33714, class_3481.field_15461).textureMap(class_4944.method_25864(class_2246.field_10309)).parentBlock(class_2246.field_10309));
		putInDatagenArgs(ModBlocks.VERTICAL_TUBE_CORAL_STAIRS, new DatagenArgs().copy(ModBlocks.VERTICAL_TUBE_CORAL_SLAB));
		putInDatagenArgs(ModBlocks.VERTICAL_BRAIN_CORAL_SLAB, new DatagenArgs().blockTags(class_3481.field_33714, class_3481.field_15461).textureMap(class_4944.method_25864(class_2246.field_10629)).parentBlock(class_2246.field_10629));
		putInDatagenArgs(ModBlocks.VERTICAL_BRAIN_CORAL_STAIRS, new DatagenArgs().copy(ModBlocks.VERTICAL_BRAIN_CORAL_SLAB));
		putInDatagenArgs(ModBlocks.VERTICAL_BUBBLE_CORAL_SLAB, new DatagenArgs().blockTags(class_3481.field_33714, class_3481.field_15461).textureMap(class_4944.method_25864(class_2246.field_10000)).parentBlock(class_2246.field_10000));
		putInDatagenArgs(ModBlocks.VERTICAL_BUBBLE_CORAL_STAIRS, new DatagenArgs().copy(ModBlocks.VERTICAL_BUBBLE_CORAL_SLAB));
		putInDatagenArgs(ModBlocks.VERTICAL_FIRE_CORAL_SLAB, new DatagenArgs().blockTags(class_3481.field_33714, class_3481.field_15461).textureMap(class_4944.method_25864(class_2246.field_10516)).parentBlock(class_2246.field_10516));
		putInDatagenArgs(ModBlocks.VERTICAL_FIRE_CORAL_STAIRS, new DatagenArgs().copy(ModBlocks.VERTICAL_FIRE_CORAL_SLAB));
		putInDatagenArgs(ModBlocks.VERTICAL_HORN_CORAL_SLAB, new DatagenArgs().blockTags(class_3481.field_33714, class_3481.field_15461).textureMap(class_4944.method_25864(class_2246.field_10464)).parentBlock(class_2246.field_10464));
		putInDatagenArgs(ModBlocks.VERTICAL_HORN_CORAL_STAIRS, new DatagenArgs().copy(ModBlocks.VERTICAL_HORN_CORAL_SLAB));
		putInDatagenArgs(ModBlocks.VERTICAL_WET_SPONGE_SLAB, new DatagenArgs().blockTags(class_3481.field_33714).textureMap(class_4944.method_25864(class_2246.field_10562)).parentBlock(class_2246.field_10562));
		putInDatagenArgs(ModBlocks.VERTICAL_WET_SPONGE_STAIRS, new DatagenArgs().copy(ModBlocks.VERTICAL_WET_SPONGE_SLAB));
		putInDatagenArgs(ModBlocks.VERTICAL_SPONGE_SLAB, new DatagenArgs().blockTags(class_3481.field_33714).textureMap(class_4944.method_25864(class_2246.field_10258)).parentBlock(class_2246.field_10258));
		putInDatagenArgs(ModBlocks.VERTICAL_SPONGE_STAIRS, new DatagenArgs().copy(ModBlocks.VERTICAL_SPONGE_SLAB));
		putInDatagenArgs(ModBlocks.VERTICAL_MELON_SLAB, new DatagenArgs().blockTags(class_3481.field_33713).textureMap(sideAndTopForEnds(class_2246.field_46283)).parentBlock(class_2246.field_46283));
		putInDatagenArgs(ModBlocks.VERTICAL_MELON_STAIRS, new DatagenArgs().copy(ModBlocks.VERTICAL_MELON_SLAB));
		putInDatagenArgs(ModBlocks.VERTICAL_PUMPKIN_SLAB, new DatagenArgs().blockTags(class_3481.field_33713).textureMap(sideAndTopForEnds(class_2246.field_46282)).parentBlock(class_2246.field_46282));
		putInDatagenArgs(ModBlocks.VERTICAL_PUMPKIN_STAIRS, new DatagenArgs().copy(ModBlocks.VERTICAL_PUMPKIN_SLAB));
		putInDatagenArgs(ModBlocks.VERTICAL_HAY_SLAB, new DatagenArgs().blockTags(class_3481.field_33714).textureMap(sideAndTopForEnds(class_2246.field_10359)).parentBlock(class_2246.field_10359));
		putInDatagenArgs(ModBlocks.VERTICAL_HAY_STAIRS, new DatagenArgs().copy(ModBlocks.VERTICAL_HAY_SLAB));
		putInDatagenArgs(ModBlocks.VERTICAL_HONEYCOMB_SLAB, new DatagenArgs().blockTags().textureMap(class_4944.method_25864(class_2246.field_21212)).parentBlock(class_2246.field_21212));
		putInDatagenArgs(ModBlocks.VERTICAL_HONEYCOMB_STAIRS, new DatagenArgs().copy(ModBlocks.VERTICAL_HONEYCOMB_SLAB));
		putInDatagenArgs(ModBlocks.VERTICAL_SLIME_SLAB, new DatagenArgs().blockTags().textureMap(class_4944.method_25864(class_2246.field_10030)).parentBlock(class_2246.field_10030));
		putInDatagenArgs(ModBlocks.VERTICAL_SLIME_STAIRS, new DatagenArgs().copy(ModBlocks.VERTICAL_SLIME_SLAB));
		putInDatagenArgs(ModBlocks.VERTICAL_HONEY_SLAB, new DatagenArgs().blockTags().textureMap(blockSTB(class_2246.field_21211)).parentBlock(class_2246.field_21211));
		putInDatagenArgs(ModBlocks.VERTICAL_HONEY_STAIRS, new DatagenArgs().copy(ModBlocks.VERTICAL_HONEY_SLAB));
		putInDatagenArgs(ModBlocks.VERTICAL_RESIN_SLAB, new DatagenArgs().blockTags().textureMap(class_4944.method_25864(class_2246.field_55053)).parentBlock(class_2246.field_55053));
		putInDatagenArgs(ModBlocks.VERTICAL_RESIN_STAIRS, new DatagenArgs().copy(ModBlocks.VERTICAL_RESIN_SLAB));
		putInDatagenArgs(ModBlocks.VERTICAL_OCHRE_FROGLIGHT_SLAB, new DatagenArgs().blockTags().textureMap(sideAndTopForEnds(class_2246.field_37572)).parentBlock(class_2246.field_37572));
		putInDatagenArgs(ModBlocks.VERTICAL_OCHRE_FROGLIGHT_STAIRS, new DatagenArgs().copy(ModBlocks.VERTICAL_OCHRE_FROGLIGHT_SLAB));
		putInDatagenArgs(ModBlocks.VERTICAL_VERDANT_FROGLIGHT_SLAB, new DatagenArgs().blockTags().textureMap(sideAndTopForEnds(class_2246.field_37573)).parentBlock(class_2246.field_37573));
		putInDatagenArgs(ModBlocks.VERTICAL_VERDANT_FROGLIGHT_STAIRS, new DatagenArgs().copy(ModBlocks.VERTICAL_VERDANT_FROGLIGHT_SLAB));
		putInDatagenArgs(ModBlocks.VERTICAL_PEARLESCENT_FROGLIGHT_SLAB, new DatagenArgs().blockTags().textureMap(sideAndTopForEnds(class_2246.field_37574)).parentBlock(class_2246.field_37574));
		putInDatagenArgs(ModBlocks.VERTICAL_PEARLESCENT_FROGLIGHT_STAIRS, new DatagenArgs().copy(ModBlocks.VERTICAL_PEARLESCENT_FROGLIGHT_SLAB));
		putInDatagenArgs(ModBlocks.VERTICAL_SCULK_SLAB, new DatagenArgs().blockTags(class_3481.field_33714).textureMap(class_4944.method_25864(class_2246.field_37568)).parentBlock(class_2246.field_37568));
		putInDatagenArgs(ModBlocks.VERTICAL_SCULK_STAIRS, new DatagenArgs().copy(ModBlocks.VERTICAL_SCULK_SLAB));
		putInDatagenArgs(ModBlocks.VERTICAL_BEDROCK_SLAB, new DatagenArgs().blockTags().textureMap(class_4944.method_25864(class_2246.field_9987)).parentBlock(class_2246.field_9987));
		putInDatagenArgs(ModBlocks.VERTICAL_BEDROCK_STAIRS, new DatagenArgs().copy(ModBlocks.VERTICAL_BEDROCK_SLAB));
		putInDatagenArgs(ModBlocks.VERTICAL_TARGET_SLAB, new DatagenArgs().blockTags().textureMap(sideAndTopForEnds(class_2246.field_22422)).parentBlock(class_2246.field_22422));
		putInDatagenArgs(ModBlocks.VERTICAL_TARGET_STAIRS, new DatagenArgs().copy(ModBlocks.VERTICAL_TARGET_SLAB));
	}
}
