package net.fellter.vanillavsplus.registry;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.class_10401;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_4944;
import net.minecraft.class_6862;

public class DatagenArgs {
	public List<class_6862<class_2248>> blockTags;
	public class_4944 textureMap;
	public class_2248 parentBlock;
	public class_2248 fullTextureBlock;
	public class_10401 tintSource;
	public Boolean y15 = false;
	public ArrayList<class_1935> stonecuttingInput = new ArrayList<>();
	public Boolean needsSilkTouch = false;

	public DatagenArgs() {
	}

	public DatagenArgs copy(class_2248 from) {
		if (!Args.DATAGEN_ARGS.containsKey(from)) {
			throw new NullPointerException("Couldn't find " + from.method_9518() + " in DatagenArgs source map.");
		} else {
			DatagenArgs oldArgs = Args.DATAGEN_ARGS.get(from);
			DatagenArgs newArgs = new DatagenArgs();
			newArgs.blockTags = oldArgs.blockTags;
			newArgs.textureMap = oldArgs.textureMap;
			newArgs.parentBlock = oldArgs.parentBlock;
			newArgs.fullTextureBlock = oldArgs.fullTextureBlock;
			newArgs.tintSource = oldArgs.tintSource;
			newArgs.y15 = oldArgs.y15;
			newArgs.stonecuttingInput = oldArgs.stonecuttingInput;
			newArgs.needsSilkTouch = oldArgs.needsSilkTouch;
			return newArgs;
		}
	}

	public DatagenArgs stonecutting(class_1935... stonecuttingInput) {
		this.stonecuttingInput.add(this.parentBlock);
		this.stonecuttingInput.addAll(Arrays.asList(stonecuttingInput));
		return this;
	}

	public DatagenArgs stonecutting() {
		this.stonecuttingInput.add(this.parentBlock);
		return this;
	}

	public DatagenArgs needsSilkTouch() {
		this.needsSilkTouch = true;
		return this;
	}

	@SafeVarargs
	public final DatagenArgs blockTags(class_6862<class_2248>... blockTags) {
		this.blockTags = List.of(blockTags);
		return this;
	}

	public DatagenArgs parentBlock(class_2248 parentBlock) {
		this.parentBlock = parentBlock;
		this.fullTextureBlock = parentBlock;
		return this;
	}

	public DatagenArgs parentBlock(class_2248 parentBlock, class_2248 fullTextureBlock) {
		this.parentBlock = parentBlock;
		this.fullTextureBlock = fullTextureBlock;
		return this;
	}

	public DatagenArgs textureMap(class_4944 textureMap) {
		this.textureMap = textureMap;
		return this;
	}

	public DatagenArgs tintSource(class_10401 tintSource) {
		this.tintSource = tintSource;
		return this;
	}

	public DatagenArgs y15() {
		this.y15 = true;
		return this;
	}
}
