package net.fellter.vanillavsplus.registry;

import java.util.Map;
import java.util.Objects;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;

import net.fellter.vanillavsplus.VanillaVSPlus;
import net.fellter.vanillavsplus.block.ModBlocks;
import net.minecraft.class_11515;
import net.minecraft.class_1163;
import net.minecraft.class_1794;
import net.minecraft.class_1802;
import net.minecraft.class_1926;
import net.minecraft.class_1933;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_7923;
import net.fabricmc.fabric.api.client.rendering.v1.BlockRenderLayerMap;
import net.fabricmc.fabric.api.client.rendering.v1.ColorProviderRegistry;
import net.fabricmc.fabric.api.registry.*;
import net.fabricmc.fabric.mixin.content.registry.ShovelItemAccessor;

public class ModRegistries {
	public static void registerFlammables() {
		class_7923.field_41175.method_10220().filter(VanillaVSPlus::isNamespaced).forEach(block -> {
			if (Args.REGISTRY_ARGS.containsKey(block)) {
				RegistryArgs args = Args.REGISTRY_ARGS.get(block);

				if (args.burn != null && args.spread != null) {
					FlammableBlockRegistry.getDefaultInstance().add(block, args.burn, args.spread);
				}
			}
		});
	}

	public static final Map<class_2248, class_2680> FLATTENED_TO_BLOCK_MAP = Maps.newHashMap(new ImmutableMap.Builder<class_2248, class_2680>().build());

	public static void registerFlattenableBlocks() {
		flattenedToBlock(ModBlocks.VERTICAL_DIRT_PATH_SLAB, ModBlocks.VERTICAL_DIRT_SLAB);
		flattenedToBlock(ModBlocks.VERTICAL_DIRT_PATH_STAIRS, ModBlocks.VERTICAL_DIRT_STAIRS);
		flattenedToBlock(ModBlocks.VERTICAL_FARMLAND_SLAB, ModBlocks.VERTICAL_DIRT_SLAB);
		flattenedToBlock(ModBlocks.VERTICAL_FARMLAND_STAIRS, ModBlocks.VERTICAL_DIRT_STAIRS);

		class_7923.field_41175.method_10220().filter(VanillaVSPlus::isNamespaced).forEach(block -> {
			if (Args.REGISTRY_ARGS.containsKey(block)) {
				RegistryArgs args = Args.REGISTRY_ARGS.get(block);

				if (args.flattened != null) {
					blockToFlattened(block, args.flattened);
				}
			}
		});
	}

	public static void blockToFlattened(class_2248 input, class_2248 flattened) {
		Objects.requireNonNull(input, "input block cannot be null");
		Objects.requireNonNull(flattened, "flattened block state cannot be null");
		class_2680 old = ShovelItemAccessor.getPathStates().put(input, flattened.method_9564());

		if (old != null) {
			VanillaVSPlus.LOGGER.debug("Replaced old flattening mapping from {} to {} with {}", input, old, flattened);
		}
	}

	public static void flattenedToBlock(class_2248 flattened, class_2248 output) {
		Objects.requireNonNull(flattened, "flattened block cannot be null");
		Objects.requireNonNull(output, "output block cannot be null");
		class_2680 old = FLATTENED_TO_BLOCK_MAP.put(flattened, output.method_9564());

		if (old != null) {
			VanillaVSPlus.LOGGER.debug("Replaced old block mapping from {} to {} with {}", flattened, old, output);
		}
	}

	public static void registerFoliage() {
		class_7923.field_41175.method_10220().filter(VanillaVSPlus::isNamespaced).forEach(block -> {
			if (Args.REGISTRY_ARGS.containsKey(block)) {
				RegistryArgs args = Args.REGISTRY_ARGS.get(block);

				if (args.grassTinted) {
					ColorProviderRegistry.BLOCK.register(((state, world, pos, tintIndex) ->
							world == null || pos == null ? class_1933.method_49724() : class_1163.method_4962(world, pos)), block);
				}

				if (args.foliageTinted) {
					ColorProviderRegistry.BLOCK.register(((state, world, pos, tintIndex) ->
									world == null || pos == null ? class_1926.field_55217 : class_1163.method_4966(world, pos)),
							block);
				}
			}
		});
	}

	public static void registerFuel() {
		class_7923.field_41175.method_10220().filter(VanillaVSPlus::isNamespaced).forEach(block -> {
			if (Args.REGISTRY_ARGS.containsKey(block) && Args.REGISTRY_ARGS.get(block).fuel) {
				FuelRegistryEvents.BUILD.register((builder, context) -> builder.method_61762(block, context.baseSmeltTime()));
			}
		});
	}

	public static void registerOxidizables() {
		class_7923.field_41175.method_10220().filter(VanillaVSPlus::isNamespaced).forEach(block -> {
			if (Args.REGISTRY_ARGS.containsKey(block)) {
				RegistryArgs args = Args.REGISTRY_ARGS.get(block);

				if (args.oxidizables != null) {
					OxidizableBlocksRegistry.registerOxidizableBlockPair(block, args.exposed);
					OxidizableBlocksRegistry.registerOxidizableBlockPair(args.exposed, args.weathered);
					OxidizableBlocksRegistry.registerOxidizableBlockPair(args.weathered, args.oxidized);

					OxidizableBlocksRegistry.registerWaxableBlockPair(block, args.waxed);
					OxidizableBlocksRegistry.registerWaxableBlockPair(args.exposed, args.exposedWaxed);
					OxidizableBlocksRegistry.registerWaxableBlockPair(args.weathered, args.weatheredWaxed);
					OxidizableBlocksRegistry.registerWaxableBlockPair(args.oxidized, args.oxidizedWaxed);
				}
			}
		});
	}

	public static void registerTillableBlocks() {
		TillableBlockRegistry.register(ModBlocks.VERTICAL_ROOTED_DIRT_SLAB, context -> true, class_1794.method_36985(ModBlocks.VERTICAL_DIRT_SLAB.method_9564(), class_1802.field_28656));
		TillableBlockRegistry.register(ModBlocks.VERTICAL_ROOTED_DIRT_STAIRS, context -> true, class_1794.method_36985(ModBlocks.VERTICAL_DIRT_STAIRS.method_9564(), class_1802.field_28656));
		TillableBlockRegistry.register(ModBlocks.VERTICAL_COARSE_DIRT_SLAB, context -> true, class_1794.method_36988(ModBlocks.VERTICAL_DIRT_SLAB.method_9564()));
		TillableBlockRegistry.register(ModBlocks.VERTICAL_COARSE_DIRT_STAIRS, context -> true, class_1794.method_36988(ModBlocks.VERTICAL_DIRT_STAIRS.method_9564()));

		class_7923.field_41175.method_10220().filter(VanillaVSPlus::isNamespaced).forEach(block -> {
			if (Args.REGISTRY_ARGS.containsKey(block)) {
				RegistryArgs args = Args.REGISTRY_ARGS.get(block);

				if (args.tilled != null && args.tillDrop != null) {
					TillableBlockRegistry.register(block, class_1794::method_36987, class_1794.method_36985(args.tilled.method_9564(), args.tillDrop));
				}

				if (args.tilled != null) {
					TillableBlockRegistry.register(block, class_1794::method_36987, class_1794.method_36988(args.tilled.method_9564()));
				}
			}
		});
	}

	public static void registerTranslucentBlocks() {
		class_7923.field_41175.method_10220().filter(VanillaVSPlus::isNamespaced).forEach(block -> {
			if (Args.REGISTRY_ARGS.containsKey(block) && Args.REGISTRY_ARGS.get(block).translucent) {
				BlockRenderLayerMap.putBlock(block, class_11515.field_60926);
			}
		});
	}

	public static void registerTransparentBlocks() {
		class_7923.field_41175.method_10220().filter(VanillaVSPlus::isNamespaced).forEach(block -> {
			if (Args.REGISTRY_ARGS.containsKey(block) && Args.REGISTRY_ARGS.get(block).transparent) {
				BlockRenderLayerMap.putBlock(block, class_11515.field_60925);
			}
		});
	}

	public static void registerStrippableBlocks() {
		class_7923.field_41175.method_10220().filter(VanillaVSPlus::isNamespaced).forEach(block -> {
			if (Args.REGISTRY_ARGS.containsKey(block) && Args.REGISTRY_ARGS.get(block).stripped != null) {
				StrippableBlockRegistry.registerCopyState(block, Args.REGISTRY_ARGS.get(block).stripped);
			}
		});
	}
}
