package net.fellter.vanillavsplus.registry;

import java.util.List;
import java.util.Objects;
import net.minecraft.class_1935;
import net.minecraft.class_2248;

public class RegistryArgs {
	public Boolean transparent = false;
	public Boolean translucent = false;
	public class_2248 stripped;
	public Integer burn;
	public Integer spread;
	public class_2248 exposed;
	public class_2248 weathered;
	public class_2248 oxidized;
	public class_2248 waxed;
	public class_2248 exposedWaxed;
	public class_2248 weatheredWaxed;
	public class_2248 oxidizedWaxed;
	public List<class_2248> oxidizables;
	public Boolean fuel = false;
	public class_2248 tilled;
	public class_1935 tillDrop;
	public Boolean grassTinted = false;
	public Boolean foliageTinted = false;
	public class_2248 flattened;

	public RegistryArgs() {
	}

	public RegistryArgs copy(class_2248 from) {
		if (!Args.REGISTRY_ARGS.containsKey(from)) {
			throw new NullPointerException("Couldn't find " + from.method_9518() + " in RegistryArgs source map.");
		} else {
			RegistryArgs args = Args.REGISTRY_ARGS.get(from);
			RegistryArgs newArgs = new RegistryArgs();
			newArgs.transparent = args.transparent;
			newArgs.translucent = args.translucent;
			newArgs.stripped = args.stripped;
			newArgs.burn = args.burn;
			newArgs.spread = args.spread;
			newArgs.exposed = args.exposed;
			newArgs.weathered = args.weathered;
			newArgs.oxidized = args.oxidized;
			newArgs.waxed = args.waxed;
			newArgs.exposedWaxed = args.exposedWaxed;
			newArgs.weatheredWaxed = args.weatheredWaxed;
			newArgs.oxidizedWaxed = args.oxidizedWaxed;
			newArgs.oxidizables = args.oxidizables;
			newArgs.fuel = args.fuel;
			newArgs.tilled = args.tilled;
			newArgs.tillDrop = args.tillDrop;
			newArgs.grassTinted = args.grassTinted;
			newArgs.flattened = args.flattened;
			newArgs.foliageTinted = args.foliageTinted;
			return newArgs;
		}
	}

	public RegistryArgs flattenable(class_2248 flattened) {
		this.flattened = flattened;
		return this;
	}

	public RegistryArgs foliageTinted() {
		this.foliageTinted = true;
		return this;
	}

	public RegistryArgs transparent() {
		this.transparent = true;
		return this;
	}

	public RegistryArgs translucent() {
		this.translucent = true;
		return this;
	}

	public RegistryArgs strippable(class_2248 stripped) {
		this.stripped = stripped;
		return this;
	}

	public RegistryArgs flammable(Integer burn, Integer spread) {
		this.burn = burn;
		this.spread = spread;
		return this;
	}

	public RegistryArgs tillable(class_2248 tilled) {
		this.tilled = tilled;
		return this;
	}

	public RegistryArgs tillableWithDrop(class_2248 tilled, class_1935 tillDrop) {
		this.tilled = tilled;
		this.tillDrop = tillDrop;
		return this;
	}

	public RegistryArgs grassTinted() {
		this.grassTinted = true;
		return this;
	}

	public RegistryArgs oxidizable(class_2248 exposed, class_2248 weathered, class_2248 oxidized, class_2248 waxed, class_2248 exposedWaxed, class_2248 weatheredWaxed, class_2248 oxidizedWaxed) {
		this.exposed = Objects.requireNonNull(exposed);
		this.weathered = Objects.requireNonNull(weathered);
		this.oxidized = Objects.requireNonNull(oxidized);
		this.waxed = Objects.requireNonNull(waxed);
		this.exposedWaxed = Objects.requireNonNull(exposedWaxed);
		this.weatheredWaxed = Objects.requireNonNull(weatheredWaxed);
		this.oxidizedWaxed = Objects.requireNonNull(oxidizedWaxed);
		this.oxidizables = List.of(exposed, weathered, oxidized, waxed, exposedWaxed, weatheredWaxed, oxidizedWaxed);
		return this;
	}

	public RegistryArgs fuel() {
		this.fuel = true;
		return this;
	}

	public static class RegistryProperty<T> {
		private T value;

		public RegistryProperty(T value) {
			this.value = value;
		}

		public RegistryProperty<?> of(T value) {
			return new RegistryProperty<>(value);
		}

		public T get() {
			if (value != null) return value;
			return null;
		}

		public void setValue(T value) {
			this.value = value;
		}
	}
}
