/*
 * Decompiled with CFR 0.152.
 */
package net.fellter.vanillavsplus.registry;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.client.rendering.v1.BlockRenderLayerMap;
import net.fabricmc.fabric.api.client.rendering.v1.ColorProviderRegistry;
import net.fabricmc.fabric.api.registry.FlammableBlockRegistry;
import net.fabricmc.fabric.api.registry.FuelRegistryEvents;
import net.fabricmc.fabric.api.registry.OxidizableBlocksRegistry;
import net.fabricmc.fabric.api.registry.StrippableBlockRegistry;
import net.fabricmc.fabric.api.registry.TillableBlockRegistry;
import net.fabricmc.fabric.mixin.content.registry.ShovelItemAccessor;
import net.fellter.vanillavsplus.VanillaVSPlus;
import net.fellter.vanillavsplus.block.ModBlocks;
import net.fellter.vanillavsplus.registry.Args;
import net.fellter.vanillavsplus.registry.RegistryArgs;
import net.minecraft.class_11515;
import net.minecraft.class_1163;
import net.minecraft.class_1794;
import net.minecraft.class_1802;
import net.minecraft.class_1920;
import net.minecraft.class_1933;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_7923;

public class ModRegistries {
    public static final Map<class_2248, class_2680> FLATTENED_TO_BLOCK_MAP = Maps.newHashMap((Map)new ImmutableMap.Builder().build());

    public static void registerFlammables() {
        class_7923.field_41175.method_10220().filter(VanillaVSPlus::isNamespaced).forEach(block -> {
            if (Args.REGISTRY_ARGS.containsKey(block)) {
                RegistryArgs args = Args.REGISTRY_ARGS.get(block);
                if (args.burn != null && args.spread != null) {
                    FlammableBlockRegistry.getDefaultInstance().add(block, args.burn.intValue(), args.spread.intValue());
                }
            }
        });
    }

    public static void registerFlattenableBlocks() {
        ModRegistries.flattenedToBlock(ModBlocks.VERTICAL_DIRT_PATH_SLAB, ModBlocks.VERTICAL_DIRT_SLAB);
        ModRegistries.flattenedToBlock(ModBlocks.VERTICAL_DIRT_PATH_STAIRS, ModBlocks.VERTICAL_DIRT_STAIRS);
        ModRegistries.flattenedToBlock(ModBlocks.VERTICAL_FARMLAND_SLAB, ModBlocks.VERTICAL_DIRT_SLAB);
        ModRegistries.flattenedToBlock(ModBlocks.VERTICAL_FARMLAND_STAIRS, ModBlocks.VERTICAL_DIRT_STAIRS);
        class_7923.field_41175.method_10220().filter(VanillaVSPlus::isNamespaced).forEach(block -> {
            if (Args.REGISTRY_ARGS.containsKey(block)) {
                RegistryArgs args = Args.REGISTRY_ARGS.get(block);
                if (args.flattened != null) {
                    ModRegistries.blockToFlattened(block, args.flattened);
                }
            }
        });
    }

    public static void blockToFlattened(class_2248 input, class_2248 flattened) {
        Objects.requireNonNull(input, "input block cannot be null");
        Objects.requireNonNull(flattened, "flattened block state cannot be null");
        class_2680 old = ShovelItemAccessor.getPathStates().put(input, flattened.method_9564());
        if (old != null) {
            VanillaVSPlus.LOGGER.debug("Replaced old flattening mapping from {} to {} with {}", new Object[]{input, old, flattened});
        }
    }

    public static void flattenedToBlock(class_2248 flattened, class_2248 output) {
        Objects.requireNonNull(flattened, "flattened block cannot be null");
        Objects.requireNonNull(output, "output block cannot be null");
        class_2680 old = FLATTENED_TO_BLOCK_MAP.put(flattened, output.method_9564());
        if (old != null) {
            VanillaVSPlus.LOGGER.debug("Replaced old block mapping from {} to {} with {}", new Object[]{flattened, old, output});
        }
    }

    public static void registerFoliage() {
        class_7923.field_41175.method_10220().filter(VanillaVSPlus::isNamespaced).forEach(block -> {
            if (Args.REGISTRY_ARGS.containsKey(block)) {
                RegistryArgs args = Args.REGISTRY_ARGS.get(block);
                if (args.grassTinted.booleanValue()) {
                    ColorProviderRegistry.BLOCK.register((state, world, pos, tintIndex) -> world == null || pos == null ? class_1933.method_49724() : class_1163.method_4962((class_1920)world, (class_2338)pos), (Object[])new class_2248[]{block});
                }
                if (args.foliageTinted.booleanValue()) {
                    ColorProviderRegistry.BLOCK.register((state, world, pos, tintIndex) -> world == null || pos == null ? -12012264 : class_1163.method_4966((class_1920)world, (class_2338)pos), (Object[])new class_2248[]{block});
                }
            }
        });
    }

    public static void registerFuel() {
        class_7923.field_41175.method_10220().filter(VanillaVSPlus::isNamespaced).forEach(block -> {
            if (Args.REGISTRY_ARGS.containsKey(block) && Args.REGISTRY_ARGS.get((Object)block).fuel.booleanValue()) {
                FuelRegistryEvents.BUILD.register((builder, context) -> builder.method_61762((class_1935)block, context.baseSmeltTime()));
            }
        });
    }

    public static void registerOxidizables() {
        class_7923.field_41175.method_10220().filter(VanillaVSPlus::isNamespaced).forEach(block -> {
            if (Args.REGISTRY_ARGS.containsKey(block)) {
                RegistryArgs args = Args.REGISTRY_ARGS.get(block);
                if (args.oxidizables != null) {
                    OxidizableBlocksRegistry.registerOxidizableBlockPair((class_2248)block, (class_2248)args.exposed);
                    OxidizableBlocksRegistry.registerOxidizableBlockPair((class_2248)args.exposed, (class_2248)args.weathered);
                    OxidizableBlocksRegistry.registerOxidizableBlockPair((class_2248)args.weathered, (class_2248)args.oxidized);
                    OxidizableBlocksRegistry.registerWaxableBlockPair((class_2248)block, (class_2248)args.waxed);
                    OxidizableBlocksRegistry.registerWaxableBlockPair((class_2248)args.exposed, (class_2248)args.exposedWaxed);
                    OxidizableBlocksRegistry.registerWaxableBlockPair((class_2248)args.weathered, (class_2248)args.weatheredWaxed);
                    OxidizableBlocksRegistry.registerWaxableBlockPair((class_2248)args.oxidized, (class_2248)args.oxidizedWaxed);
                }
            }
        });
    }

    public static void registerTillableBlocks() {
        TillableBlockRegistry.register((class_2248)ModBlocks.VERTICAL_ROOTED_DIRT_SLAB, context -> true, (Consumer)class_1794.method_36985((class_2680)ModBlocks.VERTICAL_DIRT_SLAB.method_9564(), (class_1935)class_1802.field_28656));
        TillableBlockRegistry.register((class_2248)ModBlocks.VERTICAL_ROOTED_DIRT_STAIRS, context -> true, (Consumer)class_1794.method_36985((class_2680)ModBlocks.VERTICAL_DIRT_STAIRS.method_9564(), (class_1935)class_1802.field_28656));
        TillableBlockRegistry.register((class_2248)ModBlocks.VERTICAL_COARSE_DIRT_SLAB, context -> true, (Consumer)class_1794.method_36988((class_2680)ModBlocks.VERTICAL_DIRT_SLAB.method_9564()));
        TillableBlockRegistry.register((class_2248)ModBlocks.VERTICAL_COARSE_DIRT_STAIRS, context -> true, (Consumer)class_1794.method_36988((class_2680)ModBlocks.VERTICAL_DIRT_STAIRS.method_9564()));
        class_7923.field_41175.method_10220().filter(VanillaVSPlus::isNamespaced).forEach(block -> {
            if (Args.REGISTRY_ARGS.containsKey(block)) {
                RegistryArgs args = Args.REGISTRY_ARGS.get(block);
                if (args.tilled != null && args.tillDrop != null) {
                    TillableBlockRegistry.register((class_2248)block, class_1794::method_36987, (Consumer)class_1794.method_36985((class_2680)args.tilled.method_9564(), (class_1935)args.tillDrop));
                }
                if (args.tilled != null) {
                    TillableBlockRegistry.register((class_2248)block, class_1794::method_36987, (Consumer)class_1794.method_36988((class_2680)args.tilled.method_9564()));
                }
            }
        });
    }

    public static void registerTranslucentBlocks() {
        class_7923.field_41175.method_10220().filter(VanillaVSPlus::isNamespaced).forEach(block -> {
            if (Args.REGISTRY_ARGS.containsKey(block) && Args.REGISTRY_ARGS.get((Object)block).translucent.booleanValue()) {
                BlockRenderLayerMap.putBlock((class_2248)block, (class_11515)class_11515.field_60926);
            }
        });
    }

    public static void registerTransparentBlocks() {
        class_7923.field_41175.method_10220().filter(VanillaVSPlus::isNamespaced).forEach(block -> {
            if (Args.REGISTRY_ARGS.containsKey(block) && Args.REGISTRY_ARGS.get((Object)block).transparent.booleanValue()) {
                BlockRenderLayerMap.putBlock((class_2248)block, (class_11515)class_11515.field_60925);
            }
        });
    }

    public static void registerStrippableBlocks() {
        class_7923.field_41175.method_10220().filter(VanillaVSPlus::isNamespaced).forEach(block -> {
            if (Args.REGISTRY_ARGS.containsKey(block) && Args.REGISTRY_ARGS.get((Object)block).stripped != null) {
                StrippableBlockRegistry.registerCopyState((class_2248)block, (class_2248)Args.REGISTRY_ARGS.get((Object)block).stripped);
            }
        });
    }
}

