/*
 * Decompiled with CFR 0.152.
 */
package it.crystalnest.harvest_with_ease.api;

import it.crystalnest.cobweb.api.block.BlockUtils;
import it.crystalnest.cobweb.api.item.ItemUtils;
import it.crystalnest.harvest_with_ease.config.ModConfig;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import net.minecraft.class_1267;
import net.minecraft.class_1657;
import net.minecraft.class_1702;
import net.minecraft.class_1792;
import net.minecraft.class_1922;
import net.minecraft.class_2248;
import net.minecraft.class_2282;
import net.minecraft.class_2302;
import net.minecraft.class_2338;
import net.minecraft.class_2421;
import net.minecraft.class_2680;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3481;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7924;
import net.minecraft.class_8171;
import net.minecraft.class_8237;
import org.jetbrains.annotations.ApiStatus;

public final class HarvestUtils {
    public static final class_6862<class_2248> BLACKLIST = class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)class_2960.method_60655((String)"harvest_with_ease", (String)"blacklist"));

    private HarvestUtils() {
    }

    public static boolean isCrop(class_2248 block) {
        return !(block instanceof class_8171) && (block instanceof class_2302 || block instanceof class_2421 || block instanceof class_2282 || block instanceof class_8237 || ModConfig.getCrops().contains(BlockUtils.getStringKey((class_2248)block)));
    }

    public static boolean isAllowed(class_2680 block) {
        return ModConfig.getBlacklist().stream().noneMatch(id -> id.equalsIgnoreCase(BlockUtils.getStringKey((class_2248)block.method_26204()))) && !block.method_26164(BLACKLIST);
    }

    public static boolean hasEnoughHunger(class_1657 player) {
        class_1702 foodData;
        class_1702 class_17022;
        return player.method_73183().method_8407() == class_1267.field_5801 || ModConfig.getExhaustionMultiplier().compareTo(BigDecimal.ZERO) == 0 || (class_17022 = player.method_7344()) instanceof class_1702 && (double)((float)(foodData = class_17022).method_7586() + foodData.method_7589()) - Math.floor(foodData.field_7752 / 4.0f) >= 0.0;
    }

    public static class_2758 getAge(class_2680 blockState) throws NullPointerException, NoSuchElementException, ClassCastException {
        return (class_2758)blockState.method_28501().stream().filter(property -> "age".equals(property.method_11899())).findFirst().orElseThrow();
    }

    public static boolean isMature(class_2680 blockState, class_2758 age) {
        return blockState.method_28500((class_2769)age).orElse(0) >= (Integer)Collections.max(age.method_11898());
    }

    public static boolean isMature(class_2680 blockState) throws NullPointerException, NoSuchElementException, ClassCastException {
        return HarvestUtils.isMature(blockState, HarvestUtils.getAge(blockState));
    }

    public static boolean isTallCrop(class_1922 level, class_2680 blockState, class_2338 blockPos) {
        return blockState.method_26164(class_3481.field_20341) && level.method_8320(blockPos.method_10074()).method_27852(blockState.method_26204()) || level.method_8320(blockPos.method_10084()).method_27852(blockState.method_26204());
    }

    public static boolean isTierForMultiHarvest(class_1792 tool) {
        return ModConfig.getTiers().stream().anyMatch(tier -> HarvestUtils.isOf(tool, class_2960.method_60654((String)tier)));
    }

    public static int getTierLevel(class_1792 tool) {
        return HarvestUtils.getTierLevel(ItemUtils.getKey((class_1792)tool));
    }

    @ApiStatus.Internal
    public static int getTierLevel(class_2960 tool) {
        List<? extends String> tiers = ModConfig.getTiers();
        for (int i = 0; i < tiers.size(); ++i) {
            if (!HarvestUtils.isOf(tool, class_2960.method_60654((String)tiers.get(i)))) continue;
            return i;
        }
        return 0;
    }

    public static boolean isOf(class_1792 tool, class_2960 tier) {
        return HarvestUtils.isOf(ItemUtils.getKey((class_1792)tool), tier);
    }

    private static boolean isOf(class_2960 tool, class_2960 tier) {
        return tool.method_12836().equalsIgnoreCase(tier.method_12836()) && tool.method_12832().toLowerCase().contains(tier.method_12832().toLowerCase());
    }
}

