/*
 * Decompiled with CFR 0.152.
 */
package it.crystalnest.harvest_with_ease.handler;

import it.crystalnest.cobweb.api.block.BlockUtils;
import it.crystalnest.harvest_with_ease.Constants;
import it.crystalnest.harvest_with_ease.api.HarvestUtils;
import it.crystalnest.harvest_with_ease.api.event.HarvestEvent;
import it.crystalnest.harvest_with_ease.config.ModConfig;
import it.crystalnest.harvest_with_ease.platform.Services;
import java.math.BigDecimal;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.stream.StreamSupport;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1303;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1928;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2498;
import net.minecraft.class_259;
import net.minecraft.class_2680;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_3481;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import org.jetbrains.annotations.Nullable;

public abstract class HarvestHandler {
    protected HarvestHandler() {
    }

    protected static void handle(class_1936 level, class_2680 crop, class_2338 pos) {
        try {
            if (!level.method_8608() && ModConfig.getGrantedExp() > 0 && HarvestUtils.isCrop(crop.method_26204()) && HarvestUtils.isAllowed(crop) && HarvestUtils.isMature(crop) && ((class_3218)level).method_64395().method_8355(class_1928.field_19392)) {
                class_1303.method_31493((class_3218)((class_3218)level), (class_243)class_243.method_24953((class_2382)pos), (int)ModConfig.getGrantedExp());
            }
        }
        catch (ClassCastException | NullPointerException | NoSuchElementException e) {
            HarvestHandler.logError(e, pos);
        }
    }

    protected static boolean handle(class_1937 level, class_2680 crop, class_2350 face, class_2338 pos, class_3965 hitResult, class_1657 player, class_1268 hand) {
        boolean consume = false;
        if (hand != null && hand == HarvestHandler.getValidHand(player) && HarvestHandler.canHarvest(level, crop, pos, face, hitResult, player, hand)) {
            try {
                class_2758 age = HarvestUtils.getAge(crop);
                if (HarvestUtils.isMature(crop, age)) {
                    consume = true;
                    if (!level.method_8608()) {
                        int fromCenterToEdge;
                        HarvestHandler.harvest((class_3218)level, age, crop, pos, pos, face, hitResult, (class_3222)player, hand);
                        class_1792 tool = player.method_5998(hand).method_7909();
                        if (Services.HARVEST.isHoe(tool.method_7854()) && HarvestUtils.isTierForMultiHarvest(tool) && (fromCenterToEdge = ((HarvestUtils.getTierLevel(tool) - HarvestUtils.getTierLevel(class_2960.method_60654((String)ModConfig.getMultiHarvestStartingTier()))) * ModConfig.getAreaIncrementStep().step + ModConfig.getAreaStartingSize().size - 1) / 2) > 0) {
                            StreamSupport.stream(class_2338.method_30512((class_2338)pos, (int)fromCenterToEdge, (class_2350)player.method_5735(), (class_2350)player.method_5735().method_10170()).spliterator(), false).filter(cropPos -> {
                                class_2680 cropState;
                                class_2680 patt0$temp;
                                return !pos.equals(cropPos) && (patt0$temp = level.method_8320((class_2338)cropPos)) instanceof class_2680 && HarvestHandler.canHarvest(level, cropState = patt0$temp, (class_2338)cropPos, face, null, player, hand) && HarvestUtils.isMature(cropState);
                            }).forEach(cropPos -> HarvestHandler.harvest((class_3218)level, HarvestUtils.getAge(level.method_8320((class_2338)cropPos)), level.method_8320((class_2338)cropPos), (class_2338)cropPos, pos, face, null, (class_3222)player, hand));
                        }
                    }
                }
            }
            catch (ClassCastException | NullPointerException | NoSuchElementException e) {
                HarvestHandler.logError(e, pos);
            }
        }
        return consume;
    }

    private static void harvest(class_3218 level, class_2758 age, class_2680 crop, class_2338 pos, class_2338 originalPos, class_2350 face, class_3965 hitResult, class_3222 player, class_1268 hand) {
        Services.EVENT.fireBeforeHarvestEvent(level, crop, pos, face, hitResult, player, hand);
        class_2338 basePos = HarvestHandler.getBasePos(level, crop.method_26204(), pos);
        HarvestHandler.grantExp(level, basePos);
        HarvestHandler.damageHoe(player, hand);
        HarvestHandler.updateCrop(level, age, crop, basePos, player, HarvestHandler.dropResources(level, level.method_8320(basePos), basePos, originalPos, face, hitResult, player, hand));
        HarvestHandler.playSound(level, player, crop, pos);
        HarvestHandler.exhaustPlayer((class_1657)player);
        Services.EVENT.fireAfterHarvestEvent(level, crop, pos, face, hitResult, player, hand);
    }

    private static void updateCrop(class_3218 level, class_2758 age, class_2680 crop, class_2338 basePos, class_3222 player, boolean customDrops) {
        if (crop.method_26204() == class_2246.field_43228) {
            int i = player.method_31548().method_7395(crop.method_65171((class_4538)level, basePos, false));
            if (i >= 0 || player.method_68878()) {
                level.method_8501(basePos, (class_2680)level.method_8320(basePos).method_11657((class_2769)age, (Comparable)Integer.valueOf(0)));
                if (!player.method_68878()) {
                    player.method_31548().method_5438(i).method_7934(1);
                }
            } else {
                level.method_8651(basePos, false, (class_1297)player);
            }
        } else {
            level.method_8501(basePos, (class_2680)level.method_8320(basePos).method_11657((class_2769)age, (Comparable)Integer.valueOf(0)));
        }
        if (level.method_8320(basePos).method_26164(class_3481.field_20341) && level.method_8320(basePos.method_10084()).method_27852(crop.method_26204()) && !HarvestHandler.isTallButSeparate(crop.method_26204())) {
            level.method_8651(basePos.method_10084(), !customDrops, (class_1297)player);
        }
    }

    private static class_2338 getBasePos(class_3218 level, class_2248 crop, class_2338 pos) {
        class_2338 basePos = pos;
        while (level.method_8320(pos).method_26164(class_3481.field_20341) && !HarvestHandler.isTallButSeparate(crop) && level.method_8320(basePos.method_10074()).method_27852(crop)) {
            basePos = basePos.method_10074();
        }
        return basePos;
    }

    private static void grantExp(class_3218 level, class_2338 pos) {
        if (ModConfig.getGrantedExp() > 0 && level.method_64395().method_8355(class_1928.field_19392)) {
            class_1303.method_31493((class_3218)level, (class_243)class_243.method_24953((class_2382)pos), (int)ModConfig.getGrantedExp());
        }
    }

    private static void damageHoe(class_3222 player, class_1268 hand) {
        if (ModConfig.getRequireHoe().booleanValue() && ModConfig.getDamageOnHarvest() > 0 && !player.method_68878()) {
            player.method_5998(hand).method_7970(ModConfig.getDamageOnHarvest().intValue(), (class_1309)player, hand == class_1268.field_5808 ? class_1304.field_6173 : class_1304.field_6171);
        }
    }

    private static boolean dropResources(class_3218 level, class_2680 crop, class_2338 pos, class_2338 originalPos, class_2350 face, @Nullable class_3965 hitResult, class_3222 player, class_1268 hand) {
        if (level.method_64395().method_8355(class_1928.field_19392)) {
            HarvestEvent.HarvestDropsEvent event = Services.EVENT.fireHarvestDropsEvent(level, crop, pos, face, hitResult, player, hand);
            HarvestHandler.dropStacks(level, ModConfig.getGatherDrops() != false ? originalPos : pos, face, event.getDrops());
            return event.didDropsChange();
        }
        return false;
    }

    private static void playSound(class_3218 level, class_3222 player, class_2680 crop, class_2338 pos) {
        class_2498 soundType = Services.HARVEST.getSoundType(level, player, crop, pos);
        level.method_8396(null, pos, soundType.method_10595(), class_3419.field_15245, soundType.method_10597(), soundType.method_10599());
    }

    private static void exhaustPlayer(class_1657 player) {
        if (ModConfig.getExhaustionMultiplier().compareTo(BigDecimal.ZERO) > 0) {
            player.method_7322(0.005f * ModConfig.getExhaustionMultiplier().floatValue());
        }
    }

    @Nullable
    private static class_1268 getValidHand(class_1657 player) {
        if (!player.method_18276()) {
            if (Services.HARVEST.isHoe(player.method_6047())) {
                return class_1268.field_5808;
            }
            if (Services.HARVEST.isHoe(player.method_6079())) {
                return class_1268.field_5810;
            }
            if (!ModConfig.getRequireHoe().booleanValue()) {
                return class_1268.field_5808;
            }
        }
        return null;
    }

    private static boolean canHarvest(class_1937 level, class_2680 crop, class_2338 pos, class_2350 face, @Nullable class_3965 hitResult, class_1657 player, class_1268 hand) {
        return HarvestUtils.isCrop(crop.method_26204()) && player.method_7305(crop) && HarvestUtils.hasEnoughHunger(player) && HarvestUtils.isAllowed(crop) && Services.EVENT.fireHarvestCheckEvent(level, crop, pos, face, hitResult, player, hand);
    }

    private static void dropStacks(class_3218 level, class_2338 pos, class_2350 face, List<class_1799> stacks) {
        for (class_1799 stack : stacks) {
            if (level.method_8320(pos).method_26220((class_1922)level, pos) != class_259.method_1073()) {
                class_2248.method_36992((class_1937)level, (class_2338)pos, (class_2350)face, (class_1799)stack);
                continue;
            }
            class_2248.method_9577((class_1937)level, (class_2338)pos, (class_1799)stack);
        }
    }

    private static boolean isTallButSeparate(class_2248 crop) {
        return "farmersdelight:tomatoes".equalsIgnoreCase(BlockUtils.getStringKey((class_2248)crop));
    }

    private static void logError(Exception e, class_2338 pos) {
        Constants.LOGGER.debug("Exception generated by block at [{}]", (Object)pos.method_23854());
        Constants.LOGGER.debug("This is a non blocking error, but can result in incorrect behavior for mod {}", (Object)"harvest_with_ease");
        Constants.LOGGER.debug("Most likely, it wasn't possible to retrieve a crop age property, either for an invalid item in the cropIds configuration option or for a mod incompatibility; see stack trace for more details", (Throwable)e);
    }
}

