#version 150

uniform sampler2D DiffuseSampler;

in vec2 texCoord;
in float aspectRatio;

out vec4 fragColor;

float luminance(vec3 rgb) {
    return dot(rgb, vec3(0.2126, 0.7152, 0.0722));
}

#define TAPS 12
#define AMT 1.0 / 45.0

void main() {
    vec2 poissonDisk[12];
    poissonDisk[0] = vec2(-0.613392, 0.617481);
    poissonDisk[1] = vec2(0.170019, -0.040254);
    poissonDisk[2] = vec2(-0.299417, 0.791925);
    poissonDisk[3] = vec2(0.645680, 0.493210);
    poissonDisk[4] = vec2(-0.651784, 0.717887);
    poissonDisk[5] = vec2(0.421003, 0.027070);
    poissonDisk[6] = vec2(-0.817194, -0.271096);
    poissonDisk[7] = vec2(-0.705374, -0.668203);
    poissonDisk[8] = vec2(0.977050, -0.108615);
    poissonDisk[9] = vec2(0.063326, 0.142369);
    poissonDisk[10] = vec2(0.203528, 0.214331);
    poissonDisk[11] = vec2(-0.667531, 0.326090);

    vec3 OutTexel = texture(DiffuseSampler, texCoord).rgb;
    float safeAspectRatio = max(aspectRatio, 0.1);
    vec2 tapScale = vec2(AMT / safeAspectRatio, AMT);

    vec3 bloomAccumulator = vec3(0.0);
    for (int ii = 0; ii < TAPS; ++ii) {
        vec3 colortmp = texture(DiffuseSampler, texCoord + poissonDisk[ii] * tapScale).rgb;
        float lumtmp = luminance(colortmp);
        if (lumtmp > 0.5) {
            bloomAccumulator += colortmp * (lumtmp - 0.5) * (1.0 - pow(length(poissonDisk[ii]), 2.0));
        }
    }
    bloomAccumulator /= float(TAPS);
    bloomAccumulator *= 2.5;

    fragColor = vec4(OutTexel + bloomAccumulator, 1.0);
}