#version 150

const float Vibrancy = 0.5;
const vec4 coeff = vec4(0.325,0.400,0.275, 0.);

uniform sampler2D DiffuseSampler;
uniform sampler2D DiffuseDepthSampler;

in vec2 texCoord;
out vec4 fragColor;

void main() {
    vec4 InTexel = texture(DiffuseSampler, texCoord);

    float lum = dot(InTexel, coeff);
    vec4 mask = (InTexel - vec4(lum));
    mask = clamp(mask, 0.0, 1.0);
    float lumMask = dot(coeff, mask);
    lumMask = 1.0 - lumMask;
    
    fragColor = mix(vec4(lum), InTexel, 1.0 + Vibrancy * lumMask);
}
