#version 150

uniform vec4 ColorModulator;
uniform float GameTime;
uniform mat4 ModelViewMat;
uniform mat4 ProjMat;
uniform vec2 ScreenSize;

in vec4 rawPos;

out vec4 fragColor;

vec3 sampleStarfield(vec3 v, float intensity) {
    vec3 dayTop = vec3(0.3741, 0.4765, 0.7448); // #6a87d3 10% mais escuro
    vec3 dayMid = vec3(0.6798, 0.7304, 0.8588);
    vec3 dayBottom = vec3(0.7677, 0.7431, 0.8647);
    vec3 nightTop = vec3(6.0/255.0, 14.0/255.0, 24.0/255.0);
    vec3 nightBottom = vec3(0.1, 0.2, 0.3);
    vec3 afternoonTop = vec3(27.0/255.0, 28.0/255.0, 59.0/255.0);
    vec3 afternoonMid = vec3(164.0/255.0, 143.0/255.0, 169.0/255.0);
    vec3 afternoonBottom = vec3(185.0/255.0, 104.0/255.0, 103.0/255.0);

    float t = clamp(intensity, 0.0, 1.0);
    vec3 skyTop, skyBottom, skyMid;

    if (t < 0.1) {
        skyTop = dayTop;
        skyBottom = dayBottom;
        skyMid = dayMid;
    } else if (t < 0.3) {
        float transitionT = (t - 0.1) / 0.2;
        skyTop = mix(dayTop, afternoonTop, transitionT);
        skyBottom = mix(dayBottom, afternoonBottom, transitionT);
        skyMid = mix(dayMid, afternoonMid, transitionT);
    } else if (t < 0.9) {
        skyTop = afternoonTop;
        skyBottom = afternoonBottom;
        skyMid = afternoonMid;
    } else {
        float transitionT = (t - 0.9) / 0.1;
        skyTop = mix(afternoonTop, nightTop, transitionT);
        skyBottom = mix(afternoonBottom, nightBottom, transitionT);
        skyMid = mix(afternoonMid, vec3(0.0), transitionT);
    }

    float gradient = clamp((v.y + 1.0) * 0.6 - 0.1, 0.0, 1.0);
    vec3 sky = mix(skyBottom, skyTop, gradient);

    return sky;
}

void main() {
    float intensity = 1.0 - (ColorModulator.r + ColorModulator.g + ColorModulator.b);
    float visibility = 1.0;
    float colorTransition = clamp((intensity + 0.3) / 1.3, 0.0, 1.0);

    vec2 pos = gl_FragCoord.xy / ScreenSize;
    pos -= vec2(0.5, 0.5);
    pos *= 2.0;

    vec4 cast_pos = vec4(pos, 1.0, 1.0);
    cast_pos = inverse(ProjMat) * cast_pos;
    cast_pos = normalize(cast_pos);

    vec3 v = normalize(cast_pos.xyz * mat3(ModelViewMat));
    fragColor = vec4(sampleStarfield(v, colorTransition), 1.0) * visibility;
}