#version 150

#moj_import <matrix.glsl>

uniform sampler2D Sampler1;
uniform float GameTime;

in vec4 texProj0;

const vec3[] COLORS = vec3[](
    vec3(0.40, 0.20, 0.60),
    vec3(0.35, 0.15, 0.55),
    vec3(0.45, 0.25, 0.65),
    vec3(0.50, 0.30, 0.70),
    vec3(0.38, 0.18, 0.58),
    vec3(0.55, 0.35, 0.75),
    vec3(0.42, 0.22, 0.62),
    vec3(0.60, 0.40, 0.80),
    vec3(0.37, 0.17, 0.57),
    vec3(0.48, 0.28, 0.68),
    vec3(0.33, 0.13, 0.53),
    vec3(0.52, 0.32, 0.72),
    vec3(0.39, 0.19, 0.59),
    vec3(0.47, 0.27, 0.67),
    vec3(0.36, 0.16, 0.56),
    vec3(0.58, 0.38, 0.78)
);

const mat4 SCALE_TRANSLATE = mat4(
    0.5, 0.0, 0.0, 0.25,
    0.0, 0.5, 0.0, 0.25,
    0.0, 0.0, 1.0, 0.0,
    0.0, 0.0, 0.0, 1.0
);

mat4 end_portal_layer(float layer) {
    mat4 translate = mat4(
        1.0, 0.0, 0.0, 17.0 / layer,
        0.0, 1.0, 0.0, (2.0 + layer / 1.5) * (GameTime * 2.5),
        0.0, 0.0, 1.0, 0.0,
        0.0, 0.0, 0.0, 1.0
    );

    mat2 rotate = mat2_rotate_z(radians((layer * layer * 4321.0 + layer * 9.0) * 2.0));
    mat2 scale = mat2((4.5 - layer / 1.0) * 1.5);

    return mat4(scale * rotate) * translate * SCALE_TRANSLATE;
}

out vec4 fragColor;

void main() {
    vec3 color = vec3(0.0);
    for (int i = 0; i < 16; i++) {
        color += textureProj(Sampler1, texProj0 * end_portal_layer(float(i + 1))).rgb * COLORS[i];
    }
    fragColor = vec4(color, 1.0);
}