#version 130

uniform sampler2D DiffuseSampler;
uniform sampler2D ParticlesDepthSampler;
uniform sampler2D TranslucentSampler;

in vec2 texCoord;
in vec2 oneTexel;
uniform mat4 ProjMat;
uniform vec2 InSize;
uniform vec2 OutSize;
uniform vec2 ScreenSize;
out vec4 fragColor;

uniform sampler2D BrightnessLimitMask;
float brightnessLimit = 0.6;

void main(){
    vec2 uv1 = texCoord.xy / InSize.xy;
    float valor = 1.0 - length(uv1);

    float linewidth = valor / 300.0;

    vec2 uv = texCoord;
    vec2 uv_b = vec2(uv.x, uv.y + linewidth);
    vec2 uv_l = vec2(uv.x + linewidth, uv.y);
    vec2 uv_r = vec2(uv.x - linewidth, uv.y);
    vec2 uv_u = vec2(uv.x, uv.y - linewidth);

    vec4 center = texture(DiffuseSampler, texCoord.st);

    vec4 translucentSample = texture(TranslucentSampler, uv);
    float translucent = (translucentSample.r + translucentSample.g + translucentSample.b) / 3.0;
    translucent = translucent * 10.0 * 0.5;

    if (translucent > 0.5) {
        fragColor = vec4(center.rgb, center.a);
    } else {
        float near = 0.04;
        float far = 18.0;

        float d1 = 1.0 - 2.0 * near * far / (far + near - (2.0 * texture(ParticlesDepthSampler, uv).x - 1.0) * (far - near)) / far;
        float d2 = 1.0 - 2.0 * near * far / (far + near - (2.0 * texture(ParticlesDepthSampler, uv_b).x - 1.0) * (far - near)) / far;
        float d3 = 1.0 - 2.0 * near * far / (far + near - (2.0 * texture(ParticlesDepthSampler, uv_u).x - 1.0) * (far - near)) / far;
        float d4 = 1.0 - 2.0 * near * far / (far + near - (2.0 * texture(ParticlesDepthSampler, uv_l).x - 1.0) * (far - near)) / far;
        float d5 = 1.0 - 2.0 * near * far / (far + near - (2.0 * texture(ParticlesDepthSampler, uv_r).x - 1.0) * (far - near)) / far;

        float factor = 1.0;

        float difference = (d1 - d2 - translucent) * factor;
        float difference1 = (d1 - d3 - translucent) * factor;
        float difference2 = (d1 - d4 - translucent) * factor;
        float difference3 = (d1 - d5 - translucent) * factor;

        float alldif = (difference + difference1 + difference2 + difference3);
        float borders = clamp(alldif, 0.0, 0.5) * 2.0;

        vec4 limitMask = texture(BrightnessLimitMask, texCoord);
        float attenuation = 1.0 - min(limitMask.r, brightnessLimit);

        fragColor = vec4(center.rgb + center.rgb * clamp(alldif * 20.0, 0.0, 1.0) * d1, center.a);
    }
}