/*
 * Decompiled with CFR 0.152.
 */
package cc.unilock.nilcord.discord;

import cc.unilock.nilcord.NilcordPremain;
import cc.unilock.nilcord.lib.jda.api.JDA;
import cc.unilock.nilcord.lib.jda.api.JDABuilder;
import cc.unilock.nilcord.lib.jda.api.entities.IncomingWebhookClient;
import cc.unilock.nilcord.lib.jda.api.entities.Member;
import cc.unilock.nilcord.lib.jda.api.entities.Message;
import cc.unilock.nilcord.lib.jda.api.entities.MessageReference;
import cc.unilock.nilcord.lib.jda.api.entities.User;
import cc.unilock.nilcord.lib.jda.api.entities.WebhookClient;
import cc.unilock.nilcord.lib.jda.api.entities.channel.ChannelType;
import cc.unilock.nilcord.lib.jda.api.entities.channel.concrete.TextChannel;
import cc.unilock.nilcord.lib.jda.api.events.message.MessageReceivedEvent;
import cc.unilock.nilcord.lib.jda.api.events.session.ReadyEvent;
import cc.unilock.nilcord.lib.jda.api.hooks.ListenerAdapter;
import cc.unilock.nilcord.lib.jda.api.requests.GatewayIntent;
import cc.unilock.nilcord.lib.jda.api.utils.ChunkingFilter;
import cc.unilock.nilcord.lib.jda.api.utils.MemberCachePolicy;
import cc.unilock.nilcord.lib.jda.api.utils.messages.MessageCreateBuilder;
import cc.unilock.nilcord.lib.jda.api.utils.messages.MessageCreateData;
import cc.unilock.nilcord.lib.jetbrains_annotations.NotNull;
import cc.unilock.nilcord.lib.jetbrains_annotations.Nullable;
import cc.unilock.nilcord.util.TextUtils;
import java.time.Duration;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.entity.player.EntityServerPlayer;

public class Discord
extends ListenerAdapter {
    private static final Pattern WEBHOOK_ID_REGEX = Pattern.compile("^https://discord\\.com/api/webhooks/(\\d+)/.+$");
    private final JDA jda;
    private final IncomingWebhookClient webhook;
    private final String webhookId;
    private boolean shutdown = false;
    private static final Pattern EVERYONE_AND_HERE_PATTERN = Pattern.compile("@(?<ping>everyone|here)");

    public Discord() {
        JDABuilder builder = JDABuilder.createDefault(NilcordPremain.CONFIG.discord.token.value()).addEventListeners(this).setChunkingFilter(ChunkingFilter.ALL).setMemberCachePolicy(MemberCachePolicy.ALL).enableIntents(GatewayIntent.GUILD_MEMBERS, GatewayIntent.GUILD_MESSAGES, GatewayIntent.MESSAGE_CONTENT);
        try {
            this.jda = builder.build();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to log into Discord!", e);
        }
        if (NilcordPremain.CONFIG.discord.webhook.enabled.value().booleanValue()) {
            try {
                this.webhook = WebhookClient.createClient(this.jda, NilcordPremain.CONFIG.discord.webhook.url.value());
                Matcher matcher = WEBHOOK_ID_REGEX.matcher(NilcordPremain.CONFIG.discord.webhook.url.value());
                this.webhookId = matcher.find() ? matcher.group(1) : null;
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException("Invalid webhook URL!");
            }
        } else {
            this.webhook = null;
            this.webhookId = null;
        }
    }

    @Override
    public void onReady(@NotNull ReadyEvent event) {
        NilcordPremain.LOGGER.info("Bot ready!");
    }

    @Override
    public void onMessageReceived(@NotNull MessageReceivedEvent event) {
        if (NilcordPremain.server == null) {
            return;
        }
        if (NilcordPremain.CONFIG.formatting.minecraft.discord_message.value().isEmpty()) {
            return;
        }
        if (!event.isFromType(ChannelType.TEXT)) {
            return;
        }
        if (!event.getChannel().asTextChannel().getId().equals(NilcordPremain.CONFIG.discord.channel_id.value())) {
            return;
        }
        if (!NilcordPremain.CONFIG.minecraft.show_webhook_messages.value().booleanValue() && event.isWebhookMessage()) {
            return;
        }
        User author = event.getAuthor();
        if (!NilcordPremain.CONFIG.minecraft.show_bot_messages.value().booleanValue() && author.isBot()) {
            return;
        }
        if (NilcordPremain.CONFIG.minecraft.ignored_ids.value().contains(author.getId())) {
            return;
        }
        if (author.getId().equals(this.jda.getSelfUser().getId()) || author.getId().equals(this.webhookId)) {
            return;
        }
        Message message = event.getMessage();
        MessageReference ref = message.getMessageReference();
        Member member = message.getMember();
        StringBuilder attachment_chunk = new StringBuilder(message.getContentDisplay().isEmpty() ? "" : " ");
        if (NilcordPremain.CONFIG.minecraft.show_attachments.value().booleanValue()) {
            for (Message.Attachment attachment : message.getAttachments()) {
                attachment_chunk.append(NilcordPremain.CONFIG.formatting.minecraft.attachment_format.value().replace("<attachment_url>", attachment.getUrl()));
            }
        }
        String reply_chunk = "";
        if (ref != null) {
            reply_chunk = TextUtils.parseDiscordReply(NilcordPremain.CONFIG.formatting.minecraft.reply_format.value(), ref.getMessage() == null ? ref.resolve().complete() : ref.getMessage());
        }
        String msg = TextUtils.parseDiscordMessage(NilcordPremain.CONFIG.formatting.minecraft.discord_message.value(), attachment_chunk.toString(), reply_chunk, NilcordPremain.CONFIG.formatting.minecraft.username_format.value(), author, member, message);
        NilcordPremain.server.getConfigurationManager().sendChatMsg(msg);
    }

    public void onPlayerChatMessage(EntityServerPlayer player, String message) {
        String msg = TextUtils.parseMessage(NilcordPremain.CONFIG.discord.webhook.enabled.value() != false ? NilcordPremain.CONFIG.formatting.discord.webhook.chat_message.value() : NilcordPremain.CONFIG.formatting.discord.chat_message.value(), player, message);
        if (!NilcordPremain.CONFIG.minecraft.enable_everyone_and_here.value().booleanValue()) {
            msg = this.parseEveryoneAndHere(msg);
        }
        if (NilcordPremain.CONFIG.minecraft.enable_mentions.value().booleanValue()) {
            msg = this.parseMentions(msg);
        }
        this.sendMessageToDiscord(msg, player);
    }

    public void sendMessageToDiscord(String message) {
        this.sendMessageToDiscord(message, null);
    }

    public void sendMessageToDiscord(String message, @Nullable EntityServerPlayer player) {
        if (!NilcordPremain.CONFIG.discord.webhook.enabled.value().booleanValue() || this.webhook == null || player == null) {
            this.sendBotMessageToDiscord(message);
        } else {
            this.sendWebhookMessageToDiscord(message, player);
        }
    }

    public void sendBotMessageToDiscord(String message) {
        TextChannel textChannel = this.jda.getTextChannelById(NilcordPremain.CONFIG.discord.channel_id.value());
        if (textChannel != null) {
            textChannel.sendMessage(message).queue();
        } else {
            NilcordPremain.LOGGER.error("Unable to find channel {}!", (Object)NilcordPremain.CONFIG.discord.channel_id.value());
        }
    }

    public void sendWebhookMessageToDiscord(String message, EntityServerPlayer player) {
        String avatar = TextUtils.parseAvatar(NilcordPremain.CONFIG.formatting.discord.webhook.avatar_url.value(), player);
        String username = TextUtils.parsePlayer(NilcordPremain.CONFIG.formatting.discord.webhook.username.value(), player);
        try (MessageCreateData data = ((MessageCreateBuilder)new MessageCreateBuilder().setContent(message)).build();){
            this.webhook.sendMessage(data).setAvatarUrl(avatar).setUsername(username).queue();
        }
    }

    private String parseEveryoneAndHere(String message) {
        return EVERYONE_AND_HERE_PATTERN.matcher(message).replaceAll("@\u200b${ping}");
    }

    private String parseMentions(String message) {
        String msg = message;
        TextChannel textChannel = this.jda.getTextChannelById(NilcordPremain.CONFIG.discord.channel_id.value());
        if (textChannel != null) {
            for (Member member : textChannel.getMembers()) {
                message = Pattern.compile(Pattern.quote("@" + member.getUser().getName()), 2).matcher(msg).replaceAll(member.getAsMention());
            }
        }
        return message;
    }

    public void startJda() {
        try {
            this.jda.awaitReady();
        }
        catch (InterruptedException e) {
            NilcordPremain.LOGGER.error(e.toString());
        }
    }

    public void stopJda() {
        if (this.shutdown) {
            return;
        }
        this.shutdown = true;
        try {
            this.jda.removeEventListener(this);
            this.jda.shutdown();
            if (!this.jda.awaitShutdown(Duration.ofSeconds(3L))) {
                NilcordPremain.LOGGER.error("JDA shutdown timeout exceeded! Shutting down now...");
                this.jda.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            NilcordPremain.LOGGER.error(e.toString());
        }
    }
}

