/*
 * Decompiled with CFR 0.152.
 */
package cc.unilock.nilcord.lib.commons.collections4.iterators;

import cc.unilock.nilcord.lib.commons.collections4.iterators.AbstractIteratorDecorator;
import java.util.Iterator;

public class SkippingIterator<E>
extends AbstractIteratorDecorator<E> {
    private final long offset;
    private long pos;

    public SkippingIterator(Iterator<E> iterator2, long offset) {
        super(iterator2);
        if (offset < 0L) {
            throw new IllegalArgumentException("Offset parameter must not be negative.");
        }
        this.offset = offset;
        this.pos = 0L;
        this.init();
    }

    private void init() {
        while (this.pos < this.offset && this.hasNext()) {
            this.next();
        }
    }

    @Override
    public E next() {
        Object next = super.next();
        ++this.pos;
        return next;
    }

    @Override
    public void remove() {
        if (this.pos <= this.offset) {
            throw new IllegalStateException("remove() can not be called before calling next()");
        }
        super.remove();
    }
}

