/*
 * Decompiled with CFR 0.152.
 */
package cc.unilock.nilcord.lib.jackson.databind.ser.std;

import cc.unilock.nilcord.lib.jackson.core.JsonGenerator;
import cc.unilock.nilcord.lib.jackson.core.JsonToken;
import cc.unilock.nilcord.lib.jackson.core.type.WritableTypeId;
import cc.unilock.nilcord.lib.jackson.databind.JavaType;
import cc.unilock.nilcord.lib.jackson.databind.JsonMappingException;
import cc.unilock.nilcord.lib.jackson.databind.JsonNode;
import cc.unilock.nilcord.lib.jackson.databind.SerializerProvider;
import cc.unilock.nilcord.lib.jackson.databind.annotation.JacksonStdImpl;
import cc.unilock.nilcord.lib.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import cc.unilock.nilcord.lib.jackson.databind.jsontype.TypeSerializer;
import cc.unilock.nilcord.lib.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.lang.reflect.Type;

@JacksonStdImpl
public class ToEmptyObjectSerializer
extends StdSerializer<Object> {
    protected ToEmptyObjectSerializer(Class<?> raw) {
        super(raw, false);
    }

    public ToEmptyObjectSerializer(JavaType type) {
        super(type);
    }

    @Override
    public void serialize(Object value, JsonGenerator gen, SerializerProvider ctxt) throws IOException {
        gen.writeStartObject(value, 0);
        gen.writeEndObject();
    }

    @Override
    public void serializeWithType(Object value, JsonGenerator gen, SerializerProvider ctxt, TypeSerializer typeSer) throws IOException {
        WritableTypeId typeIdDef = typeSer.writeTypePrefix(gen, typeSer.typeId(value, JsonToken.START_OBJECT));
        typeSer.writeTypeSuffix(gen, typeIdDef);
    }

    @Override
    public boolean isEmpty(SerializerProvider provider, Object value) {
        return true;
    }

    @Override
    @Deprecated
    public JsonNode getSchema(SerializerProvider provider, Type typeHint) throws JsonMappingException {
        return null;
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        visitor.expectObjectFormat(typeHint);
    }
}

