/*
 * Decompiled with CFR 0.152.
 */
package cc.unilock.nilcord.lib.jackson.databind.util;

import cc.unilock.nilcord.lib.jackson.databind.AnnotationIntrospector;
import cc.unilock.nilcord.lib.jackson.databind.BeanDescription;
import cc.unilock.nilcord.lib.jackson.databind.JavaType;
import cc.unilock.nilcord.lib.jackson.databind.PropertyName;
import cc.unilock.nilcord.lib.jackson.databind.cfg.MapperConfig;
import cc.unilock.nilcord.lib.jackson.databind.introspect.AnnotatedClass;
import cc.unilock.nilcord.lib.jackson.databind.type.ClassKey;
import cc.unilock.nilcord.lib.jackson.databind.util.LRUMap;
import java.io.Serializable;

public class RootNameLookup
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected transient LRUMap<ClassKey, PropertyName> _rootNames = new LRUMap(20, 200);

    public PropertyName findRootName(JavaType rootType, MapperConfig<?> config) {
        return this.findRootName(rootType.getRawClass(), config);
    }

    public PropertyName findRootName(Class<?> rootType, MapperConfig<?> config) {
        AnnotatedClass ac;
        ClassKey key = new ClassKey(rootType);
        PropertyName name = this._rootNames.get(key);
        if (name != null) {
            return name;
        }
        BeanDescription beanDesc = config.introspectClassAnnotations(rootType);
        AnnotationIntrospector intr = config.getAnnotationIntrospector();
        name = intr.findRootName(ac = beanDesc.getClassInfo());
        if (name == null || !name.hasSimpleName()) {
            name = PropertyName.construct(rootType.getSimpleName());
        }
        this._rootNames.put(key, name);
        return name;
    }

    protected Object readResolve() {
        return new RootNameLookup();
    }
}

