/*
 * Decompiled with CFR 0.152.
 */
package cc.unilock.nilcord.lib.jda.api.entities;

import cc.unilock.nilcord.lib.annotation.Nonnull;
import cc.unilock.nilcord.lib.annotation.Nullable;
import cc.unilock.nilcord.lib.jda.api.entities.ISnowflake;
import cc.unilock.nilcord.lib.jda.api.entities.TeamMember;
import cc.unilock.nilcord.lib.jda.api.entities.User;
import cc.unilock.nilcord.lib.jda.api.utils.ImageProxy;
import cc.unilock.nilcord.lib.jda.api.utils.MiscUtil;
import cc.unilock.nilcord.lib.jda.internal.utils.Checks;
import cc.unilock.nilcord.lib.jetbrains_annotations.Unmodifiable;
import java.util.List;

public interface ApplicationTeam
extends ISnowflake {
    public static final String ICON_URL = "https://cdn.discordapp.com/team-icons/%s/%s.png";

    @Nullable
    default public TeamMember getOwner() {
        return this.getMemberById(this.getOwnerIdLong());
    }

    @Nonnull
    default public String getOwnerId() {
        return Long.toUnsignedString(this.getOwnerIdLong());
    }

    public long getOwnerIdLong();

    @Nullable
    public String getIconId();

    @Nullable
    default public String getIconUrl() {
        String iconId = this.getIconId();
        return iconId == null ? null : String.format(ICON_URL, this.getId(), iconId);
    }

    @Nullable
    default public ImageProxy getIcon() {
        String iconUrl = this.getIconUrl();
        return iconUrl == null ? null : new ImageProxy(iconUrl);
    }

    @Nonnull
    public @Unmodifiable List<TeamMember> getMembers();

    default public boolean isMember(@Nonnull User user) {
        return this.getMember(user) != null;
    }

    @Nullable
    default public TeamMember getMember(@Nonnull User user) {
        Checks.notNull(user, "User");
        return this.getMemberById(user.getIdLong());
    }

    @Nullable
    default public TeamMember getMemberById(@Nonnull String userId) {
        return this.getMemberById(MiscUtil.parseSnowflake(userId));
    }

    @Nullable
    default public TeamMember getMemberById(long userId) {
        for (TeamMember member : this.getMembers()) {
            if (member.getUser().getIdLong() != userId) continue;
            return member;
        }
        return null;
    }
}

