/*
 * Decompiled with CFR 0.152.
 */
package cc.unilock.nilcord.lib.jda.api.entities;

import cc.unilock.nilcord.lib.annotation.CheckReturnValue;
import cc.unilock.nilcord.lib.annotation.Nonnull;
import cc.unilock.nilcord.lib.jda.api.entities.Guild;
import cc.unilock.nilcord.lib.jda.api.entities.ISnowflake;
import cc.unilock.nilcord.lib.jda.api.entities.Member;
import cc.unilock.nilcord.lib.jda.api.entities.channel.concrete.StageChannel;
import cc.unilock.nilcord.lib.jda.api.managers.StageInstanceManager;
import cc.unilock.nilcord.lib.jda.api.requests.RestAction;
import cc.unilock.nilcord.lib.jda.internal.utils.Helpers;
import cc.unilock.nilcord.lib.jetbrains_annotations.Unmodifiable;
import java.util.List;

public interface StageInstance
extends ISnowflake {
    @Nonnull
    public Guild getGuild();

    @Nonnull
    public StageChannel getChannel();

    @Nonnull
    public String getTopic();

    @Nonnull
    public PrivacyLevel getPrivacyLevel();

    @Nonnull
    default public @Unmodifiable List<Member> getSpeakers() {
        return this.getChannel().getMembers().stream().filter(member -> !member.getVoiceState().isSuppressed()).collect(Helpers.toUnmodifiableList());
    }

    @Nonnull
    default public @Unmodifiable List<Member> getAudience() {
        return this.getChannel().getMembers().stream().filter(member -> member.getVoiceState().isSuppressed()).collect(Helpers.toUnmodifiableList());
    }

    @Nonnull
    @CheckReturnValue
    public RestAction<Void> delete();

    @Nonnull
    @CheckReturnValue
    public StageInstanceManager getManager();

    public static enum PrivacyLevel {
        UNKNOWN(-1),
        GUILD_ONLY(2);

        private final int key;

        private PrivacyLevel(int key) {
            this.key = key;
        }

        public int getKey() {
            return this.key;
        }

        @Nonnull
        public static PrivacyLevel fromKey(int key) {
            for (PrivacyLevel level : PrivacyLevel.values()) {
                if (level.key != key) continue;
                return level;
            }
            return UNKNOWN;
        }
    }
}

