/*
 * Decompiled with CFR 0.152.
 */
package cc.unilock.nilcord.lib.jda.api.entities.channel.attribute;

import cc.unilock.nilcord.lib.annotation.CheckReturnValue;
import cc.unilock.nilcord.lib.annotation.Nonnull;
import cc.unilock.nilcord.lib.jda.api.entities.channel.attribute.IPermissionContainer;
import cc.unilock.nilcord.lib.jda.api.entities.channel.concrete.ThreadChannel;
import cc.unilock.nilcord.lib.jda.api.entities.channel.middleman.GuildChannel;
import cc.unilock.nilcord.lib.jda.api.requests.restaction.ThreadChannelAction;
import cc.unilock.nilcord.lib.jda.api.requests.restaction.pagination.ThreadChannelPaginationAction;
import cc.unilock.nilcord.lib.jda.api.utils.MiscUtil;
import cc.unilock.nilcord.lib.jda.internal.utils.Helpers;
import cc.unilock.nilcord.lib.jetbrains_annotations.Unmodifiable;
import java.util.List;

public interface IThreadContainer
extends GuildChannel,
IPermissionContainer {
    public int getDefaultThreadSlowmode();

    @Nonnull
    default public @Unmodifiable List<ThreadChannel> getThreadChannels() {
        return this.getGuild().getThreadChannelCache().applyStream(stream -> stream.filter(thread -> thread.getParentChannel() == this).collect(Helpers.toUnmodifiableList()));
    }

    @Nonnull
    @CheckReturnValue
    default public ThreadChannelAction createThreadChannel(@Nonnull String name) {
        return this.createThreadChannel(name, false);
    }

    @Nonnull
    @CheckReturnValue
    public ThreadChannelAction createThreadChannel(@Nonnull String var1, boolean var2);

    @Nonnull
    @CheckReturnValue
    public ThreadChannelAction createThreadChannel(@Nonnull String var1, long var2);

    @Nonnull
    @CheckReturnValue
    default public ThreadChannelAction createThreadChannel(@Nonnull String name, @Nonnull String messageId) {
        return this.createThreadChannel(name, MiscUtil.parseSnowflake(messageId));
    }

    @Nonnull
    @CheckReturnValue
    public ThreadChannelPaginationAction retrieveArchivedPublicThreadChannels();

    @Nonnull
    @CheckReturnValue
    public ThreadChannelPaginationAction retrieveArchivedPrivateThreadChannels();

    @Nonnull
    @CheckReturnValue
    public ThreadChannelPaginationAction retrieveArchivedPrivateJoinedThreadChannels();
}

