/*
 * Decompiled with CFR 0.152.
 */
package cc.unilock.nilcord.lib.jda.api.entities.channel.concrete;

import cc.unilock.nilcord.lib.annotation.CheckReturnValue;
import cc.unilock.nilcord.lib.annotation.Nonnull;
import cc.unilock.nilcord.lib.annotation.Nullable;
import cc.unilock.nilcord.lib.jda.api.entities.User;
import cc.unilock.nilcord.lib.jda.api.entities.channel.middleman.MessageChannel;
import cc.unilock.nilcord.lib.jda.api.entities.detached.IDetachableEntity;
import cc.unilock.nilcord.lib.jda.api.requests.RestAction;
import cc.unilock.nilcord.lib.jda.api.utils.ImageProxy;
import cc.unilock.nilcord.lib.jda.internal.utils.Helpers;

public interface GroupChannel
extends MessageChannel,
IDetachableEntity {
    public static final String ICON_URL = "https://cdn.discordapp.com/channel-icons/%s/%s.png";

    @Nullable
    public String getIconId();

    @Nullable
    default public String getIconUrl() {
        String iconId = this.getIconId();
        return iconId == null ? null : Helpers.format(ICON_URL, this.getId(), iconId);
    }

    @Nullable
    default public ImageProxy getIcon() {
        String iconUrl = this.getIconUrl();
        return iconUrl == null ? null : new ImageProxy(iconUrl);
    }

    public long getOwnerIdLong();

    @Nonnull
    default public String getOwnerId() {
        return Long.toUnsignedString(this.getOwnerIdLong());
    }

    @Nonnull
    @CheckReturnValue
    default public RestAction<User> retrieveOwner() {
        return this.getJDA().retrieveUserById(this.getOwnerIdLong());
    }
}

