/*
 * Decompiled with CFR 0.152.
 */
package cc.unilock.nilcord.lib.jda.api.entities.templates;

import cc.unilock.nilcord.lib.annotation.CheckReturnValue;
import cc.unilock.nilcord.lib.annotation.Nonnull;
import cc.unilock.nilcord.lib.annotation.Nullable;
import cc.unilock.nilcord.lib.jda.api.JDA;
import cc.unilock.nilcord.lib.jda.api.Permission;
import cc.unilock.nilcord.lib.jda.api.entities.Guild;
import cc.unilock.nilcord.lib.jda.api.entities.User;
import cc.unilock.nilcord.lib.jda.api.entities.templates.TemplateGuild;
import cc.unilock.nilcord.lib.jda.api.exceptions.InsufficientPermissionException;
import cc.unilock.nilcord.lib.jda.api.managers.TemplateManager;
import cc.unilock.nilcord.lib.jda.api.requests.RestAction;
import cc.unilock.nilcord.lib.jda.api.requests.Route;
import cc.unilock.nilcord.lib.jda.internal.JDAImpl;
import cc.unilock.nilcord.lib.jda.internal.managers.TemplateManagerImpl;
import cc.unilock.nilcord.lib.jda.internal.requests.RestActionImpl;
import cc.unilock.nilcord.lib.jda.internal.utils.Checks;
import cc.unilock.nilcord.lib.jda.internal.utils.EntityString;
import java.time.OffsetDateTime;

public class Template {
    private final JDAImpl api;
    private final String code;
    private final String name;
    private final String description;
    private final int uses;
    private final User creator;
    private final OffsetDateTime createdAt;
    private final OffsetDateTime updatedAt;
    private final TemplateGuild guild;
    private final boolean synced;

    public Template(JDAImpl api, String code, String name, String description, int uses, User creator, OffsetDateTime createdAt, OffsetDateTime updatedAt, TemplateGuild guild, boolean synced) {
        this.api = api;
        this.code = code;
        this.name = name;
        this.description = description;
        this.uses = uses;
        this.creator = creator;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.guild = guild;
        this.synced = synced;
    }

    @Nonnull
    @CheckReturnValue
    public static RestAction<Template> resolve(@Nonnull JDA api, @Nonnull String code) {
        Checks.notEmpty(code, "code");
        Checks.noWhitespace(code, "code");
        Checks.notNull(api, "api");
        Route.CompiledRoute route = Route.Templates.GET_TEMPLATE.compile(code);
        JDAImpl jda = (JDAImpl)api;
        return new RestActionImpl<Template>(api, route, (response, request) -> jda.getEntityBuilder().createTemplate(response.getObject()));
    }

    @Nonnull
    @CheckReturnValue
    public RestAction<Template> sync() {
        this.checkInteraction();
        Route.CompiledRoute route = Route.Templates.SYNC_TEMPLATE.compile(this.guild.getId(), this.code);
        return new RestActionImpl<Template>((JDA)this.api, route, (response, request) -> this.api.getEntityBuilder().createTemplate(response.getObject()));
    }

    @Nonnull
    @CheckReturnValue
    public RestAction<Void> delete() {
        this.checkInteraction();
        Route.CompiledRoute route = Route.Templates.DELETE_TEMPLATE.compile(this.guild.getId(), this.code);
        return new RestActionImpl<Void>(this.api, route);
    }

    @Nonnull
    public String getCode() {
        return this.code;
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    public int getUses() {
        return this.uses;
    }

    @Nonnull
    public User getCreator() {
        return this.creator;
    }

    @Nonnull
    public OffsetDateTime getTimeCreated() {
        return this.createdAt;
    }

    @Nonnull
    public OffsetDateTime getTimeUpdated() {
        return this.updatedAt;
    }

    @Nonnull
    public TemplateGuild getGuild() {
        return this.guild;
    }

    public boolean isSynced() {
        return this.synced;
    }

    @Nonnull
    @CheckReturnValue
    public TemplateManager getManager() {
        this.checkInteraction();
        return new TemplateManagerImpl(this);
    }

    private void checkInteraction() {
        Guild guild = this.api.getGuildById(this.guild.getIdLong());
        if (guild == null) {
            throw new IllegalStateException("Cannot interact with a template without shared guild");
        }
        if (!guild.getSelfMember().hasPermission(Permission.MANAGE_SERVER)) {
            throw new InsufficientPermissionException(guild, Permission.MANAGE_SERVER);
        }
    }

    @Nonnull
    public JDA getJDA() {
        return this.api;
    }

    public int hashCode() {
        return this.code.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Template)) {
            return false;
        }
        Template impl = (Template)obj;
        return impl.code.equals(this.code);
    }

    public String toString() {
        return new EntityString(this).addMetadata("code", this.code).toString();
    }
}

