/*
 * Decompiled with CFR 0.152.
 */
package cc.unilock.nilcord.lib.jda.api.events.guild.scheduledevent;

import cc.unilock.nilcord.lib.annotation.CheckReturnValue;
import cc.unilock.nilcord.lib.annotation.Nonnull;
import cc.unilock.nilcord.lib.annotation.Nullable;
import cc.unilock.nilcord.lib.jda.api.JDA;
import cc.unilock.nilcord.lib.jda.api.entities.Member;
import cc.unilock.nilcord.lib.jda.api.entities.ScheduledEvent;
import cc.unilock.nilcord.lib.jda.api.entities.User;
import cc.unilock.nilcord.lib.jda.api.events.guild.scheduledevent.GenericScheduledEventGatewayEvent;
import cc.unilock.nilcord.lib.jda.api.requests.restaction.CacheRestAction;

public abstract class GenericScheduledEventUserEvent
extends GenericScheduledEventGatewayEvent {
    private final long userId;

    public GenericScheduledEventUserEvent(@Nonnull JDA api, long responseNumber, @Nonnull ScheduledEvent scheduledEvent, long userId) {
        super(api, responseNumber, scheduledEvent);
        this.userId = userId;
    }

    public long getUserIdLong() {
        return this.userId;
    }

    @Nonnull
    public String getUserId() {
        return Long.toUnsignedString(this.userId);
    }

    @Nullable
    public User getUser() {
        return this.api.getUserById(this.userId);
    }

    @Nullable
    public Member getMember() {
        return this.guild.getMemberById(this.userId);
    }

    @Nonnull
    @CheckReturnValue
    public CacheRestAction<User> retrieveUser() {
        return this.getJDA().retrieveUserById(this.getUserIdLong());
    }

    @Nonnull
    @CheckReturnValue
    public CacheRestAction<Member> retrieveMember() {
        return this.getGuild().retrieveMemberById(this.getUserIdLong());
    }
}

