/*
 * Decompiled with CFR 0.152.
 */
package cc.unilock.nilcord.lib.jda.api.events.interaction.command;

import cc.unilock.nilcord.lib.annotation.Nonnull;
import cc.unilock.nilcord.lib.jda.api.JDA;
import cc.unilock.nilcord.lib.jda.api.entities.Guild;
import cc.unilock.nilcord.lib.jda.api.events.guild.GenericGuildEvent;
import cc.unilock.nilcord.lib.jda.api.interactions.commands.privileges.IntegrationPrivilege;
import cc.unilock.nilcord.lib.jda.api.interactions.commands.privileges.PrivilegeTargetType;
import java.util.Collections;
import java.util.List;

public abstract class GenericPrivilegeUpdateEvent
extends GenericGuildEvent {
    private final long targetId;
    private final long applicationId;
    private final List<IntegrationPrivilege> privileges;

    public GenericPrivilegeUpdateEvent(@Nonnull JDA api, long responseNumber, @Nonnull Guild guild, long targetId, long applicationId, @Nonnull List<IntegrationPrivilege> privileges) {
        super(api, responseNumber, guild);
        this.targetId = targetId;
        this.applicationId = applicationId;
        this.privileges = Collections.unmodifiableList(privileges);
    }

    @Nonnull
    public abstract PrivilegeTargetType getTargetType();

    public long getTargetIdLong() {
        return this.targetId;
    }

    @Nonnull
    public String getTargetId() {
        return Long.toUnsignedString(this.targetId);
    }

    public long getApplicationIdLong() {
        return this.applicationId;
    }

    @Nonnull
    public String getApplicationId() {
        return Long.toUnsignedString(this.applicationId);
    }

    @Nonnull
    public List<IntegrationPrivilege> getPrivileges() {
        return this.privileges;
    }
}

