/*
 * Decompiled with CFR 0.152.
 */
package cc.unilock.nilcord.lib.jda.api.hooks;

import cc.unilock.nilcord.lib.annotation.Nonnull;
import cc.unilock.nilcord.lib.jda.api.events.GenericEvent;
import cc.unilock.nilcord.lib.jda.api.hooks.EventListener;
import cc.unilock.nilcord.lib.jda.api.hooks.IEventManager;
import cc.unilock.nilcord.lib.jda.internal.JDAImpl;
import cc.unilock.nilcord.lib.jda.internal.utils.JDALogger;
import cc.unilock.nilcord.lib.jetbrains_annotations.Unmodifiable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class InterfacedEventManager
implements IEventManager {
    private final CopyOnWriteArrayList<EventListener> listeners = new CopyOnWriteArrayList();

    @Override
    public void register(@Nonnull Object listener) {
        if (!(listener instanceof EventListener)) {
            throw new IllegalArgumentException("Listener must implement EventListener");
        }
        this.listeners.add((EventListener)listener);
    }

    @Override
    public void unregister(@Nonnull Object listener) {
        if (!(listener instanceof EventListener)) {
            JDALogger.getLog(this.getClass()).warn("Trying to remove a listener that does not implement EventListener: {}", (Object)(listener == null ? "null" : listener.getClass().getName()));
        }
        this.listeners.remove(listener);
    }

    @Override
    @Nonnull
    public @Unmodifiable List<Object> getRegisteredListeners() {
        return Collections.unmodifiableList(new ArrayList<EventListener>(this.listeners));
    }

    @Override
    public void handle(@Nonnull GenericEvent event) {
        for (EventListener listener : this.listeners) {
            try {
                listener.onEvent(event);
            }
            catch (Throwable throwable) {
                JDAImpl.LOG.error("One of the EventListeners had an uncaught exception", throwable);
                if (!(throwable instanceof Error)) continue;
                throw (Error)throwable;
            }
        }
    }
}

