/*
 * Decompiled with CFR 0.152.
 */
package cc.unilock.nilcord.lib.jda.api.interactions.commands;

import cc.unilock.nilcord.lib.annotation.Nonnull;
import cc.unilock.nilcord.lib.annotation.Nullable;
import cc.unilock.nilcord.lib.jda.api.JDA;
import cc.unilock.nilcord.lib.jda.api.entities.Guild;
import cc.unilock.nilcord.lib.jda.api.interactions.commands.Command;
import cc.unilock.nilcord.lib.jda.api.interactions.commands.privileges.IntegrationPrivilege;
import cc.unilock.nilcord.lib.jda.internal.utils.Checks;
import cc.unilock.nilcord.lib.jetbrains_annotations.Unmodifiable;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class PrivilegeConfig {
    private final Guild guild;
    private final Map<String, List<IntegrationPrivilege>> privileges;

    public PrivilegeConfig(@Nonnull Guild guild, @Nonnull Map<String, List<IntegrationPrivilege>> privileges) {
        this.guild = guild;
        this.privileges = Collections.unmodifiableMap(privileges);
    }

    @Nonnull
    public Guild getGuild() {
        return this.guild;
    }

    @Nonnull
    public JDA getJDA() {
        return this.guild.getJDA();
    }

    @Nullable
    public @Unmodifiable List<IntegrationPrivilege> getApplicationPrivileges() {
        return this.getCommandPrivileges(this.getJDA().getSelfUser().getApplicationId());
    }

    @Nullable
    public @Unmodifiable List<IntegrationPrivilege> getCommandPrivileges(@Nonnull String id) {
        Checks.notNull(id, "Id");
        return this.privileges.get(id);
    }

    @Nullable
    public @Unmodifiable List<IntegrationPrivilege> getCommandPrivileges(@Nonnull Command command) {
        Checks.notNull(command, "Command");
        return this.privileges.get(command.getId());
    }

    @Nonnull
    public Map<String, List<IntegrationPrivilege>> getAsMap() {
        return this.privileges;
    }
}

