/*
 * Decompiled with CFR 0.152.
 */
package cc.unilock.nilcord.lib.jda.api.requests.restaction;

import cc.unilock.nilcord.lib.annotation.CheckReturnValue;
import cc.unilock.nilcord.lib.annotation.Nonnull;
import cc.unilock.nilcord.lib.annotation.Nullable;
import cc.unilock.nilcord.lib.jda.api.entities.Message;
import cc.unilock.nilcord.lib.jda.api.entities.MessageReference;
import cc.unilock.nilcord.lib.jda.api.entities.sticker.StickerSnowflake;
import cc.unilock.nilcord.lib.jda.api.requests.FluentRestAction;
import cc.unilock.nilcord.lib.jda.api.utils.messages.MessageCreateRequest;
import cc.unilock.nilcord.lib.jda.internal.requests.restaction.MessageCreateActionImpl;
import cc.unilock.nilcord.lib.jda.internal.utils.Checks;
import java.util.Arrays;
import java.util.Collection;

public interface MessageCreateAction
extends MessageCreateRequest<MessageCreateAction>,
FluentRestAction<Message, MessageCreateAction> {
    public static void setDefaultFailOnInvalidReply(boolean fail) {
        MessageCreateActionImpl.setDefaultFailOnInvalidReply(fail);
    }

    @Nonnull
    @CheckReturnValue
    public MessageCreateAction setNonce(@Nullable String var1);

    @Nonnull
    @CheckReturnValue
    public MessageCreateAction setMessageReference(@Nonnull MessageReference.MessageReferenceType var1, @Nullable String var2, @Nonnull String var3, @Nonnull String var4);

    @Nonnull
    @CheckReturnValue
    default public MessageCreateAction setMessageReference(@Nonnull MessageReference.MessageReferenceType type, long guildId, long channelId, long messageId) {
        return this.setMessageReference(type, Long.toUnsignedString(guildId), Long.toUnsignedString(channelId), Long.toUnsignedString(messageId));
    }

    @Nonnull
    @CheckReturnValue
    default public MessageCreateAction setMessageReference(@Nonnull MessageReference.MessageReferenceType type, @Nonnull Message message) {
        Checks.notNull(message, "Message");
        return this.setMessageReference(type, message.getGuildId(), message.getChannel().getId(), message.getId());
    }

    @Nonnull
    @CheckReturnValue
    public MessageCreateAction setMessageReference(@Nullable String var1);

    @Nonnull
    @CheckReturnValue
    default public MessageCreateAction setMessageReference(long messageId) {
        return this.setMessageReference(Long.toUnsignedString(messageId));
    }

    @Nonnull
    @CheckReturnValue
    default public MessageCreateAction setMessageReference(@Nullable Message message) {
        return this.setMessageReference(message == null ? null : message.getId());
    }

    @Nonnull
    @CheckReturnValue
    public MessageCreateAction failOnInvalidReply(boolean var1);

    @Nonnull
    @CheckReturnValue
    public MessageCreateAction setStickers(@Nullable Collection<? extends StickerSnowflake> var1);

    @Nonnull
    @CheckReturnValue
    default public MessageCreateAction setStickers(StickerSnowflake ... stickers) {
        if (stickers != null) {
            Checks.noneNull(stickers, "Sticker");
        }
        return this.setStickers(stickers == null ? null : Arrays.asList(stickers));
    }
}

