/*
 * Decompiled with CFR 0.152.
 */
package cc.unilock.nilcord.lib.jda.api.utils.concurrent;

import cc.unilock.nilcord.lib.annotation.Nonnull;
import cc.unilock.nilcord.lib.jda.internal.utils.Checks;
import cc.unilock.nilcord.lib.jetbrains_annotations.Blocking;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;

public interface Task<T> {
    public boolean isStarted();

    @Nonnull
    public Task<T> onError(@Nonnull Consumer<? super Throwable> var1);

    @Nonnull
    public Task<T> onSuccess(@Nonnull Consumer<? super T> var1);

    @Nonnull
    public Task<T> setTimeout(@Nonnull Duration var1);

    @Nonnull
    default public Task<T> setTimeout(long timeout2, @Nonnull TimeUnit unit) {
        Checks.notNull((Object)unit, "TimeUnit");
        return this.setTimeout(Duration.ofMillis(unit.toMillis(timeout2)));
    }

    @Nonnull
    @Blocking
    public T get();

    public void cancel();
}

