/*
 * Decompiled with CFR 0.152.
 */
package cc.unilock.nilcord.lib.jda.internal.entities.channel.mixin.concrete;

import cc.unilock.nilcord.lib.annotation.Nonnull;
import cc.unilock.nilcord.lib.jda.api.Region;
import cc.unilock.nilcord.lib.jda.api.entities.Guild;
import cc.unilock.nilcord.lib.jda.api.entities.PermissionOverride;
import cc.unilock.nilcord.lib.jda.api.entities.channel.concrete.Category;
import cc.unilock.nilcord.lib.jda.api.entities.channel.concrete.StageChannel;
import cc.unilock.nilcord.lib.jda.api.requests.restaction.ChannelAction;
import cc.unilock.nilcord.lib.jda.internal.entities.channel.mixin.attribute.IAgeRestrictedChannelMixin;
import cc.unilock.nilcord.lib.jda.internal.entities.channel.mixin.attribute.ISlowmodeChannelMixin;
import cc.unilock.nilcord.lib.jda.internal.entities.channel.mixin.attribute.IWebhookContainerMixin;
import cc.unilock.nilcord.lib.jda.internal.entities.channel.mixin.middleman.AudioChannelMixin;
import cc.unilock.nilcord.lib.jda.internal.entities.channel.mixin.middleman.GuildMessageChannelMixin;
import cc.unilock.nilcord.lib.jda.internal.utils.Checks;

public interface StageChannelMixin<T extends StageChannelMixin<T>>
extends StageChannel,
AudioChannelMixin<T>,
GuildMessageChannelMixin<T>,
IWebhookContainerMixin<T>,
IAgeRestrictedChannelMixin<T>,
ISlowmodeChannelMixin<T> {
    @Override
    @Nonnull
    default public ChannelAction<StageChannel> createCopy(@Nonnull Guild guild) {
        Checks.notNull(guild, "Guild");
        ChannelAction<StageChannel> action = guild.createStageChannel(this.getName()).setBitrate(this.getBitrate());
        if (this.getRegionRaw() != null) {
            action.setRegion(Region.fromKey(this.getRegionRaw()));
        }
        if (guild.equals(this.getGuild())) {
            Category parent = this.getParentCategory();
            if (parent != null) {
                action.setParent(parent);
            }
            for (PermissionOverride o : this.getPermissionOverrideMap().valueCollection()) {
                if (o.isMemberOverride()) {
                    action.addMemberPermissionOverride(o.getIdLong(), o.getAllowedRaw(), o.getDeniedRaw());
                    continue;
                }
                action.addRolePermissionOverride(o.getIdLong(), o.getAllowedRaw(), o.getDeniedRaw());
            }
        }
        return action;
    }
}

