/*
 * Decompiled with CFR 0.152.
 */
package cc.unilock.nilcord.lib.jda.internal.entities.channel.mixin.middleman;

import cc.unilock.nilcord.lib.annotation.CheckReturnValue;
import cc.unilock.nilcord.lib.annotation.Nonnull;
import cc.unilock.nilcord.lib.jda.api.Permission;
import cc.unilock.nilcord.lib.jda.api.entities.channel.attribute.IPermissionContainer;
import cc.unilock.nilcord.lib.jda.api.entities.channel.middleman.GuildChannel;
import cc.unilock.nilcord.lib.jda.api.entities.channel.unions.GuildChannelUnion;
import cc.unilock.nilcord.lib.jda.api.exceptions.InsufficientPermissionException;
import cc.unilock.nilcord.lib.jda.api.exceptions.MissingAccessException;
import cc.unilock.nilcord.lib.jda.api.requests.Route;
import cc.unilock.nilcord.lib.jda.api.requests.restaction.AuditableRestAction;
import cc.unilock.nilcord.lib.jda.internal.entities.channel.mixin.ChannelMixin;
import cc.unilock.nilcord.lib.jda.internal.entities.detached.mixin.IDetachableEntityMixin;
import cc.unilock.nilcord.lib.jda.internal.requests.restaction.AuditableRestActionImpl;

public interface GuildChannelMixin<T extends GuildChannelMixin<T>>
extends GuildChannel,
GuildChannelUnion,
ChannelMixin<T>,
IDetachableEntityMixin {
    @Override
    @Nonnull
    @CheckReturnValue
    default public AuditableRestAction<Void> delete() {
        this.checkCanAccess();
        this.checkCanManage();
        Route.CompiledRoute route = Route.Channels.DELETE_CHANNEL.compile(this.getId());
        return new AuditableRestActionImpl<Void>(this.getJDA(), route);
    }

    default public boolean hasPermission(Permission permission) {
        IPermissionContainer permChannel = this.getPermissionContainer();
        return this.getGuild().getSelfMember().hasPermission((GuildChannel)permChannel, permission);
    }

    default public void checkPermission(Permission permission) {
        this.checkPermission(permission, null);
    }

    default public void checkPermission(Permission permission, String message) {
        if (!this.hasPermission(permission)) {
            if (message != null) {
                throw new InsufficientPermissionException(this, permission, message);
            }
            throw new InsufficientPermissionException(this, permission);
        }
    }

    default public void checkCanManage() {
        this.checkPermission(Permission.MANAGE_CHANNEL);
    }

    @Override
    default public void checkCanAccess() {
        this.checkAttached();
        if (!this.hasPermission(Permission.VIEW_CHANNEL)) {
            throw new MissingAccessException(this, Permission.VIEW_CHANNEL);
        }
    }
}

